/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.Closeable;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import org.apache.lucene.util.IOUtils;
import org.apache.solr.client.solrj.impl.HttpClientConfigurer;
import org.apache.solr.client.solrj.impl.HttpClientUtil;
import org.apache.solr.client.solrj.util.SolrIdentifierValidator;
import org.apache.solr.cloud.Overseer;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.BlobRepository;
import org.apache.solr.core.CloserThread;
import org.apache.solr.core.ConfigSet;
import org.apache.solr.core.ConfigSetService;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.core.CorePropertiesLocator;
import org.apache.solr.core.CoreSorter;
import org.apache.solr.core.CoresLocator;
import org.apache.solr.core.NodeConfig;
import org.apache.solr.core.PluginBag;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrCores;
import org.apache.solr.core.SolrInfoMBean;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.core.SolrXmlConfig;
import org.apache.solr.core.ZkContainer;
import org.apache.solr.core.backup.repository.BackupRepository;
import org.apache.solr.core.backup.repository.BackupRepositoryFactory;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.handler.admin.CollectionsHandler;
import org.apache.solr.handler.admin.ConfigSetsHandler;
import org.apache.solr.handler.admin.CoreAdminHandler;
import org.apache.solr.handler.admin.InfoHandler;
import org.apache.solr.handler.admin.MetricsHandler;
import org.apache.solr.handler.admin.SecurityConfHandler;
import org.apache.solr.handler.admin.ZookeeperInfoHandler;
import org.apache.solr.handler.component.HttpShardHandlerFactory;
import org.apache.solr.handler.component.ShardHandlerFactory;
import org.apache.solr.logging.LogWatcher;
import org.apache.solr.logging.MDCLoggingContext;
import org.apache.solr.metrics.SolrCoreMetricManager;
import org.apache.solr.metrics.SolrMetricManager;
import org.apache.solr.metrics.SolrMetricProducer;
import org.apache.solr.request.SolrRequestHandler;
import org.apache.solr.security.AuthenticationPlugin;
import org.apache.solr.security.AuthorizationPlugin;
import org.apache.solr.security.HttpClientInterceptorPlugin;
import org.apache.solr.security.PKIAuthenticationPlugin;
import org.apache.solr.security.SecurityPluginHolder;
import org.apache.solr.update.SolrCoreState;
import org.apache.solr.update.UpdateShardHandler;
import org.apache.solr.util.DefaultSolrThreadFactory;
import org.apache.solr.util.stats.MetricUtils;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoreContainer {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    final SolrCores solrCores = new SolrCores(this);
    protected final Map<String, CoreLoadFailure> coreInitFailures = new ConcurrentHashMap<String, CoreLoadFailure>();
    protected CoreAdminHandler coreAdminHandler = null;
    protected CollectionsHandler collectionsHandler = null;
    private InfoHandler infoHandler;
    protected ConfigSetsHandler configSetsHandler = null;
    private PKIAuthenticationPlugin pkiAuthenticationPlugin;
    protected Properties containerProperties;
    private ConfigSetService coreConfigService;
    protected ZkContainer zkSys = new ZkContainer();
    protected ShardHandlerFactory shardHandlerFactory;
    private UpdateShardHandler updateShardHandler;
    private ExecutorService coreContainerWorkExecutor = ExecutorUtil.newMDCAwareCachedThreadPool((ThreadFactory)new DefaultSolrThreadFactory("coreContainerWorkExecutor"));
    protected LogWatcher logging = null;
    private CloserThread backgroundCloser = null;
    protected final NodeConfig cfg;
    protected final SolrResourceLoader loader;
    protected final String solrHome;
    protected final CoresLocator coresLocator;
    private String hostName;
    private final BlobRepository blobRepository = new BlobRepository(this);
    private PluginBag<SolrRequestHandler> containerHandlers = new PluginBag<SolrRequestHandler>(SolrRequestHandler.class, null);
    private boolean asyncSolrCoreLoad;
    protected SecurityConfHandler securityConfHandler;
    private SecurityPluginHolder<AuthorizationPlugin> authorizationPlugin;
    private SecurityPluginHolder<AuthenticationPlugin> authenticationPlugin;
    private BackupRepositoryFactory backupRepoFactory;
    protected SolrMetricManager metricManager;
    protected MetricsHandler metricsHandler;
    private volatile boolean isShutDown;

    public BackupRepository newBackupRepository(Optional<String> repositoryName) {
        BackupRepository repository = repositoryName.isPresent() ? this.backupRepoFactory.newInstance(this.getResourceLoader(), repositoryName.get()) : this.backupRepoFactory.newInstance(this.getResourceLoader());
        return repository;
    }

    public ExecutorService getCoreZkRegisterExecutorService() {
        return this.zkSys.getCoreZkRegisterExecutorService();
    }

    public SolrRequestHandler getRequestHandler(String path) {
        return RequestHandlerBase.getRequestHandler(path, this.containerHandlers);
    }

    public PluginBag<SolrRequestHandler> getRequestHandlers() {
        return this.containerHandlers;
    }

    public CoreContainer() {
        this(new SolrResourceLoader(SolrResourceLoader.locateSolrHome()));
    }

    public CoreContainer(SolrResourceLoader loader) {
        this(SolrXmlConfig.fromSolrHome(loader, loader.getInstancePath()));
    }

    public CoreContainer(String solrHome) {
        this(new SolrResourceLoader(Paths.get(solrHome, new String[0])));
    }

    public CoreContainer(NodeConfig config) {
        this(config, new Properties());
    }

    public CoreContainer(NodeConfig config, Properties properties) {
        this(config, properties, new CorePropertiesLocator(config.getCoreRootDirectory()));
    }

    public CoreContainer(NodeConfig config, Properties properties, boolean asyncSolrCoreLoad) {
        this(config, properties, new CorePropertiesLocator(config.getCoreRootDirectory()), asyncSolrCoreLoad);
    }

    public CoreContainer(NodeConfig config, Properties properties, CoresLocator locator) {
        this(config, properties, locator, false);
    }

    public CoreContainer(NodeConfig config, Properties properties, CoresLocator locator, boolean asyncSolrCoreLoad) {
        log.debug("New CoreContainer " + System.identityHashCode(this));
        this.isShutDown = false;
        this.loader = config.getSolrResourceLoader();
        this.solrHome = this.loader.getInstancePath().toString();
        this.cfg = Objects.requireNonNull(config);
        this.coresLocator = locator;
        this.containerProperties = new Properties(properties);
        this.asyncSolrCoreLoad = asyncSolrCoreLoad;
    }

    private synchronized void initializeAuthorizationPlugin(Map<String, Object> authorizationConf) {
        authorizationConf = Utils.getDeepCopy(authorizationConf, (int)4);
        SecurityPluginHolder<AuthorizationPlugin> old = this.authorizationPlugin;
        SecurityPluginHolder<AuthorizationPlugin> authorizationPlugin = null;
        if (authorizationConf != null) {
            String klas = (String)authorizationConf.get("class");
            if (klas == null) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "class is required for authorization plugin");
            }
            if (old != null && old.getZnodeVersion() == CoreContainer.readVersion(authorizationConf)) {
                return;
            }
            log.info("Initializing authorization plugin: " + klas);
            authorizationPlugin = new SecurityPluginHolder<AuthorizationPlugin>(CoreContainer.readVersion(authorizationConf), this.getResourceLoader().newInstance(klas, AuthorizationPlugin.class));
            ((AuthorizationPlugin)authorizationPlugin.plugin).init(authorizationConf);
        } else {
            log.debug("Security conf doesn't exist. Skipping setup for authorization module.");
        }
        this.authorizationPlugin = authorizationPlugin;
        if (old != null) {
            try {
                ((AuthorizationPlugin)old.plugin).close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private synchronized void initializeAuthenticationPlugin(Map<String, Object> authenticationConfig) {
        authenticationConfig = Utils.getDeepCopy(authenticationConfig, (int)4);
        String pluginClassName = null;
        if (authenticationConfig != null) {
            if (authenticationConfig.containsKey("class")) {
                pluginClassName = String.valueOf(authenticationConfig.get("class"));
            } else {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "No 'class' specified for authentication in ZK.");
            }
        }
        if (pluginClassName != null) {
            log.info("Authentication plugin class obtained from ZK: " + pluginClassName);
        } else if (System.getProperty("authenticationPlugin") != null) {
            pluginClassName = System.getProperty("authenticationPlugin");
            log.info("Authentication plugin class obtained from system property 'authenticationPlugin': " + pluginClassName);
        } else {
            log.debug("No authentication plugin used.");
        }
        SecurityPluginHolder<AuthenticationPlugin> old = this.authenticationPlugin;
        SecurityPluginHolder<AuthenticationPlugin> authenticationPlugin = null;
        if (pluginClassName != null) {
            authenticationPlugin = new SecurityPluginHolder<AuthenticationPlugin>(CoreContainer.readVersion(authenticationConfig), this.getResourceLoader().newInstance(pluginClassName, AuthenticationPlugin.class, null, new Class[]{CoreContainer.class}, new Object[]{this}));
        }
        if (authenticationPlugin != null) {
            ((AuthenticationPlugin)authenticationPlugin.plugin).init(authenticationConfig);
            this.addHttpConfigurer(authenticationPlugin.plugin);
        }
        this.authenticationPlugin = authenticationPlugin;
        try {
            if (old != null) {
                ((AuthenticationPlugin)old.plugin).close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void addHttpConfigurer(Object authcPlugin) {
        if (authcPlugin instanceof HttpClientInterceptorPlugin) {
            HttpClientConfigurer configurer = ((HttpClientInterceptorPlugin)authcPlugin).getClientConfigurer();
            HttpClientUtil.addConfigurer((HttpClientConfigurer)configurer);
            log.debug("Reconfiguring the shard handler factory and update shard handler.");
            if (this.getShardHandlerFactory() instanceof HttpShardHandlerFactory) {
                ((HttpShardHandlerFactory)this.getShardHandlerFactory()).reconfigureHttpClient(configurer);
            }
            this.getUpdateShardHandler().reconfigureHttpClient(configurer);
        } else if (this.pkiAuthenticationPlugin != null) {
            if (this.pkiAuthenticationPlugin.isInterceptorRegistered()) {
                return;
            }
            log.info("PKIAuthenticationPlugin is managing internode requests");
            this.addHttpConfigurer(this.pkiAuthenticationPlugin);
            this.pkiAuthenticationPlugin.setInterceptorRegistered();
        }
    }

    private static int readVersion(Map<String, Object> conf) {
        if (conf == null) {
            return -1;
        }
        Map meta = (Map)conf.get("");
        if (meta == null) {
            return -1;
        }
        Number v = (Number)meta.get("v");
        return v == null ? -1 : v.intValue();
    }

    protected CoreContainer(Object testConstructor) {
        log.debug("New CoreContainer " + System.identityHashCode(this));
        this.isShutDown = false;
        this.solrHome = null;
        this.loader = null;
        this.coresLocator = null;
        this.cfg = null;
        this.containerProperties = null;
    }

    public static CoreContainer createAndLoad(Path solrHome) {
        return CoreContainer.createAndLoad(solrHome, solrHome.resolve("solr.xml"));
    }

    public static CoreContainer createAndLoad(Path solrHome, Path configFile) {
        SolrResourceLoader loader = new SolrResourceLoader(solrHome);
        CoreContainer cc = new CoreContainer(SolrXmlConfig.fromFile(loader, configFile));
        try {
            cc.load();
        }
        catch (Exception e) {
            cc.shutdown();
            throw e;
        }
        return cc;
    }

    public Properties getContainerProperties() {
        return this.containerProperties;
    }

    public PKIAuthenticationPlugin getPkiAuthenticationPlugin() {
        return this.pkiAuthenticationPlugin;
    }

    public SolrMetricManager getMetricManager() {
        return this.metricManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        block17: {
            log.debug("Loading cores into CoreContainer [instanceDir={}]", (Object)this.loader.getInstancePath());
            String libDir = this.cfg.getSharedLibDirectory();
            if (libDir != null) {
                Path libPath = this.loader.getInstancePath().resolve(libDir);
                try {
                    this.loader.addToClassLoader(SolrResourceLoader.getURLs(libPath));
                    this.loader.reloadLuceneSPI();
                }
                catch (IOException e) {
                    if (libDir.equals("lib")) break block17;
                    log.warn("Couldn't add files from {} to classpath: {}", (Object)libPath, (Object)e.getMessage());
                }
            }
        }
        this.metricManager = new SolrMetricManager();
        this.coreContainerWorkExecutor = MetricUtils.instrumentedExecutorService(this.coreContainerWorkExecutor, this.metricManager.registry(SolrMetricManager.getRegistryName(SolrInfoMBean.Group.node, new String[0])), SolrMetricManager.mkName("coreContainerWorkExecutor", SolrInfoMBean.Category.CONTAINER.toString(), "threadPool"));
        this.shardHandlerFactory = ShardHandlerFactory.newInstance(this.cfg.getShardHandlerFactoryPluginInfo(), this.loader);
        if (this.shardHandlerFactory instanceof SolrMetricProducer) {
            SolrMetricProducer metricProducer = (SolrMetricProducer)((Object)this.shardHandlerFactory);
            metricProducer.initializeMetrics(this.metricManager, SolrInfoMBean.Group.node.toString(), "httpShardHandler");
        }
        this.updateShardHandler = new UpdateShardHandler(this.cfg.getUpdateShardHandlerConfig());
        this.updateShardHandler.initializeMetrics(this.metricManager, SolrInfoMBean.Group.node.toString(), "updateShardHandler");
        this.solrCores.allocateLazyCores(this.cfg.getTransientCacheSize(), this.loader);
        this.logging = LogWatcher.newRegisteredLogWatcher(this.cfg.getLogWatcherConfig(), this.loader);
        this.hostName = this.cfg.getNodeName();
        this.zkSys.initZooKeeper(this, this.solrHome, this.cfg.getCloudConfig());
        if (this.isZooKeeperAware()) {
            this.pkiAuthenticationPlugin = new PKIAuthenticationPlugin(this, this.zkSys.getZkController().getNodeName());
        }
        MDCLoggingContext.setNode(this);
        ZkStateReader.ConfigData securityConfig = this.isZooKeeperAware() ? this.getZkController().getZkStateReader().getSecurityProps(false) : new ZkStateReader.ConfigData(Collections.EMPTY_MAP, -1);
        this.initializeAuthorizationPlugin((Map)securityConfig.data.get("authorization"));
        this.initializeAuthenticationPlugin((Map)securityConfig.data.get("authentication"));
        this.backupRepoFactory = new BackupRepositoryFactory(this.cfg.getBackupRepositoryPlugins());
        this.createHandler("/admin/zookeeper", ZookeeperInfoHandler.class.getName(), ZookeeperInfoHandler.class);
        this.collectionsHandler = this.createHandler("/admin/collections", this.cfg.getCollectionsHandlerClass(), CollectionsHandler.class);
        this.infoHandler = this.createHandler("/admin/info", this.cfg.getInfoHandlerClass(), InfoHandler.class);
        this.coreAdminHandler = this.createHandler("/admin/cores", this.cfg.getCoreAdminHandlerClass(), CoreAdminHandler.class);
        this.configSetsHandler = this.createHandler("/admin/configs", this.cfg.getConfigSetsHandlerClass(), ConfigSetsHandler.class);
        this.metricsHandler = this.createHandler("/admin/metrics", MetricsHandler.class.getName(), MetricsHandler.class);
        this.securityConfHandler = new SecurityConfHandler(this);
        this.containerHandlers.put("/admin/authorization", this.securityConfHandler);
        this.securityConfHandler.initializeMetrics(this.metricManager, SolrInfoMBean.Group.node.toString(), "/admin/authorization");
        this.containerHandlers.put("/admin/authentication", this.securityConfHandler);
        if (this.pkiAuthenticationPlugin != null) {
            this.containerHandlers.put("/admin/info/key", this.pkiAuthenticationPlugin.getRequestHandler());
        }
        this.metricManager.loadReporters(this.cfg.getMetricReporterPlugins(), this.loader, SolrInfoMBean.Group.node, new String[0]);
        this.metricManager.loadReporters(this.cfg.getMetricReporterPlugins(), this.loader, SolrInfoMBean.Group.jvm, new String[0]);
        this.metricManager.loadReporters(this.cfg.getMetricReporterPlugins(), this.loader, SolrInfoMBean.Group.jetty, new String[0]);
        this.coreConfigService = ConfigSetService.createConfigSetService(this.cfg, this.loader, this.zkSys.zkController);
        this.containerProperties.putAll((Map<?, ?>)this.cfg.getSolrProperties());
        Gauge loadedCores = () -> this.solrCores.getCores().size();
        Gauge lazyCores = () -> this.solrCores.getCoreNames().size() - this.solrCores.getCores().size();
        Gauge unloadedCores = () -> this.solrCores.getAllCoreNames().size() - this.solrCores.getCoreNames().size();
        this.metricManager.register(SolrMetricManager.getRegistryName(SolrInfoMBean.Group.node, new String[0]), (Metric)loadedCores, true, "loaded", SolrInfoMBean.Category.CONTAINER.toString(), "cores");
        this.metricManager.register(SolrMetricManager.getRegistryName(SolrInfoMBean.Group.node, new String[0]), (Metric)lazyCores, true, "lazy", SolrInfoMBean.Category.CONTAINER.toString(), "cores");
        this.metricManager.register(SolrMetricManager.getRegistryName(SolrInfoMBean.Group.node, new String[0]), (Metric)unloadedCores, true, "unloaded", SolrInfoMBean.Category.CONTAINER.toString(), "cores");
        ExecutorService coreLoadExecutor = MetricUtils.instrumentedExecutorService(ExecutorUtil.newMDCAwareFixedThreadPool((int)this.cfg.getCoreLoadThreadCount(this.isZooKeeperAware()), (ThreadFactory)new DefaultSolrThreadFactory("coreLoadExecutor")), this.metricManager.registry(SolrMetricManager.getRegistryName(SolrInfoMBean.Group.node, new String[0])), SolrMetricManager.mkName("coreLoadExecutor", SolrInfoMBean.Category.CONTAINER.toString(), "threadPool"));
        ArrayList<Future<SolrCore>> futures = new ArrayList<Future<SolrCore>>();
        try {
            List<CoreDescriptor> cds = this.coresLocator.discover(this);
            if (this.isZooKeeperAware()) {
                CoreSorter coreComparator = new CoreSorter().init(this);
                cds = new ArrayList<CoreDescriptor>(cds);
                Collections.sort(cds, coreComparator::compare);
            }
            CoreContainer.checkForDuplicateCoreNames(cds);
            for (CoreDescriptor cd : cds) {
                if (cd.isTransient() || !cd.isLoadOnStartup()) {
                    this.solrCores.putDynamicDescriptor(cd.getName(), cd);
                } else if (this.asyncSolrCoreLoad) {
                    this.solrCores.markCoreAsLoading(cd);
                }
                if (!cd.isLoadOnStartup()) continue;
                futures.add(coreLoadExecutor.submit(() -> {
                    SolrCore core;
                    try {
                        if (this.zkSys.getZkController() != null) {
                            this.zkSys.getZkController().throwErrorIfReplicaReplaced(cd);
                        }
                        core = this.create(cd, false, false);
                    }
                    finally {
                        if (this.asyncSolrCoreLoad) {
                            this.solrCores.markCoreAsNotLoading(cd);
                        }
                    }
                    try {
                        this.zkSys.registerInZk(core, true, false);
                    }
                    catch (RuntimeException e) {
                        SolrException.log((Logger)log, (String)"Error registering SolrCore", (Throwable)e);
                    }
                    return core;
                }));
            }
            this.backgroundCloser = new CloserThread(this, this.solrCores, this.cfg);
            this.backgroundCloser.start();
        }
        finally {
            if (this.asyncSolrCoreLoad && futures != null) {
                this.coreContainerWorkExecutor.submit(() -> {
                    try {
                        for (Future future : futures) {
                            try {
                                future.get();
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                            }
                            catch (ExecutionException e) {
                                log.error("Error waiting for SolrCore to be created", (Throwable)e);
                            }
                        }
                    }
                    finally {
                        ExecutorUtil.shutdownAndAwaitTermination((ExecutorService)coreLoadExecutor);
                    }
                });
            } else {
                ExecutorUtil.shutdownAndAwaitTermination((ExecutorService)coreLoadExecutor);
            }
        }
        if (this.isZooKeeperAware()) {
            this.zkSys.getZkController().checkOverseerDesignate();
        }
    }

    public void securityNodeChanged() {
        log.info("Security node changed");
        ZkStateReader.ConfigData securityConfig = this.getZkController().getZkStateReader().getSecurityProps(false);
        this.initializeAuthorizationPlugin((Map)securityConfig.data.get("authorization"));
        this.initializeAuthenticationPlugin((Map)securityConfig.data.get("authentication"));
    }

    private static void checkForDuplicateCoreNames(List<CoreDescriptor> cds) {
        HashMap addedCores = Maps.newHashMap();
        for (CoreDescriptor cd : cds) {
            String name = cd.getName();
            if (addedCores.containsKey(name)) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, String.format(Locale.ROOT, "Found multiple cores with the name [%s], with instancedirs [%s] and [%s]", name, addedCores.get(name), cd.getInstanceDir()));
            }
            addedCores.put(name, cd.getInstanceDir());
        }
    }

    public boolean isShutDown() {
        return this.isShutDown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        log.info("Shutting down CoreContainer instance=" + System.identityHashCode(this));
        this.isShutDown = true;
        ExecutorUtil.shutdownAndAwaitTermination((ExecutorService)this.coreContainerWorkExecutor);
        if (this.isZooKeeperAware()) {
            this.cancelCoreRecoveries();
            this.zkSys.zkController.publishNodeAsDown(this.zkSys.zkController.getNodeName());
        }
        try {
            if (this.coreAdminHandler != null) {
                this.coreAdminHandler.shutdown();
            }
        }
        catch (Exception e) {
            log.warn("Error shutting down CoreAdminHandler. Continuing to close CoreContainer.", (Throwable)e);
        }
        try {
            Object e;
            block39: {
                e = this.solrCores.getModifyLock();
                synchronized (e) {
                    this.solrCores.getModifyLock().notifyAll();
                }
                if (this.backgroundCloser != null) {
                    try {
                        this.backgroundCloser.join();
                    }
                    catch (InterruptedException e2) {
                        Thread.currentThread().interrupt();
                        if (!log.isDebugEnabled()) break block39;
                        log.debug("backgroundCloser thread was interrupted before finishing");
                    }
                }
            }
            this.solrCores.close();
            e = this.solrCores.getModifyLock();
            synchronized (e) {
                this.solrCores.getModifyLock().notifyAll();
            }
        }
        finally {
            try {
                if (this.shardHandlerFactory != null) {
                    this.shardHandlerFactory.close();
                }
            }
            finally {
                try {
                    if (this.updateShardHandler != null) {
                        this.updateShardHandler.close();
                    }
                }
                finally {
                    this.zkSys.close();
                }
            }
        }
        if (this.metricManager != null) {
            this.metricManager.closeReporters(SolrMetricManager.getRegistryName(SolrInfoMBean.Group.node, new String[0]));
        }
        try {
            if (this.authorizationPlugin != null) {
                ((AuthorizationPlugin)this.authorizationPlugin.plugin).close();
            }
        }
        catch (IOException e) {
            log.warn("Exception while closing authorization plugin.", (Throwable)e);
        }
        try {
            if (this.authenticationPlugin != null) {
                ((AuthenticationPlugin)this.authenticationPlugin.plugin).close();
                this.authenticationPlugin = null;
            }
        }
        catch (Exception e) {
            log.warn("Exception while closing authentication plugin.", (Throwable)e);
        }
        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.loader});
    }

    public void cancelCoreRecoveries() {
        List<SolrCore> cores = this.solrCores.getCores();
        for (SolrCore core : cores) {
            try {
                core.getSolrCoreState().cancelRecovery();
            }
            catch (Exception e) {
                SolrException.log((Logger)log, (String)"Error canceling recovery for core", (Throwable)e);
            }
        }
    }

    protected void finalize() throws Throwable {
        try {
            if (!this.isShutDown) {
                log.error("CoreContainer was not close prior to finalize(), indicates a bug -- POSSIBLE RESOURCE LEAK!!!  instance=" + System.identityHashCode(this));
            }
        }
        finally {
            super.finalize();
        }
    }

    public CoresLocator getCoresLocator() {
        return this.coresLocator;
    }

    protected SolrCore registerCore(String name, SolrCore core, boolean registerInZk, boolean skipRecovery) {
        if (core == null) {
            throw new RuntimeException("Can not register a null core.");
        }
        CoreDescriptor cd = core.getCoreDescriptor();
        if ((cd.isTransient() || !cd.isLoadOnStartup()) && this.solrCores.getDynamicDescriptor(name) == null) {
            this.solrCores.putDynamicDescriptor(name, cd);
        }
        if (this.isShutDown) {
            core.close();
            throw new IllegalStateException("This CoreContainer has been closed");
        }
        SolrCore old = cd.isTransient() ? this.solrCores.putTransientCore(this.cfg, name, core, this.loader) : this.solrCores.putCore(name, core);
        core.setName(name);
        this.coreInitFailures.remove(name);
        if (old == null || old == core) {
            log.debug("registering core: " + name);
            if (registerInZk) {
                this.zkSys.registerInZk(core, false, skipRecovery);
            }
            return null;
        }
        log.debug("replacing core: " + name);
        old.close();
        if (registerInZk) {
            this.zkSys.registerInZk(core, false, skipRecovery);
        }
        return old;
    }

    public SolrCore create(String coreName, Map<String, String> parameters) {
        return this.create(coreName, this.cfg.getCoreRootDirectory().resolve(coreName), parameters, false);
    }

    public SolrCore create(String coreName, Path instancePath, Map<String, String> parameters, boolean newCollection) {
        CoreDescriptor cd = new CoreDescriptor(this, coreName, instancePath, parameters);
        if (this.getAllCoreNames().contains(coreName)) {
            log.warn("Creating a core with existing name is not allowed");
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Core with name '" + coreName + "' already exists.");
        }
        boolean preExisitingZkEntry = false;
        try {
            if (this.getZkController() != null) {
                if (!Overseer.isLegacy(this.getZkController().getZkStateReader()) && cd.getCloudDescriptor().getCoreNodeName() == null) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "non legacy mode coreNodeName missing " + parameters.toString());
                }
                preExisitingZkEntry = this.getZkController().checkIfCoreNodeNameAlreadyExists(cd);
            }
            SolrCore core = this.create(cd, true, newCollection);
            this.coresLocator.create(this, cd);
            return core;
        }
        catch (Exception ex) {
            if (this.isZooKeeperAware() && !preExisitingZkEntry) {
                try {
                    this.getZkController().unregister(coreName, cd);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    SolrException.log((Logger)log, null, (Throwable)e);
                }
                catch (KeeperException e) {
                    SolrException.log((Logger)log, null, (Throwable)e);
                }
            }
            Throwable tc = ex;
            Throwable c = null;
            do {
                if ((tc = tc.getCause()) == null) continue;
                c = tc;
            } while (tc != null);
            String rootMsg = "";
            if (c != null) {
                rootMsg = " Caused by: " + c.getMessage();
            }
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Error CREATEing SolrCore '" + coreName + "': " + ex.getMessage() + rootMsg, (Throwable)ex);
        }
    }

    private SolrCore create(CoreDescriptor dcore, boolean publishState, boolean newCollection) {
        if (this.isShutDown) {
            throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "Solr has been shutdown.");
        }
        SolrCore core = null;
        try {
            MDCLoggingContext.setCoreDescriptor(dcore);
            SolrIdentifierValidator.validateCoreName((String)dcore.getName());
            if (this.zkSys.getZkController() != null) {
                this.zkSys.getZkController().preRegister(dcore);
            }
            ConfigSet coreConfig = this.coreConfigService.getConfig(dcore);
            log.info("Creating SolrCore '{}' using configuration from {}", (Object)dcore.getName(), (Object)coreConfig.getName());
            core = new SolrCore(dcore, coreConfig);
            if (!this.isZooKeeperAware() && core.getUpdateHandler().getUpdateLog() != null) {
                core.getUpdateHandler().getUpdateLog().recoverFromLog();
            }
            this.registerCore(dcore.getName(), core, publishState, newCollection);
            SolrCore solrCore = core;
            return solrCore;
        }
        catch (Exception e) {
            this.coreInitFailures.put(dcore.getName(), new CoreLoadFailure(dcore, e));
            log.error("Error creating core [{}]: {}", new Object[]{dcore.getName(), e.getMessage(), e});
            SolrException solrException = new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to create core [" + dcore.getName() + "]", (Throwable)e);
            if (core != null && !core.isClosed()) {
                org.apache.solr.common.util.IOUtils.closeQuietly((Closeable)core);
            }
            throw solrException;
        }
        catch (Throwable t) {
            SolrException e = new SolrException(SolrException.ErrorCode.SERVER_ERROR, "JVM Error creating core [" + dcore.getName() + "]: " + t.getMessage(), t);
            log.error("Error creating core [{}]: {}", new Object[]{dcore.getName(), t.getMessage(), t});
            this.coreInitFailures.put(dcore.getName(), new CoreLoadFailure(dcore, (Exception)((Object)e)));
            if (core != null && !core.isClosed()) {
                org.apache.solr.common.util.IOUtils.closeQuietly((Closeable)core);
            }
            throw t;
        }
        finally {
            MDCLoggingContext.clear();
        }
    }

    public Collection<SolrCore> getCores() {
        return this.solrCores.getCores();
    }

    public Collection<String> getCoreNames() {
        return this.solrCores.getCoreNames();
    }

    public Collection<String> getCoreNames(SolrCore core) {
        return this.solrCores.getCoreNames(core);
    }

    public Collection<String> getAllCoreNames() {
        return this.solrCores.getAllCoreNames();
    }

    public Map<String, CoreLoadFailure> getCoreInitFailures() {
        return ImmutableMap.copyOf(this.coreInitFailures);
    }

    public void reload(String name) {
        SolrCore core = this.solrCores.getCoreFromAnyList(name, false);
        if (core == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No such core: " + name);
        }
        CoreDescriptor cd = core.getCoreDescriptor();
        try {
            this.solrCores.waitAddPendingCoreOps(name);
            ConfigSet coreConfig = this.coreConfigService.getConfig(cd);
            log.info("Reloading SolrCore '{}' using configuration from {}", (Object)cd.getName(), (Object)coreConfig.getName());
            SolrCore newCore = core.reload(coreConfig);
            this.registerCore(name, newCore, false, false);
        }
        catch (SolrCoreState.CoreIsClosedException e) {
            throw e;
        }
        catch (Exception e) {
            this.coreInitFailures.put(cd.getName(), new CoreLoadFailure(cd, e));
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to reload core [" + cd.getName() + "]", (Throwable)e);
        }
        finally {
            this.solrCores.removeFromPendingOps(name);
        }
    }

    public void swap(String n0, String n1) {
        if (n0 == null || n1 == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Can not swap unnamed cores.");
        }
        this.solrCores.swap(n0, n1);
        this.coresLocator.swap(this, this.solrCores.getCoreDescriptor(n0), this.solrCores.getCoreDescriptor(n1));
        log.info("swapped: " + n0 + " with " + n1);
    }

    public void unload(String name) {
        this.unload(name, false, false, false);
    }

    public void unload(String name, boolean deleteIndexDir, boolean deleteDataDir, boolean deleteInstanceDir) {
        CoreLoadFailure loadFailure;
        if (name != null && (loadFailure = this.coreInitFailures.remove(name)) != null) {
            SolrCore.deleteUnloadedCore(loadFailure.cd, deleteDataDir, deleteInstanceDir);
            return;
        }
        CoreDescriptor cd = this.solrCores.getCoreDescriptor(name);
        if (cd == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Cannot unload non-existent core [" + name + "]");
        }
        boolean close = this.solrCores.isLoadedNotPendingClose(name);
        SolrCore core = this.solrCores.remove(name);
        this.coresLocator.delete(this, cd);
        if (core == null) {
            SolrCore.deleteUnloadedCore(cd, deleteDataDir, deleteInstanceDir);
            return;
        }
        this.metricManager.removeRegistry(core.getCoreMetricManager().getRegistryName());
        if (this.zkSys.getZkController() != null) {
            core.getSolrCoreState().cancelRecovery();
        }
        core.unloadOnClose(deleteIndexDir, deleteDataDir, deleteInstanceDir);
        if (close) {
            core.closeAndWait();
        }
        if (this.zkSys.getZkController() != null) {
            try {
                this.zkSys.getZkController().unregister(name, cd);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Interrupted while unregistering core [" + name + "] from cloud state");
            }
            catch (KeeperException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error unregistering core [" + name + "] from cloud state", (Throwable)e);
            }
        }
    }

    public void rename(String name, String toName) {
        SolrIdentifierValidator.validateCoreName((String)toName);
        try (SolrCore core = this.getCore(name);){
            if (core != null) {
                String oldRegistryName = core.getCoreMetricManager().getRegistryName();
                String newRegistryName = SolrCoreMetricManager.createRegistryName(core.getCoreDescriptor().getCollectionName(), toName);
                this.metricManager.swapRegistries(oldRegistryName, newRegistryName);
                this.registerCore(toName, core, true, false);
                SolrCore old = this.solrCores.remove(name);
                this.coresLocator.rename(this, old.getCoreDescriptor(), core.getCoreDescriptor());
            }
        }
    }

    public List<CoreDescriptor> getCoreDescriptors() {
        return this.solrCores.getCoreDescriptors();
    }

    public CoreDescriptor getCoreDescriptor(String coreName) {
        for (CoreDescriptor cd : this.getCoreDescriptors()) {
            if (!cd.getName().equals(coreName)) continue;
            return cd;
        }
        return null;
    }

    public Path getCoreRootDirectory() {
        return this.cfg.getCoreRootDirectory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SolrCore getCore(String name) {
        SolrCore core = this.solrCores.getCoreFromAnyList(name, true);
        if (core != null) {
            return core;
        }
        CoreDescriptor desc = this.solrCores.getDynamicDescriptor(name);
        if (desc == null) {
            CoreLoadFailure loadFailure = this.getCoreInitFailures().get(name);
            if (null != loadFailure) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "SolrCore '" + name + "' is not available due to init failure: " + loadFailure.exception.getMessage(), (Throwable)loadFailure.exception);
            }
            return null;
        }
        core = this.solrCores.waitAddPendingCoreOps(name);
        if (this.isShutDown) {
            return null;
        }
        try {
            if (core == null) {
                if (this.zkSys.getZkController() != null) {
                    this.zkSys.getZkController().throwErrorIfReplicaReplaced(desc);
                }
                core = this.create(desc, true, false);
            }
            core.open();
        }
        finally {
            this.solrCores.removeFromPendingOps(name);
        }
        return core;
    }

    public BlobRepository getBlobRepository() {
        return this.blobRepository;
    }

    public void waitForLoadingCoresToFinish(long timeoutMs) {
        this.solrCores.waitForLoadingCoresToFinish(timeoutMs);
    }

    public void waitForLoadingCore(String name, long timeoutMs) {
        this.solrCores.waitForLoadingCoreToFinish(name, timeoutMs);
    }

    protected <T> T createHandler(String path, String handlerClass, Class<T> clazz) {
        T handler = this.loader.newInstance(handlerClass, clazz, null, new Class[]{CoreContainer.class}, new Object[]{this});
        if (handler instanceof SolrRequestHandler) {
            this.containerHandlers.put(path, (SolrRequestHandler)handler);
        }
        if (handler instanceof SolrMetricProducer) {
            ((SolrMetricProducer)handler).initializeMetrics(this.metricManager, SolrInfoMBean.Group.node.toString(), path);
        }
        return handler;
    }

    public CoreAdminHandler getMultiCoreHandler() {
        return this.coreAdminHandler;
    }

    public CollectionsHandler getCollectionsHandler() {
        return this.collectionsHandler;
    }

    public InfoHandler getInfoHandler() {
        return this.infoHandler;
    }

    public ConfigSetsHandler getConfigSetsHandler() {
        return this.configSetsHandler;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getManagementPath() {
        return this.cfg.getManagementPath();
    }

    public LogWatcher getLogging() {
        return this.logging;
    }

    public boolean isLoaded(String name) {
        return this.solrCores.isLoaded(name);
    }

    public boolean isLoadedNotPendingClose(String name) {
        return this.solrCores.isLoadedNotPendingClose(name);
    }

    public CoreDescriptor getUnloadedCoreDescriptor(String cname) {
        return this.solrCores.getUnloadedCoreDescriptor(cname);
    }

    public String getSolrHome() {
        return this.solrHome;
    }

    public boolean isZooKeeperAware() {
        return this.zkSys.getZkController() != null;
    }

    public ZkController getZkController() {
        return this.zkSys.getZkController();
    }

    public NodeConfig getConfig() {
        return this.cfg;
    }

    public ShardHandlerFactory getShardHandlerFactory() {
        return this.shardHandlerFactory;
    }

    public UpdateShardHandler getUpdateShardHandler() {
        return this.updateShardHandler;
    }

    public SolrResourceLoader getResourceLoader() {
        return this.loader;
    }

    public boolean isCoreLoading(String name) {
        return this.solrCores.isCoreLoading(name);
    }

    public AuthorizationPlugin getAuthorizationPlugin() {
        return this.authorizationPlugin == null ? null : (AuthorizationPlugin)this.authorizationPlugin.plugin;
    }

    public AuthenticationPlugin getAuthenticationPlugin() {
        return this.authenticationPlugin == null ? null : (AuthenticationPlugin)this.authenticationPlugin.plugin;
    }

    public NodeConfig getNodeConfig() {
        return this.cfg;
    }

    public static class CoreLoadFailure {
        public final CoreDescriptor cd;
        public final Exception exception;

        public CoreLoadFailure(CoreDescriptor cd, Exception loadFailure) {
            this.cd = cd;
            this.exception = loadFailure;
        }
    }
}

