/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.overseer;

import com.codahale.metrics.Timer;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.solr.cloud.Overseer;
import org.apache.solr.cloud.overseer.ZkWriteCommand;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.util.Utils;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkStateWriter {
    private static final long MAX_FLUSH_INTERVAL = TimeUnit.NANOSECONDS.convert(1500L, TimeUnit.MILLISECONDS);
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static ZkWriteCommand NO_OP = ZkWriteCommand.noop();
    protected final ZkStateReader reader;
    protected final Overseer.Stats stats;
    protected Map<String, DocCollection> updates = new HashMap<String, DocCollection>();
    protected ClusterState clusterState = null;
    protected boolean isClusterStateModified = false;
    protected long lastUpdatedTime = 0L;
    protected int lastStateFormat = -1;
    protected String lastCollectionName = null;
    protected boolean invalidState = false;

    public ZkStateWriter(ZkStateReader zkStateReader, Overseer.Stats stats) {
        assert (zkStateReader != null);
        this.reader = zkStateReader;
        this.stats = stats;
        this.clusterState = zkStateReader.getClusterState();
    }

    public ClusterState enqueueUpdate(ClusterState prevState, ZkWriteCommand cmd, ZkWriteCallback callback) throws IllegalStateException, Exception {
        boolean isCurrentlyStateFormat1;
        DocCollection previousCollection;
        if (this.invalidState) {
            throw new IllegalStateException("ZkStateWriter has seen a tragic error, this instance can no longer be used");
        }
        if (cmd == NO_OP) {
            return prevState;
        }
        if (this.maybeFlushBefore(cmd)) {
            prevState = this.clusterState = this.writePendingUpdates();
            if (callback != null) {
                callback.onWrite();
            }
        }
        if (callback != null) {
            callback.onEnqueue();
        }
        boolean wasPreviouslyStateFormat1 = (previousCollection = prevState.getCollectionOrNull(cmd.name)) != null && previousCollection.getStateFormat() == 1;
        boolean bl = isCurrentlyStateFormat1 = cmd.collection != null && cmd.collection.getStateFormat() == 1;
        if (cmd.collection == null) {
            if (wasPreviouslyStateFormat1) {
                this.isClusterStateModified = true;
            }
            this.clusterState = prevState.copyWith(cmd.name, null);
            this.updates.put(cmd.name, null);
        } else {
            if (!isCurrentlyStateFormat1) {
                this.updates.put(cmd.name, cmd.collection);
            }
            if (isCurrentlyStateFormat1 || wasPreviouslyStateFormat1) {
                this.isClusterStateModified = true;
            }
            this.clusterState = prevState.copyWith(cmd.name, cmd.collection);
        }
        if (this.maybeFlushAfter(cmd)) {
            ClusterState state = this.writePendingUpdates();
            if (callback != null) {
                callback.onWrite();
            }
            return state;
        }
        return this.clusterState;
    }

    protected boolean maybeFlushBefore(ZkWriteCommand cmd) {
        if (this.lastUpdatedTime == 0L) {
            return false;
        }
        if (cmd.collection == null) {
            return false;
        }
        if (cmd.collection.getStateFormat() != this.lastStateFormat) {
            return true;
        }
        return cmd.collection.getStateFormat() > 1 && !cmd.name.equals(this.lastCollectionName);
    }

    protected boolean maybeFlushAfter(ZkWriteCommand cmd) {
        if (cmd.collection == null) {
            return false;
        }
        this.lastCollectionName = cmd.name;
        this.lastStateFormat = cmd.collection.getStateFormat();
        return System.nanoTime() - this.lastUpdatedTime > MAX_FLUSH_INTERVAL;
    }

    public boolean hasPendingUpdates() {
        return !this.updates.isEmpty() || this.isClusterStateModified;
    }

    public ClusterState writePendingUpdates() throws IllegalStateException, KeeperException, InterruptedException {
        if (this.invalidState) {
            throw new IllegalStateException("ZkStateWriter has seen a tragic error, this instance can no longer be used");
        }
        if (!this.hasPendingUpdates()) {
            return this.clusterState;
        }
        Timer.Context timerContext = this.stats.time("update_state");
        boolean success = false;
        try {
            if (!this.updates.isEmpty()) {
                for (Map.Entry<String, DocCollection> entry : this.updates.entrySet()) {
                    String name = entry.getKey();
                    String path = ZkStateReader.getCollectionPath((String)name);
                    DocCollection c = entry.getValue();
                    if (c == null) {
                        log.debug("going to delete_collection {}", (Object)path);
                        this.reader.getZkClient().clean("/collections/" + name);
                        continue;
                    }
                    if (c.getStateFormat() > 1) {
                        byte[] data = Utils.toJSON(Collections.singletonMap(c.getName(), c));
                        if (this.reader.getZkClient().exists(path, true).booleanValue()) {
                            log.debug("going to update_collection {} version: {}", (Object)path, (Object)c.getZNodeVersion());
                            Stat stat = this.reader.getZkClient().setData(path, data, c.getZNodeVersion(), true);
                            DocCollection newCollection = new DocCollection(name, c.getSlicesMap(), c.getProperties(), c.getRouter(), stat.getVersion(), path);
                            this.clusterState = this.clusterState.copyWith(name, newCollection);
                            continue;
                        }
                        log.debug("going to create_collection {}", (Object)path);
                        this.reader.getZkClient().create(path, data, CreateMode.PERSISTENT, true);
                        DocCollection newCollection = new DocCollection(name, c.getSlicesMap(), c.getProperties(), c.getRouter(), 0, path);
                        this.clusterState = this.clusterState.copyWith(name, newCollection);
                        continue;
                    }
                    if (c.getStateFormat() != 1) continue;
                    this.isClusterStateModified = true;
                }
                this.updates.clear();
            }
            if (this.isClusterStateModified) {
                assert (this.clusterState.getZkClusterStateVersion() >= 0);
                byte[] data = Utils.toJSON((Object)this.clusterState);
                Stat stat = this.reader.getZkClient().setData("/clusterstate.json", data, this.clusterState.getZkClusterStateVersion().intValue(), true);
                Map collections = this.clusterState.getCollectionsMap();
                this.clusterState = new ClusterState(Integer.valueOf(stat.getVersion()), this.reader.getClusterState().getLiveNodes(), collections);
                this.isClusterStateModified = false;
            }
            this.lastUpdatedTime = System.nanoTime();
            success = true;
        }
        catch (KeeperException.BadVersionException bve) {
            this.invalidState = true;
            throw bve;
        }
        finally {
            timerContext.stop();
            if (success) {
                this.stats.success("update_state");
            } else {
                this.stats.error("update_state");
            }
        }
        return this.clusterState;
    }

    public long getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public ClusterState getClusterState() {
        return this.clusterState;
    }

    public static interface ZkWriteCallback {
        public void onEnqueue() throws Exception;

        public void onWrite() throws Exception;
    }
}

