/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.overseer;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.solr.cloud.overseer.ZkWriteCommand;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeMutator {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public NodeMutator(ZkStateReader zkStateReader) {
    }

    public List<ZkWriteCommand> downNode(ClusterState clusterState, ZkNodeProps message) {
        ArrayList<ZkWriteCommand> zkWriteCommands = new ArrayList<ZkWriteCommand>();
        String nodeName = message.getStr("node_name");
        log.debug("DownNode state invoked for node: " + nodeName);
        Map collections = clusterState.getCollectionsMap();
        for (Map.Entry entry : collections.entrySet()) {
            DocCollection docCollection = (DocCollection)entry.getValue();
            LinkedHashMap<String, Slice> slicesCopy = new LinkedHashMap<String, Slice>(docCollection.getSlicesMap());
            for (Map.Entry sliceEntry : slicesCopy.entrySet()) {
                Slice slice = docCollection.getSlice((String)sliceEntry.getKey());
                HashMap<String, Replica> newReplicas = new HashMap<String, Replica>();
                Collection replicas = slice.getReplicas();
                for (Replica replica : replicas) {
                    Map props = replica.shallowCopy();
                    String rNodeName = replica.getNodeName();
                    if (rNodeName.equals(nodeName)) {
                        log.debug("Update replica state for " + replica + " to " + Replica.State.DOWN.toString());
                        props.put("state", Replica.State.DOWN.toString());
                    }
                    Replica newReplica = new Replica(replica.getName(), props);
                    newReplicas.put(replica.getName(), newReplica);
                }
                Slice newSlice = new Slice(slice.getName(), newReplicas, slice.shallowCopy());
                slicesCopy.put(slice.getName(), newSlice);
            }
            zkWriteCommands.add(new ZkWriteCommand((String)entry.getKey(), docCollection.copyWithSlices(slicesCopy)));
        }
        return zkWriteCommands;
    }
}

