/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.lang.invoke.MethodHandles;
import java.net.ConnectException;
import java.net.SocketException;
import java.util.List;
import org.apache.http.NoHttpResponseException;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.request.CoreAdminRequest;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.params.CoreAdminParams;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.util.RTimer;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeaderInitiatedRecoveryThread
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected ZkController zkController;
    protected CoreContainer coreContainer;
    protected String collection;
    protected String shardId;
    protected ZkCoreNodeProps nodeProps;
    protected int maxTries;
    private CoreDescriptor leaderCd;

    public LeaderInitiatedRecoveryThread(ZkController zkController, CoreContainer cc, String collection, String shardId, ZkCoreNodeProps nodeProps, int maxTries, CoreDescriptor leaderCd) {
        super("LeaderInitiatedRecoveryThread-" + nodeProps.getCoreName());
        this.zkController = zkController;
        this.coreContainer = cc;
        this.collection = collection;
        this.shardId = shardId;
        this.nodeProps = nodeProps;
        this.maxTries = maxTries;
        this.leaderCd = leaderCd;
        this.setDaemon(true);
    }

    @Override
    public void run() {
        RTimer timer = new RTimer();
        String replicaCoreName = this.nodeProps.getCoreName();
        String replicaCoreNodeName = ((Replica)this.nodeProps.getNodeProps()).getName();
        String replicaNodeName = this.nodeProps.getNodeName();
        String replicaUrl = this.nodeProps.getCoreUrl();
        if (!this.zkController.isReplicaInRecoveryHandling(replicaUrl)) {
            throw new SolrException(SolrException.ErrorCode.INVALID_STATE, "Replica: " + replicaUrl + " should have been marked under leader initiated recovery in ZkController but wasn't.");
        }
        boolean sendRecoveryCommand = this.publishDownState(replicaCoreName, replicaCoreNodeName, replicaNodeName, replicaUrl, false);
        if (sendRecoveryCommand) {
            try {
                this.sendRecoveryCommandWithRetry();
            }
            catch (Exception exc) {
                log.error(this.getName() + " failed due to: " + exc, (Throwable)exc);
                if (exc instanceof SolrException) {
                    throw (SolrException)((Object)exc);
                }
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)exc);
            }
            finally {
                this.zkController.removeReplicaFromLeaderInitiatedRecoveryHandling(replicaUrl);
            }
        } else {
            this.zkController.removeReplicaFromLeaderInitiatedRecoveryHandling(replicaUrl);
        }
        log.info("{} completed successfully after running for {}ms", (Object)this.getName(), (Object)timer.getTime());
    }

    public boolean publishDownState(String replicaCoreName, String replicaCoreNodeName, String replicaNodeName, String replicaUrl, boolean forcePublishState) {
        boolean sendRecoveryCommand = true;
        boolean publishDownState = false;
        if (this.zkController.getZkStateReader().getClusterState().liveNodesContain(replicaNodeName)) {
            try {
                this.updateLIRState(replicaCoreNodeName);
                log.info("Put replica core={} coreNodeName={} on " + replicaNodeName + " into leader-initiated recovery.", (Object)replicaCoreName, (Object)replicaCoreNodeName);
                publishDownState = true;
            }
            catch (Exception e) {
                Throwable setLirZnodeFailedCause = SolrException.getRootCause((Throwable)e);
                log.error("Leader failed to set replica " + this.nodeProps.getCoreUrl() + " state to DOWN due to: " + setLirZnodeFailedCause, setLirZnodeFailedCause);
                if (setLirZnodeFailedCause instanceof KeeperException.SessionExpiredException || setLirZnodeFailedCause instanceof KeeperException.ConnectionLossException || setLirZnodeFailedCause instanceof ZkController.NotLeaderException) {
                    sendRecoveryCommand = false;
                    forcePublishState = false;
                }
            }
        } else {
            log.info("Node " + replicaNodeName + " is not live, so skipping leader-initiated recovery for replica: core={} coreNodeName={}", (Object)replicaCoreName, (Object)replicaCoreNodeName);
            forcePublishState = false;
            sendRecoveryCommand = false;
        }
        try {
            if (publishDownState || forcePublishState) {
                ZkNodeProps m = new ZkNodeProps(new String[]{"operation", "state", "state", Replica.State.DOWN.toString(), "base_url", this.nodeProps.getBaseUrl(), "core", this.nodeProps.getCoreName(), "node_name", this.nodeProps.getNodeName(), "shard", this.shardId, "collection", this.collection});
                log.warn("Leader is publishing core={} coreNodeName ={} state={} on behalf of un-reachable replica {}", new Object[]{replicaCoreName, replicaCoreNodeName, Replica.State.DOWN.toString(), replicaUrl});
                this.zkController.getOverseerJobQueue().offer(Utils.toJSON((Object)m));
            }
        }
        catch (Exception e) {
            log.error("Could not publish 'down' state for replicaUrl: {}", (Object)replicaUrl, (Object)e);
        }
        return sendRecoveryCommand;
    }

    protected void updateLIRState(String replicaCoreNodeName) {
        this.zkController.updateLeaderInitiatedRecoveryState(this.collection, this.shardId, replicaCoreNodeName, Replica.State.DOWN, this.leaderCd, true);
    }

    protected void sendRecoveryCommandWithRetry() throws Exception {
        int tries = 0;
        long waitBetweenTriesMs = 5000L;
        boolean continueTrying = true;
        String replicaCoreName = this.nodeProps.getCoreName();
        String recoveryUrl = this.nodeProps.getBaseUrl();
        String replicaNodeName = this.nodeProps.getNodeName();
        String coreNeedingRecovery = this.nodeProps.getCoreName();
        String replicaCoreNodeName = ((Replica)this.nodeProps.getNodeProps()).getName();
        String replicaUrl = this.nodeProps.getCoreUrl();
        log.info(this.getName() + " started running to send REQUESTRECOVERY command to " + replicaUrl + "; will try for a max of " + (long)this.maxTries * (waitBetweenTriesMs / 1000L) + " secs");
        CoreAdminRequest.RequestRecovery recoverRequestCmd = new CoreAdminRequest.RequestRecovery();
        recoverRequestCmd.setAction(CoreAdminParams.CoreAdminAction.REQUESTRECOVERY);
        recoverRequestCmd.setCoreName(coreNeedingRecovery);
        block17: while (continueTrying && ++tries <= this.maxTries) {
            if (tries > 1) {
                log.warn("Asking core={} coreNodeName={} on " + recoveryUrl + " to recover; unsuccessful after " + tries + " of " + this.maxTries + " attempts so far ...", (Object)coreNeedingRecovery, (Object)replicaCoreNodeName);
            } else {
                log.info("Asking core={} coreNodeName={} on " + recoveryUrl + " to recover", (Object)coreNeedingRecovery, (Object)replicaCoreNodeName);
            }
            try (HttpSolrClient client = new HttpSolrClient.Builder(recoveryUrl).build();){
                client.setSoTimeout(60000);
                client.setConnectionTimeout(15000);
                try {
                    client.request((SolrRequest)recoverRequestCmd);
                    log.info("Successfully sent " + CoreAdminParams.CoreAdminAction.REQUESTRECOVERY + " command to core={} coreNodeName={} on " + recoveryUrl, (Object)coreNeedingRecovery, (Object)replicaCoreNodeName);
                    continueTrying = false;
                }
                catch (Exception t) {
                    Throwable rootCause = SolrException.getRootCause((Throwable)t);
                    boolean wasCommError = rootCause instanceof ConnectException || rootCause instanceof ConnectTimeoutException || rootCause instanceof NoHttpResponseException || rootCause instanceof SocketException;
                    SolrException.log((Logger)log, (String)(recoveryUrl + ": Could not tell a replica to recover"), (Throwable)t);
                    if (!wasCommError) {
                        continueTrying = false;
                    }
                }
            }
            if (!continueTrying) continue;
            try {
                Thread.sleep(waitBetweenTriesMs);
            }
            catch (InterruptedException ignoreMe) {
                Thread.currentThread().interrupt();
            }
            if (this.coreContainer.isShutDown()) {
                log.warn("Stop trying to send recovery command to downed replica core={} coreNodeName={} on " + replicaNodeName + " because my core container is closed.", (Object)coreNeedingRecovery, (Object)replicaCoreNodeName);
                continueTrying = false;
                break;
            }
            ZkStateReader zkStateReader = this.zkController.getZkStateReader();
            if (!zkStateReader.getClusterState().liveNodesContain(replicaNodeName)) {
                log.warn("Node " + replicaNodeName + " hosting core " + coreNeedingRecovery + " is no longer live. No need to keep trying to tell it to recover!");
                continueTrying = false;
                break;
            }
            String leaderCoreNodeName = this.leaderCd.getCloudDescriptor().getCoreNodeName();
            if (leaderCoreNodeName != null && this.collection != null) {
                String leaderCoreNodeNameFromZk = null;
                try {
                    leaderCoreNodeNameFromZk = this.zkController.getZkStateReader().getLeaderRetry(this.collection, this.shardId, 1000).getName();
                }
                catch (Exception exc) {
                    log.error("Failed to determine if " + leaderCoreNodeName + " is still the leader for " + this.collection + " " + this.shardId + " before starting leader-initiated recovery thread for " + replicaUrl + " due to: " + exc);
                }
                if (!leaderCoreNodeName.equals(leaderCoreNodeNameFromZk)) {
                    log.warn("Stop trying to send recovery command to downed replica core=" + coreNeedingRecovery + ",coreNodeName=" + replicaCoreNodeName + " on " + replicaNodeName + " because " + leaderCoreNodeName + " is no longer the leader! New leader is " + leaderCoreNodeNameFromZk);
                    continueTrying = false;
                    break;
                }
                if (!this.leaderCd.getCloudDescriptor().isLeader()) {
                    log.warn("Stop trying to send recovery command to downed replica core=" + coreNeedingRecovery + ",coreNodeName=" + replicaCoreNodeName + " on " + replicaNodeName + " because " + leaderCoreNodeName + " is no longer the leader!");
                    continueTrying = false;
                    break;
                }
            }
            if (this.collection == null || this.shardId == null) continue;
            try {
                Replica.State lirState = this.zkController.getLeaderInitiatedRecoveryState(this.collection, this.shardId, replicaCoreNodeName);
                if (lirState == null) {
                    log.warn("Stop trying to send recovery command to downed replica core=" + coreNeedingRecovery + ",coreNodeName=" + replicaCoreNodeName + " on " + replicaNodeName + " because the znode no longer exists.");
                    continueTrying = false;
                    break;
                }
                if (lirState == Replica.State.RECOVERING) {
                    continueTrying = false;
                    log.info("Replica " + coreNeedingRecovery + " on node " + replicaNodeName + " ack'd the leader initiated recovery state, no need to keep trying to send recovery command");
                    continue;
                }
                String lcnn = zkStateReader.getLeaderRetry(this.collection, this.shardId, 5000).getName();
                List replicaProps = zkStateReader.getReplicaProps(this.collection, this.shardId, lcnn);
                if (replicaProps == null || replicaProps.size() <= 0) continue;
                for (ZkCoreNodeProps prop : replicaProps) {
                    Replica replica = (Replica)prop.getNodeProps();
                    if (!replicaCoreNodeName.equals(replica.getName())) continue;
                    if (replica.getState() != Replica.State.ACTIVE || lirState != Replica.State.DOWN) continue block17;
                    log.warn("Replica core={} coreNodeName={} set to active but the leader thinks it should be in recovery; forcing it back to down state to re-run the leader-initiated recovery process; props: " + replicaProps.get(0), (Object)coreNeedingRecovery, (Object)replicaCoreNodeName);
                    this.publishDownState(replicaCoreName, replicaCoreNodeName, replicaNodeName, replicaUrl, true);
                }
            }
            catch (Exception ignoreMe) {
                log.warn("Failed to determine state of core={} coreNodeName={} due to: " + ignoreMe, (Object)coreNeedingRecovery, (Object)replicaCoreNodeName);
            }
        }
        this.zkController.removeReplicaFromLeaderInitiatedRecoveryHandling(replicaUrl);
        if (continueTrying) {
            log.error("Timed out after waiting for " + (long)tries * (waitBetweenTriesMs / 1000L) + " secs to send the recovery request to: " + replicaUrl + "; not much more we can do here?");
        }
    }
}

