/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.embedded;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.embedded.JettyConfig;
import org.apache.solr.client.solrj.embedded.SSLConfig;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.servlet.SolrDispatchFilter;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.LowResourceMonitor;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SessionIdManager;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.eclipse.jetty.server.session.HashSessionIdManager;
import org.eclipse.jetty.servlet.BaseHolder;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class JettySolrRunner {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    Server server;
    FilterHolder dispatchFilter;
    FilterHolder debugFilter;
    private boolean waitOnSolr = false;
    private int lastPort = -1;
    private final JettyConfig config;
    private final String solrHome;
    private final Properties nodeProperties;
    private volatile boolean startedBefore = false;
    private LinkedList<FilterHolder> extraFilters;
    private static final String excludePatterns = "/css/.+,/js/.+,/img/.+,/tpl/.+";
    private int proxyPort = -1;

    public JettySolrRunner(String solrHome, String context, int port) {
        this(solrHome, JettyConfig.builder().setContext(context).setPort(port).build());
    }

    public JettySolrRunner(String solrHome, JettyConfig config) {
        this(solrHome, new Properties(), config);
    }

    public JettySolrRunner(String solrHome, Properties nodeProperties, JettyConfig config) {
        this.solrHome = solrHome;
        this.config = config;
        this.nodeProperties = nodeProperties;
        this.init(this.config.port);
    }

    private void init(int port) {
        QueuedThreadPool qtp = new QueuedThreadPool();
        qtp.setMaxThreads(10000);
        qtp.setIdleTimeout((int)TimeUnit.SECONDS.toMillis(5L));
        qtp.setStopTimeout((long)((int)TimeUnit.MINUTES.toMillis(1L)));
        this.server = new Server((ThreadPool)qtp);
        this.server.manage((Object)qtp);
        this.server.setStopAtShutdown(this.config.stopAtShutdown);
        if (System.getProperty("jetty.testMode") != null) {
            ServerConnector connector;
            SslContextFactory sslcontext = SSLConfig.createContextFactory(this.config.sslConfig);
            if (sslcontext != null) {
                HttpConfiguration configuration = new HttpConfiguration();
                configuration.setSecureScheme("https");
                configuration.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
                connector = new ServerConnector(this.server, new ConnectionFactory[]{new SslConnectionFactory(sslcontext, "http/1.1"), new HttpConnectionFactory(configuration)});
            } else {
                connector = new ServerConnector(this.server, new ConnectionFactory[]{new HttpConnectionFactory()});
            }
            connector.setReuseAddress(true);
            connector.setSoLingerTime(0);
            connector.setPort(port);
            connector.setHost("127.0.0.1");
            LowResourceMonitor lowResources = new LowResourceMonitor(this.server);
            lowResources.setLowResourcesIdleTimeout(1500);
            lowResources.setMaxConnections(10000);
            this.server.addBean((Object)lowResources);
            this.server.setConnectors(new Connector[]{connector});
            this.server.setSessionIdManager((SessionIdManager)new HashSessionIdManager(new Random()));
        } else {
            ServerConnector connector = new ServerConnector(this.server, new ConnectionFactory[]{new HttpConnectionFactory()});
            connector.setPort(port);
            this.server.setConnectors(new Connector[]{connector});
        }
        final ServletContextHandler root = new ServletContextHandler((HandlerContainer)this.server, this.config.context, 1);
        this.server.addLifeCycleListener(new LifeCycle.Listener(){

            public void lifeCycleStopping(LifeCycle arg0) {
            }

            public void lifeCycleStopped(LifeCycle arg0) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void lifeCycleStarting(LifeCycle arg0) {
                JettySolrRunner jettySolrRunner = JettySolrRunner.this;
                synchronized (jettySolrRunner) {
                    JettySolrRunner.this.waitOnSolr = true;
                    JettySolrRunner.this.notify();
                }
            }

            public void lifeCycleStarted(LifeCycle arg0) {
                JettySolrRunner.this.lastPort = JettySolrRunner.this.getFirstConnectorPort();
                JettySolrRunner.this.nodeProperties.setProperty("hostPort", Integer.toString(JettySolrRunner.this.lastPort));
                JettySolrRunner.this.nodeProperties.setProperty("hostContext", ((JettySolrRunner)JettySolrRunner.this).config.context);
                root.getServletContext().setAttribute("solr.properties", (Object)JettySolrRunner.this.nodeProperties);
                root.getServletContext().setAttribute("solr.solr.home", (Object)JettySolrRunner.this.solrHome);
                logger.info("Jetty properties: {}", (Object)JettySolrRunner.this.nodeProperties);
                JettySolrRunner.this.debugFilter = root.addFilter(DebugFilter.class, "*", EnumSet.of(DispatcherType.REQUEST));
                JettySolrRunner.this.extraFilters = new LinkedList();
                for (Class<? extends Filter> filterClass : ((JettySolrRunner)JettySolrRunner.this).config.extraFilters.keySet()) {
                    JettySolrRunner.this.extraFilters.add(root.addFilter(filterClass, ((JettySolrRunner)JettySolrRunner.this).config.extraFilters.get(filterClass), EnumSet.of(DispatcherType.REQUEST)));
                }
                for (ServletHolder servletHolder : ((JettySolrRunner)JettySolrRunner.this).config.extraServlets.keySet()) {
                    String pathSpec = ((JettySolrRunner)JettySolrRunner.this).config.extraServlets.get(servletHolder);
                    root.addServlet(servletHolder, pathSpec);
                }
                JettySolrRunner.this.dispatchFilter = root.getServletHandler().newFilterHolder(BaseHolder.Source.EMBEDDED);
                JettySolrRunner.this.dispatchFilter.setHeldClass(SolrDispatchFilter.class);
                JettySolrRunner.this.dispatchFilter.setInitParameter("excludePatterns", JettySolrRunner.excludePatterns);
                root.addFilter(JettySolrRunner.this.dispatchFilter, "*", EnumSet.of(DispatcherType.REQUEST));
            }

            public void lifeCycleFailure(LifeCycle arg0, Throwable arg1) {
                System.clearProperty("hostPort");
            }
        });
        root.addServlet(Servlet404.class, "/*");
        GzipHandler gzipHandler = new GzipHandler();
        gzipHandler.setHandler((Handler)root);
        gzipHandler.setMinGzipSize(0);
        gzipHandler.setCheckGzExists(false);
        gzipHandler.setCompressionLevel(-1);
        gzipHandler.setExcludedAgentPatterns(new String[]{".*MSIE.6\\.0.*"});
        gzipHandler.setIncludedMethods(new String[]{"GET"});
        this.server.setHandler((Handler)gzipHandler);
    }

    public SolrDispatchFilter getSolrDispatchFilter() {
        return (SolrDispatchFilter)this.dispatchFilter.getFilter();
    }

    public CoreContainer getCoreContainer() {
        if (this.getSolrDispatchFilter() == null || this.getSolrDispatchFilter().getCores() == null) {
            return null;
        }
        return this.getSolrDispatchFilter().getCores();
    }

    public String getNodeName() {
        return this.getCoreContainer().getZkController().getNodeName();
    }

    public boolean isRunning() {
        return this.server.isRunning();
    }

    public boolean isStopped() {
        return this.server.isStopped();
    }

    public void start() throws Exception {
        this.start(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(boolean reusePort) throws Exception {
        Map prevContext = MDC.getCopyOfContextMap();
        MDC.clear();
        try {
            if (this.startedBefore) {
                this.waitOnSolr = false;
                int port = reusePort ? this.lastPort : this.config.port;
                this.init(port);
            } else {
                this.startedBefore = true;
            }
            if (!this.server.isRunning()) {
                this.server.start();
            }
            JettySolrRunner jettySolrRunner = this;
            synchronized (jettySolrRunner) {
                int cnt = 0;
                while (!this.waitOnSolr) {
                    this.wait(100L);
                    if (cnt++ != 5) continue;
                    throw new RuntimeException("Jetty/Solr unresponsive");
                }
            }
            if (this.config.waitForLoadingCoresToFinishMs != null && this.config.waitForLoadingCoresToFinishMs > 0L) {
                this.waitForLoadingCoresToFinish(this.config.waitForLoadingCoresToFinishMs);
            }
        }
        finally {
            if (prevContext != null) {
                MDC.setContextMap((Map)prevContext);
            } else {
                MDC.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws Exception {
        Map prevContext = MDC.getCopyOfContextMap();
        MDC.clear();
        try {
            Filter filter = this.dispatchFilter.getFilter();
            this.server.stop();
            if (this.server.getState().equals("FAILED")) {
                filter.destroy();
                if (this.extraFilters != null) {
                    for (FilterHolder f : this.extraFilters) {
                        f.getFilter().destroy();
                    }
                }
            }
            this.server.join();
        }
        finally {
            if (prevContext != null) {
                MDC.setContextMap((Map)prevContext);
            } else {
                MDC.clear();
            }
        }
    }

    private int getFirstConnectorPort() {
        Connector[] conns = this.server.getConnectors();
        if (0 == conns.length) {
            throw new RuntimeException("Jetty Server has no Connectors");
        }
        return this.proxyPort != -1 ? this.proxyPort : ((ServerConnector)conns[0]).getLocalPort();
    }

    public int getLocalPort() {
        if (this.lastPort == -1) {
            throw new IllegalStateException("You cannot get the port until this instance has started");
        }
        return this.proxyPort != -1 ? this.proxyPort : this.lastPort;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public URL getBaseUrl() {
        String protocol = null;
        try {
            Connector[] conns = this.server.getConnectors();
            if (0 == conns.length) {
                throw new IllegalStateException("Jetty Server has no Connectors");
            }
            ServerConnector c = (ServerConnector)conns[0];
            if (c.getLocalPort() < 0) {
                throw new IllegalStateException("Jetty Connector is not open: " + c.getLocalPort());
            }
            protocol = c.getDefaultProtocol().startsWith("SSL") ? "https" : "http";
            return new URL(protocol, c.getHost(), c.getLocalPort(), this.config.context);
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Java could not make sense of protocol: " + protocol, e);
        }
    }

    public SolrClient newClient() {
        return new HttpSolrClient.Builder(this.getBaseUrl().toString()).build();
    }

    public DebugFilter getDebugFilter() {
        return (DebugFilter)this.debugFilter.getFilter();
    }

    public static void main(String[] args) {
        try {
            JettySolrRunner jetty = new JettySolrRunner(".", "/solr", 8983);
            jetty.start();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public String getSolrHome() {
        return this.solrHome;
    }

    public Properties getNodeProperties() {
        return this.nodeProperties;
    }

    private void waitForLoadingCoresToFinish(long timeoutMs) {
        SolrDispatchFilter solrFilter;
        CoreContainer cores;
        if (this.dispatchFilter != null && (cores = (solrFilter = (SolrDispatchFilter)this.dispatchFilter.getFilter()).getCores()) != null) {
            cores.waitForLoadingCoresToFinish(timeoutMs);
        }
    }

    public static class Servlet404
    extends HttpServlet {
        public void service(HttpServletRequest req, HttpServletResponse res) throws IOException {
            res.sendError(404, "Can not find: " + req.getRequestURI());
        }
    }

    public static class DebugFilter
    implements Filter {
        private AtomicLong nRequests = new AtomicLong();

        public long getTotalRequests() {
            return this.nRequests.get();
        }

        public void init(FilterConfig filterConfig) throws ServletException {
        }

        public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
            this.nRequests.incrementAndGet();
            filterChain.doFilter(servletRequest, servletResponse);
        }

        public void destroy() {
        }
    }
}

