/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.dwca.tools;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class MetaValidator {
    private static final Logger LOG = LoggerFactory.getLogger(MetaValidator.class);
    private static final String SCHEMA_LANG = "http://www.w3.org/2001/XMLSchema";
    private static final String XSD_SCHEMA = "https://raw.githubusercontent.com/tdwg/dwc/master/text/tdwg_dwc_text.xsd";
    private static Validator VALIDATOR;

    public static void validate(String xml) throws IllegalArgumentException, IOException, SAXException {
        MetaValidator.validate(new StreamSource(new StringReader(xml)));
    }

    public static void validate(InputStream xml) throws IllegalArgumentException, IOException, SAXException {
        MetaValidator.validate(new StreamSource(xml));
    }

    public static void validate(Source source) throws IllegalArgumentException, IOException, SAXException {
        MetaValidator.getValidator().validate(source);
        LOG.debug("XML passed validation");
    }

    public static Validator getValidator() throws IOException, SAXException {
        if (VALIDATOR == null) {
            SchemaFactory factory = SchemaFactory.newInstance(SCHEMA_LANG);
            Schema schema = factory.newSchema(new StreamSource(XSD_SCHEMA));
            VALIDATOR = schema.newValidator();
        }
        return VALIDATOR;
    }
}

