/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.crawler.retry;

import org.gbif.crawler.RetryPolicy;

public class LimitedRetryPolicy
implements RetryPolicy {
    private final int maxTotalProtocolExceptions;
    private final int maxConsecutiveProtocolExceptions;
    private final int maxTotalTransportExceptions;
    private final int maxConsecutiveTransportExceptions;
    private int totalProtocolExceptionCount;
    private int totalTransportExceptionCount;
    private int consecutiveProtocolExceptionCount;
    private int consecutiveTransportExceptionCount;

    public LimitedRetryPolicy(int maxTotalProtocolExceptions, int maxConsecutiveProtocolExceptions, int maxTotalTransportExceptions, int maxConsecutiveTransportExceptions) {
        this.maxTotalProtocolExceptions = maxTotalProtocolExceptions;
        this.maxConsecutiveProtocolExceptions = maxConsecutiveProtocolExceptions;
        this.maxTotalTransportExceptions = maxTotalTransportExceptions;
        this.maxConsecutiveTransportExceptions = maxConsecutiveTransportExceptions;
    }

    @Override
    public boolean allowAfterProtocolException() {
        ++this.totalProtocolExceptionCount;
        ++this.consecutiveProtocolExceptionCount;
        return this.allowRetry();
    }

    @Override
    public boolean allowAfterTransportException() {
        ++this.totalTransportExceptionCount;
        ++this.consecutiveTransportExceptionCount;
        return this.allowRetry();
    }

    @Override
    public void successfulRequest() {
        this.consecutiveProtocolExceptionCount = 0;
        this.consecutiveTransportExceptionCount = 0;
    }

    @Override
    public void giveUpRequest() {
        this.consecutiveProtocolExceptionCount = 0;
        this.consecutiveTransportExceptionCount = 0;
    }

    @Override
    public boolean abortCrawl() {
        return this.totalProtocolExceptionCount > this.maxTotalProtocolExceptions || this.totalTransportExceptionCount > this.maxTotalTransportExceptions;
    }

    private boolean allowRetry() {
        return !this.abortCrawl() && this.consecutiveProtocolExceptionCount <= this.maxConsecutiveProtocolExceptions && this.consecutiveTransportExceptionCount <= this.maxConsecutiveTransportExceptions;
    }
}

