/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.crawler.protocol.biocase;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.util.UUID;
import javax.annotation.concurrent.ThreadSafe;
import org.gbif.crawler.CrawlConfiguration;

@ThreadSafe
public class BiocaseCrawlConfiguration
extends CrawlConfiguration {
    public static final ImmutableList<String> VALID_SCHEMAS = ImmutableList.of((Object)"http://www.tdwg.org/schemas/abcd/1.2", (Object)"http://www.tdwg.org/schemas/abcd/2.06");
    private final String contentNamespace;
    private final String datasetTitle;

    public BiocaseCrawlConfiguration(UUID datasetKey, int attempt, URI url, String contentNamespace, String datasetTitle) {
        super(datasetKey, url, attempt);
        this.contentNamespace = (String)Preconditions.checkNotNull((Object)contentNamespace, (Object)"contentNamespace can't be null");
        Preconditions.checkArgument((boolean)VALID_SCHEMAS.contains((Object)contentNamespace), (Object)"contentNamespace: Only ABCD 1.2 and 2.06 are supported");
        this.datasetTitle = (String)Preconditions.checkNotNull((Object)datasetTitle, (Object)"datasetTitle can't be null");
        Preconditions.checkArgument((!datasetTitle.isEmpty() ? 1 : 0) != 0, (Object)"datasetTitle can't be empty");
    }

    public String getContentNamespace() {
        return this.contentNamespace;
    }

    public String getDatasetTitle() {
        return this.datasetTitle;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BiocaseCrawlConfiguration)) {
            return false;
        }
        BiocaseCrawlConfiguration other = (BiocaseCrawlConfiguration)obj;
        return super.equals(other) && Objects.equal((Object)this.contentNamespace, (Object)other.contentNamespace) && Objects.equal((Object)this.datasetTitle, (Object)other.datasetTitle);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.contentNamespace, this.datasetTitle});
    }

    public String toString() {
        return this.toStringHelper().add("contentNamespace", (Object)this.contentNamespace).add("datasetTitle", (Object)this.datasetTitle).toString();
    }
}

