/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.sds.validation;

import au.org.ala.sds.knowledgebase.KnowledgeBaseFactory;
import au.org.ala.sds.model.Message;
import au.org.ala.sds.model.SdsMessage;
import au.org.ala.sds.model.SensitiveTaxon;
import au.org.ala.sds.model.SensitivityCategoryFactory;
import au.org.ala.sds.model.SensitivityZone;
import au.org.ala.sds.util.DateHelper;
import au.org.ala.sds.util.ValidationUtils;
import au.org.ala.sds.validation.FactCollection;
import au.org.ala.sds.validation.ReportFactory;
import au.org.ala.sds.validation.RuleState;
import au.org.ala.sds.validation.ValidationOutcome;
import au.org.ala.sds.validation.ValidationReport;
import au.org.ala.sds.validation.ValidationService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kie.internal.KnowledgeBase;
import org.kie.internal.runtime.StatelessKnowledgeSession;

public class PlantPestService
implements ValidationService {
    protected static final Logger logger = Logger.getLogger(PlantPestService.class);
    private KnowledgeBase knowledgeBase;
    private ReportFactory reportFactory;
    private final SensitiveTaxon taxon;

    public PlantPestService(SensitiveTaxon taxon, KnowledgeBase knowledgeBase, ReportFactory reportFactory) {
        this.taxon = taxon;
        this.knowledgeBase = knowledgeBase;
        this.reportFactory = reportFactory;
    }

    @Override
    public ValidationOutcome validate(Map<String, String> biocacheData) {
        FactCollection facts = new FactCollection(biocacheData);
        ValidationReport report = this.reportFactory.createValidationReport(this.taxon);
        Date date = null;
        if (!ValidationUtils.validateLocation(facts, report)) {
            return new ValidationOutcome(report, false);
        }
        try {
            date = DateHelper.validateDate(facts);
        }
        catch (Exception e) {
            report.addMessage(new SdsMessage(Message.Type.ERROR, e.getMessage(), null));
            return new ValidationOutcome(report, false);
        }
        List<SensitivityZone> zones = SensitivityZone.getListFromString(facts.get("zone"));
        RuleState state = new RuleState();
        String category = this.taxon.getInstances().get(0).getCategory().getId();
        do {
            state.setComplete(true);
            StatelessKnowledgeSession session = this.knowledgeBase.newStatelessKnowledgeSession();
            session.setGlobal("validationReport", (Object)report);
            session.setGlobal("state", (Object)state);
            session.setGlobal("logger", (Object)logger);
            session.execute(this.getFacts(this.taxon, zones, date, biocacheData));
            if (state.isComplete()) continue;
            if (StringUtils.isNotBlank((String)state.getDelegateRules())) {
                this.knowledgeBase = KnowledgeBaseFactory.getKnowledgeBase(SensitivityCategoryFactory.getCategory(state.getDelegateRules()));
                category = state.getDelegateRules();
                state.setDelegateRules(null);
                continue;
            }
            throw new IllegalStateException("Delegate rules not specified.");
        } while (!state.isComplete());
        ValidationOutcome outcome = new ValidationOutcome(report);
        outcome.setLoadable(state.isLoadable());
        outcome.setSensitive(!state.isLoadable());
        report.setAssertion(state.getAnnotation());
        report.setCategory(category);
        outcome.setControlledAccess(state.isControlledAccess());
        if (state.isRestricted()) {
            Map<String, Object> result = ValidationUtils.restrictForPests(biocacheData);
            outcome.setResult(result);
        }
        return outcome;
    }

    public void setKnowledgeBase(KnowledgeBase knowledgeBase) {
        this.knowledgeBase = knowledgeBase;
    }

    public void setReportFactory(ReportFactory reportFactory) {
        this.reportFactory = reportFactory;
    }

    private Collection<Object> getFacts(SensitiveTaxon st, List<SensitivityZone> zones, Date date, Map<String, String> props) {
        ArrayList<Object> facts = new ArrayList<Object>();
        facts.add(st);
        facts.add(zones);
        facts.add(date);
        facts.add(props);
        return facts;
    }
}

