/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.sds.model;

import au.org.ala.sds.model.SensitivityZone;
import au.org.ala.sds.util.Configuration;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public class SensitivityZoneFactory {
    protected static final Logger logger = Logger.getLogger(SensitivityZoneFactory.class);
    private static final String ZONES_RESOURCE = "sensitivity-zones.xml";
    private static Map<String, SensitivityZone> zones;
    private static Map<String, SensitivityZone> pidToZoneMap;

    public static SensitivityZone getZone(String key) {
        if (zones == null) {
            SensitivityZoneFactory.initZones();
        }
        return zones.get(key.toUpperCase());
    }

    public static SensitivityZone getZoneByName(String name) {
        if (zones == null) {
            SensitivityZoneFactory.initZones();
        }
        for (SensitivityZone sz : zones.values()) {
            if (!sz.getName().equalsIgnoreCase(name) && !sz.getId().equalsIgnoreCase(name)) continue;
            return sz;
        }
        logger.warn((Object)("No sensitivity zone matches " + name));
        return null;
    }

    public static SensitivityZone findZone(String nameOrId) {
        SensitivityZone zone = SensitivityZoneFactory.getZoneByName(nameOrId);
        if (zone == null) {
            zone = SensitivityZoneFactory.getZone(nameOrId);
        }
        return zone;
    }

    private static void initZones() {
        zones = new HashMap<String, SensitivityZone>();
        try {
            SAXBuilder builder = new SAXBuilder();
            Document doc = builder.build(SensitivityZoneFactory.getZonesInputStream());
            Element root = doc.getRootElement();
            List zonesList = root.getChildren();
            for (Element sze : zonesList) {
                SensitivityZone sz = SensitivityZoneFactory.createSensitiveZone(sze);
                zones.put(sz.getId(), sz);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to load zone information.", e);
        }
    }

    private static InputStream getZonesInputStream() {
        URL url = null;
        InputStream is = null;
        try {
            url = new URL(Configuration.getInstance().getZoneUrl());
            is = url.openStream();
        }
        catch (Exception e) {
            logger.warn((Object)("Exception occurred getting zones list from " + url), (Throwable)e);
            is = SensitivityZoneFactory.class.getClassLoader().getResourceAsStream(ZONES_RESOURCE);
            if (is == null) {
                logger.error((Object)"Unable to read sensitivity-zones.xml from jar file");
            }
            logger.info((Object)"Reading bundled resource sensitivity-zones.xml from jar file");
        }
        return is;
    }

    private static SensitivityZone createSensitiveZone(Element sze) {
        String id = sze.getAttributeValue("id");
        String name = sze.getAttributeValue("name");
        String layerId = sze.getAttributeValue("name");
        SensitivityZone.ZoneType type = SensitivityZone.ZoneType.valueOf(sze.getAttributeValue("type").toUpperCase());
        return new SensitivityZone(id, name, layerId, type);
    }

    public static void reset() {
        zones = null;
    }
}

