/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.tool;

import au.com.bytecode.opencsv.CSVReader;
import au.com.bytecode.opencsv.CSVWriter;
import au.org.ala.biocache.Config$;
import au.org.ala.biocache.caches.LocationDAO$;
import au.org.ala.biocache.model.QualityAssertion;
import au.org.ala.biocache.processor.LocationProcessor;
import au.org.ala.biocache.tool.LoadSamplingConsumer;
import au.org.ala.biocache.tool.LocColumnExporter;
import au.org.ala.biocache.tool.PointsReader;
import au.org.ala.biocache.tool.Sampling$;
import au.org.ala.biocache.tool.SyncLocTable;
import au.org.ala.biocache.util.FileHelper$;
import au.org.ala.biocache.util.GISPoint;
import au.org.ala.biocache.util.Json$;
import au.org.ala.biocache.util.LayersStore;
import au.org.ala.layers.client.Client;
import au.org.ala.layers.dao.IntersectCallback;
import au.org.ala.layers.dao.LayerIntersectDAO;
import au.org.ala.layers.dto.IntersectionFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.Null$;
import scala.runtime.RichInt$;
import scala.runtime.StringAdd$;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001\t\u0015r!B\u0001\u0003\u0011\u0003i\u0011\u0001C*b[Bd\u0017N\\4\u000b\u0005\r!\u0011\u0001\u0002;p_2T!!\u0002\u0004\u0002\u0011\tLwnY1dQ\u0016T!a\u0002\u0005\u0002\u0007\u0005d\u0017M\u0003\u0002\n\u0015\u0005\u0019qN]4\u000b\u0003-\t!!Y;\u0004\u0001A\u0011abD\u0007\u0002\u0005\u0019)\u0001C\u0001E\u0001#\tA1+Y7qY&twmE\u0003\u0010%aq\u0012\u0005\u0005\u0002\u0014-5\tACC\u0001\u0016\u0003\u0015\u00198-\u00197b\u0013\t9BC\u0001\u0004B]f\u0014VM\u001a\t\u00033qi\u0011A\u0007\u0006\u00037\u0011\t1aY7e\u0013\ti\"D\u0001\u0003U_>d\u0007CA\r \u0013\t\u0001#DA\bJ]\u000e\u0014X-\\3oi\u0006dGk\\8m!\t\u0011S%D\u0001$\u0015\t!C!A\u0003j]\u0012,\u00070\u0003\u0002'G\t91i\\;oi\u0016\u0014\b\"\u0002\u0015\u0010\t\u0003I\u0013A\u0002\u001fj]&$h\bF\u0001\u000e\u0011\u0015Yr\u0002\"\u0001,+\u0005a\u0003CA\u00173\u001b\u0005q#BA\u00181\u0003\u0011a\u0017M\\4\u000b\u0003E\nAA[1wC&\u00111G\f\u0002\u0007'R\u0014\u0018N\\4\t\u000bUzA\u0011A\u0016\u0002\t\u0011,7o\u0019\u0005\u0006o=!\t\u0001O\u0001\u0005[\u0006Lg\u000e\u0006\u0002:yA\u00111CO\u0005\u0003wQ\u0011A!\u00168ji\")QH\u000ea\u0001}\u0005!\u0011M]4t!\r\u0019r(Q\u0005\u0003\u0001R\u0011Q!\u0011:sCf\u0004\"AQ#\u000f\u0005M\u0019\u0015B\u0001#\u0015\u0003\u0019\u0001&/\u001a3fM&\u00111G\u0012\u0006\u0003\tRAQ\u0001S\b\u0005\u0002%\u000b1\u0004\\8bIN\u000bW\u000e\u001d7j]\u001eLe\u000e^8PG\u000e,(O]3oG\u0016\u001cHCA\u001dK\u0011\u0015Yu\t1\u0001B\u0003=!\u0017\r^1SKN|WO]2f+&$\u0007\"B'\u0010\t\u0003q\u0015AE:b[BdW\rR1uCJ+7o\\;sG\u0016$B!O(Q5\")1\n\u0014a\u0001\u0003\"9\u0011\u000b\u0014I\u0001\u0002\u0004\u0011\u0016\u0001C2bY2\u0014\u0017mY6\u0011\u0005MCV\"\u0001+\u000b\u0005U3\u0016a\u00013b_*\u0011qKB\u0001\u0007Y\u0006LXM]:\n\u0005e#&!E%oi\u0016\u00148/Z2u\u0007\u0006dGNY1dW\"91\f\u0014I\u0001\u0002\u0004\t\u0015aD:j]\u001edW\rT1zKJt\u0015-\\3\t\u000fu{\u0011\u0013!C\u0001=\u0006a2/Y7qY\u0016$\u0015\r^1SKN|WO]2fI\u0011,g-Y;mi\u0012\u0012T#A0+\u0005I\u00037&A1\u0011\u0005\t<W\"A2\u000b\u0005\u0011,\u0017!C;oG\",7m[3e\u0015\t1G#\u0001\u0006b]:|G/\u0019;j_:L!\u0001[2\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0004k\u001fE\u0005I\u0011A6\u00029M\fW\u000e\u001d7f\t\u0006$\u0018MU3t_V\u00148-\u001a\u0013eK\u001a\fW\u000f\u001c;%gU\tAN\u000b\u0002BA\u001a!\u0001C\u0001\u0001o'\ti'\u0003C\u0003)[\u0012\u0005\u0001\u000fF\u0001r!\tqQ\u000eC\u0004t[\n\u0007I\u0011\u0001;\u0002\r1|wmZ3s+\u0005)\bC\u0001<{\u001b\u00059(B\u0001=z\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005I\u0011BA>x\u0005\u0019aunZ4fe\"1Q0\u001cQ\u0001\nU\fq\u0001\\8hO\u0016\u0014\b\u0005\u0003\u0004\u0000[\u0012\u0005\u0011\u0011A\u0001\u0013Q\u0006tG\r\\3MCRduN\\4J]6\u000b\u0007\u000fF\u0004:\u0003\u0007\ti!!\t\t\u000f\u0005\u0015a\u00101\u0001\u0002\b\u0005\u0019Q.\u00199\u0011\u000b\t\u000bI!Q!\n\u0007\u0005-aIA\u0002NCBDq!a\u0004\u007f\u0001\u0004\t\t\"A\u0006d_>\u0014H-\u001b8bi\u0016\u001c\b#BA\n\u0003;\tUBAA\u000b\u0015\u0011\t9\"!\u0007\u0002\u000f5,H/\u00192mK*\u0019\u00111\u0004\u000b\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002 \u0005U!a\u0002%bg\"\u001cV\r\u001e\u0005\b\u0003Gq\b\u0019AA\u0013\u0003\ta\u0007\u000f\u0005\u0003\u0002(\u00055RBAA\u0015\u0015\r\tY\u0003B\u0001\naJ|7-Z:t_JLA!a\f\u0002*\t\tBj\\2bi&|g\u000e\u0015:pG\u0016\u001c8o\u001c:\t\u000f\u0005MR\u000e\"\u0001\u00026\u0005y\u0001.\u00198eY\u0016\u0014VmY8sI6\u000b\u0007\u000fF\u0004:\u0003o\tI$a\u000f\t\u0011\u0005\u0015\u0011\u0011\u0007a\u0001\u0003\u000fA\u0001\"a\u0004\u00022\u0001\u0007\u0011\u0011\u0003\u0005\t\u0003G\t\t\u00041\u0001\u0002&!I\u0011qH7C\u0002\u0013\u0005\u0011\u0011I\u0001\u000baJ|\u0007/\u001a:uS\u0016\u001cXCAA\"!\r\u0019r\b\f\u0005\t\u0003\u000fj\u0007\u0015!\u0003\u0002D\u0005Y\u0001O]8qKJ$\u0018.Z:!\u0011\u001d\tY%\u001cC\u0001\u0003\u001b\nqdZ3u\t&\u001cH/\u001b8di\u000e{wN\u001d3j]\u0006$Xm\u001d$peJ{woS3z)\rI\u0014q\n\u0005\b\u0003#\nI\u00051\u0001B\u0003\u0019\u0011xn^&fs\"9\u0011QK7\u0005\u0002\u0005]\u0013!H4fi\u0012K7\u000f^5oGR\u001cun\u001c:eS:\fG/Z:G_J4\u0015\u000e\\3\u0015\u000be\nI&!\u0018\t\u000f\u0005m\u00131\u000ba\u0001\u0003\u0006YAn\\2GS2,\u0007+\u0019;i\u0011\u001d\ty&a\u0015A\u0002\u0005\u000b!B]8x\u0017\u0016Lh)\u001b7f\u0011\u001d\t\u0019'\u001cC\u0001\u0003K\n\u0011fZ3u\t&\u001cH/\u001b8di\u000e{wN\u001d3j]\u0006$Xm\u001d$peJ+7o\\;sG\u0016$\u0006N]3bI\u0016$GcB\u001d\u0002h\u0005E\u00141\u000f\u0005\t\u0003S\n\t\u00071\u0001\u0002l\u0005Qa.^7UQJ,\u0017\rZ:\u0011\u0007M\ti'C\u0002\u0002pQ\u00111!\u00138u\u0011\u001d\tY&!\u0019A\u0002\u0005C\u0001bSA1!\u0003\u0005\r!\u0011\u0005\b\u0003ojG\u0011AA=\u0003!\u0019\u0018-\u001c9mS:<GcD\u001d\u0002|\u0005}\u00141QAC\u0003\u0013\u000b\u0019*a&\t\u000f\u0005u\u0014Q\u000fa\u0001\u0003\u0006Aa-\u001b7f!\u0006$\b\u000eC\u0004\u0002\u0002\u0006U\u0004\u0019A!\u0002\u001d=,H\u000f];u\r&dW\rU1uQ\"A\u0011+!\u001e\u0011\u0002\u0003\u0007!\u000b\u0003\u0006\u0002\b\u0006U\u0004\u0013!a\u0001\u0003W\n\u0011BY1uG\"\u001c\u0016N_3\t\u0015\u0005-\u0015Q\u000fI\u0001\u0002\u0004\ti)A\td_:\u001cWO\u001d:f]Rdu.\u00193j]\u001e\u00042aEAH\u0013\r\t\t\n\u0006\u0002\b\u0005>|G.Z1o\u0011)\t)*!\u001e\u0011\u0002\u0003\u0007\u0011QR\u0001\nW\u0016,\u0007OR5mKNDqaVA;\u0001\u0004\tI\nE\u0003\u0002\u001c\u0006-\u0016I\u0004\u0003\u0002\u001e\u0006\u001df\u0002BAP\u0003Kk!!!)\u000b\u0007\u0005\rF\"\u0001\u0004=e>|GOP\u0005\u0002+%\u0019\u0011\u0011\u0016\u000b\u0002\u000fA\f7m[1hK&!\u0011QVAX\u0005\r\u0019V-\u001d\u0006\u0004\u0003S#\u0002bBAZ[\u0012%\u0011QW\u0001\raJ|7-Z:t\u0005\u0006$8\r\u001b\u000b\ns\u0005]\u0016qZAo\u0003CD\u0001\"!/\u00022\u0002\u0007\u00111X\u0001\u0007oJLG/\u001a:\u0011\t\u0005u\u00161Z\u0007\u0003\u0003\u007fSA!!1\u0002D\u00069q\u000e]3oGN4(\u0002BAc\u0003\u000f\f\u0001BY=uK\u000e|G-\u001a\u0006\u0004\u0003\u0013T\u0011aA2p[&!\u0011QZA`\u0005%\u00195KV,sSR,'\u000f\u0003\u0005\u0002R\u0006E\u0006\u0019AAj\u0003\u0019\u0001x.\u001b8ugB!1cPAk!\u0011\u0019r(a6\u0011\u0007M\tI.C\u0002\u0002\\R\u0011a\u0001R8vE2,\u0007bBAp\u0003c\u0003\rAP\u0001\u0007M&,G\u000eZ:\t\u0011E\u000b\t\f%AA\u0002ICq!!:n\t\u0013\t9/\u0001\nqe>\u001cWm]:CCR\u001c\u0007NU3n_R,G#C\u001d\u0002j\u0006-\u0018Q^Ax\u0011!\tI,a9A\u0002\u0005m\u0006\u0002CAi\u0003G\u0004\r!a5\t\u000f\u0005}\u00171\u001da\u0001}!A\u0011+a9\u0011\u0002\u0003\u0007!\u000bC\u0004\u0002t6$\t!!>\u0002\u00191|\u0017\rZ*b[Bd\u0017N\\4\u0015\u000be\n90a?\t\u000f\u0005e\u0018\u0011\u001fa\u0001\u0003\u0006i\u0011N\u001c9vi\u001aKG.\u001a(b[\u0016D\u0001\"UAy!\u0003\u0005\rA\u0015\u0005\t\u0003\u007fl\u0017\u0013!C\u0001=\u0006\u00112/Y7qY&tw\r\n3fM\u0006,H\u000e\u001e\u00134\u0011%\u0011\u0019!\\I\u0001\n\u0003\u0011)!\u0001\ntC6\u0004H.\u001b8hI\u0011,g-Y;mi\u0012\"TC\u0001B\u0004U\r\tY\u0007\u0019\u0005\n\u0005\u0017i\u0017\u0013!C\u0001\u0005\u001b\t!c]1na2Lgn\u001a\u0013eK\u001a\fW\u000f\u001c;%kU\u0011!q\u0002\u0016\u0004\u0003\u001b\u0003\u0007\"\u0003B\n[F\u0005I\u0011\u0001B\u0007\u0003I\u0019\u0018-\u001c9mS:<G\u0005Z3gCVdG\u000f\n\u001c\t\u0011\t]Q.%A\u0005\u0002-\f1gZ3u\t&\u001cH/\u001b8di\u000e{wN\u001d3j]\u0006$Xm\u001d$peJ+7o\\;sG\u0016$\u0006N]3bI\u0016$G\u0005Z3gCVdG\u000fJ\u001a\t\u0011\tmQ.%A\u0005\u0002y\u000ba\u0003\\8bIN\u000bW\u000e\u001d7j]\u001e$C-\u001a4bk2$HE\r\u0005\t\u0005?i\u0017\u0013!C\u0005=\u0006a\u0002O]8dKN\u001c()\u0019;dQJ+Wn\u001c;fI\u0011,g-Y;mi\u0012\"\u0004\u0002\u0003B\u0012[F\u0005I\u0011\u00020\u0002-A\u0014xnY3tg\n\u000bGo\u00195%I\u00164\u0017-\u001e7uIQ\u0002")
public class Sampling {
    private final Logger logger = LoggerFactory.getLogger((String)"Sampling");
    private final String[] properties = (String[])((Object[])new String[]{"decimalLatitude", "decimalLongitude", new StringBuilder().append((Object)"decimalLatitude").append((Object)BoxesRunTime.boxToCharacter((char)Config$.MODULE$.persistenceManager().fieldDelimiter())).append((Object)"p").toString(), new StringBuilder().append((Object)"decimalLongitude").append((Object)BoxesRunTime.boxToCharacter((char)Config$.MODULE$.persistenceManager().fieldDelimiter())).append((Object)"p").toString(), "verbatimLatitude", "verbatimLongitude", "originalDecimalLatitude", "originalDecimalLongitude", "originalSensitiveValues", "geodeticDatum", "verbatimSRS", "easting", "northing", "zone"});

    public static String help() {
        return Sampling$.MODULE$.help();
    }

    public static Tuple2<Object, Option<String>> hasRowKey(String string) {
        return Sampling$.MODULE$.hasRowKey(string);
    }

    public static Option<String> getDeleteRowFile(String string) {
        return Sampling$.MODULE$.getDeleteRowFile(string);
    }

    public static long printOutStatus$default$4() {
        return Sampling$.MODULE$.printOutStatus$default$4();
    }

    public static void printOutStatus(int n, String string, String string2, long l) {
        Sampling$.MODULE$.printOutStatus(n, string, string2, l);
    }

    public static void addToCounter(int n) {
        Sampling$.MODULE$.addToCounter(n);
    }

    public static void au$org$ala$biocache$index$Counter$_setter_$logger_$eq(Logger logger) {
        Sampling$.MODULE$.au$org$ala$biocache$index$Counter$_setter_$logger_$eq(logger);
    }

    @TraitSetter
    public static void finishTime_$eq(long l) {
        Sampling$.MODULE$.finishTime_$eq(l);
    }

    public static long finishTime() {
        return Sampling$.MODULE$.finishTime();
    }

    @TraitSetter
    public static void startTime_$eq(long l) {
        Sampling$.MODULE$.startTime_$eq(l);
    }

    public static long startTime() {
        return Sampling$.MODULE$.startTime();
    }

    @TraitSetter
    public static void counter_$eq(int n) {
        Sampling$.MODULE$.counter_$eq(n);
    }

    public static int counter() {
        return Sampling$.MODULE$.counter();
    }

    public static String sampleDataResource$default$3() {
        return Sampling$.MODULE$.sampleDataResource$default$3();
    }

    public static IntersectCallback sampleDataResource$default$2() {
        return Sampling$.MODULE$.sampleDataResource$default$2();
    }

    public static void sampleDataResource(String string, IntersectCallback intersectCallback, String string2) {
        Sampling$.MODULE$.sampleDataResource(string, intersectCallback, string2);
    }

    public static void loadSamplingIntoOccurrences(String string) {
        Sampling$.MODULE$.loadSamplingIntoOccurrences(string);
    }

    public static void main(String[] stringArray) {
        Sampling$.MODULE$.main(stringArray);
    }

    public static String desc() {
        return Sampling$.MODULE$.desc();
    }

    public static String cmd() {
        return Sampling$.MODULE$.cmd();
    }

    public Logger logger() {
        return this.logger;
    }

    public void handleLatLongInMap(scala.collection.immutable.Map<String, String> map, HashSet<String> coordinates, LocationProcessor lp) {
        Option<GISPoint> option;
        block4: {
            block3: {
                block2: {
                    Option<GISPoint> latLongWithOption = lp.processLatLong((String)map.getOrElse((Object)"decimalLatitude", (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Null$ apply() {
                            return null;
                        }
                    }), (String)map.getOrElse((Object)"decimalLongitude", (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Null$ apply() {
                            return null;
                        }
                    }), (String)map.getOrElse((Object)"geodeticDatum", (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Null$ apply() {
                            return null;
                        }
                    }), (String)map.getOrElse((Object)"verbatimLongitude", (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Null$ apply() {
                            return null;
                        }
                    }), (String)map.getOrElse((Object)"verbatimLongitude", (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Null$ apply() {
                            return null;
                        }
                    }), (String)map.getOrElse((Object)"verbatimSRS", (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Null$ apply() {
                            return null;
                        }
                    }), (String)map.getOrElse((Object)"easting", (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Null$ apply() {
                            return null;
                        }
                    }), (String)map.getOrElse((Object)"northing", (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Null$ apply() {
                            return null;
                        }
                    }), (String)map.getOrElse((Object)"zone", (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Null$ apply() {
                            return null;
                        }
                    }), (String)map.getOrElse((Object)"gridReference", (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Null$ apply() {
                            return null;
                        }
                    }), (ArrayBuffer<QualityAssertion>)new ArrayBuffer());
                    option = latLongWithOption;
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    GISPoint latLong = (GISPoint)some.x();
                    coordinates.$plus$eq((Object)new StringBuilder().append((Object)latLong.longitude()).append((Object)",").append((Object)latLong.latitude()).toString());
                    coordinates.$plus$eq((Object)new StringBuilder().append((Object)((Object)BoxesRunTime.boxToFloat((float)new StringOps(Predef$.MODULE$.augmentString(latLong.longitude())).toFloat())).toString().trim()).append((Object)",").append((Object)((Object)BoxesRunTime.boxToFloat((float)new StringOps(Predef$.MODULE$.augmentString(latLong.latitude())).toFloat())).toString().trim()).toString());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option<GISPoint> option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError(option);
    }

    /*
     * Unable to fully structure code
     */
    public void handleRecordMap(scala.collection.immutable.Map<String, String> map, HashSet<String> coordinates, LocationProcessor lp) {
        this.handleLatLongInMap(map, coordinates, lp);
        v0 = originalSensitiveValues = (String)map.getOrElse((Object)"originalSensitiveValues", (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        });
        var5_5 = "";
        if (v0 == null ? var5_5 != null : v0.equals(var5_5) == false) {
            sensitiveLatLong = Json$.MODULE$.toMap(originalSensitiveValues);
            lat = sensitiveLatLong.getOrElse((Object)"decimalLatitude", (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Null$ apply() {
                    return null;
                }
            });
            lon = sensitiveLatLong.getOrElse((Object)"decimalLongitude", (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Null$ apply() {
                    return null;
                }
            });
            if (lat != null && lon != null) {
                coordinates.$plus$eq((Object)new StringBuilder().append((Object)StringAdd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd(lon), ",")).append(lat).toString());
                newMap = map.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"decimalLatitude"), (Object)lat.toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"decimalLongitude"), (Object)lon.toString())})));
                this.handleLatLongInMap((scala.collection.immutable.Map<String, String>)newMap, coordinates, lp);
            }
        }
        originalDecimalLatitude = (String)map.getOrElse((Object)"originalDecimalLatitude", (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        });
        originalDecimalLongitude = (String)map.getOrElse((Object)"originalDecimalLongitude", (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        });
        v1 = originalDecimalLatitude;
        var12_12 = "";
        if (!(v1 == null ? var12_12 != null : v1.equals(var12_12) == false)) ** GOTO lbl-1000
        v2 = originalDecimalLongitude;
        var13_13 = "";
        if (!(v2 != null ? v2.equals(var13_13) == false : var13_13 != null)) lbl-1000:
        // 2 sources

        {
            v3 = BoxedUnit.UNIT;
        } else {
            v3 = coordinates.$plus$eq((Object)new StringBuilder().append((Object)originalDecimalLongitude).append((Object)",").append((Object)originalDecimalLatitude).toString());
        }
        processedDecimalLatitude = (String)map.getOrElse((Object)new StringBuilder().append((Object)"decimalLatitude").append((Object)BoxesRunTime.boxToCharacter((char)Config$.MODULE$.persistenceManager().fieldDelimiter())).append((Object)"p").toString(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        });
        processedDecimalLongitude = (String)map.getOrElse((Object)new StringBuilder().append((Object)"decimalLongitude").append((Object)BoxesRunTime.boxToCharacter((char)Config$.MODULE$.persistenceManager().fieldDelimiter())).append((Object)"p").toString(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        });
        v4 = processedDecimalLatitude;
        var16_16 = "";
        if (v4 == null ? var16_16 != null : v4.equals(var16_16) == false) {
            v5 = processedDecimalLongitude;
            var17_17 = "";
            if (v5 == null ? var17_17 != null : v5.equals(var17_17) == false) {
                coordinates.$plus$eq((Object)new StringBuilder().append((Object)processedDecimalLongitude).append((Object)",").append((Object)processedDecimalLatitude).toString());
            }
        }
    }

    public String[] properties() {
        return this.properties;
    }

    public void getDistinctCoordinatesForRowKey(String rowKey) {
        Option<scala.collection.immutable.Map<String, String>> values = Config$.MODULE$.persistenceManager().getSelected(rowKey, "occ", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])this.properties()));
        if (values.isDefined()) {
            HashSet coordinates = new HashSet();
            this.handleRecordMap((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)values.get()), (HashSet<String>)coordinates, new LocationProcessor());
        }
    }

    public void getDistinctCoordinatesForFile(String locFilePath, String rowKeyFile) {
        this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Creating distinct list of coordinates for row keys in ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rowKeyFile})));
        IntRef counter = new IntRef(0);
        IntRef passed = new IntRef(0);
        File rowKeys = new File(rowKeyFile);
        HashSet coordinates = new HashSet();
        LocationProcessor lp = new LocationProcessor();
        FileHelper$.MODULE$.file2helper(rowKeys).foreachLine((Function1<String, BoxedUnit>)new Serializable(this, counter, passed, coordinates, lp){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Sampling $outer;
            private final IntRef counter$1;
            private final IntRef passed$1;
            private final HashSet coordinates$1;
            private final LocationProcessor lp$1;

            public final void apply(String line) {
                Option<scala.collection.immutable.Map<String, String>> values = Config$.MODULE$.persistenceManager().getSelected(line, "occ", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])this.$outer.properties()));
                if (values.isDefined()) {
                    this.$outer.handleRecordMap((scala.collection.immutable.Map<String, String>)this.map$1(values), (HashSet<String>)this.coordinates$1, this.lp$1);
                    if (this.counter$1.elem % 10000 == 0 && this.counter$1.elem > 0) {
                        int numberOfCoordinates = this.coordinates$1.size();
                        this.$outer.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Distinct coordinates counter: ", " , current count: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.counter$1.elem), BoxesRunTime.boxToInteger((int)numberOfCoordinates)})));
                    }
                    ++this.counter$1.elem;
                    ++this.passed$1.elem;
                }
            }

            private final scala.collection.immutable.Map map$1(Option values$1) {
                return (scala.collection.immutable.Map)values$1.get();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.counter$1 = counter$1;
                this.passed$1 = passed$1;
                this.coordinates$1 = coordinates$1;
                this.lp$1 = lp$1;
            }
        });
        int noOfCoordinates = coordinates.size();
        this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Created distinct list of coordinates for row keys in ", ". Number of coordinates: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rowKeyFile, BoxesRunTime.boxToInteger((int)noOfCoordinates)})));
        this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Writing to file: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{locFilePath})));
        try {
            FileWriter fw = new FileWriter(locFilePath);
            coordinates.foreach((Function1)new Serializable(this, fw){
                public static final long serialVersionUID = 0L;
                private final FileWriter fw$1;

                public final void apply(String c) {
                    this.fw$1.write(c);
                    this.fw$1.write("\n");
                }
                {
                    this.fw$1 = fw$1;
                }
            });
            fw.flush();
            fw.close();
            this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Finished writing to file: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{locFilePath})));
        }
        catch (Exception exception) {
            this.logger().error(new StringBuilder().append((Object)"Failed to write - ").append((Object)exception.getMessage()).toString(), (Throwable)exception);
        }
    }

    public void getDistinctCoordinatesForResourceThreaded(int numThreads, String locFilePath, String dataResourceUid) {
        this.logger().info("Creating distinct list of coordinates....");
        LocColumnExporter lce = new LocColumnExporter(numThreads, dataResourceUid, (Function3<scala.collection.immutable.Map<String, String>, HashSet<String>, LocationProcessor, BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Sampling $outer;

            public final void apply(scala.collection.immutable.Map<String, String> map, HashSet<String> coordinates, LocationProcessor lp) {
                this.$outer.handleRecordMap(map, coordinates, lp);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        lce.run();
        try {
            FileWriter fw = new FileWriter(locFilePath);
            lce.coordinates().foreach((Function1)new Serializable(this, fw){
                public static final long serialVersionUID = 0L;
                private final FileWriter fw$2;

                public final void apply(String c) {
                    this.fw$2.write(c);
                    this.fw$2.write("\n");
                }
                {
                    this.fw$2 = fw$2;
                }
            });
            fw.flush();
            fw.close();
        }
        catch (Exception exception) {
            this.logger().error(exception.getMessage(), (Throwable)exception);
        }
    }

    public String getDistinctCoordinatesForResourceThreaded$default$3() {
        return "";
    }

    public void sampling(String filePath, String outputFilePath, IntersectCallback callback, int batchSize, boolean concurrentLoading, boolean keepFiles, Seq<String> layers) {
        new SyncLocTable().sync();
        this.logger().info("********* START - TEST BATCH SAMPLING FROM FILE ***************");
        PointsReader pointsReader = new PointsReader(filePath);
        String[] fields = layers.nonEmpty() ? (String[])layers.toArray(ClassTag$.MODULE$.apply(String.class)) : Config$.MODULE$.fieldsToSample(Config$.MODULE$.fieldsToSample$default$1());
        String filename = outputFilePath;
        CSVWriter writer = new CSVWriter((Writer)new FileWriter(filename));
        LinkedBlockingQueue<String> batch = new LinkedBlockingQueue<String>();
        int batchCount = 0;
        LoadSamplingConsumer sampleLoading = new LoadSamplingConsumer(batch);
        if (concurrentLoading) {
            sampleLoading.start();
        }
        writer.writeNext((String[])Predef$.MODULE$.refArrayOps((Object[])new String[]{"longitude", "latitude"}).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])fields), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        int totalProcessed = 0;
        double[][] points = pointsReader.loadPoints(batchSize);
        while (true) {
            if (Predef$.MODULE$.refArrayOps((Object[])points).isEmpty()) {
                pointsReader.close();
                writer.flush();
                writer.close();
                this.logger().info(new StringBuilder().append((Object)"Total points sampled : ").append((Object)BoxesRunTime.boxToInteger((int)totalProcessed)).append((Object)", output file: ").append((Object)outputFilePath).append((Object)" point file: ").append((Object)filePath).toString());
                this.logger().info("********* END - TEST BATCH SAMPLING FROM FILE ***************");
                if (concurrentLoading) {
                    while (sampleLoading.doneList().size() < batchCount) {
                        Thread.sleep(50L);
                    }
                    sampleLoading.interrupt();
                    if (!keepFiles) {
                        Predef$.MODULE$.refArrayOps(sampleLoading.doneList().toArray()).foreach((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(Object f) {
                                return new File(f.toString()).delete();
                            }
                        });
                    }
                }
                return;
            }
            if (Config$.MODULE$.layersServiceSampling()) {
                this.processBatchRemote(writer, points, fields, callback);
            } else {
                this.processBatch(writer, points, fields, callback);
            }
            this.logger().info(new StringBuilder().append((Object)"Total points sampled so far : ").append((Object)BoxesRunTime.boxToInteger((int)(totalProcessed += Predef$.MODULE$.refArrayOps((Object[])points).size()))).toString());
            points = pointsReader.loadPoints(batchSize);
            if (!concurrentLoading) continue;
            ++batchCount;
            batch.put(filename);
            writer.flush();
            writer.close();
            filename = new StringBuilder().append((Object)outputFilePath).append((Object)BoxesRunTime.boxToInteger((int)totalProcessed)).toString();
            writer = new CSVWriter((Writer)new FileWriter(filename));
            writer.writeNext((String[])Predef$.MODULE$.refArrayOps((Object[])new String[]{"longitude", "latitude"}).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])fields), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        }
    }

    public IntersectCallback sampling$default$3() {
        return null;
    }

    public int sampling$default$4() {
        return 100000;
    }

    public boolean sampling$default$5() {
        return false;
    }

    public boolean sampling$default$6() {
        return true;
    }

    private void processBatch(CSVWriter writer, double[][] points, String[] fields, IntersectCallback callback) {
        LayerIntersectDAO layerIntersectDAO = Client.getLayerIntersectDao();
        ArrayList samples = layerIntersectDAO.sampling(fields, points, callback);
        String[][] columns = (String[][])Array$.MODULE$.ofDim(samples.size(), points.length, ClassTag$.MODULE$.apply(String.class));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), samples.size()).foreach$mVc$sp((Function1)new Serializable(this, samples, columns){
            public static final long serialVersionUID = 0L;
            private final ArrayList samples$1;
            private final String[][] columns$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.columns$1[i] = new StringOps(Predef$.MODULE$.augmentString((String)this.samples$1.get(i))).split('\n');
            }
            {
                this.samples$1 = samples$1;
                this.columns$1 = columns$1;
            }
        });
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), points.length).foreach$mVc$sp((Function1)new Serializable(this, writer, points, columns){
            public static final long serialVersionUID = 0L;
            private final CSVWriter writer$1;
            private final double[][] points$1;
            public final String[][] columns$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                String[] sampledPoint = (String[])Array$.MODULE$.fill(2 + this.columns$1.length, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "";
                    }
                }, ClassTag$.MODULE$.apply(String.class));
                sampledPoint[0] = ((Object)BoxesRunTime.boxToDouble((double)this.points$1[i][0])).toString();
                sampledPoint[1] = ((Object)BoxesRunTime.boxToDouble((double)this.points$1[i][1])).toString();
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.columns$1.length).foreach$mVc$sp((Function1)new Serializable(this, sampledPoint, i){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$processBatch$2 $outer;
                    private final String[] sampledPoint$1;
                    private final int i$1;

                    public final void apply(int j) {
                        this.apply$mcVI$sp(j);
                    }

                    public void apply$mcVI$sp(int j) {
                        if (this.i$1 < this.$outer.columns$1[j].length) {
                            String string = this.$outer.columns$1[j][this.i$1];
                            String string2 = "n/a";
                            if (string == null ? string2 != null : !string.equals(string2)) {
                                this.sampledPoint$1[j + 2] = this.$outer.columns$1[j][this.i$1];
                            }
                        }
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.sampledPoint$1 = sampledPoint$1;
                        this.i$1 = i$1;
                    }
                });
                this.writer$1.writeNext((String[])Predef$.MODULE$.refArrayOps((Object[])sampledPoint).toArray(ClassTag$.MODULE$.apply(String.class)));
                this.writer$1.flush();
            }
            {
                this.writer$1 = writer$1;
                this.points$1 = points$1;
                this.columns$1 = columns$1;
            }
        });
    }

    private IntersectCallback processBatch$default$4() {
        return null;
    }

    private void processBatchRemote(CSVWriter writer, double[][] points, String[] fields, IntersectCallback callback) {
        if (callback != null) {
            IntersectionFile[] intersectionFiles = new IntersectionFile[fields.length];
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), fields.length).foreach$mVc$sp((Function1)new Serializable(this, fields, intersectionFiles){
                public static final long serialVersionUID = 0L;
                private final String[] fields$1;
                private final IntersectionFile[] intersectionFiles$1;

                public final void apply(int j) {
                    this.apply$mcVI$sp(j);
                }

                public void apply$mcVI$sp(int j) {
                    this.intersectionFiles$1[j] = new IntersectionFile(this.fields$1[j], "", "", new StringBuilder().append((Object)"layer ").append((Object)BoxesRunTime.boxToInteger((int)(j + 1))).toString(), "", "", "", "", null);
                }
                {
                    this.fields$1 = fields$1;
                    this.intersectionFiles$1 = intersectionFiles$1;
                }
            });
            callback.setLayersToSample(intersectionFiles);
        }
        CSVReader samples = new CSVReader(this.layersStore$1().sample(fields, points, callback));
        String[] header = samples.readNext();
        String[] row = samples.readNext();
        Integer rowCounter = Predef$.MODULE$.int2Integer(0);
        while (true) {
            if (row == null) break;
            if (callback != null && Predef$.MODULE$.Integer2int(rowCounter) % 500 == 0) {
                callback.setCurrentLayer(new IntersectionFile("", "", "", new StringBuilder().append((Object)"finished. Loaded ").append((Object)rowCounter).toString(), "", "", "", "", null));
                callback.progressMessage("Loading sampling.");
            }
            rowCounter = Predef$.MODULE$.int2Integer(Predef$.MODULE$.Integer2int(rowCounter) + 1);
            String lng = row[0];
            row[0] = row[1];
            row[1] = lng;
            writer.writeNext(row);
            row = samples.readNext();
        }
        writer.flush();
        if (callback != null) {
            callback.setCurrentLayer(new IntersectionFile("", "", "", "finished. Load sampling finished", "", "", "", "", null));
            callback.progressMessage("Load sampling finished.");
        }
    }

    private IntersectCallback processBatchRemote$default$4() {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void loadSampling(String inputFileName, IntersectCallback callback) {
        this.logger().info("Loading the sampling into the database");
        long startTime = System.currentTimeMillis();
        long nextTime = System.currentTimeMillis();
        try {
            CSVReader csvReader = new CSVReader((Reader)new InputStreamReader((InputStream)new FileInputStream(inputFileName), "UTF-8"));
            String[] header = csvReader.readNext();
            int counter = 0;
            String[] line = csvReader.readNext();
            HashMap batches = new HashMap();
            int batchSize = 500;
            while (line != null) {
                try {
                    scala.collection.immutable.Map map = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])header).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])line), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).filter((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public final boolean apply(Tuple2<String, String> x) {
                            if (StringUtils.isEmpty((String)((String)x._2()).trim())) return false;
                            Object object = x._1();
                            String string = "latitude";
                            if (object == null) {
                                if (string == null) return false;
                            } else if (object.equals(string)) return false;
                            Object object2 = x._1();
                            String string2 = "longitude";
                            if (object2 != null) {
                                if (!object2.equals(string2)) return true;
                                return false;
                            }
                            if (string2 == null) return false;
                            return true;
                        }
                    })).toMap(Predef$.MODULE$.conforms());
                    String el = Json$.MODULE$.toJSON((scala.collection.immutable.Map<String, Object>)((scala.collection.immutable.Map)((TraversableLike)map.filter((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public final boolean apply(Tuple2<String, String> x) {
                            if (!((String)x._1()).startsWith("el")) return false;
                            Object object = x._2();
                            String string = "n/a";
                            if (object == null) {
                                if (string == null) return false;
                                return true;
                            } else if (object.equals(string)) return false;
                            return true;
                        }
                    })).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Tuple2<String, Object> apply(Tuple2<String, String> y) {
                            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc(y._1()), (Object)BoxesRunTime.boxToFloat((float)new StringOps(Predef$.MODULE$.augmentString((String)y._2())).toFloat()));
                        }
                    }, Map$.MODULE$.canBuildFrom())));
                    String cl = Json$.MODULE$.toJSON((scala.collection.immutable.Map<String, Object>)((scala.collection.immutable.Map)map.filter((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public final boolean apply(Tuple2<String, String> x) {
                            if (!((String)x._1()).startsWith("cl")) return false;
                            Object object = x._2();
                            String string = "n/a";
                            if (object == null) {
                                if (string == null) return false;
                                return true;
                            } else if (object.equals(string)) return false;
                            return true;
                        }
                    })).toMap(Predef$.MODULE$.conforms()));
                    if (batches.size() == batchSize) {
                        LocationDAO$.MODULE$.writeLocBatch((Map<String, scala.collection.immutable.Map<String, String>>)batches);
                        batches.clear();
                    }
                    batches.$plus$eq(LocationDAO$.MODULE$.addLayerIntersects(line[1], line[0], cl, el, true));
                    if (counter % 200 == 0 && callback != null) {
                        callback.setCurrentLayer(new IntersectionFile("", "", "", new StringBuilder().append((Object)"finished. Processing loaded samples ").append((Object)BoxesRunTime.boxToInteger((int)counter)).toString(), "", "", "", "", null));
                        callback.progressMessage("Loading sampling.");
                    }
                    if (counter % 1000 == 0) {
                        this.logger().info(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"writing to loc: ", " : records per sec: "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)counter)}))).append((Object)BoxesRunTime.boxToFloat((float)(1000.0f / ((float)(System.currentTimeMillis() - nextTime) / 1000.0f)))).toString());
                        nextTime = System.currentTimeMillis();
                    }
                    ++counter;
                }
                catch (Exception exception) {
                    this.logger().error(exception.getMessage(), (Throwable)exception);
                    this.logger().error(new StringBuilder().append((Object)"Problem writing line: ").append((Object)BoxesRunTime.boxToInteger((int)counter)).append((Object)", line length: ").append((Object)BoxesRunTime.boxToInteger((int)line.length)).append((Object)", header length: ").append((Object)BoxesRunTime.boxToInteger((int)header.length)).toString());
                }
                line = csvReader.readNext();
            }
            csvReader.close();
            if (batches.size() > 0) {
                LocationDAO$.MODULE$.writeLocBatch((Map<String, scala.collection.immutable.Map<String, String>>)batches.toMap(Predef$.MODULE$.conforms()));
            }
        }
        catch (Exception exception) {
            this.logger().error(new StringBuilder().append((Object)"Problem loading sampling. ").append((Object)exception.getMessage()).toString(), (Throwable)exception);
        }
        this.logger().info(new StringBuilder().append((Object)"Finished loading: ").append((Object)inputFileName).append((Object)" in ").append((Object)BoxesRunTime.boxToLong((long)(System.currentTimeMillis() - startTime))).append((Object)"ms").toString());
    }

    public IntersectCallback loadSampling$default$2() {
        return null;
    }

    private final LayersStore layersStore$1() {
        return new LayersStore(Config$.MODULE$.layersServiceUrl());
    }
}

