/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.tool;

import au.org.ala.biocache.Config$;
import au.org.ala.biocache.caches.LocationDAO$;
import au.org.ala.biocache.cmd.IncrementalTool;
import au.org.ala.biocache.cmd.IncrementalTool$class;
import au.org.ala.biocache.cmd.Tool;
import au.org.ala.biocache.cmd.Tool$class;
import au.org.ala.biocache.index.Counter;
import au.org.ala.biocache.index.Counter$class;
import au.org.ala.biocache.model.Location;
import au.org.ala.biocache.tool.ProcessRecords$;
import au.org.ala.biocache.tool.Sampling;
import au.org.ala.biocache.util.OptionParser;
import au.org.ala.layers.dao.IntersectCallback;
import java.io.File;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.collection.mutable.WrappedArray;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.TraitSetter;
import scala.sys.package$;

public final class Sampling$
implements Tool,
IncrementalTool,
Counter {
    public static final Sampling$ MODULE$;
    private final Logger logger;
    private int counter;
    private long startTime;
    private long finishTime;

    static {
        new Sampling$();
    }

    @Override
    public Logger logger() {
        return this.logger;
    }

    @Override
    public int counter() {
        return this.counter;
    }

    @Override
    @TraitSetter
    public void counter_$eq(int x$1) {
        this.counter = x$1;
    }

    @Override
    public long startTime() {
        return this.startTime;
    }

    @Override
    @TraitSetter
    public void startTime_$eq(long x$1) {
        this.startTime = x$1;
    }

    @Override
    public long finishTime() {
        return this.finishTime;
    }

    @Override
    @TraitSetter
    public void finishTime_$eq(long x$1) {
        this.finishTime = x$1;
    }

    @Override
    public void au$org$ala$biocache$index$Counter$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    @Override
    public void addToCounter(int amount) {
        Counter$class.addToCounter(this, amount);
    }

    @Override
    public void printOutStatus(int threadId, String lastKey, String runnerType, long totalTime) {
        Counter$class.printOutStatus(this, threadId, lastKey, runnerType, totalTime);
    }

    @Override
    public long printOutStatus$default$4() {
        return Counter$class.printOutStatus$default$4(this);
    }

    @Override
    public Option<String> getDeleteRowFile(String resourceUid) {
        return IncrementalTool$class.getDeleteRowFile(this, resourceUid);
    }

    @Override
    public Tuple2<Object, Option<String>> hasRowKey(String resourceUid) {
        return IncrementalTool$class.hasRowKey(this, resourceUid);
    }

    @Override
    public String help() {
        return Tool$class.help(this);
    }

    @Override
    public String cmd() {
        return "sample";
    }

    @Override
    public String desc() {
        return "Sample coordinates against geospatial layers";
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void main(String[] args) {
        block12: {
            block13: {
                block15: {
                    block14: {
                        dataResourceUid = new ObjectRef((Object)"");
                        locFilePath = new ObjectRef((Object)"");
                        singleLayerName = new ObjectRef((Object)"");
                        rowKeyFile = new ObjectRef((Object)"");
                        keepFiles = new BooleanRef(true);
                        singleRowKey = new ObjectRef((Object)"");
                        workingDir = new ObjectRef((Object)Config$.MODULE$.tmpWorkDir());
                        parser = new OptionParser(dataResourceUid, locFilePath, singleLayerName, rowKeyFile, keepFiles, singleRowKey, workingDir, batchSize = new IntRef(100000), checkRowKeyFile = new BooleanRef(true), abortIfNotRowKeyFile = new BooleanRef(true), numThreads = new IntRef(8)){
                            {
                                this.opt("dr", "data-resource-uid", "the data resource to sample", (Function1<String, BoxedUnit>)new Serializable(this, dataResourceUid$1){
                                    public static final long serialVersionUID = 0L;
                                    private final ObjectRef dataResourceUid$1;

                                    public final void apply(String v) {
                                        this.dataResourceUid$1.elem = v;
                                    }
                                    {
                                        this.dataResourceUid$1 = dataResourceUid$1;
                                    }
                                });
                                this.opt("cf", "coordinates-file", "the file containing coordinates", (Function1<String, BoxedUnit>)new Serializable(this, locFilePath$1){
                                    public static final long serialVersionUID = 0L;
                                    private final ObjectRef locFilePath$1;

                                    public final void apply(String v) {
                                        this.locFilePath$1.elem = v;
                                    }
                                    {
                                        this.locFilePath$1 = locFilePath$1;
                                    }
                                });
                                this.opt("l", "single-layer-sample", "sample a single layer only", (Function1<String, BoxedUnit>)new Serializable(this, singleLayerName$1){
                                    public static final long serialVersionUID = 0L;
                                    private final ObjectRef singleLayerName$1;

                                    public final void apply(String v) {
                                        this.singleLayerName$1.elem = v;
                                    }
                                    {
                                        this.singleLayerName$1 = singleLayerName$1;
                                    }
                                });
                                this.opt("rf", "row-key-file", "The row keys which to sample", (Function1<String, BoxedUnit>)new Serializable(this, rowKeyFile$1){
                                    public static final long serialVersionUID = 0L;
                                    private final ObjectRef rowKeyFile$1;

                                    public final void apply(String v) {
                                        this.rowKeyFile$1.elem = v;
                                    }
                                    {
                                        this.rowKeyFile$1 = rowKeyFile$1;
                                    }
                                });
                                this.opt("keep", "Keep the files produced from the sampling", (Function0<BoxedUnit>)new Serializable(this, keepFiles$1){
                                    public static final long serialVersionUID = 0L;
                                    private final BooleanRef keepFiles$1;

                                    public final void apply() {
                                        this.apply$mcV$sp();
                                    }

                                    public void apply$mcV$sp() {
                                        this.keepFiles$1.elem = true;
                                    }
                                    {
                                        this.keepFiles$1 = keepFiles$1;
                                    }
                                });
                                this.opt("rk", "key", "the single rowkey to sample", (Function1<String, BoxedUnit>)new Serializable(this, singleRowKey$1){
                                    public static final long serialVersionUID = 0L;
                                    private final ObjectRef singleRowKey$1;

                                    public final void apply(String v) {
                                        this.singleRowKey$1.elem = v;
                                    }
                                    {
                                        this.singleRowKey$1 = singleRowKey$1;
                                    }
                                });
                                this.opt("wd", "working-dir", new StringBuilder().append((Object)"the directory to write temporary files too. Defaults to ").append((Object)Config$.MODULE$.tmpWorkDir()).toString(), (Function1<String, BoxedUnit>)new Serializable(this, workingDir$1){
                                    public static final long serialVersionUID = 0L;
                                    private final ObjectRef workingDir$1;

                                    public final void apply(String v) {
                                        this.workingDir$1.elem = v;
                                    }
                                    {
                                        this.workingDir$1 = workingDir$1;
                                    }
                                });
                                this.intOpt("bs", "batch-size", new StringBuilder().append((Object)"Batch size when processing points. Defaults to ").append((Object)BoxesRunTime.boxToInteger((int)batchSize$1.elem)).toString(), (Function1<Object, BoxedUnit>)new Serializable(this, batchSize$1){
                                    public static final long serialVersionUID = 0L;
                                    private final IntRef batchSize$1;

                                    public final void apply(int v) {
                                        this.apply$mcVI$sp(v);
                                    }

                                    public void apply$mcVI$sp(int v) {
                                        this.batchSize$1.elem = v;
                                    }
                                    {
                                        this.batchSize$1 = batchSize$1;
                                    }
                                });
                                this.opt("crk", "check for row key file", (Function0<BoxedUnit>)new Serializable(this, checkRowKeyFile$1){
                                    public static final long serialVersionUID = 0L;
                                    private final BooleanRef checkRowKeyFile$1;

                                    public final void apply() {
                                        this.apply$mcV$sp();
                                    }

                                    public void apply$mcV$sp() {
                                        this.checkRowKeyFile$1.elem = true;
                                    }
                                    {
                                        this.checkRowKeyFile$1 = checkRowKeyFile$1;
                                    }
                                });
                                this.opt("acrk", "abort if no row key file found", (Function0<BoxedUnit>)new Serializable(this, abortIfNotRowKeyFile$1){
                                    public static final long serialVersionUID = 0L;
                                    private final BooleanRef abortIfNotRowKeyFile$1;

                                    public final void apply() {
                                        this.apply$mcV$sp();
                                    }

                                    public void apply$mcV$sp() {
                                        this.abortIfNotRowKeyFile$1.elem = true;
                                    }
                                    {
                                        this.abortIfNotRowKeyFile$1 = abortIfNotRowKeyFile$1;
                                    }
                                });
                                this.intOpt("t", "threads", new StringBuilder().append((Object)"The number of threads for the unique coordinate extract. The default is ").append((Object)BoxesRunTime.boxToInteger((int)numThreads$1.elem)).toString(), (Function1<Object, BoxedUnit>)new Serializable(this, numThreads$1){
                                    public static final long serialVersionUID = 0L;
                                    private final IntRef numThreads$1;

                                    public final void apply(int v) {
                                        this.apply$mcVI$sp(v);
                                    }

                                    public void apply$mcVI$sp(int v) {
                                        this.numThreads$1.elem = v;
                                    }
                                    {
                                        this.numThreads$1 = numThreads$1;
                                    }
                                });
                            }
                        };
                        if (!parser.parse((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])args))) break block12;
                        if (StringUtils.isEmpty((String)Config$.MODULE$.layersServiceUrl()) || !Config$.MODULE$.layersServiceSampling()) break block13;
                        s = new Sampling();
                        v0 = (String)dataResourceUid.elem;
                        var15_15 = "";
                        if ((v0 == null ? var15_15 != null : v0.equals(var15_15) == false) && checkRowKeyFile.elem) {
                            var17_16 = ProcessRecords$.MODULE$.hasRowKey((String)dataResourceUid.elem);
                            if (var17_16 != null) {
                                hasRowKey = var17_16._1$mcZ$sp();
                                retrievedRowKeyFile = (Option)var17_16._2();
                                var16_20 = var20_19 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)hasRowKey), (Object)retrievedRowKeyFile);
                                hasRowKey = var16_20._1$mcZ$sp();
                                retrievedRowKeyFile = (Option)var16_20._2();
                                rowKeyFile.elem = (String)retrievedRowKeyFile.getOrElse((Function0)new Serializable(){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply() {
                                        return "";
                                    }
                                });
                            } else {
                                throw new MatchError(var17_16);
                            }
                        }
                        if (!abortIfNotRowKeyFile.elem) break block14;
                        v1 = (String)rowKeyFile.elem;
                        var23_23 = "";
                        if ((v1 == null ? var23_23 != null : v1.equals(var23_23) == false) && new File((String)rowKeyFile.elem).exists()) break block14;
                        this.logger().warn("No rowkey file was found for this sampling. Aborting.");
                        break block12;
                    }
                    v2 = (String)dataResourceUid.elem;
                    var25_24 = "";
                    if (!(v2 != null ? v2.equals(var25_24) == false : var25_24 != null)) {
                        this.logger().info("Sampling all records");
                        v3 = "all";
                    } else {
                        this.logger().info(new StringBuilder().append((Object)"Sampling : ").append((Object)((String)dataResourceUid.elem)).toString());
                        v3 = (String)dataResourceUid.elem;
                    }
                    fileSuffix = v3;
                    v4 = (String)locFilePath.elem;
                    var26_26 = "";
                    if (v4 != null ? v4.equals(var26_26) == false : var26_26 != null) break block15;
                    locFilePath.elem = new StringBuilder().append((Object)((String)workingDir.elem)).append((Object)"/loc-").append((Object)fileSuffix).append((Object)".txt").toString();
                    v5 = (String)rowKeyFile.elem;
                    var27_27 = "";
                    if (v5 != null ? v5.equals(var27_27) == false : var27_27 != null) ** GOTO lbl-1000
                    v6 = (String)singleRowKey.elem;
                    var28_28 = "";
                    if (!(v6 != null ? v6.equals(var28_28) == false : var28_28 != null)) {
                        s.getDistinctCoordinatesForResourceThreaded(numThreads.elem, (String)locFilePath.elem, (String)dataResourceUid.elem);
                    } else lbl-1000:
                    // 2 sources

                    {
                        v7 = (String)singleRowKey.elem;
                        var29_29 = "";
                        if (!(v7 != null ? v7.equals(var29_29) == false : var29_29 != null)) {
                            s.getDistinctCoordinatesForFile((String)locFilePath.elem, (String)rowKeyFile.elem);
                        } else {
                            s.getDistinctCoordinatesForRowKey((String)singleRowKey.elem);
                            throw package$.MODULE$.exit();
                        }
                    }
                }
                samplingFilePath = new StringBuilder().append((Object)((String)workingDir.elem)).append((Object)"/sampling-").append((Object)fileSuffix).append((Object)".txt").toString();
                this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Running sampling...writing to file: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{samplingFilePath})));
                v8 = (String)singleLayerName.elem;
                var32_31 = "";
                layers = !(v8 != null ? v8.equals(var32_31) == false : var32_31 != null) ? (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class)) : (String[])((Object[])new String[]{(String)singleLayerName.elem});
                x$4 = (String)locFilePath.elem;
                x$5 = samplingFilePath;
                x$6 = batchSize.elem;
                x$7 = true;
                x$8 = keepFiles.elem;
                x$9 = Predef$.MODULE$.wrapRefArray((Object[])layers);
                x$10 = s.sampling$default$3();
                s.sampling(x$4, x$5, x$10, x$6, x$7, x$8, (Seq<String>)x$9);
                this.logger().info("Loading sampling into occ table");
                if ((String)dataResourceUid.elem != null) {
                    this.loadSamplingIntoOccurrences((String)dataResourceUid.elem);
                }
                this.logger().info("Completed loading sampling into occ table");
                if (!keepFiles.elem) {
                    this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Removing temporary file: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{samplingFilePath})));
                    new File(samplingFilePath).delete();
                    if (new File((String)locFilePath.elem).exists()) {
                        new File((String)locFilePath.elem).delete();
                    }
                }
                break block12;
            }
            this.logger().warn("No layer service configured or sampling disabled. No sampling will take place");
            return;
        }
    }

    public void loadSamplingIntoOccurrences(String dataResourceUid) {
        this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Starting loading sampling for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dataResourceUid})));
        Config$.MODULE$.persistenceManager().pageOverSelect("occ", (Function2<String, Map<String, String>, Object>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String guid, Map<String, String> map) {
                Tuple3 tuple3;
                block7: {
                    block4: {
                        block6: {
                            Tuple3 tuple32;
                            Object object;
                            Option<Tuple3<Location, String, String>> point;
                            block5: {
                                String lat = (String)map.getOrElse((Object)new StringBuilder().append((Object)"decimalLatitude").append((Object)BoxesRunTime.boxToCharacter((char)Config$.MODULE$.persistenceManager().fieldDelimiter())).append((Object)"p").toString(), (Function0)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply() {
                                        return "";
                                    }
                                });
                                String lon = (String)map.getOrElse((Object)new StringBuilder().append((Object)"decimalLongitude").append((Object)BoxesRunTime.boxToCharacter((char)Config$.MODULE$.persistenceManager().fieldDelimiter())).append((Object)"p").toString(), (Function0)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply() {
                                        return "";
                                    }
                                });
                                if (lat == null || lon == null) break block4;
                                point = LocationDAO$.MODULE$.getSamplesForLatLon(lat, lon);
                                if (!point.isEmpty()) break block5;
                                object = BoxedUnit.UNIT;
                                break block6;
                            }
                            tuple3 = (Tuple3)point.get();
                            if (tuple3 == null) break block7;
                            Location location = (Location)tuple3._1();
                            String environmentalLayers = (String)tuple3._2();
                            String contextualLayers = (String)tuple3._3();
                            Tuple3 tuple33 = tuple32 = new Tuple3((Object)location, (Object)environmentalLayers, (Object)contextualLayers);
                            Location location2 = (Location)tuple33._1();
                            String environmentalLayers2 = (String)tuple33._2();
                            String contextualLayers2 = (String)tuple33._3();
                            object = Config$.MODULE$.persistenceManager().put(guid, "occ", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new StringBuilder().append((Object)"el").append((Object)BoxesRunTime.boxToCharacter((char)Config$.MODULE$.persistenceManager().fieldDelimiter())).append((Object)"p").toString()), (Object)environmentalLayers2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new StringBuilder().append((Object)"cl").append((Object)BoxesRunTime.boxToCharacter((char)Config$.MODULE$.persistenceManager().fieldDelimiter())).append((Object)"p").toString()), (Object)contextualLayers2)}))), false, false);
                        }
                        Sampling$.MODULE$.counter_$eq(Sampling$.MODULE$.counter() + 1);
                        if (Sampling$.MODULE$.counter() % 1000 == 0) {
                            Sampling$.MODULE$.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[Loading sampling] Import of sample data ", " Last key ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)Sampling$.MODULE$.counter()), guid})));
                        }
                    }
                    return true;
                }
                throw new MatchError((Object)tuple3);
            }
        }, 1000, 1, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder().append((Object)"decimalLatitude").append((Object)BoxesRunTime.boxToCharacter((char)Config$.MODULE$.persistenceManager().fieldDelimiter())).append((Object)"p").toString(), new StringBuilder().append((Object)"decimalLongitude").append((Object)BoxesRunTime.boxToCharacter((char)Config$.MODULE$.persistenceManager().fieldDelimiter())).append((Object)"p").toString()}));
    }

    public void sampleDataResource(String dataResourceUid, IntersectCallback callback, String singleLayerName) {
        String locFilePath = new StringBuilder().append((Object)Config$.MODULE$.tmpWorkDir()).append((Object)"/loc-").append((Object)dataResourceUid).append((Object)".txt").toString();
        Sampling s = new Sampling();
        s.getDistinctCoordinatesForResourceThreaded(4, locFilePath, dataResourceUid);
        String samplingFilePath = new StringBuilder().append((Object)Config$.MODULE$.tmpWorkDir()).append((Object)"/sampling-").append((Object)dataResourceUid).append((Object)".txt").toString();
        String x$11 = locFilePath;
        String x$12 = samplingFilePath;
        IntersectCallback x$13 = callback;
        WrappedArray x$14 = Predef$.MODULE$.wrapRefArray((Object[])new String[]{singleLayerName});
        int x$15 = s.sampling$default$4();
        boolean x$16 = s.sampling$default$5();
        boolean x$17 = s.sampling$default$6();
        s.sampling(x$11, x$12, x$13, x$15, x$16, x$17, (Seq<String>)x$14);
        s.loadSampling(samplingFilePath, callback);
        this.logger().info(new StringBuilder().append((Object)"Removing temporary file: ").append((Object)samplingFilePath).toString());
        new File(samplingFilePath).delete();
        new File(locFilePath).delete();
    }

    public IntersectCallback sampleDataResource$default$2() {
        return null;
    }

    public String sampleDataResource$default$3() {
        return "";
    }

    private Sampling$() {
        MODULE$ = this;
        Tool$class.$init$(this);
        IncrementalTool$class.$init$(this);
        Counter$class.$init$(this);
    }
}

