/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.tool;

import au.org.ala.biocache.Config$;
import au.org.ala.biocache.cmd.IncrementalTool;
import au.org.ala.biocache.cmd.IncrementalTool$class;
import au.org.ala.biocache.cmd.Tool;
import au.org.ala.biocache.cmd.Tool$class;
import au.org.ala.biocache.dao.OccurrenceDAO;
import au.org.ala.biocache.model.FullRecord;
import au.org.ala.biocache.persistence.PersistenceManager;
import au.org.ala.biocache.processor.RecordProcessor;
import au.org.ala.biocache.tool.ProcessRecords$;
import au.org.ala.biocache.util.FileHelper$;
import au.org.ala.biocache.util.OptionParser;
import au.org.ala.biocache.util.StringConsumer;
import java.io.File;
import java.util.concurrent.ArrayBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;

public final class ProcessRecords$
implements Tool,
IncrementalTool {
    public static final ProcessRecords$ MODULE$;
    private final OccurrenceDAO occurrenceDAO;
    private final PersistenceManager persistenceManager;
    private final Logger logger;

    static {
        new ProcessRecords$();
    }

    @Override
    public Option<String> getDeleteRowFile(String resourceUid) {
        return IncrementalTool$class.getDeleteRowFile(this, resourceUid);
    }

    @Override
    public Tuple2<Object, Option<String>> hasRowKey(String resourceUid) {
        return IncrementalTool$class.hasRowKey(this, resourceUid);
    }

    @Override
    public String help() {
        return Tool$class.help(this);
    }

    @Override
    public String cmd() {
        return "process";
    }

    @Override
    public String desc() {
        return "Process records (geospatial, taxonomy)";
    }

    public OccurrenceDAO occurrenceDAO() {
        return this.occurrenceDAO;
    }

    public PersistenceManager persistenceManager() {
        return this.persistenceManager;
    }

    public Logger logger() {
        return this.logger;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void main(String[] args) {
        this.logger().info("Starting processing...");
        IntRef threads = new IntRef(4);
        BooleanRef checkDeleted = new BooleanRef(false);
        ObjectRef dataResourceUid = new ObjectRef((Object)None$.MODULE$);
        boolean checkRowKeyFile = true;
        String rowKeyFile = "";
        boolean abortIfNotRowKeyFile = true;
        OptionParser parser = new OptionParser(threads, checkDeleted, dataResourceUid){
            {
                this.intOpt("t", "thread", "The number of threads to use", (Function1<Object, BoxedUnit>)new Serializable(this, threads$1){
                    public static final long serialVersionUID = 0L;
                    private final IntRef threads$1;

                    public final void apply(int v) {
                        this.apply$mcVI$sp(v);
                    }

                    public void apply$mcVI$sp(int v) {
                        this.threads$1.elem = v;
                    }
                    {
                        this.threads$1 = threads$1;
                    }
                });
                this.opt("dr", "resource", "The data resource to process", (Function1<String, BoxedUnit>)new Serializable(this, dataResourceUid$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef dataResourceUid$1;

                    public final void apply(String v) {
                        this.dataResourceUid$1.elem = new Some((Object)v);
                    }
                    {
                        this.dataResourceUid$1 = dataResourceUid$1;
                    }
                });
                this.booleanOpt("cd", "checkDeleted", "Check deleted records", (Function1<Object, BoxedUnit>)new Serializable(this, checkDeleted$1){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef checkDeleted$1;

                    public final void apply(boolean v) {
                        this.checkDeleted$1.elem = v;
                    }
                    {
                        this.checkDeleted$1 = checkDeleted$1;
                    }
                });
            }
        };
        if (!parser.parse((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])args))) return;
        if (!((Option)dataResourceUid.elem).isEmpty() && checkRowKeyFile) {
            Tuple2 tuple2;
            Tuple2<Object, Option<String>> tuple22 = this.hasRowKey((String)((Option)dataResourceUid.elem).get());
            if (tuple22 == null) throw new MatchError(tuple22);
            boolean hasRowKey = tuple22._1$mcZ$sp();
            Option retrievedRowKeyFile = (Option)tuple22._2();
            Tuple2 tuple23 = tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)hasRowKey), (Object)retrievedRowKeyFile);
            boolean hasRowKey2 = tuple23._1$mcZ$sp();
            Option retrievedRowKeyFile2 = (Option)tuple23._2();
            rowKeyFile = (String)retrievedRowKeyFile2.getOrElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "";
                }
            });
        }
        if (abortIfNotRowKeyFile) {
            String string = rowKeyFile;
            String string2 = "";
            if (!(string == null ? string2 != null : !string.equals(string2)) || !new File(rowKeyFile).exists()) {
                this.logger().warn("No rowkey file was found for this processing. Aborting.");
                return;
            }
        }
        String string = rowKeyFile;
        String string3 = "";
        if (!(string != null ? !string.equals(string3) : string3 != null)) {
            this.logger().info("rowkey file not found");
            return;
        }
        this.processFileOfRowKeys(new File(rowKeyFile), threads.elem);
    }

    public void processRecords(String dataResourceUid, int threads) {
        Tuple2<Object, Option<String>> tuple2 = this.hasRowKey(dataResourceUid);
        if (tuple2 != null) {
            Tuple2 tuple22;
            boolean hasRowKey = tuple2._1$mcZ$sp();
            Option retrievedRowKeyFile = (Option)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)hasRowKey), (Object)retrievedRowKeyFile);
            boolean hasRowKey2 = tuple23._1$mcZ$sp();
            Option retrievedRowKeyFile2 = (Option)tuple23._2();
            if (!retrievedRowKeyFile2.isEmpty() && new File((String)retrievedRowKeyFile2.get()).exists()) {
                this.processFileOfRowKeys(new File((String)retrievedRowKeyFile2.get()), threads);
            } else {
                this.logger().warn("No rowkey file was found for this processing. Aborting.");
            }
            return;
        }
        throw new MatchError(tuple2);
    }

    public void processRowKeys(List<String> rowkeys) {
        List<String> queue = rowkeys;
        boolean ids = false;
        IntRef counter = new IntRef(0);
        RecordProcessor recordProcessor = new RecordProcessor();
        rowkeys.foreach((Function1)new Serializable(counter, recordProcessor){
            public static final long serialVersionUID = 0L;
            private final IntRef counter$1;
            private final RecordProcessor recordProcessor$1;

            public final Object apply(String guid) {
                Map<String, Object> map;
                ++this.counter$1.elem;
                Option<FullRecord[]> rawProcessed = Config$.MODULE$.occurrenceDAO().getRawProcessedByRowKey(guid);
                if (rawProcessed.isEmpty()) {
                    map = BoxedUnit.UNIT;
                } else {
                    FullRecord[] rp = (FullRecord[])rawProcessed.get();
                    map = this.recordProcessor$1.processRecord(rp[0], rp[1], this.recordProcessor$1.processRecord$default$3(), this.recordProcessor$1.processRecord$default$4(), this.recordProcessor$1.processRecord$default$5());
                }
                return map;
            }
            {
                this.counter$1 = counter$1;
                this.recordProcessor$1 = recordProcessor$1;
            }
        });
        this.logger().info(new StringBuilder().append((Object)"Total records processed: ").append((Object)BoxesRunTime.boxToInteger((int)counter.elem)).toString());
    }

    public void processFileOfRowKeys(File file, int threads) {
        ArrayBlockingQueue queue = new ArrayBlockingQueue(100);
        IntRef ids = new IntRef(0);
        IntRef counter = new IntRef(0);
        RecordProcessor recordProcessor = new RecordProcessor();
        StringConsumer[] pool = (StringConsumer[])Array$.MODULE$.fill(threads, (Function0)new Serializable(queue, ids, counter, recordProcessor){
            public static final long serialVersionUID = 0L;
            private final ArrayBlockingQueue queue$1;
            private final IntRef ids$1;
            public final IntRef counter$2;
            public final RecordProcessor recordProcessor$2;

            /*
             * WARNING - void declaration
             */
            public final StringConsumer apply() {
                void var3_3;
                LongRef startTime = new LongRef(System.currentTimeMillis());
                LongRef finishTime = new LongRef(System.currentTimeMillis());
                StringConsumer p = new StringConsumer(this.queue$1, this.ids$1.elem, (Function1<String, BoxedUnit>)new Serializable(this, startTime, finishTime){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.4 $outer;
                    private final LongRef startTime$1;
                    private final LongRef finishTime$1;

                    public final void apply(String guid) {
                        ++this.$outer.counter$2.elem;
                        Option<FullRecord[]> rawProcessed = Config$.MODULE$.occurrenceDAO().getRawProcessedByRowKey(guid);
                        if (!rawProcessed.isEmpty()) {
                            FullRecord[] rp = (FullRecord[])rawProcessed.get();
                            this.$outer.recordProcessor$2.processRecord(rp[0], rp[1], this.$outer.recordProcessor$2.processRecord$default$3(), this.$outer.recordProcessor$2.processRecord$default$4(), this.$outer.recordProcessor$2.processRecord$default$5());
                            if (this.$outer.counter$2.elem % 1000 == 0) {
                                this.finishTime$1.elem = System.currentTimeMillis();
                                ProcessRecords$.MODULE$.logger().info(new StringBuilder().append(this.$outer.counter$2.elem).append((Object)" >> Last key : ").append((Object)rp[0].rowKey()).append((Object)", records per sec: ").append((Object)BoxesRunTime.boxToFloat((float)(1000.0f / ((float)(this.finishTime$1.elem - this.startTime$1.elem) / 1000.0f)))).toString());
                                this.startTime$1.elem = System.currentTimeMillis();
                            }
                        }
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.startTime$1 = startTime$1;
                        this.finishTime$1 = finishTime$1;
                    }
                });
                ++this.ids$1.elem;
                p.start();
                return var3_3;
            }
            {
                this.queue$1 = queue$1;
                this.ids$1 = ids$1;
                this.counter$2 = counter$2;
                this.recordProcessor$2 = recordProcessor$2;
            }
        }, ClassTag$.MODULE$.apply(StringConsumer.class));
        FileHelper$.MODULE$.file2helper(file).foreachLine((Function1<String, BoxedUnit>)new Serializable(queue){
            public static final long serialVersionUID = 0L;
            private final ArrayBlockingQueue queue$1;

            public final void apply(String line) {
                this.queue$1.put(line.trim());
            }
            {
                this.queue$1 = queue$1;
            }
        });
        Predef$.MODULE$.refArrayOps((Object[])pool).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(StringConsumer t) {
                t.shouldStop_$eq(true);
            }
        });
        Predef$.MODULE$.refArrayOps((Object[])pool).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(StringConsumer x$3) {
                x$3.join();
            }
        });
        this.logger().info(new StringBuilder().append((Object)"Total records processed: ").append((Object)BoxesRunTime.boxToInteger((int)counter.elem)).toString());
    }

    private ProcessRecords$() {
        MODULE$ = this;
        Tool$class.$init$(this);
        IncrementalTool$class.$init$(this);
        this.occurrenceDAO = Config$.MODULE$.occurrenceDAO();
        this.persistenceManager = Config$.MODULE$.persistenceManager();
        this.logger = LoggerFactory.getLogger((String)"ProcessRecords");
    }
}

