/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.tool;

import au.org.ala.biocache.Config$;
import au.org.ala.biocache.model.FullRecord;
import au.org.ala.biocache.processor.RecordProcessor;
import au.org.ala.biocache.tool.ProcessLocalRecords$;
import au.org.ala.biocache.util.ZookeeperUtil$;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001m<Q!\u0001\u0002\t\u00025\t1\u0003\u0015:pG\u0016\u001c8\u000fT8dC2\u0014VmY8sINT!a\u0001\u0003\u0002\tQ|w\u000e\u001c\u0006\u0003\u000b\u0019\t\u0001BY5pG\u0006\u001c\u0007.\u001a\u0006\u0003\u000f!\t1!\u00197b\u0015\tI!\"A\u0002pe\u001eT\u0011aC\u0001\u0003CV\u001c\u0001\u0001\u0005\u0002\u000f\u001f5\t!AB\u0003\u0011\u0005!\u0005\u0011CA\nQe>\u001cWm]:M_\u000e\fGNU3d_J$7oE\u0002\u0010%a\u0001\"a\u0005\f\u000e\u0003QQ\u0011!F\u0001\u0006g\u000e\fG.Y\u0005\u0003/Q\u0011a!\u00118z%\u00164\u0007CA\r\u001d\u001b\u0005Q\"BA\u000e\u0005\u0003\r\u0019W\u000eZ\u0005\u0003;i\u0011A\u0001V8pY\")qd\u0004C\u0001A\u00051A(\u001b8jiz\"\u0012!\u0004\u0005\u00067=!\tAI\u000b\u0002GA\u0011A%K\u0007\u0002K)\u0011aeJ\u0001\u0005Y\u0006twMC\u0001)\u0003\u0011Q\u0017M^1\n\u0005)*#AB*ue&tw\rC\u0003-\u001f\u0011\u0005!%\u0001\u0003eKN\u001c\u0007\"\u0002\u0018\u0010\t\u0003y\u0013\u0001B7bS:$\"\u0001M\u001a\u0011\u0005M\t\u0014B\u0001\u001a\u0015\u0005\u0011)f.\u001b;\t\u000bQj\u0003\u0019A\u001b\u0002\t\u0005\u0014xm\u001d\t\u0004'YB\u0014BA\u001c\u0015\u0005\u0015\t%O]1z!\tIDH\u0004\u0002\u0014u%\u00111\bF\u0001\u0007!J,G-\u001a4\n\u0005)j$BA\u001e\u0015\r\u0011\u0001\"\u0001A \u0014\u0005y\u0012\u0002\"B\u0010?\t\u0003\tE#\u0001\"\u0011\u00059q\u0004b\u0002#?\u0005\u0004%\t!R\u0001\u0007Y><w-\u001a:\u0016\u0003\u0019\u0003\"aR&\u000e\u0003!S!!\u0013&\u0002\u000bMdg\r\u000e6\u000b\u0003%I!\u0001\u0014%\u0003\r1{wmZ3s\u0011\u0019qe\b)A\u0005\r\u00069An\\4hKJ\u0004\u0003\"\u0002)?\t\u0003\t\u0016a\u00049s_\u000e,7o\u001d+bq\u0006|e\u000e\\=\u0015\u000bA\u0012v+W.\t\u000bM{\u0005\u0019\u0001+\u0002\u000fQD'/Z1egB\u00111#V\u0005\u0003-R\u00111!\u00138u\u0011\u0015Av\n1\u00019\u00031!\u0018\r_1GS2,\u0007+\u0019;i\u0011\u0015Qv\n1\u0001U\u0003I\u0019H/\u0019:u)>\\WM\u001c*b]\u001e,\u0017\n\u001a=\t\u000bq{\u0005\u0019\u0001\u001d\u0002\u001d\rDWmY6q_&tGOR5mK\")aL\u0010C\u0001?\u0006q\u0001O]8dKN\u001c(+Z2pe\u0012\u001cHC\u0002\u0019aC>\f(\u000fC\u0003T;\u0002\u0007A\u000bC\u0003c;\u0002\u00071-A\u0002eeN\u00042\u0001\u001a79\u001d\t)'N\u0004\u0002gS6\tqM\u0003\u0002i\u0019\u00051AH]8pizJ\u0011!F\u0005\u0003WR\tq\u0001]1dW\u0006<W-\u0003\u0002n]\n\u00191+Z9\u000b\u0005-$\u0002\"\u00029^\u0001\u0004\u0019\u0017aB:lSB$%o\u001d\u0005\u00065v\u0003\r\u0001\u0016\u0005\u00069v\u0003\r\u0001\u000f\u0005\u0006iz\"\t!^\u0001\u000fg\u0016$8\t[3dWB|\u0017N\u001c;t)\r1\u0018P\u001f\t\u0003']L!\u0001\u001f\u000b\u0003\u0007\u0005s\u0017\u0010C\u0003[g\u0002\u0007A\u000bC\u0003]g\u0002\u0007\u0001\b")
public class ProcessLocalRecords {
    private final Logger logger = LoggerFactory.getLogger((String)"ProcessLocalRecords");

    public static String help() {
        return ProcessLocalRecords$.MODULE$.help();
    }

    public static void main(String[] stringArray) {
        ProcessLocalRecords$.MODULE$.main(stringArray);
    }

    public static String desc() {
        return ProcessLocalRecords$.MODULE$.desc();
    }

    public static String cmd() {
        return ProcessLocalRecords$.MODULE$.cmd();
    }

    public Logger logger() {
        return this.logger;
    }

    public void processTaxaOnly(int threads, String taxaFilePath, int startTokenRangeIdx, String checkpointFile) {
        ZookeeperUtil$.MODULE$.setStatus("PROCESSING", "STARTING", 0);
        Set taxaIDList = Source$.MODULE$.fromFile(new File(taxaFilePath), Codec$.MODULE$.fallbackSystemCodec()).getLines().toSet();
        this.logger().info(new StringBuilder().append((Object)"Number of taxa to process ").append((Object)BoxesRunTime.boxToInteger((int)taxaIDList.size())).toString());
        RecordProcessor processor = new RecordProcessor();
        IntRef count = new IntRef(0);
        IntRef matchedCount = new IntRef(0);
        ObjectRef lastMatched = new ObjectRef((Object)"");
        this.setCheckpoints(startTokenRangeIdx, checkpointFile);
        Config$.MODULE$.persistenceManager().pageOverLocal("occ", (Function3<String, Map<String, String>, String, Object>)new Serializable(this, taxaIDList, processor, count, matchedCount, lastMatched){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProcessLocalRecords $outer;
            private final Set taxaIDList$1;
            private final RecordProcessor processor$1;
            private final IntRef count$1;
            private final IntRef matchedCount$1;
            private final ObjectRef lastMatched$1;

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public final boolean apply(String rowkey, Map<String, String> map, String batchID) {
                BoxedUnit boxedUnit;
                String taxonConceptID;
                String string = taxonConceptID = (String)map.getOrElse((Object)new StringBuilder().append((Object)"taxonConceptID").append((Object)BoxesRunTime.boxToCharacter((char)Config$.MODULE$.persistenceManager().fieldDelimiter())).append((Object)"p").toString(), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "";
                    }
                });
                String string2 = "";
                if ((string == null ? string2 != null : !string.equals(string2)) && this.taxaIDList$1.contains((Object)taxonConceptID)) {
                    Option<FullRecord[]> records = Config$.MODULE$.occurrenceDAO().getAllVersionsByRowKey(rowkey, Config$.MODULE$.occurrenceDAO().getAllVersionsByRowKey$default$2());
                    if (records.isEmpty()) {
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        this.processor$1.processRecord(((FullRecord[])records.get())[0], ((FullRecord[])records.get())[1], this.processor$1.processRecord$default$3(), this.processor$1.processRecord$default$4(), this.processor$1.processRecord$default$5());
                        ProcessLocalRecords processLocalRecords = this.$outer;
                        synchronized (processLocalRecords) {
                            ++this.matchedCount$1.elem;
                            this.lastMatched$1.elem = rowkey;
                            BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                            // MONITOREXIT @DISABLED, blocks:[0, 1, 4, 7] lbl16 : MonitorExitStatement: MONITOREXIT : var7_7
                            boxedUnit = boxedUnit2;
                        }
                    }
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                ++this.count$1.elem;
                if (this.count$1.elem % 100000 == 0) {
                    this.$outer.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Total read : ", ", total matched: ", ", last matched ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.count$1.elem), BoxesRunTime.boxToInteger((int)this.matchedCount$1.elem), (String)this.lastMatched$1.elem})));
                    ZookeeperUtil$.MODULE$.setStatus("PROCESSING", "RUNNING", this.count$1.elem);
                }
                return true;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.taxaIDList$1 = taxaIDList$1;
                this.processor$1 = processor$1;
                this.count$1 = count$1;
                this.matchedCount$1 = matchedCount$1;
                this.lastMatched$1 = lastMatched$1;
            }
        }, threads, (String[])((Object[])new String[]{"rowkey", new StringBuilder().append((Object)"taxonConceptID").append((Object)BoxesRunTime.boxToCharacter((char)Config$.MODULE$.persistenceManager().fieldDelimiter())).append((Object)"p").toString()}));
        new File(checkpointFile).renameTo(new File(new StringBuilder().append((Object)checkpointFile).append((Object)".complete").toString()));
        ZookeeperUtil$.MODULE$.setStatus("PROCESSING", "COMPLETE", count.elem);
        this.logger().info(new StringBuilder().append((Object)"Finished reprocessing. Total matched and reprocessed: ").append((Object)BoxesRunTime.boxToInteger((int)count.elem)).toString());
    }

    public void processRecords(int threads, Seq<String> drs, Seq<String> skipDrs, int startTokenRangeIdx, String checkpointFile) {
        RecordProcessor processor = new RecordProcessor();
        long start = System.currentTimeMillis();
        LongRef lastLog = new LongRef(System.currentTimeMillis());
        IntRef updateCount = new IntRef(0);
        IntRef readCount = new IntRef(0);
        this.setCheckpoints(startTokenRangeIdx, checkpointFile);
        this.logger().info("Using a full scan...");
        int total = Config$.MODULE$.occurrenceDAO().pageOverRawProcessedLocal((Function1<Option<Tuple2<FullRecord, FullRecord>>, Object>)new Serializable(this, drs, skipDrs, processor, lastLog, updateCount, readCount){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProcessLocalRecords $outer;
            private final Seq drs$2;
            private final Seq skipDrs$2;
            private final RecordProcessor processor$2;
            private final LongRef lastLog$1;
            private final IntRef updateCount$1;
            private final IntRef readCount$1;

            public final boolean apply(Option<Tuple2<FullRecord, FullRecord>> record) {
                if (!record.isEmpty()) {
                    FullRecord raw = (FullRecord)((Tuple2)record.get())._1();
                    FullRecord processed = (FullRecord)((Tuple2)record.get())._2();
                    String uuid = raw.rowKey();
                    ++this.readCount$1.elem;
                    if ((this.drs$2.isEmpty() || this.drs$2.contains((Object)raw.attribution().dataResourceUid())) && !this.skipDrs$2.contains((Object)raw.attribution().dataResourceUid())) {
                        this.processor$2.processRecord(raw, processed, false, true, this.processor$2.processRecord$default$5());
                        ++this.updateCount$1.elem;
                    }
                    if (this.updateCount$1.elem % 10000 == 0) {
                        long end = System.currentTimeMillis();
                        float timeInSecs = (float)(end - this.lastLog$1.elem) / 1000.0f;
                        int recordsPerSec = Math.round(10000.0f / timeInSecs);
                        this.$outer.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Total processed : ", ", total read: ", " Last rowkey: ", "  Last 1000 in ", " seconds (", " records a second)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.updateCount$1.elem), BoxesRunTime.boxToInteger((int)this.readCount$1.elem), uuid, BoxesRunTime.boxToFloat((float)timeInSecs), BoxesRunTime.boxToInteger((int)recordsPerSec)})));
                        this.lastLog$1.elem = end;
                        ZookeeperUtil$.MODULE$.setStatus("PROCESSING", "RUNNING", this.updateCount$1.elem);
                    }
                }
                return true;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.drs$2 = drs$2;
                this.skipDrs$2 = skipDrs$2;
                this.processor$2 = processor$2;
                this.lastLog$1 = lastLog$1;
                this.updateCount$1 = updateCount$1;
                this.readCount$1 = readCount$1;
            }
        }, null, threads);
        new File(checkpointFile).renameTo(new File(new StringBuilder().append((Object)checkpointFile).append((Object)".complete").toString()));
        ZookeeperUtil$.MODULE$.setStatus("PROCESSING", "COMPLETED", total);
        long end = System.currentTimeMillis();
        float timeInMinutes = (float)(end - start) / 100.0f / 60.0f / 60.0f;
        float timeInSecs = (float)(end - start) / 1000.0f;
        this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Total records processed : ", " in ", " seconds (or ", " minutes)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)total), BoxesRunTime.boxToFloat((float)timeInSecs), BoxesRunTime.boxToFloat((float)timeInMinutes)})));
    }

    public Object setCheckpoints(int startTokenRangeIdx, String checkpointFile) {
        Object object;
        System.setProperty("startAtTokenRange", ((Object)BoxesRunTime.boxToInteger((int)startTokenRangeIdx)).toString());
        System.setProperty("tokenRangeCheckPointFile", checkpointFile);
        if (new File(checkpointFile).exists()) {
            this.logger().info("Checkpoint file detected. Will attempt to restart process.....");
            ObjectRef completedTokenRanges = new ObjectRef((Object)((ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$)));
            Source$.MODULE$.fromFile(checkpointFile, Codec$.MODULE$.fallbackSystemCodec()).getLines().foreach((Function1)new Serializable(this, completedTokenRanges){
                public static final long serialVersionUID = 0L;
                private final ObjectRef completedTokenRanges$1;

                public final Object apply(String line) {
                    String[] parts = line.split(",");
                    return parts.length == 2 ? ((ListBuffer)this.completedTokenRanges$1.elem).$plus$eq((Object)parts[0]) : BoxedUnit.UNIT;
                }
                {
                    this.completedTokenRanges$1 = completedTokenRanges$1;
                }
            });
            object = System.setProperty("completedTokenRanges", ((ListBuffer)completedTokenRanges.elem).mkString(","));
        } else {
            object = BoxedUnit.UNIT;
        }
        return object;
    }
}

