/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.processor;

import au.org.ala.biocache.Config$;
import au.org.ala.biocache.dao.OccurrenceDAO;
import au.org.ala.biocache.load.FullRecordMapper$;
import au.org.ala.biocache.model.FullRecord;
import au.org.ala.biocache.model.Processed$;
import au.org.ala.biocache.model.QualityAssertion;
import au.org.ala.biocache.model.Version;
import au.org.ala.biocache.model.Versions$;
import au.org.ala.biocache.processor.Processor;
import au.org.ala.biocache.processor.Processors$;
import java.util.Date;
import java.util.UUID;
import org.apache.commons.lang.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0005}c\u0001B\u0001\u0003\u00015\u0011qBU3d_J$\u0007K]8dKN\u001cxN\u001d\u0006\u0003\u0007\u0011\t\u0011\u0002\u001d:pG\u0016\u001c8o\u001c:\u000b\u0005\u00151\u0011\u0001\u00032j_\u000e\f7\r[3\u000b\u0005\u001dA\u0011aA1mC*\u0011\u0011BC\u0001\u0004_J<'\"A\u0006\u0002\u0005\u0005,8\u0001A\n\u0003\u00019\u0001\"a\u0004\n\u000e\u0003AQ\u0011!E\u0001\u0006g\u000e\fG.Y\u0005\u0003'A\u0011a!\u00118z%\u00164\u0007\"B\u000b\u0001\t\u00031\u0012A\u0002\u001fj]&$h\bF\u0001\u0018!\tA\u0002!D\u0001\u0003\u0011\u001dQ\u0002A1A\u0005\u0002m\ta\u0001\\8hO\u0016\u0014X#\u0001\u000f\u0011\u0005u\tS\"\u0001\u0010\u000b\u0005}\u0001\u0013!B:mMRR'\"A\u0005\n\u0005\tr\"A\u0002'pO\u001e,'\u000f\u0003\u0004%\u0001\u0001\u0006I\u0001H\u0001\bY><w-\u001a:!\u0011\u001d1\u0003A1A\u0005\u0002\u001d\n1\u0002\u001d:pG\u0016\u001c8\u000fV5nKV\t\u0001\u0006\u0005\u0002*]5\t!F\u0003\u0002,Y\u0005!A.\u00198h\u0015\u0005i\u0013\u0001\u00026bm\u0006L!a\f\u0016\u0003\rM#(/\u001b8h\u0011\u0019\t\u0004\u0001)A\u0005Q\u0005a\u0001O]8dKN\u001cH+[7fA!91\u0007\u0001b\u0001\n\u0003!\u0014A\u00033va2L7-\u0019;fgV\tQ\u0007E\u00027w!j\u0011a\u000e\u0006\u0003qe\n\u0011\"[7nkR\f'\r\\3\u000b\u0005i\u0002\u0012AC2pY2,7\r^5p]&\u0011Ah\u000e\u0002\u0005\u0019&\u001cH\u000f\u0003\u0004?\u0001\u0001\u0006I!N\u0001\fIV\u0004H.[2bi\u0016\u001c\b\u0005C\u0004A\u0001\t\u0007I\u0011A!\u0002\u001dA\u0014xnY3tgRKW.\u001b8hgV\t!\t\u0005\u0003D\r\"sU\"\u0001#\u000b\u0005\u0015K\u0014aB7vi\u0006\u0014G.Z\u0005\u0003\u000f\u0012\u00131!T1q!\tIEJ\u0004\u0002\u0010\u0015&\u00111\nE\u0001\u0007!J,G-\u001a4\n\u0005=j%BA&\u0011!\tyq*\u0003\u0002Q!\t!Aj\u001c8h\u0011\u0019\u0011\u0006\u0001)A\u0005\u0005\u0006y\u0001O]8dKN\u001cH+[7j]\u001e\u001c\b\u0005C\u0003U\u0001\u0011\u0005Q+A\u0007qe>\u001cWm]:SK\u000e|'\u000f\u001a\u000b\u0007-n\u001bWM\u001b7\u0011\t%;\u0006\nW\u0005\u0003\u000f6\u0003\"!K-\n\u0005iS#AB(cU\u0016\u001cG\u000fC\u0003]'\u0002\u0007Q,A\u0002sC^\u0004\"AX1\u000e\u0003}S!\u0001\u0019\u0003\u0002\u000b5|G-\u001a7\n\u0005\t|&A\u0003$vY2\u0014VmY8sI\")Am\u0015a\u0001;\u0006\u00012-\u001e:sK:$\bK]8dKN\u001cX\r\u001a\u0005\bMN\u0003\n\u00111\u0001h\u0003\u0015\u0011\u0017\r^2i!\ty\u0001.\u0003\u0002j!\t9!i\\8mK\u0006t\u0007bB6T!\u0003\u0005\raZ\u0001\nM&\u00148\u000f\u001e'pC\u0012Dq!\\*\u0011\u0002\u0003\u0007a.\u0001\u0006qe>\u001cWm]:peN\u00042aD8I\u0013\t\u0001\bC\u0001\u0004PaRLwN\u001c\u0005\u0006e\u0002!\ta]\u0001\u0012oJLG/\u001a)s_\u000e,7o\u001d\"bi\u000eDGC\u0001;x!\tyQ/\u0003\u0002w!\t!QK\\5u\u0011\u00151\u0017\u000f1\u0001y!\u0011I\u00181\u0001,\u000f\u0005i|hBA>\u007f\u001b\u0005a(BA?\r\u0003\u0019a$o\\8u}%\t\u0011#C\u0002\u0002\u0002A\tq\u0001]1dW\u0006<W-C\u0002=\u0003\u000bQ1!!\u0001\u0011\u0011\u0019!\u0006\u0001\"\u0001\u0002\nQ!\u00111BA\u0010!\u0019y\u0011QB/\u0002\u0012%\u0019\u0011q\u0002\t\u0003\rQ+\b\u000f\\33!\u0015Iu\u000bSA\n!\u0015y\u0011QCA\r\u0013\r\t9\u0002\u0005\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0004=\u0006m\u0011bAA\u000f?\n\u0001\u0012+^1mSRL\u0018i]:feRLwN\u001c\u0005\u00079\u0006\u001d\u0001\u0019A/\t\u000f\u0005\r\u0002\u0001\"\u0001\u0002&\u00051\u0002O]8dKN\u001c(+Z2pe\u0012\fe\u000eZ+qI\u0006$X\rF\u0002u\u0003OAa\u0001XA\u0011\u0001\u0004i\u0006bBA\u0016\u0001\u0011\u0005\u0011QF\u0001\nC\u0012$'+Z2pe\u0012$R\u0001SA\u0018\u0003gAq!!\r\u0002*\u0001\u0007\u0001*A\beCR\f'+Z:pkJ\u001cW-V5e\u0011!\t)$!\u000bA\u0002\u0005]\u0012A\u00039s_B,'\u000f^5fgB!\u0011j\u0016%I\u0011%\tY\u0004AI\u0001\n\u0003\ti$A\fqe>\u001cWm]:SK\u000e|'\u000f\u001a\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011q\b\u0016\u0004O\u0006\u00053FAA\"!\u0011\t)%a\u0014\u000e\u0005\u0005\u001d#\u0002BA%\u0003\u0017\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u00055\u0003#\u0001\u0006b]:|G/\u0019;j_:LA!!\u0015\u0002H\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0013\u0005U\u0003!%A\u0005\u0002\u0005u\u0012a\u00069s_\u000e,7o\u001d*fG>\u0014H\r\n3fM\u0006,H\u000e\u001e\u00135\u0011%\tI\u0006AI\u0001\n\u0003\tY&A\fqe>\u001cWm]:SK\u000e|'\u000f\u001a\u0013eK\u001a\fW\u000f\u001c;%kU\u0011\u0011Q\f\u0016\u0004]\u0006\u0005\u0003")
public class RecordProcessor {
    private final Logger logger = LoggerFactory.getLogger(RecordProcessor.class);
    private final String processTime = DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd'T'HH:mm:ss'Z'");
    private final List<String> duplicates = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"D", "D1", "D2"}));
    private final scala.collection.mutable.Map<String, Object> processTimings = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);

    public Logger logger() {
        return this.logger;
    }

    public String processTime() {
        return this.processTime;
    }

    public List<String> duplicates() {
        return this.duplicates;
    }

    public scala.collection.mutable.Map<String, Object> processTimings() {
        return this.processTimings;
    }

    public scala.collection.immutable.Map<String, Object> processRecord(FullRecord raw, FullRecord currentProcessed, boolean batch, boolean firstLoad, Option<String> processors) {
        scala.collection.immutable.Map map;
        try {
            String guid = raw.rowKey();
            OccurrenceDAO occurrenceDAO = (OccurrenceDAO)Config$.MODULE$.getInstance(OccurrenceDAO.class);
            FullRecord processed = raw.createNewProcessedRecord();
            ObjectRef assertions = new ObjectRef((Object)new HashMap());
            Processors$.MODULE$.foreach((Function1<Processor, BoxedUnit>)new Serializable(this, raw, currentProcessed, firstLoad, processors, guid, processed, assertions){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ RecordProcessor $outer;
                private final FullRecord raw$2;
                private final FullRecord currentProcessed$1;
                private final boolean firstLoad$1;
                private final Option processors$1;
                private final String guid$1;
                private final FullRecord processed$1;
                private final ObjectRef assertions$1;

                public final void apply(Processor processor) {
                    block7: {
                        if (!processor.getName().equals("offline") || !this.firstLoad$1) {
                            long start;
                            block6: {
                                start = System.nanoTime();
                                try {
                                    if (this.processors$1.isEmpty() || ((String)this.processors$1.get()).contains(processor.getName())) {
                                        ((HashMap)this.assertions$1.elem).$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)processor.getName()), (Object)processor.process(this.guid$1, this.raw$2, this.processed$1, (Option<FullRecord>)new Some((Object)this.currentProcessed$1))));
                                        break block6;
                                    }
                                    ((HashMap)this.assertions$1.elem).$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)processor.getName()), (Object)processor.skip(this.guid$1, this.raw$2, this.processed$1, (Option<FullRecord>)new Some((Object)this.currentProcessed$1))));
                                }
                                catch (Exception exception) {
                                    try {
                                        this.$outer.logger().warn(new StringBuilder().append((Object)"Non-fatal error processing record: ").append((Object)this.raw$2.rowKey()).append((Object)", processorName: ").append((Object)processor.getName()).append((Object)", error: ").append((Object)exception.getMessage()).toString(), (Throwable)exception);
                                    }
                                    catch (Throwable throwable) {
                                        long currentTime = System.nanoTime() - start + BoxesRunTime.unboxToLong((Object)this.$outer.processTimings().getOrElse((Object)processor.getName(), (Function0)new Serializable(this){
                                            public static final long serialVersionUID = 0L;

                                            public final long apply() {
                                                return this.apply$mcJ$sp();
                                            }

                                            public long apply$mcJ$sp() {
                                                return 0L;
                                            }
                                        }));
                                        this.$outer.processTimings().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)processor.getName()), (Object)BoxesRunTime.boxToLong((long)currentTime)));
                                        throw throwable;
                                    }
                                }
                            }
                            long currentTime = System.nanoTime() - start + BoxesRunTime.unboxToLong((Object)this.$outer.processTimings().getOrElse((Object)processor.getName(), (Function0)new /* invalid duplicate definition of identical inner class */));
                            this.$outer.processTimings().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)processor.getName()), (Object)BoxesRunTime.boxToLong((long)currentTime)));
                            break block7;
                            currentTime = System.nanoTime() - start + BoxesRunTime.unboxToLong((Object)this.$outer.processTimings().getOrElse((Object)processor.getName(), (Function0)new /* invalid duplicate definition of identical inner class */));
                            this.$outer.processTimings().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)processor.getName()), (Object)BoxesRunTime.boxToLong((long)currentTime)));
                        }
                    }
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.raw$2 = raw$2;
                    this.currentProcessed$1 = currentProcessed$1;
                    this.firstLoad$1 = firstLoad$1;
                    this.processors$1 = processors$1;
                    this.guid$1 = guid$1;
                    this.processed$1 = processed$1;
                    this.assertions$1 = assertions$1;
                }
            });
            processed.lastModifiedTime_$eq(this.processTime());
            Some systemAssertions = new Some((Object)((HashMap)assertions.elem).toMap(Predef$.MODULE$.conforms()));
            if (batch) {
                map = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"rowKey"), (Object)guid), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"oldRecord"), (Object)currentProcessed), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"newRecord"), (Object)processed), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"assertions"), (Object)systemAssertions), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"version"), (Object)Processed$.MODULE$)}));
            } else {
                occurrenceDAO.updateOccurrence(guid, currentProcessed, processed, (Option<scala.collection.immutable.Map<String, QualityAssertion[]>>)systemAssertions, Processed$.MODULE$);
                map = null;
            }
        }
        catch (Exception exception) {
            this.logger().error(new StringBuilder().append((Object)"Error processing record: ").append((Object)raw.rowKey()).append((Object)", ").append((Object)exception.getMessage()).toString(), (Throwable)exception);
            map = null;
        }
        return map;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeProcessBatch(List<scala.collection.immutable.Map<String, Object>> batch) {
        OccurrenceDAO occurrenceDAO = (OccurrenceDAO)Config$.MODULE$.getInstance(OccurrenceDAO.class);
        int retries = 0;
        boolean processedOK = false;
        if (processedOK) return;
        if (retries >= 6) return;
        {
            occurrenceDAO.updateOccurrenceBatch(batch);
            return;
        }
    }

    public Tuple2<FullRecord, scala.collection.immutable.Map<String, QualityAssertion[]>> processRecord(FullRecord raw) {
        FullRecord processed = raw.createNewProcessedRecord();
        HashMap assertions = new HashMap();
        Processors$.MODULE$.foreach((Function1<Processor, BoxedUnit>)new Serializable(this, raw, processed, assertions){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RecordProcessor $outer;
            private final FullRecord raw$1;
            private final FullRecord processed$2;
            private final HashMap assertions$2;

            public final void apply(Processor processor) {
                if (this.$outer.logger().isDebugEnabled()) {
                    this.$outer.logger().debug(new StringBuilder().append((Object)"Running processor ").append((Object)processor.getName()).toString());
                }
                this.assertions$2.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)processor.getName()), (Object)processor.process(this.raw$1.rowKey(), this.raw$1, this.processed$2, processor.process$default$4())));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.raw$1 = raw$1;
                this.processed$2 = processed$2;
                this.assertions$2 = assertions$2;
            }
        });
        processed.lastModifiedTime_$eq(DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd'T'HH:mm:ss'Z'"));
        return new Tuple2((Object)processed, (Object)assertions.toMap(Predef$.MODULE$.conforms()));
    }

    public boolean processRecord$default$3() {
        return false;
    }

    public boolean processRecord$default$4() {
        return false;
    }

    public Option<String> processRecord$default$5() {
        return None$.MODULE$;
    }

    public void processRecordAndUpdate(FullRecord raw) {
        Tuple2<FullRecord, scala.collection.immutable.Map<String, QualityAssertion[]>> tuple2 = this.processRecord(raw);
        if (tuple2 != null) {
            Tuple2 tuple22;
            FullRecord processed = (FullRecord)tuple2._1();
            scala.collection.immutable.Map assertions = (scala.collection.immutable.Map)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)processed, (Object)assertions);
            FullRecord processed2 = (FullRecord)tuple23._1();
            scala.collection.immutable.Map assertions2 = (scala.collection.immutable.Map)tuple23._2();
            Some systemAssertions = new Some((Object)assertions2);
            processed2.lastModifiedTime_$eq(this.processTime());
            Config$.MODULE$.occurrenceDAO().updateOccurrence(raw.rowKey(), processed2, (Option<scala.collection.immutable.Map<String, QualityAssertion[]>>)systemAssertions, Processed$.MODULE$);
            return;
        }
        throw new MatchError(tuple2);
    }

    /*
     * WARNING - void declaration
     */
    public String addRecord(String dataResourceUid, scala.collection.immutable.Map<String, String> properties) {
        void var3_3;
        String uuid = UUID.randomUUID().toString();
        FullRecord raw = FullRecordMapper$.MODULE$.createFullRecord(uuid, (Map<String, String>)properties, (Version)Versions$.MODULE$.RAW());
        raw.attribution().dataResourceUid_$eq(dataResourceUid);
        Config$.MODULE$.occurrenceDAO().updateOccurrence(raw.rowKey(), raw, (Option<scala.collection.immutable.Map<String, QualityAssertion[]>>)None$.MODULE$, Versions$.MODULE$.RAW());
        boolean downloaded = Config$.MODULE$.occurrenceDAO().downloadMedia(raw);
        if (downloaded) {
            Config$.MODULE$.occurrenceDAO().updateOccurrence(raw.rowKey(), raw, (Option<scala.collection.immutable.Map<String, QualityAssertion[]>>)None$.MODULE$, Versions$.MODULE$.RAW());
        }
        return var3_3;
    }
}

