/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.model;

import au.org.ala.biocache.model.QualityAssertion;
import au.org.ala.biocache.util.BiocacheConversions$;
import au.org.ala.biocache.vocab.AssertionCodes$;
import au.org.ala.biocache.vocab.ErrorCode;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.Date;
import java.util.UUID;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

@JsonIgnoreProperties(value={"propertyNames"})
public final class QualityAssertion$ {
    public static final QualityAssertion$ MODULE$;

    static {
        new QualityAssertion$();
    }

    public QualityAssertion apply(int code) {
        String uuid = UUID.randomUUID().toString();
        Option<ErrorCode> errorCode = AssertionCodes$.MODULE$.getByCode(code);
        if (errorCode.isEmpty()) {
            throw new Exception(new StringBuilder().append((Object)"Unrecognised code: ").append((Object)BoxesRunTime.boxToInteger((int)code)).toString());
        }
        return new QualityAssertion(uuid, null, ((ErrorCode)errorCode.get()).name(), ((ErrorCode)errorCode.get()).code(), null, null, 2, null, null, null, null, null, null, null, null, BiocacheConversions$.MODULE$.dateToString(new Date()));
    }

    public QualityAssertion apply(ErrorCode errorCode) {
        String uuid = UUID.randomUUID().toString();
        return new QualityAssertion(uuid, null, errorCode.name(), errorCode.code(), null, null, 0, null, null, null, null, null, null, null, null, BiocacheConversions$.MODULE$.dateToString(new Date()));
    }

    public QualityAssertion apply(ErrorCode errorCode, boolean problemAsserted) {
        String uuid = UUID.randomUUID().toString();
        return new QualityAssertion(uuid, null, errorCode.name(), errorCode.code(), null, null, problemAsserted ? 0 : 1, null, null, null, null, null, null, null, null, BiocacheConversions$.MODULE$.dateToString(new Date()));
    }

    public QualityAssertion apply(ErrorCode errorCode, boolean problemAsserted, String comment) {
        String uuid = UUID.randomUUID().toString();
        return new QualityAssertion(uuid, null, errorCode.name(), errorCode.code(), null, null, problemAsserted ? 0 : 1, comment, null, null, null, null, null, null, null, BiocacheConversions$.MODULE$.dateToString(new Date()));
    }

    public QualityAssertion apply(ErrorCode errorCode, String comment) {
        String uuid = UUID.randomUUID().toString();
        return new QualityAssertion(uuid, null, errorCode.name(), errorCode.code(), null, null, 0, comment, null, null, null, null, null, null, null, BiocacheConversions$.MODULE$.dateToString(new Date()));
    }

    public QualityAssertion apply(ErrorCode errorCode, int qaStatus, String comment) {
        String uuid = UUID.randomUUID().toString();
        return new QualityAssertion(uuid, null, errorCode.name(), errorCode.code(), null, null, qaStatus, comment, null, null, null, null, null, null, null, BiocacheConversions$.MODULE$.dateToString(new Date()));
    }

    public QualityAssertion apply(ErrorCode errorCode, int qaStatus) {
        String uuid = UUID.randomUUID().toString();
        return new QualityAssertion(uuid, null, errorCode.name(), errorCode.code(), null, null, qaStatus, null, null, null, null, null, null, null, null, BiocacheConversions$.MODULE$.dateToString(new Date()));
    }

    public QualityAssertion apply(int assertionCode, boolean problemAsserted, String comment) {
        String uuid = UUID.randomUUID().toString();
        return new QualityAssertion(uuid, null, null, assertionCode, null, null, problemAsserted ? 0 : 1, comment, null, null, null, null, null, null, null, BiocacheConversions$.MODULE$.dateToString(new Date()));
    }

    public QualityAssertion apply(int assertionCode, int qaStatus, String comment) {
        String uuid = UUID.randomUUID().toString();
        return new QualityAssertion(uuid, null, null, assertionCode, null, null, qaStatus, comment, null, null, null, null, null, null, null, BiocacheConversions$.MODULE$.dateToString(new Date()));
    }

    public QualityAssertion apply(int assertionCode, int qaStatus) {
        String uuid = UUID.randomUUID().toString();
        return new QualityAssertion(uuid, null, null, assertionCode, null, null, qaStatus, null, null, null, null, null, null, null, null, BiocacheConversions$.MODULE$.dateToString(new Date()));
    }

    public QualityAssertion apply(ErrorCode errorCode, String relatedUuid, int qaStatus) {
        String uuid = UUID.randomUUID().toString();
        return new QualityAssertion(uuid, null, errorCode.name(), errorCode.code(), null, relatedUuid, qaStatus, null, null, null, null, null, null, null, null, BiocacheConversions$.MODULE$.dateToString(new Date()));
    }

    public Function2<QualityAssertion, QualityAssertion, Object> compareByRelatedId() {
        return new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(QualityAssertion a, QualityAssertion b) {
                return new StringOps(Predef$.MODULE$.augmentString(a.relatedUuid())).$less((Object)b.relatedUuid());
            }
        };
    }

    public Function2<QualityAssertion, QualityAssertion, Object> compareByCreatedDesc() {
        return new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(QualityAssertion a, QualityAssertion b) {
                DateTimeFormatter dtf = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss'Z'");
                return dtf.parseDateTime(a.created()).isAfter((ReadableInstant)dtf.parseDateTime(b.created()));
            }
        };
    }

    public Function2<QualityAssertion, QualityAssertion, Object> compareByReferenceRowKeyDesc() {
        return new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(QualityAssertion a, QualityAssertion b) {
                return new StringOps(Predef$.MODULE$.augmentString((String)Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(a.referenceRowKey())).split('|')).last())).toInt() > new StringOps(Predef$.MODULE$.augmentString((String)Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(b.referenceRowKey())).split('|')).last())).toInt();
            }
        };
    }

    private QualityAssertion$() {
        MODULE$ = this;
    }
}

