/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.load;

import au.org.ala.biocache.Config$;
import au.org.ala.biocache.load.DataLoader;
import au.org.ala.biocache.load.DataLoader$class;
import au.org.ala.biocache.load.DataResourceConfig;
import au.org.ala.biocache.load.DwCALoader$;
import au.org.ala.biocache.load.FullRecordMapper$;
import au.org.ala.biocache.model.FullRecord;
import au.org.ala.biocache.model.Multimedia;
import au.org.ala.biocache.model.Multimedia$;
import au.org.ala.biocache.model.Raw$;
import au.org.ala.biocache.model.Version;
import au.org.ala.biocache.persistence.PersistenceManager;
import au.org.ala.biocache.vocab.DwC$;
import au.org.ala.biocache.vocab.Term;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.gbif.dwc.terms.DcTerm;
import org.gbif.dwc.terms.DwcTerm;
import org.gbif.dwc.terms.GbifTerm;
import org.gbif.dwca.io.Archive;
import org.gbif.dwca.io.ArchiveFactory;
import org.gbif.dwca.io.ArchiveField;
import org.gbif.dwca.record.Record;
import org.gbif.dwca.record.StarRecord;
import org.gbif.utils.file.ClosableIterator;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.GenSet;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\u0005Uw!B\u0001\u0003\u0011\u0003i\u0011A\u0003#x\u0007\u0006cu.\u00193fe*\u00111\u0001B\u0001\u0005Y>\fGM\u0003\u0002\u0006\r\u0005A!-[8dC\u000eDWM\u0003\u0002\b\u0011\u0005\u0019\u0011\r\\1\u000b\u0005%Q\u0011aA8sO*\t1\"\u0001\u0002bk\u000e\u0001\u0001C\u0001\b\u0010\u001b\u0005\u0011a!\u0002\t\u0003\u0011\u0003\t\"A\u0003#x\u0007\u0006cu.\u00193feN\u0019qB\u0005\r\u0011\u0005M1R\"\u0001\u000b\u000b\u0003U\tQa]2bY\u0006L!a\u0006\u000b\u0003\r\u0005s\u0017PU3g!\tIB$D\u0001\u001b\u0015\tYB!A\u0002d[\u0012L!!\b\u000e\u0003\tQ{w\u000e\u001c\u0005\u0006?=!\t\u0001I\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00035AqAI\bC\u0002\u0013\u00051%\u0001\u0006J\u001b\u0006;Ui\u0018+Z!\u0016+\u0012\u0001\n\t\u0003K5j\u0011A\n\u0006\u0003O!\nQ\u0001^3s[NT!!\u000b\u0016\u0002\u0007\u0011<8M\u0003\u0002,Y\u0005!qMY5g\u0015\u0005I\u0011B\u0001\u0018'\u0005!9%-\u001b4UKJl\u0007B\u0002\u0019\u0010A\u0003%A%A\u0006J\u001b\u0006;Ui\u0018+Z!\u0016\u0003\u0003b\u0002\u001a\u0010\u0005\u0004%\taI\u0001\u0010\u001bVcE+S'F\t&\u000bu\fV-Q\u000b\"1Ag\u0004Q\u0001\n\u0011\n\u0001#T+M)&kU\tR%B?RK\u0006+\u0012\u0011\t\u000bmyA\u0011\u0001\u001c\u0016\u0003]\u0002\"\u0001O\u001f\u000e\u0003eR!AO\u001e\u0002\t1\fgn\u001a\u0006\u0002y\u0005!!.\u0019<b\u0013\tq\u0014H\u0001\u0004TiJLgn\u001a\u0005\u0006\u0001>!\tAN\u0001\u0005I\u0016\u001c8\rC\u0003C\u001f\u0011\u00051)\u0001\u0003nC&tGC\u0001#H!\t\u0019R)\u0003\u0002G)\t!QK\\5u\u0011\u0015A\u0015\t1\u0001J\u0003\u0011\t'oZ:\u0011\u0007MQE*\u0003\u0002L)\t)\u0011I\u001d:bsB\u0011Q\n\u0015\b\u0003'9K!a\u0014\u000b\u0002\rA\u0013X\rZ3g\u0013\tq\u0014K\u0003\u0002P)\u0019!\u0001C\u0001\u0001T'\r\u0011&\u0003\u0016\t\u0003\u001dUK!A\u0016\u0002\u0003\u0015\u0011\u000bG/\u0019'pC\u0012,'\u000fC\u0003 %\u0012\u0005\u0001\fF\u0001Z!\tq!\u000bC\u0003\u0004%\u0012\u00051\fF\u0004E9z\u001bWmZ5\t\u000buS\u0006\u0019\u0001'\u0002\u0017I,7o\\;sG\u0016,\u0016\u000e\u001a\u0005\b?j\u0003\n\u00111\u0001a\u0003)awn\u001a*po.+\u0017p\u001d\t\u0003'\u0005L!A\u0019\u000b\u0003\u000f\t{w\u000e\\3b]\"9AM\u0017I\u0001\u0002\u0004\u0001\u0017\u0001\u0003;fgR4\u0015\u000e\\3\t\u000f\u0019T\u0006\u0013!a\u0001A\u0006Iam\u001c:dK2{\u0017\r\u001a\u0005\bQj\u0003\n\u00111\u0001a\u0003A\u0011X-\\8wK:+H\u000e\u001c$jK2$7\u000fC\u0004k5B\u0005\t\u0019\u00011\u0002\u001f1|\u0017\rZ'jgNLgnZ(oYfDQ\u0001\u001c*\u0005\u00025\f\u0011\u0002\\8bI2{7-\u00197\u0015\u000f\u0011sw.\u001d:ti\")Ql\u001ba\u0001\u0019\")\u0001o\u001ba\u0001\u0019\u0006Aa-\u001b7f\u001d\u0006lW\rC\u0003`W\u0002\u0007\u0001\rC\u0003eW\u0002\u0007\u0001\rC\u0004iWB\u0005\t\u0019\u00011\t\u000f)\\\u0007\u0013!a\u0001A\")aO\u0015C\u0001o\u00069q-\u001a;Vk&$G#\u0003=\u0002\u0006\u0005-\u0011qDA!!\u0011\u0019\u0012p\u001f?\n\u0005i$\"A\u0002+va2,'\u0007\u0005\u0003\u0014s2\u0003\u0007cA\n~\u007f&\u0011a\u0010\u0006\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000b5\u000b\t\u0001\u0014'\n\u0007\u0005\r\u0011KA\u0002NCBDq!a\u0002v\u0001\u0004\tI!\u0001\u0005v]&\fX/Z%E!\r\u0019R\u0010\u0014\u0005\b\u0003\u001b)\b\u0019AA\b\u0003\u0011\u0019H/\u0019:\u0011\t\u0005E\u00111D\u0007\u0003\u0003'QA!!\u0006\u0002\u0018\u00051!/Z2pe\u0012T1!!\u0007+\u0003\u0011!woY1\n\t\u0005u\u00111\u0003\u0002\u000b'R\f'OU3d_J$\u0007bBA\u0011k\u0002\u0007\u00111E\u0001\fk:L\u0017/^3UKJl7\u000f\u0005\u0004\u0002&\u0005U\u00121\b\b\u0005\u0003O\t\tD\u0004\u0003\u0002*\u0005=RBAA\u0016\u0015\r\ti\u0003D\u0001\u0007yI|w\u000e\u001e \n\u0003UI1!a\r\u0015\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u000e\u0002:\t\u00191+Z9\u000b\u0007\u0005MB\u0003E\u0002&\u0003{I1!a\u0010'\u0005\u0011!VM]7\t\r\u0005\rS\u000f1\u0001}\u0003Ai\u0017\r\u001d9fIB\u0013x\u000e]3si&,7\u000fC\u0004\u0002HI#\t!!\u0013\u0002\u00171|\u0017\rZ!sG\"Lg/\u001a\u000b\u0014\t\u0006-\u0013QJA(\u0003#\n)&!\u0017\u0002\\\u0005u\u0013q\f\u0005\u0007a\u0006\u0015\u0003\u0019\u0001'\t\ru\u000b)\u00051\u0001M\u0011!\t\t#!\u0012A\u0002\u0005\r\u0002\u0002CA*\u0003\u000b\u0002\r!!\u0003\u0002\u0011%l\u0017mZ3Ve2Dq!a\u0016\u0002F\u0001\u0007\u0001-A\u0006tiJL\u0007o\u00159bG\u0016\u001c\bBB0\u0002F\u0001\u0007\u0001\r\u0003\u0004e\u0003\u000b\u0002\r\u0001\u0019\u0005\tQ\u0006\u0015\u0003\u0013!a\u0001A\"1!.!\u0012A\u0002\u0001Dq!a\u0019S\t\u0003\t)'\u0001\bm_\u0006$W*\u001e7uS6,G-[1\u0015\u0011\u0005\u001d\u0014QOA<\u0003w\u0002b!!\n\u00026\u0005%\u0004\u0003BA6\u0003cj!!!\u001c\u000b\u0007\u0005=D!A\u0003n_\u0012,G.\u0003\u0003\u0002t\u00055$AC'vYRLW.\u001a3jC\"A\u0011QBA1\u0001\u0004\ty\u0001\u0003\u0005\u0002z\u0005\u0005\u0004\u0019AA\u001e\u0003\u001d\u0011xn\u001e+za\u0016D\u0001\"! \u0002b\u0001\u0007\u0011qP\u0001\nS6\fw-\u001a\"bg\u0016\u0004B!!!\u0002\b6\u0011\u00111\u0011\u0006\u0004\u0003\u000b[\u0014a\u00018fi&!\u0011\u0011RAB\u0005\r)&\u000b\u0014\u0005\b\u0003\u001b\u0013F\u0011AAH\u0003AawnY1uK6+H\u000e^5nK\u0012L\u0017\r\u0006\u0004\u0002\u0012\u0006M\u0015Q\u0014\t\u0005'u\fy\b\u0003\u0005\u0002\u0016\u0006-\u0005\u0019AAL\u0003\r\u0011xn\u001e\t\u0005\u0003#\tI*\u0003\u0003\u0002\u001c\u0006M!A\u0002*fG>\u0014H\r\u0003\u0005\u0002~\u0005-\u0005\u0019AA@\u0011%\t\tKUI\u0001\n\u0003\t\u0019+\u0001\bm_\u0006$G\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005\u0015&f\u00011\u0002(.\u0012\u0011\u0011\u0016\t\u0005\u0003W\u000b),\u0004\u0002\u0002.*!\u0011qVAY\u0003%)hn\u00195fG.,GMC\u0002\u00024R\t!\"\u00198o_R\fG/[8o\u0013\u0011\t9,!,\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0005\u0002<J\u000b\n\u0011\"\u0001\u0002$\u0006qAn\\1eI\u0011,g-Y;mi\u0012\u001a\u0004\"CA`%F\u0005I\u0011AAR\u00039aw.\u00193%I\u00164\u0017-\u001e7uIQB\u0011\"a1S#\u0003%\t!a)\u0002\u001d1|\u0017\r\u001a\u0013eK\u001a\fW\u000f\u001c;%k!I\u0011q\u0019*\u0012\u0002\u0013\u0005\u00111U\u0001\u000fY>\fG\r\n3fM\u0006,H\u000e\u001e\u00137\u0011%\tYMUI\u0001\n\u0003\t\u0019+A\u000bm_\u0006$\u0017I]2iSZ,G\u0005Z3gCVdG\u000f\n\u001d\t\u0013\u0005='+%A\u0005\u0002\u0005\r\u0016a\u00057pC\u0012dunY1mI\u0011,g-Y;mi\u0012*\u0004\"CAj%F\u0005I\u0011AAR\u0003Maw.\u00193M_\u000e\fG\u000e\n3fM\u0006,H\u000e\u001e\u00137\u0001")
public class DwCALoader
implements DataLoader {
    private final String user;
    private final Logger logger;
    private final String temporaryFileStore;
    private final PersistenceManager pm;
    private final String loadTime;
    private final Regex sftpPattern;

    public static String help() {
        return DwCALoader$.MODULE$.help();
    }

    public static void main(String[] stringArray) {
        DwCALoader$.MODULE$.main(stringArray);
    }

    public static String desc() {
        return DwCALoader$.MODULE$.desc();
    }

    public static String cmd() {
        return DwCALoader$.MODULE$.cmd();
    }

    public static GbifTerm MULTIMEDIA_TYPE() {
        return DwCALoader$.MODULE$.MULTIMEDIA_TYPE();
    }

    public static GbifTerm IMAGE_TYPE() {
        return DwCALoader$.MODULE$.IMAGE_TYPE();
    }

    @Override
    public String user() {
        return this.user;
    }

    @Override
    public Logger logger() {
        return this.logger;
    }

    @Override
    public String temporaryFileStore() {
        return this.temporaryFileStore;
    }

    @Override
    public PersistenceManager pm() {
        return this.pm;
    }

    @Override
    public String loadTime() {
        return this.loadTime;
    }

    @Override
    public Regex sftpPattern() {
        return this.sftpPattern;
    }

    @Override
    public void au$org$ala$biocache$load$DataLoader$_setter_$user_$eq(String x$1) {
        this.user = x$1;
    }

    @Override
    public void au$org$ala$biocache$load$DataLoader$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    @Override
    public void au$org$ala$biocache$load$DataLoader$_setter_$temporaryFileStore_$eq(String x$1) {
        this.temporaryFileStore = x$1;
    }

    @Override
    public void au$org$ala$biocache$load$DataLoader$_setter_$pm_$eq(PersistenceManager x$1) {
        this.pm = x$1;
    }

    @Override
    public void au$org$ala$biocache$load$DataLoader$_setter_$loadTime_$eq(String x$1) {
        this.loadTime = x$1;
    }

    @Override
    public void au$org$ala$biocache$load$DataLoader$_setter_$sftpPattern_$eq(Regex x$1) {
        this.sftpPattern = x$1;
    }

    @Override
    public boolean emptyTempFileStore(String resourceUid) {
        return DataLoader$class.emptyTempFileStore(this, resourceUid);
    }

    @Override
    public FileWriter getDeletedFileWriter(String resourceUid) {
        return DataLoader$class.getDeletedFileWriter(this, resourceUid);
    }

    @Override
    public void deleteOldRowKeys(String resourceUid) {
        DataLoader$class.deleteOldRowKeys(this, resourceUid);
    }

    @Override
    public Option<Writer> getRowKeyWriter(String resourceUid, boolean writeRowKeys) {
        return DataLoader$class.getRowKeyWriter(this, resourceUid, writeRowKeys);
    }

    @Override
    public void setNotLoadedForOtherPhases(String resourceUid) {
        DataLoader$class.setNotLoadedForOtherPhases(this, resourceUid);
    }

    @Override
    public scala.collection.immutable.Map<String, String> getDataResourceDetailsAsMap(String uid) {
        return DataLoader$class.getDataResourceDetailsAsMap(this, uid);
    }

    @Override
    public scala.collection.immutable.Map<String, String> getDataProviderDetailsAsMap(String uid) {
        return DataLoader$class.getDataProviderDetailsAsMap(this, uid);
    }

    @Override
    public scala.collection.immutable.Map<String, String> getInstitutionDetailsAsMap(String uid) {
        return DataLoader$class.getInstitutionDetailsAsMap(this, uid);
    }

    @Override
    public Option<DataResourceConfig> retrieveConnectionParameters(String resourceUid) {
        return DataLoader$class.retrieveConnectionParameters(this, resourceUid);
    }

    @Override
    public Seq<org.gbif.dwc.terms.Term> mapConceptTerms(Seq<String> terms) {
        return DataLoader$class.mapConceptTerms(this, terms);
    }

    @Override
    public boolean exists(String dataResourceUid, List<String> identifyingTerms) {
        return DataLoader$class.exists(this, dataResourceUid, identifyingTerms);
    }

    @Override
    public String createUniqueID(String dataResourceUid, Seq<String> identifyingTerms, boolean stripSpaces) {
        return DataLoader$class.createUniqueID(this, dataResourceUid, identifyingTerms, stripSpaces);
    }

    @Override
    public boolean load(String dataResourceUid, FullRecord fr, Seq<String> identifyingTerms, Seq<Multimedia> multimedia) {
        return DataLoader$class.load((DataLoader)this, dataResourceUid, fr, identifyingTerms, multimedia);
    }

    @Override
    public boolean load(String dataResourceUid, FullRecord fr, Seq<String> identifyingTerms) {
        return DataLoader$class.load(this, dataResourceUid, fr, identifyingTerms);
    }

    @Override
    public boolean load(String dataResourceUid, FullRecord fr, Seq<String> identifyingTerms, boolean updateLastModified) {
        return DataLoader$class.load((DataLoader)this, dataResourceUid, fr, identifyingTerms, updateLastModified);
    }

    @Override
    public boolean load(String dataResourceUid, FullRecord fr, Seq<String> identifyingTerms, boolean updateLastModified, boolean downloadMedia2, boolean deleteIfNullValue) {
        return DataLoader$class.load(this, dataResourceUid, fr, identifyingTerms, updateLastModified, downloadMedia2, deleteIfNullValue);
    }

    @Override
    public boolean load(String dataResourceUid, FullRecord fr, Seq<String> identifyingTerms, boolean updateLastModified, boolean downloadMedia2, boolean stripSpaces, Option<Writer> rowKeyWriter, Seq<Multimedia> multimedia, boolean deleteIfNullValue) {
        return DataLoader$class.load(this, dataResourceUid, fr, identifyingTerms, updateLastModified, downloadMedia2, stripSpaces, rowKeyWriter, multimedia, deleteIfNullValue);
    }

    @Override
    public FullRecord processMedia(String dataResourceUid, FullRecord fr, Seq<Multimedia> multimedia) {
        return DataLoader$class.processMedia(this, dataResourceUid, fr, multimedia);
    }

    @Override
    public Tuple2<String, Date> downloadArchive(String url, String resourceUid, Option<Date> lastChecked) {
        return DataLoader$class.downloadArchive(this, url, resourceUid, lastChecked);
    }

    @Override
    public Tuple4<File, Date, Object, Object> downloadSFTPArchive(String url, String resourceUid, Option<Date> lastChecked) {
        return DataLoader$class.downloadSFTPArchive(this, url, resourceUid, lastChecked);
    }

    @Override
    public Option<Tuple2<String, Date>> sftpLatestArchive(String url, String resourceUid, Option<Date> afterDate) {
        return DataLoader$class.sftpLatestArchive(this, url, resourceUid, afterDate);
    }

    @Override
    public Tuple4<File, Date, Object, Object> downloadStandardArchive(String url, String resourceUid, Option<Date> afterDate) {
        return DataLoader$class.downloadStandardArchive(this, url, resourceUid, afterDate);
    }

    @Override
    public boolean updateLastChecked(String resourceUid, Option<Date> dataCurrency) {
        return DataLoader$class.updateLastChecked(this, resourceUid, dataCurrency);
    }

    @Override
    public Option<Date> updateLastChecked$default$2() {
        return DataLoader$class.updateLastChecked$default$2(this);
    }

    @Override
    public boolean createUniqueID$default$3() {
        return DataLoader$class.createUniqueID$default$3(this);
    }

    @Override
    public Seq<Multimedia> processMedia$default$3() {
        return DataLoader$class.processMedia$default$3(this);
    }

    public void load(String resourceUid, boolean logRowKeys, boolean testFile, boolean forceLoad, boolean removeNullFields, boolean loadMissingOnly) {
        this.emptyTempFileStore(resourceUid);
        this.deleteOldRowKeys(resourceUid);
        Option<DataResourceConfig> option = this.retrieveConnectionParameters(resourceUid);
        None$ none$ = None$.MODULE$;
        Option<DataResourceConfig> option2 = option;
        if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
            throw new Exception(new StringBuilder().append((Object)"Unable to retrieve connection params for ").append((Object)resourceUid).toString());
        }
        if (option instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option;
            DataResourceConfig dataResourceConfig = (DataResourceConfig)some.x();
            Seq<org.gbif.dwc.terms.Term> conceptTerms = this.mapConceptTerms(dataResourceConfig.uniqueTerms());
            Option imageUrl = dataResourceConfig.connectionParams().get((Object)"imageUrl");
            boolean incremental = BoxesRunTime.unboxToBoolean((Object)dataResourceConfig.connectionParams().getOrElse((Object)"incremental", (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    return false;
                }
            }));
            boolean strip = BoxesRunTime.unboxToBoolean((Object)dataResourceConfig.connectionParams().getOrElse((Object)"strip", (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    return false;
                }
            }));
            BooleanRef loaded = new BooleanRef(false);
            ObjectRef maxLastModifiedDate = new ObjectRef(null);
            dataResourceConfig.urls().foreach((Function1)new Serializable(this, resourceUid, logRowKeys, testFile, forceLoad, removeNullFields, loadMissingOnly, dataResourceConfig, conceptTerms, imageUrl, incremental, strip, loaded, maxLastModifiedDate){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DwCALoader $outer;
                private final String resourceUid$2;
                private final boolean logRowKeys$1;
                private final boolean testFile$2;
                private final boolean forceLoad$1;
                private final boolean removeNullFields$2;
                private final boolean loadMissingOnly$2;
                private final DataResourceConfig dataResourceConfig$1;
                private final Seq conceptTerms$1;
                private final Option imageUrl$1;
                private final boolean incremental$1;
                private final boolean strip$1;
                private final BooleanRef loaded$1;
                private final ObjectRef maxLastModifiedDate$1;

                public final void apply(String url) {
                    Tuple2<String, Date> tuple2 = this.$outer.downloadArchive(url, this.resourceUid$2, this.forceLoad$1 ? None$.MODULE$ : this.dataResourceConfig$1.dateLastChecked());
                    if (tuple2 != null) {
                        Tuple2 tuple22;
                        String fileName = (String)tuple2._1();
                        Date date = (Date)tuple2._2();
                        Tuple2 tuple23 = tuple22 = new Tuple2((Object)fileName, (Object)date);
                        String fileName2 = (String)tuple23._1();
                        Date date2 = (Date)tuple23._2();
                        if ((Date)this.maxLastModifiedDate$1.elem == null || date2.after((Date)this.maxLastModifiedDate$1.elem)) {
                            this.maxLastModifiedDate$1.elem = date2;
                        }
                        this.$outer.logger().info(new StringBuilder().append((Object)"File last modified date: ").append((Object)((Date)this.maxLastModifiedDate$1.elem)).toString());
                        if (fileName2 != null) {
                            this.$outer.loadArchive(fileName2, this.resourceUid$2, (Seq<org.gbif.dwc.terms.Term>)this.conceptTerms$1, (Option<String>)this.imageUrl$1, this.strip$1, this.logRowKeys$1 || this.incremental$1, this.testFile$2, this.removeNullFields$2, this.loadMissingOnly$2);
                            this.loaded$1.elem = true;
                        }
                        return;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.resourceUid$2 = resourceUid$2;
                    this.logRowKeys$1 = logRowKeys$1;
                    this.testFile$2 = testFile$2;
                    this.forceLoad$1 = forceLoad$1;
                    this.removeNullFields$2 = removeNullFields$2;
                    this.loadMissingOnly$2 = loadMissingOnly$2;
                    this.dataResourceConfig$1 = dataResourceConfig$1;
                    this.conceptTerms$1 = conceptTerms$1;
                    this.imageUrl$1 = imageUrl$1;
                    this.incremental$1 = incremental$1;
                    this.strip$1 = strip$1;
                    this.loaded$1 = loaded$1;
                    this.maxLastModifiedDate$1 = maxLastModifiedDate$1;
                }
            });
            if (testFile) {
                boxedUnit = BoxedUnit.UNIT;
            } else {
                this.updateLastChecked(resourceUid, (Option<Date>)(loaded.elem ? new Some((Object)((Date)maxLastModifiedDate.elem)) : None$.MODULE$));
                if (loaded.elem) {
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    this.setNotLoadedForOtherPhases(resourceUid);
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
            BoxedUnit boxedUnit2 = boxedUnit;
            return;
        }
        throw new MatchError(option);
    }

    public boolean load$default$2() {
        return false;
    }

    public boolean load$default$3() {
        return false;
    }

    public boolean load$default$4() {
        return false;
    }

    public boolean load$default$5() {
        return false;
    }

    public boolean load$default$6() {
        return false;
    }

    public void loadLocal(String resourceUid, String fileName, boolean logRowKeys, boolean testFile, boolean removeNullFields, boolean loadMissingOnly) {
        Option<DataResourceConfig> option = this.retrieveConnectionParameters(resourceUid);
        None$ none$ = None$.MODULE$;
        Option<DataResourceConfig> option2 = option;
        if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
            throw new Exception(new StringBuilder().append((Object)"Unable to load resourceUid: ").append((Object)resourceUid).toString());
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            DataResourceConfig dataResourceConfig = (DataResourceConfig)some.x();
            Seq<org.gbif.dwc.terms.Term> conceptTerms = this.mapConceptTerms(dataResourceConfig.uniqueTerms());
            boolean strip = BoxesRunTime.unboxToBoolean((Object)dataResourceConfig.connectionParams().getOrElse((Object)"strip", (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    return false;
                }
            }));
            this.loadArchive(fileName, resourceUid, conceptTerms, (Option<String>)dataResourceConfig.connectionParams().get((Object)"imageUrl"), strip, logRowKeys, testFile, removeNullFields, loadMissingOnly);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        throw new MatchError(option);
    }

    public boolean loadLocal$default$5() {
        return false;
    }

    public boolean loadLocal$default$6() {
        return false;
    }

    public Tuple2<Tuple2<String, Object>, Option<scala.collection.immutable.Map<String, String>>> getUuid(Option<String> uniqueID, StarRecord star, Seq<org.gbif.dwc.terms.Term> uniqueTerms, Option<scala.collection.immutable.Map<String, String>> mappedProperties) {
        Option<String> option;
        block4: {
            Tuple2 tuple2;
            block3: {
                block2: {
                    option = uniqueID;
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    String value = (String)some.x();
                    tuple2 = new Tuple2(Config$.MODULE$.occurrenceDAO().createOrRetrieveUuid(value), mappedProperties);
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option<String> option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                tuple2 = new Tuple2((Object)new Tuple2((Object)Config$.MODULE$.occurrenceDAO().createUuid(), (Object)BoxesRunTime.boxToBoolean((boolean)true)), mappedProperties);
            }
            return tuple2;
        }
        throw new MatchError(option);
    }

    public void loadArchive(String fileName, String resourceUid, Seq<org.gbif.dwc.terms.Term> uniqueTerms, Option<String> imageUrl, boolean stripSpaces, boolean logRowKeys, boolean testFile, boolean removeNullFields, boolean loadMissingOnly) {
        this.logger().info(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Loading archive: ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fileName}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"for resource: ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resourceUid}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"with unique terms: ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{uniqueTerms}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"stripping spaces:  ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)stripSpaces)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"incremental: ", ",  "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)logRowKeys)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"load missing only: ", ",  "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)loadMissingOnly)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"testing: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)testFile)}))).toString());
        File archiveDir = new File(fileName);
        URL imageBase = new URL((String)imageUrl.getOrElse((Function0)new Serializable(this, archiveDir){
            public static final long serialVersionUID = 0L;
            private final File archiveDir$1;

            public final String apply() {
                return this.archiveDir$1.toURI().toURL().toString();
            }
            {
                this.archiveDir$1 = archiveDir$1;
            }
        }));
        Option<Writer> rowKeyWriter = this.getRowKeyWriter(resourceUid, logRowKeys);
        Archive archive = ArchiveFactory.openArchive((File)archiveDir);
        ClosableIterator iter = archive.iterator();
        int count = 0;
        int skipped = 0;
        int newCount = 0;
        Map fieldMap = archive.getCore().getFields();
        List fieldShortNames = JavaConversions$.MODULE$.asScalaSet(fieldMap.keySet()).toList();
        Seq<String> biocacheModelValues = DwC$.MODULE$.retrieveCanonicals((Seq<String>)((Seq)fieldShortNames.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(org.gbif.dwc.terms.Term x$2) {
                return x$2.simpleName();
            }
        }, List$.MODULE$.canBuildFrom())));
        scala.collection.immutable.Map fieldToModelMap = ((TraversableOnce)fieldShortNames.zip(biocacheModelValues, List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
        HashMap fieldShortNameToIdxMap = new HashMap();
        JavaConversions$.MODULE$.mapAsScalaMap(fieldMap).foreach((Function1)new Serializable(this, fieldShortNameToIdxMap){
            public static final long serialVersionUID = 0L;
            private final HashMap fieldShortNameToIdxMap$1;

            public final Object apply(Tuple2<org.gbif.dwc.terms.Term, ArchiveField> x0$1) {
                Tuple2<org.gbif.dwc.terms.Term, ArchiveField> tuple2;
                block2: {
                    Option<Term> option;
                    block7: {
                        BoxedUnit boxedUnit;
                        block4: {
                            Option option2;
                            block6: {
                                Integer fieldIdx;
                                org.gbif.dwc.terms.Term term;
                                block5: {
                                    block3: {
                                        tuple2 = x0$1;
                                        if (tuple2 == null) break block2;
                                        term = (org.gbif.dwc.terms.Term)tuple2._1();
                                        ArchiveField field = (ArchiveField)tuple2._2();
                                        fieldIdx = field.getIndex();
                                        if (fieldIdx != null) break block3;
                                        boxedUnit = BoxedUnit.UNIT;
                                        break block4;
                                    }
                                    option = DwC$.MODULE$.matchTerm(term.simpleName());
                                    if (!(option instanceof Some)) break block5;
                                    Some some = (Some)option;
                                    Term matchedTerm = (Term)some.x();
                                    option2 = this.fieldShortNameToIdxMap$1.put((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(fieldIdx)), (Object)matchedTerm.canonical());
                                    break block6;
                                }
                                None$ none$ = None$.MODULE$;
                                Option<Term> option3 = option;
                                if (none$ != null ? !none$.equals(option3) : option3 != null) break block7;
                                option2 = this.fieldShortNameToIdxMap$1.put((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(fieldIdx)), (Object)term.simpleName());
                            }
                            boxedUnit = option2;
                        }
                        BoxedUnit boxedUnit2 = boxedUnit;
                        return boxedUnit2;
                    }
                    throw new MatchError(option);
                }
                throw new MatchError(tuple2);
            }
            {
                this.fieldShortNameToIdxMap$1 = fieldShortNameToIdxMap$1;
            }
        });
        if (this.logger().isDebugEnabled()) {
            fieldToModelMap.foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DwCALoader $outer;

                public final void apply(Tuple2<org.gbif.dwc.terms.Term, String> x0$2) {
                    Tuple2<org.gbif.dwc.terms.Term, String> tuple2 = x0$2;
                    if (tuple2 != null) {
                        org.gbif.dwc.terms.Term dwcShortName = (org.gbif.dwc.terms.Term)tuple2._1();
                        String biocacheField = (String)tuple2._2();
                        this.$outer.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"dwcShortName: ", " , biocacheField: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dwcShortName, biocacheField})));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
        }
        long startTime = System.currentTimeMillis();
        long finishTime = System.currentTimeMillis();
        ArrayBuffer currentBatch = new ArrayBuffer();
        scala.collection.immutable.Set institutionCodes = ((TraversableOnce)Config$.MODULE$.indexDAO().getDistinctValues(new StringBuilder().append((Object)"data_resource_uid:").append((Object)resourceUid).toString(), "institution_code", 100).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final List<Nothing$> apply() {
                return Nil$.MODULE$;
            }
        })).toSet();
        scala.collection.immutable.Set collectionCodes = ((TraversableOnce)Config$.MODULE$.indexDAO().getDistinctValues(new StringBuilder().append((Object)"data_resource_uid:").append((Object)resourceUid).toString(), "collection_code", 100).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final List<Nothing$> apply() {
                return Nil$.MODULE$;
            }
        })).toSet();
        this.logger().info(new StringBuilder().append((Object)"The current institution codes for the data resource: ").append((Object)institutionCodes).toString());
        this.logger().info(new StringBuilder().append((Object)"The current collection codes for the data resource: ").append((Object)collectionCodes).toString());
        HashSet newCollCodes = new HashSet();
        HashSet newInstCodes = new HashSet();
        while (iter.hasNext()) {
            Tuple2<Tuple2<String, Object>, Option<scala.collection.immutable.Map<String, String>>> tuple2;
            Object object;
            None$ uniqueID;
            None$ none$;
            StarRecord star = (StarRecord)iter.next();
            if (uniqueTerms.isEmpty()) {
                none$ = None$.MODULE$;
            } else {
                Seq uniqueTermValues = (Seq)uniqueTerms.map((Function1)new Serializable(this, star){
                    public static final long serialVersionUID = 0L;
                    private final StarRecord star$1;

                    public final String apply(org.gbif.dwc.terms.Term t) {
                        return this.star$1.core().value(t);
                    }
                    {
                        this.star$1 = star$1;
                    }
                }, Seq$.MODULE$.canBuildFrom());
                List list = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{resourceUid}));
                String id = uniqueTermValues.toList().$colon$colon$colon(list).mkString("|").trim();
                none$ = uniqueID = new Some((Object)(stripSpaces ? id.replaceAll("\\s", "") : id));
            }
            if (testFile) {
                String icode = star.core().value((org.gbif.dwc.terms.Term)DwcTerm.institutionCode);
                newInstCodes.add((Object)(icode == null ? "<NULL>" : icode));
                String ccode = star.core().value((org.gbif.dwc.terms.Term)DwcTerm.collectionCode);
                object = BoxesRunTime.boxToBoolean((boolean)newCollCodes.add((Object)(ccode == null ? "<NULL>" : ccode)));
            } else {
                object = BoxedUnit.UNIT;
            }
            ListBuffer fieldTuples = new ListBuffer();
            fieldShortNameToIdxMap.foreach((Function1)new Serializable(this, removeNullFields, star, fieldTuples){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DwCALoader $outer;
                private final boolean removeNullFields$3;
                private final StarRecord star$1;
                private final ListBuffer fieldTuples$1;

                public final Object apply(Tuple2<Object, String> x0$3) {
                    Tuple2<Object, String> tuple2 = x0$3;
                    if (tuple2 != null) {
                        int fieldIdx = tuple2._1$mcI$sp();
                        String modelProperty = (String)tuple2._2();
                        String property = this.star$1.core().column(fieldIdx);
                        if (this.$outer.logger().isDebugEnabled() && StringUtils.isNotBlank((CharSequence)property)) {
                            this.$outer.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Mapped field: ", ", fieldIdx: ", ", value: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{modelProperty, BoxesRunTime.boxToInteger((int)fieldIdx), property})));
                        }
                        BoxedUnit boxedUnit = this.removeNullFields$3 ? this.fieldTuples$1.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)modelProperty), (Object)property)) : (StringUtils.isNotBlank((CharSequence)property) ? this.fieldTuples$1.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)modelProperty), (Object)property)) : BoxedUnit.UNIT);
                        return boxedUnit;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.removeNullFields$3 = removeNullFields$3;
                    this.star$1 = star$1;
                    this.fieldTuples$1 = fieldTuples$1;
                }
            });
            if (this.logger().isDebugEnabled()) {
                fieldTuples.foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ DwCALoader $outer;

                    public final void apply(Tuple2<String, String> x0$4) {
                        Tuple2<String, String> tuple2 = x0$4;
                        if (tuple2 != null) {
                            String key = (String)tuple2._1();
                            String value = (String)tuple2._2();
                            this.$outer.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Not blank fields: ", " , value: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key, value})));
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }
            if ((tuple2 = this.getUuid((Option<String>)uniqueID, star, uniqueTerms, (Option<scala.collection.immutable.Map<String, String>>)None$.MODULE$)) != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._1();
                Option mappedProps = (Option)tuple2._2();
                if (tuple22 != null) {
                    boolean toBeLoaded;
                    Tuple3 tuple3;
                    String recordUuid = (String)tuple22._1();
                    boolean isNew = tuple22._2$mcZ$sp();
                    Tuple3 tuple32 = tuple3 = new Tuple3((Object)recordUuid, (Object)BoxesRunTime.boxToBoolean((boolean)isNew), (Object)mappedProps);
                    String recordUuid2 = (String)tuple32._1();
                    boolean isNew2 = BoxesRunTime.unboxToBoolean((Object)tuple32._2());
                    Option mappedProps2 = (Option)tuple32._3();
                    Object object2 = mappedProps2.isDefined() && uniqueID.isDefined() ? Config$.MODULE$.persistenceManager().put(recordUuid2, "occ", (scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)mappedProps2.get()), isNew2, removeNullFields) : BoxedUnit.UNIT;
                    fieldTuples.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"dataResourceUid"), (Object)resourceUid));
                    fieldTuples.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"lastModifiedTime"), (Object)this.loadTime()));
                    if (isNew2) {
                        fieldTuples.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"firstLoaded"), (Object)this.loadTime()));
                        ++newCount;
                    }
                    Seq multimedia = (Seq)this.loadMultimedia(star, (org.gbif.dwc.terms.Term)DwCALoader$.MODULE$.IMAGE_TYPE(), imageBase).$plus$plus(this.loadMultimedia(star, (org.gbif.dwc.terms.Term)DwCALoader$.MODULE$.MULTIMEDIA_TYPE(), imageBase), Seq$.MODULE$.canBuildFrom());
                    boolean bl = toBeLoaded = loadMissingOnly ? true : true;
                    if (toBeLoaded) {
                        BoxedUnit boxedUnit;
                        ++count;
                        if (rowKeyWriter.isDefined()) {
                            ((Writer)rowKeyWriter.get()).write(new StringBuilder().append((Object)recordUuid2).append((Object)"\n").toString());
                        }
                        if (testFile) {
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            FullRecord fullRecord = FullRecordMapper$.MODULE$.createFullRecord(recordUuid2, (Tuple2[])fieldTuples.toArray(ClassTag$.MODULE$.apply(Tuple2.class)), (Version)Raw$.MODULE$);
                            this.processMedia(resourceUid, fullRecord, (Seq<Multimedia>)multimedia);
                            boxedUnit = currentBatch.$plus$eq((Object)fullRecord);
                        }
                        if (count % 1000 != 0 || count <= 0) continue;
                        if (!testFile) {
                            Config$.MODULE$.occurrenceDAO().addRawOccurrenceBatch((FullRecord[])currentBatch.toArray(ClassTag$.MODULE$.apply(FullRecord.class)), removeNullFields);
                        }
                        finishTime = System.currentTimeMillis();
                        float timeInSecs = (float)1000 / ((float)(finishTime - startTime) / 1000.0f);
                        this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ", >> last key : ", ", UUID: ", ", records per sec: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)count), uniqueID, recordUuid2, BoxesRunTime.boxToFloat((float)timeInSecs)})));
                        startTime = System.currentTimeMillis();
                        currentBatch.clear();
                        continue;
                    }
                    ++skipped;
                    continue;
                }
            }
            throw new MatchError(tuple2);
        }
        if (rowKeyWriter.isDefined()) {
            ((Writer)rowKeyWriter.get()).flush();
            ((Writer)rowKeyWriter.get()).close();
        }
        if (testFile) {
            HashSet unknownInstitutions = (HashSet)newInstCodes.$amp$tilde((GenSet)institutionCodes);
            HashSet unknownCollections = (HashSet)newCollCodes.$amp$tilde((GenSet)collectionCodes);
            if (!unknownInstitutions.isEmpty()) {
                this.logger().warn(new StringBuilder().append((Object)"Warning there are new institution codes in the set: ").append((Object)unknownInstitutions.mkString(",")).toString());
            }
            if (!unknownCollections.isEmpty()) {
                this.logger().warn(new StringBuilder().append((Object)"Warning there are new collection codes in the set: ").append((Object)unknownCollections.mkString(",")).toString());
            }
            this.logger().info(new StringBuilder().append((Object)"There are ").append((Object)BoxesRunTime.boxToInteger((int)count)).append((Object)" records in the file. The number of NEW records: ").append((Object)BoxesRunTime.boxToInteger((int)newCount)).toString());
        }
        Config$.MODULE$.occurrenceDAO().addRawOccurrenceBatch((FullRecord[])currentBatch.toArray(ClassTag$.MODULE$.apply(FullRecord.class)), removeNullFields);
        this.logger().info(new StringBuilder().append((Object)"Finished DwCA loader. Records loaded into the system: ").append((Object)BoxesRunTime.boxToInteger((int)count)).append((Object)", records skipped:").append((Object)BoxesRunTime.boxToInteger((int)skipped)).toString());
    }

    public boolean loadArchive$default$8() {
        return false;
    }

    public Seq<Multimedia> loadMultimedia(StarRecord star, org.gbif.dwc.terms.Term rowType, URL imageBase) {
        if (star.hasExtension(rowType)) {
            Buffer records = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(star.extension(rowType)).asScala();
            ListBuffer multimedia = new ListBuffer();
            records.foreach((Function1)new Serializable(this, imageBase, multimedia){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DwCALoader $outer;
                private final URL imageBase$1;
                private final ListBuffer multimedia$1;

                public final Object apply(Record row) {
                    Option<URL> option;
                    block4: {
                        Boolean bl;
                        block3: {
                            block2: {
                                Set terms = (Set)JavaConversions$.MODULE$.asScalaSet(row.terms()).filter((Function1)new Serializable(this, row){
                                    public static final long serialVersionUID = 0L;
                                    private final Record row$1;

                                    public final boolean apply(org.gbif.dwc.terms.Term term) {
                                        return Option$.MODULE$.apply((Object)this.row$1.value(term)).isDefined();
                                    }
                                    {
                                        this.row$1 = row$1;
                                    }
                                });
                                scala.collection.immutable.Map metadata = ((TraversableOnce)terms.map((Function1)new Serializable(this, row){
                                    public static final long serialVersionUID = 0L;
                                    private final Record row$1;

                                    public final Tuple2<org.gbif.dwc.terms.Term, String> apply(org.gbif.dwc.terms.Term term) {
                                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)term), (Object)this.row$1.value(term));
                                    }
                                    {
                                        this.row$1 = row$1;
                                    }
                                }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
                                option = this.$outer.locateMultimedia(row, this.imageBase$1);
                                if (!(option instanceof Some)) break block2;
                                Some some = (Some)option;
                                URL location = (URL)some.x();
                                bl = BoxesRunTime.boxToBoolean((boolean)JavaConversions$.MODULE$.bufferAsJavaList((Buffer)this.multimedia$1).add(Multimedia$.MODULE$.create(location, (scala.collection.immutable.Map<org.gbif.dwc.terms.Term, String>)metadata)));
                                break block3;
                            }
                            None$ none$ = None$.MODULE$;
                            Option<URL> option2 = option;
                            if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                            this.$outer.logger().info(new StringBuilder().append((Object)"No location found for multimedia typed row: ").append((Object)row).toString());
                            bl = BoxedUnit.UNIT;
                        }
                        return bl;
                    }
                    throw new MatchError(option);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.imageBase$1 = imageBase$1;
                    this.multimedia$1 = multimedia$1;
                }
            });
            return multimedia;
        }
        return List$.MODULE$.empty();
    }

    public Option<URL> locateMultimedia(Record row, URL imageBase) {
        String identifier = row.value((org.gbif.dwc.terms.Term)DcTerm.identifier);
        return identifier == null ? None$.MODULE$ : new Some((Object)new URL(imageBase, identifier));
    }

    public DwCALoader() {
        DataLoader$class.$init$(this);
    }
}

