/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.index;

import au.org.ala.biocache.Config$;
import au.org.ala.biocache.ObserverCallback;
import au.org.ala.biocache.Store$;
import au.org.ala.biocache.cmd.IncrementalTool;
import au.org.ala.biocache.cmd.IncrementalTool$class;
import au.org.ala.biocache.cmd.Tool;
import au.org.ala.biocache.cmd.Tool$class;
import au.org.ala.biocache.dao.OccurrenceDAO;
import au.org.ala.biocache.index.IndexDAO;
import au.org.ala.biocache.load.FullRecordMapper$;
import au.org.ala.biocache.persistence.PersistenceManager;
import au.org.ala.biocache.util.FileHelper$;
import au.org.ala.biocache.util.OptionParser;
import au.org.ala.biocache.util.StringFileWriterConsumer;
import java.io.File;
import java.io.FileWriter;
import java.util.Date;
import java.util.concurrent.ArrayBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;

public final class IndexRecords$
implements Tool,
IncrementalTool {
    public static final IndexRecords$ MODULE$;
    private final Logger logger;
    private final IndexDAO indexer;
    private final OccurrenceDAO occurrenceDAO;
    private final PersistenceManager persistenceManager;

    static {
        new IndexRecords$();
    }

    @Override
    public Option<String> getDeleteRowFile(String resourceUid) {
        return IncrementalTool$class.getDeleteRowFile(this, resourceUid);
    }

    @Override
    public Tuple2<Object, Option<String>> hasRowKey(String resourceUid) {
        return IncrementalTool$class.hasRowKey(this, resourceUid);
    }

    @Override
    public String help() {
        return Tool$class.help(this);
    }

    @Override
    public String cmd() {
        return "index";
    }

    @Override
    public String desc() {
        return "Index records for a data resource. Not suitable for full re-indexing (>5m)";
    }

    public Logger logger() {
        return this.logger;
    }

    public IndexDAO indexer() {
        return this.indexer;
    }

    public OccurrenceDAO occurrenceDAO() {
        return this.occurrenceDAO;
    }

    public PersistenceManager persistenceManager() {
        return this.persistenceManager;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void main(String[] args) {
        BooleanRef empty = new BooleanRef(false);
        BooleanRef check = new BooleanRef(false);
        ObjectRef startDate = new ObjectRef((Object)None$.MODULE$);
        IntRef pageSize = new IntRef(1000);
        ObjectRef dataResourceUid = new ObjectRef((Object)None$.MODULE$);
        ObjectRef uuidFile = new ObjectRef((Object)"");
        ObjectRef rowKeyFile = new ObjectRef((Object)"");
        IntRef threads = new IntRef(1);
        BooleanRef test = new BooleanRef(false);
        BooleanRef checkRowKeyFile = new BooleanRef(true);
        BooleanRef abortIfNotRowKeyFile = new BooleanRef(true);
        OptionParser parser = new OptionParser(empty, check, startDate, pageSize, dataResourceUid, uuidFile, rowKeyFile, threads, test, checkRowKeyFile, abortIfNotRowKeyFile){
            {
                this.opt("empty", "empty the index first", (Function0<BoxedUnit>)new Serializable(this, empty$1){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef empty$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.empty$1.elem = true;
                    }
                    {
                        this.empty$1 = empty$1;
                    }
                });
                this.opt("check", "check to see if the record is deleted before indexing", (Function0<BoxedUnit>)new Serializable(this, check$1){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef check$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.check$1.elem = true;
                    }
                    {
                        this.check$1 = check$1;
                    }
                });
                this.opt("date", "date", "The earliest modification date for records to be indexed. Date in the form yyyy-mm-dd", (Function1<String, BoxedUnit>)new Serializable(this, startDate$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef startDate$1;

                    public final void apply(String v) {
                        this.startDate$1.elem = new Some((Object)v);
                    }
                    {
                        this.startDate$1 = startDate$1;
                    }
                });
                this.opt("dr", "dataResource", "The data resource to index", (Function1<String, BoxedUnit>)new Serializable(this, dataResourceUid$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef dataResourceUid$1;

                    public final void apply(String v) {
                        this.dataResourceUid$1.elem = new Some((Object)v);
                    }
                    {
                        this.dataResourceUid$1 = dataResourceUid$1;
                    }
                });
                this.intOpt("ps", "pageSize", "The page size for indexing", (Function1<Object, BoxedUnit>)new Serializable(this, pageSize$1){
                    public static final long serialVersionUID = 0L;
                    private final IntRef pageSize$1;

                    public final void apply(int v) {
                        this.apply$mcVI$sp(v);
                    }

                    public void apply$mcVI$sp(int v) {
                        this.pageSize$1.elem = v;
                    }
                    {
                        this.pageSize$1 = pageSize$1;
                    }
                });
                this.opt("if", "file-uuids-to-index", "Absolute file path to fle containing UUIDs to index", (Function1<String, BoxedUnit>)new Serializable(this, uuidFile$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef uuidFile$1;

                    public final void apply(String v) {
                        this.uuidFile$1.elem = v;
                    }
                    {
                        this.uuidFile$1 = uuidFile$1;
                    }
                });
                this.opt("rf", "file-rowkeys-to-index", "Absolute file path to fle containing rowkeys to index", (Function1<String, BoxedUnit>)new Serializable(this, rowKeyFile$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef rowKeyFile$1;

                    public final void apply(String v) {
                        this.rowKeyFile$1.elem = v;
                    }
                    {
                        this.rowKeyFile$1 = rowKeyFile$1;
                    }
                });
                this.intOpt("t", "threads", "Number of threads to index from", (Function1<Object, BoxedUnit>)new Serializable(this, threads$1){
                    public static final long serialVersionUID = 0L;
                    private final IntRef threads$1;

                    public final void apply(int v) {
                        this.apply$mcVI$sp(v);
                    }

                    public void apply$mcVI$sp(int v) {
                        this.threads$1.elem = v;
                    }
                    {
                        this.threads$1 = threads$1;
                    }
                });
                this.opt("test", "test the speed of creating the index the minus the actual SOLR indexing costs", (Function0<BoxedUnit>)new Serializable(this, test$1){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef test$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.test$1.elem = true;
                    }
                    {
                        this.test$1 = test$1;
                    }
                });
                this.opt("crk", "check for row key file", (Function0<BoxedUnit>)new Serializable(this, checkRowKeyFile$1){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef checkRowKeyFile$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.checkRowKeyFile$1.elem = true;
                    }
                    {
                        this.checkRowKeyFile$1 = checkRowKeyFile$1;
                    }
                });
                this.opt("acrk", "abort if no row key file found", (Function0<BoxedUnit>)new Serializable(this, abortIfNotRowKeyFile$1){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef abortIfNotRowKeyFile$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.abortIfNotRowKeyFile$1.elem = true;
                    }
                    {
                        this.abortIfNotRowKeyFile$1 = abortIfNotRowKeyFile$1;
                    }
                });
            }
        };
        if (!parser.parse((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])args))) return;
        if (!((Option)dataResourceUid.elem).isEmpty() && checkRowKeyFile.elem && ((String)rowKeyFile.elem).isEmpty()) {
            Tuple2 tuple2;
            Tuple2<Object, Option<String>> tuple22 = this.hasRowKey((String)((Option)dataResourceUid.elem).get());
            if (tuple22 == null) throw new MatchError(tuple22);
            boolean hasRowKey = tuple22._1$mcZ$sp();
            Option retrievedRowKeyFile = (Option)tuple22._2();
            Tuple2 tuple23 = tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)hasRowKey), (Object)retrievedRowKeyFile);
            boolean hasRowKey2 = tuple23._1$mcZ$sp();
            Option retrievedRowKeyFile2 = (Option)tuple23._2();
            rowKeyFile.elem = (String)retrievedRowKeyFile2.getOrElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "";
                }
            });
        }
        if (abortIfNotRowKeyFile.elem) {
            String string = (String)rowKeyFile.elem;
            String string2 = "";
            if (!(string == null ? string2 != null : !string.equals(string2)) || !new File((String)rowKeyFile.elem).exists()) {
                this.logger().warn("No rowkey file was found for this index. Aborting.");
                return;
            }
        }
        if (!((Option)dataResourceUid.elem).isEmpty() && ((String)rowKeyFile.elem).isEmpty()) {
            this.index((Option<String>)((Option)dataResourceUid.elem), this.index$default$2(), this.index$default$3(), this.index$default$4(), this.index$default$5(), this.index$default$6(), this.index$default$7(), this.index$default$8(), this.index$default$9(), this.index$default$10(), this.index$default$11());
            return;
        }
        if (empty.elem) {
            this.logger().info("Emptying index");
            this.indexer().emptyIndex();
        }
        String string = (String)uuidFile.elem;
        String string3 = "";
        if (!(string != null ? !string.equals(string3) : string3 != null)) {
            String string4 = (String)rowKeyFile.elem;
            String string5 = "";
            if (string4 == null ? string5 != null : !string4.equals(string5)) {
                if (threads.elem == 1) {
                    this.indexList(new File((String)rowKeyFile.elem), this.indexList$default$2());
                } else {
                    this.indexListThreaded(new File((String)rowKeyFile.elem), threads.elem);
                }
            }
        } else {
            this.indexListOfUUIDs(new File((String)uuidFile.elem));
        }
        this.indexer().shutdown();
    }

    public void index(Option<String> dataResource, boolean optimise, boolean shutdown, Option<String> startDate, boolean checkDeleted, int pageSize, Seq<String> miscIndexProperties, Seq<String> userProvidedTypeMiscIndexProperties, ObserverCallback callback, boolean test, int threads) {
        if (dataResource.isEmpty()) {
            this.logger().info("Starting full index");
        } else {
            this.logger().info(new StringBuilder().append((Object)"Starting to index ").append(dataResource.get()).toString());
        }
        String x$3 = (String)dataResource.getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        });
        None$ x$4 = None$.MODULE$;
        boolean x$5 = checkDeleted;
        Seq<String> x$6 = miscIndexProperties;
        Seq<String> x$7 = userProvidedTypeMiscIndexProperties;
        ObserverCallback x$8 = callback;
        boolean x$9 = test;
        int x$10 = threads;
        int x$11 = this.indexRange$default$4();
        this.indexRange(x$3, (Option<Date>)x$4, x$5, x$11, x$6, x$7, x$8, x$9, x$10);
        this.indexer().finaliseIndex(optimise, shutdown);
    }

    public boolean index$default$2() {
        return false;
    }

    public boolean index$default$3() {
        return false;
    }

    public Option<String> index$default$4() {
        return None$.MODULE$;
    }

    public boolean index$default$5() {
        return false;
    }

    public int index$default$6() {
        return 1000;
    }

    public Seq<String> index$default$7() {
        return Predef$.MODULE$.wrapRefArray((Object[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class)));
    }

    public Seq<String> index$default$8() {
        return Predef$.MODULE$.wrapRefArray((Object[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class)));
    }

    public ObserverCallback index$default$9() {
        return null;
    }

    public boolean index$default$10() {
        return false;
    }

    public int index$default$11() {
        return 4;
    }

    public void indexRange(String dataResourceUid, Option<Date> startDate, boolean checkDeleted, int pageSize, Seq<String> miscIndexProperties, Seq<String> userProvidedTypeMiscIndexProperties, ObserverCallback callback, boolean test, int threads) {
        FileWriter csvFileWriter;
        IntRef counter = new IntRef(0);
        long start = System.currentTimeMillis();
        LongRef startTime = new LongRef(System.currentTimeMillis());
        LongRef finishTime = new LongRef(System.currentTimeMillis());
        FileWriter fileWriter = Config$.MODULE$.exportIndexAsCsvPath().length() > 0 ? this.indexer().getCsvWriter(this.indexer().getCsvWriter$default$1()) : (csvFileWriter = null);
        FileWriter csvFileWriterSensitive = Config$.MODULE$.exportIndexAsCsvPathSensitive().length() > 0 ? this.indexer().getCsvWriter(true) : null;
        Serializable x$23 = new Serializable(startDate, pageSize, miscIndexProperties, userProvidedTypeMiscIndexProperties, callback, test, counter, startTime, finishTime, csvFileWriter, csvFileWriterSensitive){
            public static final long serialVersionUID = 0L;
            private final Option startDate$2;
            private final int pageSize$2;
            private final Seq miscIndexProperties$1;
            private final Seq userProvidedTypeMiscIndexProperties$1;
            private final ObserverCallback callback$1;
            private final boolean test$2;
            private final IntRef counter$1;
            private final LongRef startTime$1;
            private final LongRef finishTime$1;
            private final FileWriter csvFileWriter$1;
            private final FileWriter csvFileWriterSensitive$1;

            public final boolean apply(String guid, scala.collection.immutable.Map<String, String> map) {
                ++this.counter$1.elem;
                boolean shouldcommit = this.counter$1.elem % 10000 == 0;
                String x$12 = guid;
                scala.collection.immutable.Map<String, String> x$13 = map;
                Option x$14 = this.startDate$2;
                boolean x$15 = shouldcommit;
                Seq x$16 = this.miscIndexProperties$1;
                Seq x$17 = this.userProvidedTypeMiscIndexProperties$1;
                boolean x$18 = this.test$2;
                FileWriter x$19 = this.csvFileWriter$1;
                FileWriter x$20 = this.csvFileWriterSensitive$1;
                boolean x$21 = IndexRecords$.MODULE$.indexer().indexFromMap$default$3();
                String x$22 = IndexRecords$.MODULE$.indexer().indexFromMap$default$9();
                IndexRecords$.MODULE$.indexer().indexFromMap(x$12, (Map<String, String>)x$13, x$21, (Option<Date>)x$14, x$15, (Seq<String>)x$16, (Seq<String>)x$17, x$18, x$22, x$19, x$20);
                if (this.counter$1.elem % this.pageSize$2 == 0) {
                    if (this.callback$1 != null) {
                        this.callback$1.progressMessage(this.counter$1.elem);
                    }
                    this.finishTime$1.elem = System.currentTimeMillis();
                    IndexRecords$.MODULE$.logger().info(new StringBuilder().append(this.counter$1.elem).append((Object)" >> Last key : ").append((Object)guid).append((Object)", records per sec: ").append((Object)BoxesRunTime.boxToFloat((float)((float)this.pageSize$2 / ((float)(this.finishTime$1.elem - this.startTime$1.elem) / 1000.0f)))).toString());
                    this.startTime$1.elem = System.currentTimeMillis();
                }
                return true;
            }
            {
                this.startDate$2 = startDate$2;
                this.pageSize$2 = pageSize$2;
                this.miscIndexProperties$1 = miscIndexProperties$1;
                this.userProvidedTypeMiscIndexProperties$1 = userProvidedTypeMiscIndexProperties$1;
                this.callback$1 = callback$1;
                this.test$2 = test$2;
                this.counter$1 = counter$1;
                this.startTime$1 = startTime$1;
                this.finishTime$1 = finishTime$1;
                this.csvFileWriter$1 = csvFileWriter$1;
                this.csvFileWriterSensitive$1 = csvFileWriterSensitive$1;
            }
        };
        String x$24 = dataResourceUid;
        boolean x$25 = checkDeleted;
        int x$26 = pageSize;
        int x$27 = threads;
        this.performPaging((Function2<String, scala.collection.immutable.Map<String, String>, Object>)x$23, x$24, x$26, x$25, x$27);
        if (csvFileWriter != null) {
            csvFileWriter.flush();
            csvFileWriter.close();
        }
        if (csvFileWriterSensitive != null) {
            csvFileWriterSensitive.flush();
            csvFileWriterSensitive.close();
        }
        finishTime.elem = System.currentTimeMillis();
        this.logger().info(new StringBuilder().append((Object)"Total indexing time ").append((Object)BoxesRunTime.boxToFloat((float)((float)(finishTime.elem - start) / 1000.0f))).append((Object)" seconds").toString());
    }

    public Option<Date> indexRange$default$2() {
        return None$.MODULE$;
    }

    public boolean indexRange$default$3() {
        return false;
    }

    public int indexRange$default$4() {
        return 1000;
    }

    public Seq<String> indexRange$default$5() {
        return Predef$.MODULE$.wrapRefArray((Object[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class)));
    }

    public Seq<String> indexRange$default$6() {
        return Predef$.MODULE$.wrapRefArray((Object[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class)));
    }

    public ObserverCallback indexRange$default$7() {
        return null;
    }

    public boolean indexRange$default$8() {
        return false;
    }

    public int indexRange$default$9() {
        return 4;
    }

    public void performPaging(Function2<String, scala.collection.immutable.Map<String, String>, Object> proc, String dataResourceUid, int pageSize, boolean checkDeleted, int threads) {
        File keyFile = Store$.MODULE$.rowKeyFile(dataResourceUid);
        if (keyFile.exists()) {
            this.logger().info(new StringBuilder().append((Object)"Using rowKeyFile ").append((Object)keyFile.getPath()).toString());
            FileHelper$.MODULE$.file2helper(keyFile).foreachLine((Function1<String, BoxedUnit>)new Serializable(proc, checkDeleted){
                public static final long serialVersionUID = 0L;
                private final Function2 proc$1;
                private final boolean checkDeleted$1;

                public final void apply(String line) {
                    Option<scala.collection.immutable.Map<String, String>> map = IndexRecords$.MODULE$.persistenceManager().get(line, "occ");
                    if (!(map.isEmpty() || this.checkDeleted$1 && !map.getOrElse((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Tuple2<String, String> apply() {
                            return new Tuple2((Object)FullRecordMapper$.MODULE$.deletedColumn(), (Object)"false");
                        }
                    }).toString().equals("false"))) {
                        this.proc$1.apply((Object)line, map.get());
                    }
                }
                {
                    this.proc$1 = proc$1;
                    this.checkDeleted$1 = checkDeleted$1;
                }
            });
        } else {
            this.logger().info("Using query for dataResourceUid");
            this.persistenceManager().pageOverIndexedField("occ", (Function2<String, scala.collection.immutable.Map<String, String>, Object>)new Serializable(proc, checkDeleted){
                public static final long serialVersionUID = 0L;
                private final Function2 proc$1;
                private final boolean checkDeleted$1;

                public final boolean apply(String guid, scala.collection.immutable.Map<String, String> map) {
                    Object object = map.isEmpty() || this.checkDeleted$1 && !((String)map.getOrElse((Object)FullRecordMapper$.MODULE$.deletedColumn(), (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "false";
                        }
                    })).equals("false") ? BoxedUnit.UNIT : this.proc$1.apply((Object)guid, map);
                    return true;
                }
                {
                    this.proc$1 = proc$1;
                    this.checkDeleted$1 = checkDeleted$1;
                }
            }, "dataResourceUid", dataResourceUid, threads, this.persistenceManager().pageOverIndexedField$default$6());
        }
    }

    public int performPaging$default$3() {
        return 1000;
    }

    public boolean performPaging$default$4() {
        return false;
    }

    public int performPaging$default$5() {
        return 4;
    }

    public void indexList(List<String> rowKeys) {
        FileWriter csvFileWriter;
        IntRef counter = new IntRef(0);
        LongRef startTime = new LongRef(System.currentTimeMillis());
        LongRef finishTime = new LongRef(System.currentTimeMillis());
        FileWriter fileWriter = Config$.MODULE$.exportIndexAsCsvPath().length() > 0 ? this.indexer().getCsvWriter(this.indexer().getCsvWriter$default$1()) : (csvFileWriter = null);
        FileWriter csvFileWriterSensitive = Config$.MODULE$.exportIndexAsCsvPathSensitive().length() > 0 ? this.indexer().getCsvWriter(true) : null;
        rowKeys.foreach((Function1)new Serializable(counter, startTime, finishTime, csvFileWriter, csvFileWriterSensitive){
            public static final long serialVersionUID = 0L;
            private final IntRef counter$2;
            private final LongRef startTime$2;
            private final LongRef finishTime$2;
            private final FileWriter csvFileWriter$2;
            private final FileWriter csvFileWriterSensitive$2;

            public final void apply(String rowKey) {
                boolean shouldcommit;
                ++this.counter$2.elem;
                Option<scala.collection.immutable.Map<String, String>> map = IndexRecords$.MODULE$.persistenceManager().get(rowKey, "occ");
                boolean bl = shouldcommit = this.counter$2.elem % 10000 == 0;
                if (!map.isEmpty()) {
                    String x$28 = rowKey;
                    scala.collection.immutable.Map x$29 = (scala.collection.immutable.Map)map.get();
                    boolean x$30 = shouldcommit;
                    FileWriter x$31 = this.csvFileWriter$2;
                    FileWriter x$32 = this.csvFileWriterSensitive$2;
                    boolean x$33 = IndexRecords$.MODULE$.indexer().indexFromMap$default$3();
                    Option<Date> x$34 = IndexRecords$.MODULE$.indexer().indexFromMap$default$4();
                    Seq<String> x$35 = IndexRecords$.MODULE$.indexer().indexFromMap$default$6();
                    Seq<String> x$36 = IndexRecords$.MODULE$.indexer().indexFromMap$default$7();
                    boolean x$37 = IndexRecords$.MODULE$.indexer().indexFromMap$default$8();
                    String x$38 = IndexRecords$.MODULE$.indexer().indexFromMap$default$9();
                    IndexRecords$.MODULE$.indexer().indexFromMap(x$28, (Map<String, String>)x$29, x$33, x$34, x$30, x$35, x$36, x$37, x$38, x$31, x$32);
                }
                if (this.counter$2.elem % 100 == 0) {
                    this.finishTime$2.elem = System.currentTimeMillis();
                    IndexRecords$.MODULE$.logger().debug(new StringBuilder().append(this.counter$2.elem).append((Object)" >> Last key : ").append((Object)rowKey).append((Object)", records per sec: ").append((Object)BoxesRunTime.boxToFloat((float)(100.0f / ((float)(this.finishTime$2.elem - this.startTime$2.elem) / 1000.0f)))).toString());
                    this.startTime$2.elem = System.currentTimeMillis();
                }
            }
            {
                this.counter$2 = counter$2;
                this.startTime$2 = startTime$2;
                this.finishTime$2 = finishTime$2;
                this.csvFileWriter$2 = csvFileWriter$2;
                this.csvFileWriterSensitive$2 = csvFileWriterSensitive$2;
            }
        });
        if (csvFileWriter != null) {
            csvFileWriter.flush();
            csvFileWriter.close();
        }
        if (csvFileWriterSensitive != null) {
            csvFileWriterSensitive.flush();
            csvFileWriterSensitive.close();
        }
        this.indexer().finaliseIndex(false, false);
    }

    public void indexListThreaded(File rowKeys, int threads) {
        ArrayBlockingQueue queue = new ArrayBlockingQueue(100);
        IntRef ids = new IntRef(0);
        FileWriter[] csvFileWriterList = (FileWriter[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(FileWriter.class));
        StringFileWriterConsumer[] pool = (StringFileWriterConsumer[])Array$.MODULE$.fill(threads, (Function0)new Serializable(queue, ids, csvFileWriterList){
            public static final long serialVersionUID = 0L;
            private final ArrayBlockingQueue queue$1;
            private final IntRef ids$1;
            private final FileWriter[] csvFileWriterList$1;

            public final StringFileWriterConsumer apply() {
                IntRef counter = new IntRef(0);
                LongRef startTime = new LongRef(System.currentTimeMillis());
                LongRef finishTime = new LongRef(System.currentTimeMillis());
                FileWriter csvFileWriter = Config$.MODULE$.exportIndexAsCsvPath().length() > 0 ? IndexRecords$.MODULE$.indexer().getCsvWriter(IndexRecords$.MODULE$.indexer().getCsvWriter$default$1()) : null;
                Predef$.MODULE$.refArrayOps((Object[])this.csvFileWriterList$1).$colon$plus((Object)csvFileWriter, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(FileWriter.class)));
                FileWriter csvFileWriterSensitive = Config$.MODULE$.exportIndexAsCsvPathSensitive().length() > 0 ? IndexRecords$.MODULE$.indexer().getCsvWriter(true) : null;
                Predef$.MODULE$.refArrayOps((Object[])this.csvFileWriterList$1).$colon$plus((Object)csvFileWriterSensitive, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(FileWriter.class)));
                IndexRecords$.MODULE$.indexer().init();
                StringFileWriterConsumer p = new StringFileWriterConsumer(this.queue$1, this.ids$1.elem, csvFileWriter, csvFileWriterSensitive, (Function3<String, FileWriter, FileWriter, BoxedUnit>)new Serializable(this, counter, startTime, finishTime){
                    public static final long serialVersionUID = 0L;
                    private final IntRef counter$3;
                    private final LongRef startTime$3;
                    private final LongRef finishTime$3;

                    public final void apply(String rowKey, FileWriter csvFileWriter, FileWriter csvFileWriterSensitive) {
                        ++this.counter$3.elem;
                        try {
                            boolean shouldcommit;
                            Option<scala.collection.immutable.Map<String, String>> map = IndexRecords$.MODULE$.persistenceManager().get(rowKey, "occ");
                            boolean bl = shouldcommit = this.counter$3.elem % 1000 == 0;
                            if (!map.isEmpty()) {
                                String x$39 = rowKey;
                                scala.collection.immutable.Map x$40 = (scala.collection.immutable.Map)map.get();
                                boolean x$41 = shouldcommit;
                                FileWriter x$42 = csvFileWriter;
                                FileWriter x$43 = csvFileWriterSensitive;
                                boolean x$44 = IndexRecords$.MODULE$.indexer().indexFromMap$default$3();
                                Option<Date> x$45 = IndexRecords$.MODULE$.indexer().indexFromMap$default$4();
                                Seq<String> x$46 = IndexRecords$.MODULE$.indexer().indexFromMap$default$6();
                                Seq<String> x$47 = IndexRecords$.MODULE$.indexer().indexFromMap$default$7();
                                boolean x$48 = IndexRecords$.MODULE$.indexer().indexFromMap$default$8();
                                String x$49 = IndexRecords$.MODULE$.indexer().indexFromMap$default$9();
                                IndexRecords$.MODULE$.indexer().indexFromMap(x$39, (Map<String, String>)x$40, x$44, x$45, x$41, x$46, x$47, x$48, x$49, x$42, x$43);
                            }
                        }
                        catch (Exception exception) {
                            IndexRecords$.MODULE$.logger().error(new StringBuilder().append((Object)"Problem indexing record with row key: '").append((Object)rowKey).append((Object)"'.  ").toString(), (Throwable)exception);
                        }
                        if (this.counter$3.elem % 1000 == 0) {
                            this.finishTime$3.elem = System.currentTimeMillis();
                            IndexRecords$.MODULE$.logger().info(new StringBuilder().append(this.counter$3.elem).append((Object)" >> Last key : ").append((Object)rowKey).append((Object)", records per sec: ").append((Object)BoxesRunTime.boxToFloat((float)(1000.0f / ((float)(this.finishTime$3.elem - this.startTime$3.elem) / 1000.0f)))).toString());
                            this.startTime$3.elem = System.currentTimeMillis();
                        }
                    }
                    {
                        this.counter$3 = counter$3;
                        this.startTime$3 = startTime$3;
                        this.finishTime$3 = finishTime$3;
                    }
                });
                ++this.ids$1.elem;
                p.start();
                return p;
            }
            {
                this.queue$1 = queue$1;
                this.ids$1 = ids$1;
                this.csvFileWriterList$1 = csvFileWriterList$1;
            }
        }, ClassTag$.MODULE$.apply(StringFileWriterConsumer.class));
        FileHelper$.MODULE$.file2helper(rowKeys).foreachLine((Function1<String, BoxedUnit>)new Serializable(queue){
            public static final long serialVersionUID = 0L;
            private final ArrayBlockingQueue queue$1;

            public final void apply(String line) {
                this.queue$1.put(line.trim());
            }
            {
                this.queue$1 = queue$1;
            }
        });
        Predef$.MODULE$.refArrayOps((Object[])pool).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(StringFileWriterConsumer t) {
                t.shouldStop_$eq(true);
            }
        });
        Predef$.MODULE$.refArrayOps((Object[])pool).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(StringFileWriterConsumer x$2) {
                x$2.join();
            }
        });
        this.indexer().finaliseIndex(false, false);
        Predef$.MODULE$.refArrayOps((Object[])csvFileWriterList).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(FileWriter t) {
                if (t != null) {
                    t.flush();
                    t.close();
                }
            }
        });
    }

    public void indexList(File file, boolean shutdown) {
        FileWriter csvFileWriter;
        this.logger().info("Starting the reindex by row key....");
        IntRef counter = new IntRef(0);
        LongRef startTime = new LongRef(System.currentTimeMillis());
        LongRef finishTime = new LongRef(System.currentTimeMillis());
        FileWriter fileWriter = Config$.MODULE$.exportIndexAsCsvPath().length() > 0 ? this.indexer().getCsvWriter(this.indexer().getCsvWriter$default$1()) : (csvFileWriter = null);
        FileWriter csvFileWriterSensitive = Config$.MODULE$.exportIndexAsCsvPathSensitive().length() > 0 ? this.indexer().getCsvWriter(this.indexer().getCsvWriter$default$1()) : null;
        FileHelper$.MODULE$.file2helper(file).foreachLine((Function1<String, BoxedUnit>)new Serializable(counter, startTime, finishTime, csvFileWriter, csvFileWriterSensitive){
            public static final long serialVersionUID = 0L;
            private final IntRef counter$4;
            private final LongRef startTime$4;
            private final LongRef finishTime$4;
            private final FileWriter csvFileWriter$3;
            private final FileWriter csvFileWriterSensitive$3;

            public final void apply(String line) {
                boolean shouldCommit;
                ++this.counter$4.elem;
                String rowKey = BoxesRunTime.unboxToChar((Object)new StringOps(Predef$.MODULE$.augmentString(line)).head()) == '\"' && BoxesRunTime.unboxToChar((Object)new StringOps(Predef$.MODULE$.augmentString(line)).last()) == '\"' ? line.substring(1, line.length() - 1) : line;
                Option<scala.collection.immutable.Map<String, String>> map = IndexRecords$.MODULE$.persistenceManager().get(rowKey, "occ");
                boolean bl = shouldCommit = this.counter$4.elem % 10000 == 0;
                if (!map.isEmpty()) {
                    String x$50 = rowKey;
                    scala.collection.immutable.Map x$51 = (scala.collection.immutable.Map)map.get();
                    boolean x$52 = shouldCommit;
                    FileWriter x$53 = this.csvFileWriter$3;
                    FileWriter x$54 = this.csvFileWriterSensitive$3;
                    boolean x$55 = IndexRecords$.MODULE$.indexer().indexFromMap$default$3();
                    Option<Date> x$56 = IndexRecords$.MODULE$.indexer().indexFromMap$default$4();
                    Seq<String> x$57 = IndexRecords$.MODULE$.indexer().indexFromMap$default$6();
                    Seq<String> x$58 = IndexRecords$.MODULE$.indexer().indexFromMap$default$7();
                    boolean x$59 = IndexRecords$.MODULE$.indexer().indexFromMap$default$8();
                    String x$60 = IndexRecords$.MODULE$.indexer().indexFromMap$default$9();
                    IndexRecords$.MODULE$.indexer().indexFromMap(x$50, (Map<String, String>)x$51, x$55, x$56, x$52, x$57, x$58, x$59, x$60, x$53, x$54);
                }
                if (this.counter$4.elem % 1000 == 0) {
                    this.finishTime$4.elem = System.currentTimeMillis();
                    IndexRecords$.MODULE$.logger().info(new StringBuilder().append(this.counter$4.elem).append((Object)" >> Last key : ").append((Object)line).append((Object)", records per sec: ").append((Object)BoxesRunTime.boxToFloat((float)(1000.0f / ((float)(this.finishTime$4.elem - this.startTime$4.elem) / 1000.0f)))).toString());
                    this.startTime$4.elem = System.currentTimeMillis();
                }
            }
            {
                this.counter$4 = counter$4;
                this.startTime$4 = startTime$4;
                this.finishTime$4 = finishTime$4;
                this.csvFileWriter$3 = csvFileWriter$3;
                this.csvFileWriterSensitive$3 = csvFileWriterSensitive$3;
            }
        });
        if (csvFileWriter != null) {
            csvFileWriter.flush();
            csvFileWriter.close();
        }
        if (csvFileWriterSensitive != null) {
            csvFileWriterSensitive.flush();
            csvFileWriterSensitive.close();
        }
        this.indexer().finaliseIndex(false, shutdown);
    }

    public boolean indexList$default$2() {
        return true;
    }

    public void indexListOfUUIDs(File file) {
        FileWriter csvFileWriter;
        this.logger().info("Starting the reindex by UUIDs....");
        IntRef counter = new IntRef(0);
        LongRef startTime = new LongRef(System.currentTimeMillis());
        LongRef finishTime = new LongRef(System.currentTimeMillis());
        FileWriter fileWriter = Config$.MODULE$.exportIndexAsCsvPath().length() > 0 ? this.indexer().getCsvWriter(this.indexer().getCsvWriter$default$1()) : (csvFileWriter = null);
        FileWriter csvFileWriterSensitive = Config$.MODULE$.exportIndexAsCsvPathSensitive().length() > 0 ? this.indexer().getCsvWriter(true) : null;
        FileHelper$.MODULE$.file2helper(file).foreachLine((Function1<String, BoxedUnit>)new Serializable(counter, startTime, finishTime, csvFileWriter, csvFileWriterSensitive){
            public static final long serialVersionUID = 0L;
            private final IntRef counter$5;
            private final LongRef startTime$5;
            private final LongRef finishTime$5;
            private final FileWriter csvFileWriter$4;
            private final FileWriter csvFileWriterSensitive$4;

            public final void apply(String line) {
                boolean shouldCommit;
                String uuid = line.replaceAll("\"", "");
                ++this.counter$5.elem;
                Option<scala.collection.immutable.Map<String, String>> map = IndexRecords$.MODULE$.persistenceManager().getByIndex(uuid, "occ", "uuid");
                boolean bl = shouldCommit = this.counter$5.elem % 10000 == 0;
                if (!map.isEmpty()) {
                    String x$61 = uuid;
                    scala.collection.immutable.Map x$62 = (scala.collection.immutable.Map)map.get();
                    boolean x$63 = shouldCommit;
                    FileWriter x$64 = this.csvFileWriter$4;
                    FileWriter x$65 = this.csvFileWriterSensitive$4;
                    boolean x$66 = IndexRecords$.MODULE$.indexer().indexFromMap$default$3();
                    Option<Date> x$67 = IndexRecords$.MODULE$.indexer().indexFromMap$default$4();
                    Seq<String> x$68 = IndexRecords$.MODULE$.indexer().indexFromMap$default$6();
                    Seq<String> x$69 = IndexRecords$.MODULE$.indexer().indexFromMap$default$7();
                    boolean x$70 = IndexRecords$.MODULE$.indexer().indexFromMap$default$8();
                    String x$71 = IndexRecords$.MODULE$.indexer().indexFromMap$default$9();
                    IndexRecords$.MODULE$.indexer().indexFromMap(x$61, (Map<String, String>)x$62, x$66, x$67, x$63, x$68, x$69, x$70, x$71, x$64, x$65);
                }
                if (this.counter$5.elem % 1000 == 0) {
                    this.finishTime$5.elem = System.currentTimeMillis();
                    IndexRecords$.MODULE$.logger().info(new StringBuilder().append(this.counter$5.elem).append((Object)" >> Last key : ").append((Object)line).append((Object)", records per sec: ").append((Object)BoxesRunTime.boxToFloat((float)(1000.0f / ((float)(this.finishTime$5.elem - this.startTime$5.elem) / 1000.0f)))).toString());
                    this.startTime$5.elem = System.currentTimeMillis();
                }
            }
            {
                this.counter$5 = counter$5;
                this.startTime$5 = startTime$5;
                this.finishTime$5 = finishTime$5;
                this.csvFileWriter$4 = csvFileWriter$4;
                this.csvFileWriterSensitive$4 = csvFileWriterSensitive$4;
            }
        });
        if (csvFileWriter != null) {
            csvFileWriter.flush();
            csvFileWriter.close();
        }
        if (csvFileWriterSensitive != null) {
            csvFileWriterSensitive.flush();
            csvFileWriterSensitive.close();
        }
        this.logger().info("Finalising index.....");
        this.indexer().finaliseIndex(false, true);
        this.logger().info("Finalised index.");
    }

    private IndexRecords$() {
        MODULE$ = this;
        Tool$class.$init$(this);
        IncrementalTool$class.$init$(this);
        this.logger = LoggerFactory.getLogger((String)"IndexRecords");
        this.indexer = (IndexDAO)Config$.MODULE$.getInstance(IndexDAO.class);
        this.occurrenceDAO = (OccurrenceDAO)Config$.MODULE$.getInstance(OccurrenceDAO.class);
        this.persistenceManager = (PersistenceManager)Config$.MODULE$.getInstance(PersistenceManager.class);
    }
}

