/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.index;

import au.org.ala.biocache.Config$;
import au.org.ala.biocache.index.DefaultCounter;
import au.org.ala.biocache.index.IndexLocalRecordsV2$;
import au.org.ala.biocache.index.IndexMergeTool$;
import au.org.ala.biocache.index.IndexRunner;
import au.org.ala.biocache.index.IndexRunnerMap;
import au.org.ala.biocache.index.lucene.DocBuilder;
import au.org.ala.biocache.index.lucene.LuceneIndexing;
import java.io.File;
import java.io.FileWriter;
import org.apache.commons.io.FileUtils;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.IndexSchemaFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.StringBuilder;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.StringAdd$;

@ScalaSignature(bytes="\u0006\u0001\u00054A!\u0001\u0002\u0001\u001b\t\u0019\u0012J\u001c3fq2{7-\u00197SK\u000e|'\u000fZ:We)\u00111\u0001B\u0001\u0006S:$W\r\u001f\u0006\u0003\u000b\u0019\t\u0001BY5pG\u0006\u001c\u0007.\u001a\u0006\u0003\u000f!\t1!\u00197b\u0015\tI!\"A\u0002pe\u001eT\u0011aC\u0001\u0003CV\u001c\u0001a\u0005\u0002\u0001\u001dA\u0011qBE\u0007\u0002!)\t\u0011#A\u0003tG\u0006d\u0017-\u0003\u0002\u0014!\t1\u0011I\\=SK\u001aDQ!\u0006\u0001\u0005\u0002Y\ta\u0001P5oSRtD#A\f\u0011\u0005a\u0001Q\"\u0001\u0002\t\u000fi\u0001!\u0019!C\u00017\u00051An\\4hKJ,\u0012\u0001\b\t\u0003;\u0005j\u0011A\b\u0006\u0003?\u0001\nQa\u001d7gi)T\u0011!C\u0005\u0003Ey\u0011a\u0001T8hO\u0016\u0014\bB\u0002\u0013\u0001A\u0003%A$A\u0004m_\u001e<WM\u001d\u0011\t\u000b\u0019\u0002A\u0011A\u0014\u0002\u0019%tG-\u001a=SK\u000e|'\u000fZ:\u0015%!Z\u0003'O\u001eA\u0005\u00123\u0005J\u0013'O!J#f\u000b\u0017\t\u0003\u001f%J!A\u000b\t\u0003\tUs\u0017\u000e\u001e\u0005\u0006Y\u0015\u0002\r!L\u0001\u000b]VlG\u000b\u001b:fC\u0012\u001c\bCA\b/\u0013\ty\u0003CA\u0002J]RDQ!M\u0013A\u0002I\n\u0001b]8me\"{W.\u001a\t\u0003gYr!a\u0004\u001b\n\u0005U\u0002\u0012A\u0002)sK\u0012,g-\u0003\u00028q\t11\u000b\u001e:j]\u001eT!!\u000e\t\t\u000bi*\u0003\u0019\u0001\u001a\u0002#M|GN]\"p]\u001aLw\rW7m!\u0006$\b\u000eC\u0003=K\u0001\u0007Q(\u0001\u0005paRLW.[:f!\tya(\u0003\u0002@!\t9!i\\8mK\u0006t\u0007\"B!&\u0001\u0004i\u0014\u0001D8qi&l\u0017n]3P]2L\b\"B\"&\u0001\u0004\u0011\u0014AD2iK\u000e\\\u0007o\\5oi\u001aKG.\u001a\u0005\u0006\u000b\u0016\u0002\r!L\u0001\u0011i\"\u0014X-\u00193t!\u0016\u0014xK]5uKJDQaR\u0013A\u00025\n\u0011\u0003\u001e5sK\u0006$7\u000fU3s!J|7-Z:t\u0011\u0015IU\u00051\u0001.\u00031\u0011\u0018-\u001c)fe^\u0013\u0018\u000e^3s\u0011\u0015YU\u00051\u0001.\u0003E9(/\u001b;feN+w-\\3oiNK'0\u001a\u0005\u0006\u001b\u0016\u0002\r!L\u0001\u0014aJ|7-Z:t_J\u0014UO\u001a4feNK'0\u001a\u0005\u0006\u001f\u0016\u0002\r!L\u0001\u0011oJLG/\u001a:Ck\u001a4WM]*ju\u0016DQ!U\u0013A\u00025\n\u0001\u0002]1hKNK'0\u001a\u0005\u0006'\u0016\u0002\r!L\u0001\u000e[\u0016\u0014x-Z*fO6,g\u000e^:\t\u000bU+\u0003\u0019A\u001f\u0002\tQ,7\u000f\u001e\u0005\u0006/\u0016\u0002\r!L\u0001\foJLG/\u001a:D_VtG\u000fC\u0003ZK\u0001\u0007Q(A\u0004uKN$X*\u00199\t\u000bm\u0003A\u0011\u0001/\u0002\u0019\u0011|wO\u001c7pC\u00124\u0015\u000e\\3\u0015\u0007!jv\fC\u0003_5\u0002\u0007!'A\u0002ve2DQ\u0001\u0019.A\u0002I\naBZ5mKR{Gi\\<oY>\fG\r")
public class IndexLocalRecordsV2 {
    private final Logger logger = LoggerFactory.getLogger((String)"IndexLocalRecordsV2");

    public Logger logger() {
        return this.logger;
    }

    public void indexRecords(int numThreads, String solrHome, String solrConfigXmlPath, boolean optimise, boolean optimiseOnly, String checkpointFile, int threadsPerWriter, int threadsPerProcess, int ramPerWriter, int writerSegmentSize, int processorBufferSize, int writerBufferSize, int pageSize, int mergeSegments, boolean test, int writerCount, boolean testMap) {
        File s;
        BoxedUnit boxedUnit;
        long start = System.currentTimeMillis();
        System.setProperty("tokenRangeCheckPointFile", checkpointFile);
        boolean count = false;
        boolean singleWriter = writerCount == 0;
        ObjectRef luceneIndexing = new ObjectRef((Object)new ArrayBuffer());
        String confDir = new StringBuilder().append((Object)solrHome).append((Object)"/solr-create/biocache/conf").toString();
        File newIndexDir = new File(confDir);
        if (newIndexDir.exists()) {
            FileUtils.deleteDirectory((File)newIndexDir.getParentFile());
        }
        FileUtils.forceMkdir((File)newIndexDir);
        File sourceConfDir = new File(solrConfigXmlPath).getParentFile();
        if (!sourceConfDir.exists()) {
            FileUtils.forceMkdir((File)sourceConfDir);
            if (Config$.MODULE$.solrHome().startsWith("http")) {
                Predef$.MODULE$.refArrayOps((Object[])new String[]{"schema.xml", "additionalFields.list", "elevate.xml", "protwords.txt", "solrconfig.xml", "stopwords.txt", "synonyms.txt"}).foreach((Function1)new Serializable(this, sourceConfDir){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ IndexLocalRecordsV2 $outer;
                    private final File sourceConfDir$1;

                    public final void apply(String fileName) {
                        this.$outer.downloadFile(new StringBuilder().append((Object)Config$.MODULE$.solrHome()).append((Object)"/admin/file?file=").append((Object)fileName).toString(), new StringBuilder().append((Object)this.sourceConfDir$1.getAbsolutePath()).append((Object)File.separator).append((Object)fileName).toString());
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.sourceConfDir$1 = sourceConfDir$1;
                    }
                });
            }
        }
        FileUtils.copyDirectory((File)sourceConfDir, (File)newIndexDir);
        File s1 = new File(new StringBuilder().append((Object)confDir).append((Object)"/schema.xml").toString());
        File s2 = new File(new StringBuilder().append((Object)confDir).append((Object)"/schema.xml.bak").toString());
        File s3 = new File(new StringBuilder().append((Object)confDir).append((Object)"/schema-managed").toString());
        Object object = s3.exists() ? BoxesRunTime.boxToBoolean((boolean)s3.delete()) : BoxedUnit.UNIT;
        File schemaFile = s1.exists() ? s1 : s2;
        IndexSchema schema = IndexSchemaFactory.buildIndexSchema((String)schemaFile.getName(), (SolrConfig)SolrConfig.readFromResourceLoader((SolrResourceLoader)new SolrResourceLoader(new File(new StringBuilder().append((Object)solrHome).append((Object)"/solr-create/biocache").toString()).toPath()), (String)"solrconfig.xml"));
        FileUtils.writeStringToFile((File)new File(new StringBuilder().append((Object)solrHome).append((Object)"/solr-create/solr.xml").toString()), (String)"<?xml version=\"1.0\" encoding=\"UTF-8\" ?><solr></solr>", (String)"UTF-8");
        FileUtils.writeStringToFile((File)new File(new StringBuilder().append((Object)solrHome).append((Object)"/solr-create/zoo.cfg").toString()), (String)"", (String)"UTF-8");
        if (singleWriter) {
            String outputDir = new StringBuilder().append((Object)newIndexDir.getParent()).append((Object)"/data0-").toString();
            this.logger().info(new StringBuilder().append((Object)"Writing index to ").append((Object)outputDir).toString());
            boxedUnit = ((ArrayBuffer)luceneIndexing.elem).$plus$eq((Object)new LuceneIndexing(schema, Predef$.MODULE$.long2Long((long)writerSegmentSize), outputDir, Predef$.MODULE$.int2Integer(ramPerWriter), Predef$.MODULE$.int2Integer(writerBufferSize), Predef$.MODULE$.int2Integer(writerBufferSize / 2), Predef$.MODULE$.int2Integer(threadsPerWriter)));
        } else {
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), writerCount).foreach((Function1)new Serializable(this, threadsPerWriter, ramPerWriter, writerSegmentSize, writerBufferSize, luceneIndexing, newIndexDir, schema){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ IndexLocalRecordsV2 $outer;
                private final int threadsPerWriter$1;
                private final int ramPerWriter$1;
                private final int writerSegmentSize$1;
                private final int writerBufferSize$1;
                private final ObjectRef luceneIndexing$1;
                private final File newIndexDir$1;
                private final IndexSchema schema$1;

                public final ArrayBuffer<LuceneIndexing> apply(int i) {
                    String outputDir = new StringBuilder().append((Object)this.newIndexDir$1.getParent()).append((Object)"/data").append((Object)BoxesRunTime.boxToInteger((int)i)).append((Object)"-").toString();
                    this.$outer.logger().info(new StringBuilder().append((Object)"Writing index to ").append((Object)outputDir).toString());
                    return ((ArrayBuffer)this.luceneIndexing$1.elem).$plus$eq((Object)new LuceneIndexing(this.schema$1, Predef$.MODULE$.long2Long((long)this.writerSegmentSize$1), outputDir, Predef$.MODULE$.int2Integer(this.ramPerWriter$1), Predef$.MODULE$.int2Integer(this.writerBufferSize$1), Predef$.MODULE$.int2Integer(this.writerBufferSize$1 / (this.threadsPerWriter$1 + 2)), Predef$.MODULE$.int2Integer(this.threadsPerWriter$1)));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.threadsPerWriter$1 = threadsPerWriter$1;
                    this.ramPerWriter$1 = ramPerWriter$1;
                    this.writerSegmentSize$1 = writerSegmentSize$1;
                    this.writerBufferSize$1 = writerBufferSize$1;
                    this.luceneIndexing$1 = luceneIndexing$1;
                    this.newIndexDir$1 = newIndexDir$1;
                    this.schema$1 = schema$1;
                }
            });
            boxedUnit = BoxedUnit.UNIT;
        }
        if (test) {
            DocBuilder.setIsIndexing(Predef$.MODULE$.boolean2Boolean(false));
        }
        DefaultCounter counter = new DefaultCounter();
        if (testMap) {
            new IndexRunnerMap(counter, confDir, pageSize, (ArrayBuffer<LuceneIndexing>)((ArrayBuffer)luceneIndexing.elem), Predef$.MODULE$.int2Integer(threadsPerProcess), Predef$.MODULE$.int2Integer(processorBufferSize), singleWriter, test, numThreads).run();
        } else {
            new IndexRunner(counter, confDir, pageSize, (ArrayBuffer<LuceneIndexing>)((ArrayBuffer)luceneIndexing.elem), Predef$.MODULE$.int2Integer(threadsPerProcess), Predef$.MODULE$.int2Integer(processorBufferSize), singleWriter, test, numThreads).run();
        }
        long end = System.currentTimeMillis();
        this.logger().info(new StringBuilder().append((Object)"Indexing completed. Total indexed : ").append((Object)BoxesRunTime.boxToInteger((int)counter.counter())).append((Object)" in ").append((Object)BoxesRunTime.boxToFloat((float)((float)(end - start) / 1000.0f / 60.0f))).append((Object)" minutes").toString());
        ArrayBuffer dirs = new ArrayBuffer();
        if (singleWriter) {
            ((LuceneIndexing)((ArrayBuffer)luceneIndexing.elem).apply(0)).close(true, false);
        }
        ((ArrayBuffer)luceneIndexing.elem).indices().foreach$mVc$sp((Function1)new Serializable(this, luceneIndexing, dirs){
            public static final long serialVersionUID = 0L;
            public final ObjectRef luceneIndexing$1;
            public final ArrayBuffer dirs$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), ((LuceneIndexing)((ArrayBuffer)this.luceneIndexing$1.elem).apply(i)).getOutputDirectories().size()).foreach((Function1)new Serializable(this, i){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$indexRecords$1 $outer;
                    private final int i$1;

                    public final ArrayBuffer<String> apply(int j) {
                        return this.$outer.dirs$1.$plus$eq((Object)((LuceneIndexing)((ArrayBuffer)this.$outer.luceneIndexing$1.elem).apply(this.i$1)).getOutputDirectories().get(j).getPath());
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.i$1 = i$1;
                    }
                });
            }
            {
                this.luceneIndexing$1 = luceneIndexing$1;
                this.dirs$1 = dirs$1;
            }
        });
        luceneIndexing.elem = null;
        System.gc();
        int mem = (int)Math.max((double)Runtime.getRuntime().freeMemory() * 0.75 / (double)1024 / (double)1024, (double)(writerCount * ramPerWriter));
        File file = s = s1.exists() ? s1 : s2;
        if (DocBuilder.getAdditionalSchemaEntries().size() > 0) {
            this.logger().info(new StringBuilder().append((Object)"Writing ").append((Object)BoxesRunTime.boxToInteger((int)DocBuilder.getAdditionalSchemaEntries().size())).append((Object)" new fields into updated schema: ").append((Object)s1.getPath()).toString());
            String schemaString = FileUtils.readFileToString((File)s);
            StringBuilder sb = new StringBuilder();
            ((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(DocBuilder.getAdditionalSchemaEntries()).asScala()).withFilter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(String check$ifrefutable$1) {
                    String string = check$ifrefutable$1;
                    boolean bl = string != null;
                    return bl;
                }
            }).foreach((Function1)new Serializable(this, sb){
                public static final long serialVersionUID = 0L;
                private final StringBuilder sb$1;

                public final Object apply(String i) {
                    BoxedUnit boxedUnit;
                    if (i.contains("name=\"\"") || i.contains("name=\"_\")")) {
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        this.sb$1.append(i);
                        boxedUnit = this.sb$1.append('\n');
                    }
                    return boxedUnit;
                }
                {
                    this.sb$1 = sb$1;
                }
            });
            FileUtils.writeStringToFile((File)new File(StringAdd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)sourceConfDir), "/additionalFields.list")), (String)sb.toString());
        } else {
            FileUtils.writeStringToFile((File)new File(StringAdd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)sourceConfDir), "/additionalFields.list")), (String)"");
        }
        if (mergeSegments > 0) {
            int segmentCount = mergeSegments;
            int segmentSize = dirs.length() / segmentCount + 1;
            this.logger().info(new StringBuilder().append((Object)"Merging index into ").append((Object)BoxesRunTime.boxToInteger((int)segmentCount)).append((Object)" segments. source dirs=").append((Object)BoxesRunTime.boxToInteger((int)dirs.length())).append((Object)", segment size=").append((Object)BoxesRunTime.boxToInteger((int)segmentSize)).append((Object)", mem=").append((Object)BoxesRunTime.boxToInteger((int)mem)).append((Object)"mb").toString());
            ArrayBuffer dirsRemaining = dirs;
            int segmentNumber = 0;
            while (dirsRemaining.nonEmpty()) {
                Tuple2 tuple2 = dirsRemaining.splitAt(Math.min(segmentSize, dirsRemaining.length()));
                if (tuple2 != null) {
                    ArrayBuffer remainder;
                    Tuple2 tuple22;
                    ArrayBuffer dirsSegment = (ArrayBuffer)tuple2._1();
                    ArrayBuffer remainder2 = (ArrayBuffer)tuple2._2();
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)dirsSegment, (Object)remainder2);
                    ArrayBuffer dirsSegment2 = (ArrayBuffer)tuple23._1();
                    dirsRemaining = remainder = (ArrayBuffer)tuple23._2();
                    this.logger().info(new StringBuilder().append((Object)"merged_").append((Object)BoxesRunTime.boxToInteger((int)segmentNumber)).append((Object)", ").append((Object)dirsSegment2).toString());
                    IndexMergeTool$.MODULE$.merge(new StringBuilder().append((Object)solrHome).append((Object)"merged_").append((Object)BoxesRunTime.boxToInteger((int)segmentNumber)).toString(), (String[])dirsSegment2.toArray(ClassTag$.MODULE$.apply(String.class)), optimise, dirsSegment2.length(), false, mem);
                    new File(new StringBuilder().append((Object)solrHome).append((Object)"merged_").append((Object)BoxesRunTime.boxToInteger((int)segmentNumber)).append((Object)"/conf").toString()).mkdirs();
                    FileUtils.copyFile((File)s, (File)new File(new StringBuilder().append((Object)solrHome).append((Object)"merged_").append((Object)BoxesRunTime.boxToInteger((int)segmentNumber)).append((Object)"/conf/schema.xml").toString()));
                    ++segmentNumber;
                    continue;
                }
                throw new MatchError((Object)tuple2);
            }
        }
        this.logger().info("Complete");
        new File(checkpointFile).renameTo(new File(new StringBuilder().append((Object)checkpointFile).append((Object)".complete").toString()));
    }

    public void downloadFile(String url, String fileToDownload) {
        BufferedSource src = Source$.MODULE$.fromURL(url, Codec$.MODULE$.fallbackSystemCodec());
        FileWriter out = new FileWriter(fileToDownload);
        out.write(src.mkString());
        out.close();
    }
}

