/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.caches;

import au.org.ala.biocache.Config$;
import au.org.ala.biocache.model.Location;
import java.io.FileWriter;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections.map.LRUMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Try$;

public final class LocationDAO$ {
    public static final LocationDAO$ MODULE$;
    private final Logger logger;
    private final String columnFamily;
    private final Object lock;
    private final LRUMap lru;
    private final ConcurrentHashMap.KeySetView<String, Boolean> storedPointCache;
    private final String latitudeCol;
    private final String longitudeCol;
    private FileWriter persistPointsFile;

    static {
        new LocationDAO$();
    }

    public Logger logger() {
        return this.logger;
    }

    private String columnFamily() {
        return this.columnFamily;
    }

    private Object lock() {
        return this.lock;
    }

    private LRUMap lru() {
        return this.lru;
    }

    private ConcurrentHashMap.KeySetView<String, Boolean> storedPointCache() {
        return this.storedPointCache;
    }

    private final String latitudeCol() {
        return "lat";
    }

    private final String longitudeCol() {
        return "lon";
    }

    public FileWriter persistPointsFile() {
        return this.persistPointsFile;
    }

    public void persistPointsFile_$eq(FileWriter x$1) {
        this.persistPointsFile = x$1;
    }

    public Tuple2<String, scala.collection.immutable.Map<String, String>> addLayerIntersects(String latitude, String longitude, String contextual, String environmental, boolean batch) {
        Tuple2 tuple2;
        if (latitude != null && latitude.trim().length() > 0 && longitude != null && longitude.trim().length() > 0) {
            String guid = this.getLatLongKey(latitude, longitude);
            if (guid.length() > 0) {
                HashMap mapBuffer = new HashMap();
                mapBuffer.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"lat"), (Object)latitude));
                mapBuffer.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"lon"), (Object)longitude));
                mapBuffer.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"cl"), (Object)contextual));
                mapBuffer.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"el"), (Object)environmental));
                if (batch) {
                    tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)guid), (Object)mapBuffer.toMap(Predef$.MODULE$.conforms()));
                } else {
                    Config$.MODULE$.persistenceManager().put(guid, this.columnFamily(), (scala.collection.immutable.Map<String, String>)mapBuffer.toMap(Predef$.MODULE$.conforms()), true, false);
                    tuple2 = null;
                }
            } else {
                tuple2 = null;
            }
        } else {
            tuple2 = null;
        }
        return tuple2;
    }

    public boolean addLayerIntersects$default$5() {
        return false;
    }

    public void writeLocBatch(Map<String, scala.collection.immutable.Map<String, String>> batch) {
        boolean retries = false;
        boolean processedOK = false;
        while (!processedOK) {
            Config$.MODULE$.persistenceManager().putBatch(this.columnFamily(), (scala.collection.immutable.Map<String, scala.collection.immutable.Map<String, String>>)batch.toMap(Predef$.MODULE$.conforms()), true, false);
            processedOK = true;
        }
        return;
    }

    public String getLatLongKey(String latitude, String longitude) {
        return (String)Try$.MODULE$.apply((Function0)new Serializable(latitude, longitude){
            public static final long serialVersionUID = 0L;
            private final String latitude$1;
            private final String longitude$1;

            public final String apply() {
                return new StringBuilder().append((Object)((Object)BoxesRunTime.boxToFloat((float)new StringOps(Predef$.MODULE$.augmentString(this.latitude$1)).toFloat())).toString().trim()).append((Object)"|").append((Object)((Object)BoxesRunTime.boxToFloat((float)new StringOps(Predef$.MODULE$.augmentString(this.longitude$1)).toFloat())).toString()).toString();
            }
            {
                this.latitude$1 = latitude$1;
                this.longitude$1 = longitude$1;
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        });
    }

    private String getLatLongKey(float latitude, float longitude) {
        return new StringBuilder().append((Object)((Object)BoxesRunTime.boxToFloat((float)latitude)).toString().trim()).append((Object)"|").append((Object)((Object)BoxesRunTime.boxToFloat((float)longitude)).toString()).toString();
    }

    private String getLatLongKey(double latitude, double longitude) {
        return new StringBuilder().append((Object)((Object)BoxesRunTime.boxToDouble((double)latitude)).toString().trim()).append((Object)"|").append((Object)((Object)BoxesRunTime.boxToDouble((double)longitude)).toString()).toString();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String storePointForSampling(String latitude, String longitude) {
        void var3_3;
        Object object;
        String uuid = this.getLatLongKey(latitude, longitude);
        if (this.storedPointCache().contains(uuid)) {
            return uuid;
        }
        if (uuid.length() <= 0) {
            object = BoxedUnit.UNIT;
            return var3_3;
        }
        scala.collection.immutable.Map map = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"lat"), (Object)latitude), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"lon"), (Object)longitude)}));
        String string = Config$.MODULE$.persistPointsFile();
        String string2 = "";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            Config$.MODULE$.persistenceManager().put(uuid, this.columnFamily(), (scala.collection.immutable.Map<String, String>)map, true, false);
            object = BoxesRunTime.boxToBoolean((boolean)this.storedPointCache().add(uuid));
            return var3_3;
        }
        LocationDAO$ locationDAO$ = this;
        synchronized (locationDAO$) {
            if (this.persistPointsFile() == null) {
                this.persistPointsFile_$eq(new FileWriter(Config$.MODULE$.persistPointsFile()));
            }
            this.persistPointsFile().write(new StringBuilder().append((Object)longitude).append((Object)",").append((Object)latitude).append((Object)"\n").toString());
            this.persistPointsFile().flush();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl23 : MonitorExitStatement: MONITOREXIT : locationDAO$
            object = boxedUnit;
            return var3_3;
        }
    }

    public void closePointsFile() {
        if (this.persistPointsFile() != null) {
            this.persistPointsFile().flush();
            this.persistPointsFile().close();
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Option<Tuple3<Location, String, String>> getSamplesForLatLon(String latitude, String longitude) {
        None$ none$;
        if (latitude == null || longitude == null || latitude.trim().length() == 0 || longitude.trim().length() == 0) {
            return None$.MODULE$;
        }
        String uuid = this.getLatLongKey(latitude, longitude);
        if (uuid.length() > 0) {
            Object cachedObject;
            block11: {
                None$ none$2;
                Object object = this.lock();
                synchronized (object) {
                    Object object2 = this.lru().get((Object)uuid);
                    // MONITOREXIT @DISABLED, blocks:[0, 2, 10] lbl9 : MonitorExitStatement: MONITOREXIT : var5_4
                    cachedObject = object2;
                    if (cachedObject != null) break block11;
                }
                Option<scala.collection.immutable.Map<String, String>> map = Config$.MODULE$.persistenceManager().get(uuid, this.columnFamily());
                Option<scala.collection.immutable.Map<String, String>> option = map;
                if (option instanceof Some) {
                    Some some = (Some)option;
                    scala.collection.immutable.Map map2 = (scala.collection.immutable.Map)some.x();
                    Location location = new Location();
                    location.decimalLatitude_$eq(latitude);
                    location.decimalLongitude_$eq(longitude);
                    String el = (String)map2.getOrElse((Object)"el", (Function0)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "";
                        }
                    });
                    String cl = (String)map2.getOrElse((Object)"cl", (Function0)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "";
                        }
                    });
                    Some returnValue = new Some((Object)new Tuple3((Object)location, (Object)el, (Object)cl));
                    Object object3 = this.lock();
                    synchronized (object3) {
                        this.lru().put((Object)uuid, (Object)returnValue);
                        // MONITOREXIT @DISABLED, blocks:[1, 3, 8, 10] lbl28 : MonitorExitStatement: MONITOREXIT : var16_15
                        none$2 = returnValue;
                    }
                } else {
                    None$ none$3 = None$.MODULE$;
                    Option<scala.collection.immutable.Map<String, String>> option2 = option;
                    if (none$3 != null ? !none$3.equals(option2) : option2 != null) throw new MatchError(option);
                    if (!Predef$.MODULE$.refArrayOps((Object[])Config$.MODULE$.fieldsToSample(false)).isEmpty()) {
                        this.logger().warn(new StringBuilder().append((Object)"Location lookup failed for [").append((Object)latitude).append((Object)",").append((Object)longitude).append((Object)"] - Sampling may need to be re-ran").toString());
                    }
                    none$2 = None$.MODULE$;
                }
                none$ = none$2;
                return none$;
            }
            none$ = (Option)cachedObject;
            return none$;
        }
        none$ = None$.MODULE$;
        return none$;
        {
            catch (Throwable throwable) {
                throw throwable;
            }
        }
        {
            catch (Throwable throwable) {
                throw throwable;
            }
        }
    }

    private LocationDAO$() {
        MODULE$ = this;
        this.logger = LoggerFactory.getLogger((String)"LocationDAO");
        this.columnFamily = "loc";
        this.lock = new Object();
        this.lru = new LRUMap(10000);
        this.storedPointCache = ConcurrentHashMap.newKeySet();
        this.persistPointsFile = null;
    }
}

