/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.caches;

import au.org.ala.biocache.Config$;
import au.org.ala.biocache.model.Classification;
import au.org.ala.names.model.LinnaeanRankClassification;
import au.org.ala.names.model.MetricsResultDTO;
import au.org.ala.names.model.NameSearchResult;
import au.org.ala.names.model.RankType;
import au.org.ala.names.search.ALANameSearcher;
import org.apache.commons.collections.map.LRUMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;

public final class ClassificationDAO$ {
    public static final ClassificationDAO$ MODULE$;
    private final Logger logger;
    private final LRUMap lru;
    private final Object lock;
    private final ALANameSearcher nameIndex;
    private final int RECURSIVE_LOOP_LIMIT;

    static {
        new ClassificationDAO$();
    }

    public Logger logger() {
        return this.logger;
    }

    private LRUMap lru() {
        return this.lru;
    }

    private Object lock() {
        return this.lock;
    }

    private ALANameSearcher nameIndex() {
        return this.nameIndex;
    }

    private int RECURSIVE_LOOP_LIMIT() {
        return this.RECURSIVE_LOOP_LIMIT;
    }

    /*
     * WARNING - void declaration
     */
    private String stripStrayQuotes(String str) {
        String string;
        if (str == null) {
            string = null;
        } else {
            void var2_2;
            String normalised = str;
            if (normalised.startsWith("'") || normalised.startsWith("\"")) {
                normalised = (String)new StringOps(Predef$.MODULE$.augmentString(normalised)).drop(1);
            }
            if (normalised.endsWith("'") || normalised.endsWith("\"")) {
                normalised = (String)new StringOps(Predef$.MODULE$.augmentString(normalised)).dropRight(1);
            }
            string = var2_2;
        }
        return string;
    }

    /*
     * Loose catch block
     */
    public Option<MetricsResultDTO> get(Classification cl, int count) {
        Option option;
        block34: {
            NameSearchResult cnsr;
            MetricsResultDTO resultMetric;
            Object cachedObject;
            String hash;
            block30: {
                MetricsResultDTO metricsResultDTO;
                NameSearchResult nameSearchResult;
                block33: {
                    block31: {
                        block32: {
                            String string = hash = cl.vernacularName() != null && cl.scientificName() == null && cl.specificEpithet() == null && cl.infraspecificEpithet() == null && cl.kingdom() == null && cl.phylum() == null && cl.classs() == null && cl.order() == null && cl.family() == null && cl.genus() == null && cl.taxonConceptID() == null && cl.taxonID() == null ? cl.vernacularName() : (String)Predef$.MODULE$.refArrayOps((Object[])new String[]{cl.kingdom(), cl.phylum(), cl.classs(), cl.order(), cl.family(), cl.genus(), cl.species(), cl.specificEpithet(), cl.subspecies(), cl.infraspecificEpithet(), cl.scientificName(), cl.taxonRank(), cl.taxonConceptID(), cl.taxonID()}).reduceLeft((Function2)new Serializable(){
                                public static final long serialVersionUID = 0L;

                                public final String apply(String x$1, String x$2) {
                                    return new StringBuilder().append((Object)x$1).append((Object)"|").append((Object)x$2).toString();
                                }
                            });
                            if (cl.scientificName() == null) {
                                cl.scientificName_$eq((String)(cl.subspecies() == null ? (cl.genus() == null || cl.specificEpithet() == null || cl.infraspecificEpithet() == null ? (cl.genus() == null || cl.specificEpithet() == null ? (cl.species() == null ? (cl.genus() == null ? (cl.family() == null ? (cl.classs() == null ? (cl.order() == null ? (cl.phylum() == null ? (cl.kingdom() == null ? null : cl.kingdom()) : cl.phylum()) : cl.order()) : cl.classs()) : cl.family()) : cl.genus()) : cl.species()) : new StringBuilder().append((Object)cl.genus()).append((Object)" ").append((Object)cl.specificEpithet()).toString()) : new StringBuilder().append((Object)cl.genus()).append((Object)" ").append((Object)cl.specificEpithet()).append((Object)" ").append((Object)cl.infraspecificEpithet()).toString()) : cl.subspecies()));
                            }
                            Object object = this.lock();
                            synchronized (object) {
                                Object object2 = this.lru().get((Object)hash);
                                // MONITOREXIT @DISABLED, blocks:[0, 4] lbl8 : MonitorExitStatement: MONITOREXIT : var5_4
                                cachedObject = object2;
                                if (cachedObject != null) break block30;
                                if (cl.taxonConceptID() != null) break block31;
                                if (cl.taxonID() != null) break block32;
                            }
                            nameSearchResult = null;
                            break block33;
                        }
                        nameSearchResult = this.nameIndex().searchForRecordByLsid(cl.taxonID());
                        break block33;
                    }
                    nameSearchResult = this.nameIndex().searchForRecordByLsid(cl.taxonConceptID());
                }
                NameSearchResult idnsr = nameSearchResult;
                try {
                    if (idnsr == null) {
                        if (hash.contains("|")) {
                            LinnaeanRankClassification lrcl = new LinnaeanRankClassification(this.stripStrayQuotes(cl.kingdom()), this.stripStrayQuotes(cl.phylum()), this.stripStrayQuotes(cl.classs()), this.stripStrayQuotes(cl.order()), this.stripStrayQuotes(cl.family()), this.stripStrayQuotes(cl.genus()), this.stripStrayQuotes(cl.species()), this.stripStrayQuotes(cl.specificEpithet()), this.stripStrayQuotes(cl.subspecies()), this.stripStrayQuotes(cl.infraspecificEpithet()), this.stripStrayQuotes(cl.scientificName()));
                            lrcl.setRank(cl.taxonRank());
                            metricsResultDTO = this.nameIndex().searchForRecordMetrics(lrcl, true, true);
                        } else {
                            metricsResultDTO = null;
                        }
                    } else {
                        MetricsResultDTO metric = new MetricsResultDTO();
                        metric.setResult(idnsr);
                        metricsResultDTO = metric;
                    }
                }
                catch (Exception exception) {
                    this.logger().debug(new StringBuilder().append((Object)exception.getMessage()).append((Object)", hash =  ").append((Object)hash).toString(), (Throwable)exception);
                    metricsResultDTO = resultMetric = null;
                }
            }
            option = (Option)cachedObject;
            break block34;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            if (resultMetric == null && (cnsr = this.nameIndex().searchForCommonName(cl.getVernacularName())) != null) {
                resultMetric = new MetricsResultDTO();
                resultMetric.setResult(cnsr);
            }
            if (resultMetric == null || resultMetric.getResult() == null) {
                None$ result2 = resultMetric == null ? None$.MODULE$ : new Some((Object)resultMetric);
                Object object = this.lock();
                synchronized (object) {
                    this.lru().put((Object)hash, (Object)result2);
                    // MONITOREXIT @DISABLED, blocks:[2, 5, 29] lbl52 : MonitorExitStatement: MONITOREXIT : var19_14
                    option = result2;
                }
            } else {
                Option<MetricsResultDTO> result;
                Option<MetricsResultDTO> option2;
                if (resultMetric.getResult().isSynonym()) {
                    NameSearchResult ansr = this.nameIndex().searchForRecordByLsid(resultMetric.getResult().getAcceptedLsid());
                    if (ansr == null) {
                        option2 = None$.MODULE$;
                    } else {
                        ansr.setMatchType(resultMetric.getResult().getMatchType());
                        resultMetric.setResult(ansr);
                        option2 = new Some((Object)resultMetric);
                    }
                } else {
                    option2 = result = new Option<MetricsResultDTO>((Object)resultMetric);
                }
                if (result.isDefined()) {
                    RankType rank = ((MetricsResultDTO)result.get()).getResult().getRank();
                    if (rank != null && Predef$.MODULE$.Integer2int(rank.getId()) > 7000 && Predef$.MODULE$.Integer2int(rank.getId()) < 9999) {
                        ((MetricsResultDTO)result.get()).getResult().getRankClassification().setSubspecies(((MetricsResultDTO)result.get()).getResult().getRankClassification().getScientificName());
                    }
                } else {
                    this.logger().debug(new StringBuilder().append((Object)"Unable to locate accepted concept for synonym ").append((Object)resultMetric.getResult()).append((Object)". Attempting a higher level match").toString());
                    if (cl.kingdom() == null && cl.phylum() == null && cl.classs() == null && cl.order() == null && cl.family() == null && cl.genus() == null || cl.getScientificName() == null && cl.getSpecies() == null && cl.getSpecificEpithet() == null && cl.getInfraspecificEpithet() == null) {
                        this.logger().warn(new StringBuilder().append((Object)"Recursively unable to locate a synonym for ").append((Object)cl.scientificName()).toString());
                    } else {
                        Classification newcl = cl.clone();
                        newcl.setScientificName(null);
                        newcl.setInfraspecificEpithet(null);
                        newcl.setSpecificEpithet(null);
                        newcl.setSpecies(null);
                        this.updateClassificationRemovingMissingSynonym(newcl, resultMetric.getResult());
                        if (count < this.RECURSIVE_LOOP_LIMIT()) {
                            result = this.get(newcl, count + 1);
                        } else {
                            this.logger().warn(new StringBuilder().append((Object)"Potential recursive issue with ").append((Object)cl.getKingdom()).append((Object)" ").append((Object)cl.getPhylum()).append((Object)" ").append((Object)cl.getClasss()).append((Object)" ").append((Object)cl.getOrder()).append((Object)" ").append((Object)cl.getFamily()).toString());
                        }
                    }
                }
                Object object = this.lock();
                synchronized (object) {
                    this.lru().put((Object)hash, (Object)result);
                    // MONITOREXIT @DISABLED, blocks:[3, 6, 28] lbl94 : MonitorExitStatement: MONITOREXIT : var17_19
                    option = result;
                }
            }
        }
        return option;
        {
            catch (Throwable throwable) {
                throw throwable;
            }
        }
        {
            catch (Throwable throwable) {
                throw throwable;
            }
        }
    }

    public int get$default$2() {
        return 0;
    }

    private void updateClassificationRemovingMissingSynonym(Classification newcl, NameSearchResult result) {
        String sciName = result.getRankClassification().getScientificName();
        String string = newcl.genus();
        String string2 = sciName;
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            newcl.genus_$eq(null);
        }
        String string3 = newcl.family();
        String string4 = sciName;
        if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
            newcl.family_$eq(null);
        }
        String string5 = newcl.order();
        String string6 = sciName;
        if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
            newcl.order_$eq(null);
        }
        String string7 = newcl.classs();
        String string8 = sciName;
        if (!(string7 != null ? !string7.equals(string8) : string8 != null)) {
            newcl.classs_$eq(null);
        }
        String string9 = newcl.phylum();
        String string10 = sciName;
        if (!(string9 != null ? !string9.equals(string10) : string10 != null)) {
            newcl.phylum_$eq(null);
        }
    }

    private ClassificationDAO$() {
        MODULE$ = this;
        this.logger = LoggerFactory.getLogger((String)"ClassificationDAO");
        this.lru = new LRUMap(Config$.MODULE$.classificationCacheSize());
        this.lock = new Object();
        this.nameIndex = Config$.MODULE$.nameIndex();
        this.RECURSIVE_LOOP_LIMIT = 4;
    }
}

