/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.SelectItem;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class Select
extends Node {
    private final boolean distinct;
    private final List<SelectItem> selectItems;

    public Select(boolean distinct, List<SelectItem> selectItems) {
        this.distinct = distinct;
        this.selectItems = ImmutableList.copyOf((Collection)Objects.requireNonNull(selectItems, "selectItems"));
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public List<SelectItem> getSelectItems() {
        return this.selectItems;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitSelect(this, context);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("distinct", this.distinct).add("selectItems", this.selectItems).omitNullValues().toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Select select = (Select)o;
        if (this.distinct != select.distinct) {
            return false;
        }
        return this.selectItems.equals(select.selectItems);
    }

    @Override
    public int hashCode() {
        int result = this.distinct ? 1 : 0;
        result = 31 * result + this.selectItems.hashCode();
        return result;
    }
}

