/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.github.benmanes.caffeine.cache.LocalCache;
import com.github.benmanes.caffeine.cache.LocalManualCache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.logging.Level;
import java.util.logging.Logger;

interface LocalLoadingCache<C extends LocalCache<K, V>, K, V>
extends LocalManualCache<C, K, V>,
LoadingCache<K, V> {
    public static final Logger logger = Logger.getLogger(LocalLoadingCache.class.getName());

    public CacheLoader<? super K, V> cacheLoader();

    public boolean hasBulkLoader();

    default public boolean hasLoadAll(CacheLoader<? super K, V> loader) {
        try {
            return !loader.getClass().getMethod("loadAll", Iterable.class).isDefault();
        }
        catch (NoSuchMethodException | SecurityException e) {
            logger.log(Level.WARNING, "Cannot determine if CacheLoader can bulk load", e);
            return false;
        }
    }

    @Override
    default public V get(K key) {
        return (V)this.cache().computeIfAbsent(key, this.cacheLoader()::load);
    }

    @Override
    default public Map<K, V> getAll(Iterable<? extends K> keys) {
        return this.hasBulkLoader() ? this.loadInBulk(keys) : this.loadSequentially(keys);
    }

    default public Map<K, V> loadSequentially(Iterable<? extends K> keys) {
        int count = 0;
        HashMap<K, V> result = new HashMap<K, V>();
        Iterator<K> iter = keys.iterator();
        while (iter.hasNext()) {
            K key = iter.next();
            ++count;
            try {
                V value = this.get(key);
                if (value == null) continue;
                result.put(key, value);
            }
            catch (Throwable t) {
                int remaining;
                if (keys instanceof Collection) {
                    remaining = ((Collection)keys).size() - count;
                } else {
                    remaining = 0;
                    while (iter.hasNext()) {
                        ++remaining;
                        iter.next();
                    }
                }
                this.cache().statsCounter().recordMisses(remaining);
                throw t;
            }
        }
        return Collections.unmodifiableMap(result);
    }

    default public Map<K, V> loadInBulk(Iterable<? extends K> keys) {
        Map found = this.cache().getAllPresent(keys);
        ArrayList<K> keysToLoad = new ArrayList<K>();
        for (K key : keys) {
            if (found.containsKey(key)) continue;
            keysToLoad.add(key);
        }
        if (keysToLoad.isEmpty()) {
            return found;
        }
        HashMap result = new HashMap(found);
        this.bulkLoad(keysToLoad, result);
        return Collections.unmodifiableMap(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void bulkLoad(List<K> keysToLoad, Map<K, V> result) {
        boolean success = false;
        long startTime = this.cache().ticker().read();
        try {
            Map<K, V> loaded = this.cacheLoader().loadAll(keysToLoad);
            this.cache().putAll(loaded);
            for (K key : keysToLoad) {
                V value = loaded.get(key);
                if (value == null) continue;
                result.put(key, value);
            }
            success = !loaded.isEmpty();
        }
        finally {
            long loadTime = this.cache().ticker().read() - startTime;
            if (success) {
                this.cache().statsCounter().recordLoadSuccess(loadTime);
            } else {
                this.cache().statsCounter().recordLoadFailure(loadTime);
            }
        }
    }

    @Override
    default public void refresh(K key) {
        Objects.requireNonNull(key);
        this.cache().executor().execute(() -> {
            try {
                BiFunction<Object, Object, Object> refreshFunction = (k, oldValue) -> oldValue == null ? this.cacheLoader().load(key) : this.cacheLoader().reload(key, oldValue);
                this.cache().compute(key, refreshFunction, false, false);
            }
            catch (Throwable t) {
                logger.log(Level.WARNING, "Exception thrown during refresh", t);
            }
        });
    }
}

