/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

@FunctionalInterface
public interface CacheLoader<K, V> {
    @CheckForNull
    public V load(@Nonnull K var1);

    @Nonnull
    default public Map<K, V> loadAll(@Nonnull Iterable<? extends K> keys) {
        throw new UnsupportedOperationException();
    }

    @CheckForNull
    default public CompletableFuture<V> asyncLoad(@Nonnull K key, @Nonnull Executor executor) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(executor);
        return CompletableFuture.supplyAsync(() -> this.load(key), executor);
    }

    @Nonnull
    default public CompletableFuture<Map<K, V>> asyncLoadAll(Iterable<? extends K> keys, @Nonnull Executor executor) {
        Objects.requireNonNull(keys);
        Objects.requireNonNull(executor);
        return CompletableFuture.supplyAsync(() -> this.loadAll(keys), executor);
    }

    @CheckForNull
    default public V reload(@Nonnull K key, @Nonnull V oldValue) {
        return this.load(key);
    }
}

