/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache;

import com.github.benmanes.caffeine.cache.AccessOrderDeque;
import com.github.benmanes.caffeine.cache.Async;
import com.github.benmanes.caffeine.cache.BoundedBuffer;
import com.github.benmanes.caffeine.cache.Buffer;
import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LinkedDeque;
import com.github.benmanes.caffeine.cache.LocalAsyncLoadingCache;
import com.github.benmanes.caffeine.cache.LocalCache;
import com.github.benmanes.caffeine.cache.LocalCacheFactory;
import com.github.benmanes.caffeine.cache.LocalLoadingCache;
import com.github.benmanes.caffeine.cache.LocalManualCache;
import com.github.benmanes.caffeine.cache.Node;
import com.github.benmanes.caffeine.cache.NodeFactory;
import com.github.benmanes.caffeine.cache.Policy;
import com.github.benmanes.caffeine.cache.References;
import com.github.benmanes.caffeine.cache.RemovalCause;
import com.github.benmanes.caffeine.cache.RemovalListener;
import com.github.benmanes.caffeine.cache.RemovalNotification;
import com.github.benmanes.caffeine.cache.SerializationProxy;
import com.github.benmanes.caffeine.cache.Ticker;
import com.github.benmanes.caffeine.cache.Weigher;
import com.github.benmanes.caffeine.cache.WriteOrderDeque;
import com.github.benmanes.caffeine.cache.WriteThroughEntry;
import com.github.benmanes.caffeine.cache.stats.DisabledStatsCounter;
import com.github.benmanes.caffeine.cache.stats.StatsCounter;
import com.github.benmanes.caffeine.cache.tracing.Tracer;
import com.github.benmanes.caffeine.locks.NonReentrantLock;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
abstract class BoundedLocalCache<K, V>
extends AbstractMap<K, V>
implements LocalCache<K, V> {
    static final long MAXIMUM_CAPACITY = 9223372034707292160L;
    static final int WRITE_BUFFER_DRAIN_THRESHOLD = 16;
    static final Logger logger = Logger.getLogger(BoundedLocalCache.class.getName());
    final ConcurrentHashMap<Object, Node<K, V>> data;
    final NodeFactory nodeFactory;
    final long id;
    final AtomicReference<DrainStatus> drainStatus;
    final Buffer<Node<K, V>> readBuffer;
    final NonReentrantLock evictionLock;
    final Weigher<K, V> weigher;
    final boolean isAsync;
    transient Set<K> keySet;
    transient Collection<V> values;
    transient Set<Map.Entry<K, V>> entrySet;

    protected BoundedLocalCache(Caffeine<K, V> builder, @Nullable CacheLoader<? super K, V> loader, boolean isAsync) {
        this.isAsync = isAsync;
        this.weigher = builder.getWeigher(isAsync);
        this.evictionLock = new NonReentrantLock();
        this.id = this.tracer().register(builder.name());
        this.drainStatus = new AtomicReference<DrainStatus>(DrainStatus.IDLE);
        this.data = new ConcurrentHashMap(builder.getInitialCapacity());
        this.nodeFactory = NodeFactory.getFactory(builder.isStrongKeys(), builder.isWeakKeys(), builder.isStrongValues(), builder.isWeakValues(), builder.isSoftValues(), builder.expiresAfterAccess(), builder.expiresAfterWrite(), builder.refreshes(), builder.evicts(), isAsync && builder.evicts() || builder.isWeighted());
        this.readBuffer = this.evicts() || this.collectKeys() || this.collectValues() || this.expiresAfterAccess() ? new BoundedBuffer<Node<K, V>>() : Buffer.disabled();
    }

    final boolean isComputingAsync(Node<?, ?> node) {
        return this.isAsync && !Async.isReady((CompletableFuture)node.getValue());
    }

    @GuardedBy(value="evictionLock")
    protected AccessOrderDeque<Node<K, V>> accessOrderDeque() {
        throw new UnsupportedOperationException();
    }

    @GuardedBy(value="evictionLock")
    protected WriteOrderDeque<Node<K, V>> writeOrderDeque() {
        throw new UnsupportedOperationException();
    }

    protected ConcurrentLinkedQueue<Runnable> writeQueue() {
        throw new UnsupportedOperationException();
    }

    protected boolean buffersWrites() {
        return false;
    }

    protected CacheLoader<? super K, V> cacheLoader() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Executor executor() {
        return ForkJoinPool.commonPool();
    }

    @Override
    public Ticker ticker() {
        return Ticker.disabledTicker();
    }

    @Override
    public StatsCounter statsCounter() {
        return DisabledStatsCounter.INSTANCE;
    }

    @Override
    public boolean isRecordingStats() {
        return false;
    }

    @Override
    public RemovalListener<K, V> removalListener() {
        return null;
    }

    protected boolean hasRemovalListener() {
        return false;
    }

    void notifyRemoval(@Nullable K key, @Nullable V value, RemovalCause cause) {
        Caffeine.requireState(this.hasRemovalListener(), "Notification should be guarded with a check", new Object[0]);
        try {
            this.executor().execute(() -> {
                try {
                    this.removalListener().onRemoval(new RemovalNotification<Object, Object>(key, value, cause));
                }
                catch (Throwable t) {
                    logger.log(Level.WARNING, "Exception thrown by removal listener", t);
                }
            });
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "Exception thrown when submitting removal listener", t);
        }
    }

    protected boolean collectKeys() {
        return false;
    }

    protected boolean collectValues() {
        return false;
    }

    @Nullable
    protected ReferenceQueue<K> keyReferenceQueue() {
        return null;
    }

    @Nullable
    protected ReferenceQueue<V> valueReferenceQueue() {
        return null;
    }

    protected boolean expiresAfterAccess() {
        return false;
    }

    protected long expiresAfterAccessNanos() {
        throw new UnsupportedOperationException();
    }

    protected void setExpiresAfterAccessNanos(long expireAfterAccessNanos) {
        throw new UnsupportedOperationException();
    }

    protected boolean expiresAfterWrite() {
        return false;
    }

    protected long expiresAfterWriteNanos() {
        throw new UnsupportedOperationException();
    }

    protected void setExpiresAfterWriteNanos(long expireAfterWriteNanos) {
        throw new UnsupportedOperationException();
    }

    protected boolean refreshAfterWrite() {
        return false;
    }

    protected long refreshAfterWriteNanos() {
        throw new UnsupportedOperationException();
    }

    protected void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
        throw new UnsupportedOperationException();
    }

    protected boolean evicts() {
        return false;
    }

    protected long maximum() {
        throw new UnsupportedOperationException();
    }

    @GuardedBy(value="evictionLock")
    protected void lazySetMaximum(long maximum) {
        throw new UnsupportedOperationException();
    }

    void setMaximum(long maximum) {
        Caffeine.requireArgument(maximum >= 0L);
        this.evictionLock.lock();
        try {
            this.lazySetMaximum(Math.min(maximum, 9223372034707292160L));
            this.drainBuffers();
            this.evictEntries();
        }
        finally {
            this.evictionLock.unlock();
        }
    }

    long adjustedWeightedSize() {
        return Math.max(0L, this.weightedSize());
    }

    protected long weightedSize() {
        throw new UnsupportedOperationException();
    }

    @GuardedBy(value="evictionLock")
    protected void lazySetWeightedSize(long weightedSize) {
        throw new UnsupportedOperationException();
    }

    void lazySetDrainStatus(DrainStatus drainStatus) {
        this.drainStatus.lazySet(drainStatus);
    }

    void compareAndSetDrainStatus(DrainStatus expect, DrainStatus update) {
        this.drainStatus.compareAndSet(expect, update);
    }

    @GuardedBy(value="evictionLock")
    boolean hasOverflowed() {
        return this.weightedSize() > this.maximum();
    }

    @GuardedBy(value="evictionLock")
    void evictEntries() {
        if (!this.evicts()) {
            return;
        }
        AccessOrderDeque.AccessOrder node = (Node)this.accessOrderDeque().peek();
        while (this.hasOverflowed()) {
            if (node == null) {
                return;
            }
            AccessOrderDeque.AccessOrder next = node.getNextInAccessOrder();
            if (node.getWeight() != 0) {
                this.evictEntry((Node<K, V>)node, RemovalCause.SIZE);
            }
            node = next;
        }
    }

    @GuardedBy(value="evictionLock")
    void evictEntry(Node<K, V> node, RemovalCause cause) {
        boolean removed = this.data.remove(node.getKeyReference(), node);
        K key = node.getKey();
        this.makeDead(node);
        if (this.evicts() || this.expiresAfterAccess()) {
            this.accessOrderDeque().remove(node);
        }
        if (this.expiresAfterWrite()) {
            this.writeOrderDeque().remove(node);
        }
        if (removed) {
            this.statsCounter().recordEviction();
            if (this.hasRemovalListener()) {
                this.notifyRemoval(key, node.getValue(), cause);
            }
        }
    }

    @GuardedBy(value="evictionLock")
    void expire() {
        Node node;
        long expirationTime;
        long now = this.ticker().read();
        if (this.expiresAfterAccess()) {
            expirationTime = now - this.expiresAfterAccessNanos();
            while ((node = (Node)this.accessOrderDeque().peekFirst()) != null && node.getAccessTime() <= expirationTime) {
                this.accessOrderDeque().pollFirst();
                if (this.expiresAfterWrite()) {
                    this.writeOrderDeque().remove(node);
                }
                this.evictEntry(node, RemovalCause.EXPIRED);
            }
        }
        if (this.expiresAfterWrite()) {
            expirationTime = now - this.expiresAfterWriteNanos();
            while ((node = (Node)this.writeOrderDeque().peekFirst()) != null && node.getWriteTime() <= expirationTime) {
                this.writeOrderDeque().pollFirst();
                if (this.evicts() || this.expiresAfterAccess()) {
                    this.accessOrderDeque().remove(node);
                }
                this.evictEntry(node, RemovalCause.EXPIRED);
            }
        }
    }

    boolean hasExpired(Node<K, V> node, long now) {
        if (this.isComputingAsync(node)) {
            return false;
        }
        return this.expiresAfterAccess() && now - node.getAccessTime() >= this.expiresAfterAccessNanos() || this.expiresAfterWrite() && now - node.getWriteTime() >= this.expiresAfterWriteNanos();
    }

    void afterRead(Node<K, V> node, boolean recordHit) {
        if (recordHit) {
            this.statsCounter().recordHits(1);
        }
        long now = this.ticker().read();
        node.setAccessTime(now);
        boolean delayable = this.readBuffer.offer(node) != 1;
        this.drainOnReadIfNeeded(delayable);
        this.refreshIfNeeded(node, now);
    }

    void refreshIfNeeded(Node<K, V> node, long now) {
        if (!this.refreshAfterWrite()) {
            return;
        }
        long writeTime = node.getWriteTime();
        if (now - writeTime > this.refreshAfterWriteNanos() && node.casWriteTime(writeTime, now)) {
            this.executor().execute(() -> {
                Object key = node.getKey();
                if (key != null && node.isAlive()) {
                    try {
                        this.computeIfPresent(key, this.cacheLoader()::reload);
                    }
                    catch (Throwable t) {
                        logger.log(Level.WARNING, "Exception thrown during reload", t);
                    }
                }
            });
        }
    }

    void drainOnReadIfNeeded(boolean delayable) {
        DrainStatus status = this.drainStatus.get();
        if (status.shouldDrainBuffers(delayable)) {
            this.tryToDrainBuffers();
        }
    }

    void afterWrite(@Nullable Node<K, V> node, Runnable task) {
        if (node != null) {
            long now = this.ticker().read();
            node.setAccessTime(now);
            node.setWriteTime(now);
        }
        if (this.buffersWrites()) {
            this.writeQueue().add(task);
        }
        this.lazySetDrainStatus(DrainStatus.REQUIRED);
        this.tryToDrainBuffers();
    }

    void tryToDrainBuffers() {
        if (this.evictionLock.tryLock()) {
            try {
                this.lazySetDrainStatus(DrainStatus.PROCESSING);
                this.drainBuffers();
            }
            finally {
                this.compareAndSetDrainStatus(DrainStatus.PROCESSING, DrainStatus.IDLE);
                this.evictionLock.unlock();
            }
        }
    }

    @GuardedBy(value="evictionLock")
    void drainBuffers() {
        this.drainReadBuffer();
        this.drainWriteBuffer();
        this.expire();
        this.drainKeyReferences();
        this.drainValueReferences();
    }

    void drainKeyReferences() {
        Reference<K> keyRef;
        if (!this.collectKeys()) {
            return;
        }
        while ((keyRef = this.keyReferenceQueue().poll()) != null) {
            Node<K, V> node = this.data.get(keyRef);
            if (node == null) continue;
            this.evictEntry(node, RemovalCause.COLLECTED);
        }
    }

    void drainValueReferences() {
        Reference<V> valueRef;
        if (!this.collectValues()) {
            return;
        }
        while ((valueRef = this.valueReferenceQueue().poll()) != null) {
            References.InternalReference ref = (References.InternalReference)((Object)valueRef);
            Node<K, V> node = this.data.get(ref.getKeyReference());
            if (node == null) continue;
            this.evictEntry(node, RemovalCause.COLLECTED);
        }
    }

    @GuardedBy(value="evictionLock")
    void drainReadBuffer() {
        if (this.evicts() || this.expiresAfterAccess()) {
            this.readBuffer.drain(node -> BoundedLocalCache.reorder(this.accessOrderDeque(), node));
        } else {
            this.readBuffer.drain(e -> {});
        }
    }

    @GuardedBy(value="evictionLock")
    static <K, V> void reorder(LinkedDeque<Node<K, V>> deque, Node<K, V> node) {
        if (deque.contains(node)) {
            deque.moveToBack(node);
        }
    }

    @GuardedBy(value="evictionLock")
    void drainWriteBuffer() {
        Runnable task;
        if (!this.buffersWrites()) {
            return;
        }
        for (int i = 0; i < 16 && (task = this.writeQueue().poll()) != null; ++i) {
            task.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value="evictionLock")
    void makeDead(Node<K, V> node) {
        Node<K, V> node2 = node;
        synchronized (node2) {
            if (node.isDead()) {
                return;
            }
            if (this.evicts()) {
                this.lazySetWeightedSize(this.weightedSize() - (long)node.getWeight());
            }
            node.die();
        }
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public long estimatedSize() {
        return this.data.mappingCount();
    }

    @Override
    public void clear() {
        this.evictionLock.lock();
        try {
            Node node;
            Runnable task;
            while (this.buffersWrites() && (task = this.writeQueue().poll()) != null) {
                task.run();
            }
            if (this.evicts() || this.expiresAfterAccess()) {
                while ((node = (Node)this.accessOrderDeque().poll()) != null) {
                    this.removeNode(node);
                }
            }
            if (this.expiresAfterWrite()) {
                while ((node = (Node)this.writeOrderDeque().poll()) != null) {
                    this.removeNode(node);
                }
            }
            this.data.values().forEach(this::removeNode);
            this.readBuffer.drain(e -> {});
        }
        finally {
            this.evictionLock.unlock();
        }
    }

    @GuardedBy(value="evictionLock")
    void removeNode(Node<K, V> node) {
        if (this.data.remove(node.getKeyReference(), node) && this.hasRemovalListener()) {
            K key = node.getKey();
            V value = node.getValue();
            if (key == null || value == null) {
                this.notifyRemoval(key, value, RemovalCause.COLLECTED);
            } else {
                this.notifyRemoval(key, value, RemovalCause.EXPLICIT);
            }
            this.tracer().recordDelete(this.id, node.getKeyReference());
        }
        this.makeDead(node);
    }

    @Override
    public boolean containsKey(Object key) {
        Node<K, V> node = this.data.get(this.nodeFactory.newLookupKey(key));
        return node != null && !this.hasExpired(node, this.ticker().read());
    }

    @Override
    public boolean containsValue(Object value) {
        Objects.requireNonNull(value);
        long now = this.ticker().read();
        for (Node<K, V> node : this.data.values()) {
            if (!node.containsValue(value) || this.hasExpired(node, now)) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(Object key) {
        return this.getIfPresent(key, false);
    }

    @Override
    public V getIfPresent(Object key, boolean recordStats) {
        Node<K, V> node = this.data.get(this.nodeFactory.newLookupKey(key));
        this.tracer().recordRead(this.id, key);
        if (node == null) {
            if (recordStats) {
                this.statsCounter().recordMisses(1);
            }
            return null;
        }
        if (this.hasExpired(node, this.ticker().read())) {
            if (recordStats) {
                this.statsCounter().recordMisses(1);
            }
            this.tryToDrainBuffers();
            return null;
        }
        this.afterRead(node, recordStats);
        return node.getValue();
    }

    @Override
    public Map<K, V> getAllPresent(Iterable<?> keys) {
        int misses = 0;
        long now = this.ticker().read();
        LinkedHashMap result = new LinkedHashMap();
        for (Object key : keys) {
            Node<K, V> node = this.data.get(this.nodeFactory.newLookupKey(key));
            this.tracer().recordRead(this.id, key);
            if (node == null || this.hasExpired(node, now)) {
                ++misses;
                continue;
            }
            Object castKey = key;
            V value = node.getValue();
            result.put(castKey, value);
            this.afterRead(node, true);
        }
        this.statsCounter().recordMisses(misses);
        return Collections.unmodifiableMap(result);
    }

    @Override
    public V put(K key, V value) {
        return this.put(key, value, false);
    }

    @Override
    public V putIfAbsent(K key, V value) {
        return this.put(key, value, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    V put(K key, V value, boolean onlyIfAbsent) {
        int oldWeight;
        V oldValue;
        Node<K, V> prior;
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        long now = this.ticker().read();
        int weight = this.weigher.weigh(key, value);
        Node<K, V> node = this.nodeFactory.newNode(key, this.keyReferenceQueue(), value, this.valueReferenceQueue(), weight, now);
        this.tracer().recordWrite(this.id, key, weight);
        while (true) {
            if ((prior = this.data.putIfAbsent(node.getKeyReference(), node)) == null) {
                this.afterWrite(node, new AddTask(node, weight));
                return null;
            }
            if (onlyIfAbsent) {
                this.afterRead(prior, false);
                return prior.getValue();
            }
            Node<K, V> node2 = prior;
            synchronized (node2) {
                if (prior.isAlive()) break;
            }
        }
        {
            oldValue = prior.getValue();
            oldWeight = prior.getWeight();
            prior.setValue(value, this.valueReferenceQueue());
            prior.setWeight(weight);
        }
        int weightedDifference = weight - oldWeight;
        if (!this.expiresAfterWrite() && weightedDifference == 0) {
            this.afterRead(prior, false);
        } else {
            this.afterWrite(prior, new UpdateTask(prior, weightedDifference));
        }
        if (this.hasRemovalListener() && value != oldValue) {
            this.notifyRemoval(key, value, RemovalCause.REPLACED);
        }
        return oldValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Object key) {
        Node<K, V> node = this.data.remove(this.nodeFactory.newLookupKey(key));
        this.tracer().recordDelete(this.id, key);
        if (node == null) {
            return null;
        }
        boolean retired = false;
        Node<K, V> node2 = node;
        synchronized (node2) {
            if (node.isAlive()) {
                retired = true;
                node.retire();
            }
        }
        V oldValue = node.getValue();
        if (retired) {
            this.afterWrite(node, new RemovalTask(node));
            if (this.hasRemovalListener()) {
                Object castKey = key;
                RemovalCause cause = oldValue == null ? RemovalCause.COLLECTED : RemovalCause.EXPLICIT;
                this.notifyRemoval(castKey, oldValue, cause);
            }
        }
        return oldValue;
    }

    @Override
    public boolean remove(Object key, Object value) {
        Object keyRef = this.nodeFactory.newLookupKey(key);
        this.tracer().recordDelete(this.id, key);
        if (this.data.get(keyRef) == null || value == null) {
            return false;
        }
        Node[] removed = new Node[1];
        this.data.computeIfPresent(keyRef, (k, node) -> {
            Node node2 = node;
            synchronized (node2) {
                if (!node.isAlive() || !node.containsValue(value)) {
                    return node;
                }
                node.retire();
            }
            nodeArray[0] = node;
            return null;
        });
        if (removed[0] == null) {
            return false;
        }
        if (this.hasRemovalListener()) {
            Object castKey = key;
            this.notifyRemoval(castKey, removed[0].getValue(), RemovalCause.EXPLICIT);
        }
        this.afterWrite(removed[0], new RemovalTask(removed[0]));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V replace(K key, V value) {
        V oldValue;
        int oldWeight;
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        int weight = this.weigher.weigh(key, value);
        Node<K, V> node = this.data.get(this.nodeFactory.newLookupKey(key));
        this.tracer().recordWrite(this.id, key, weight);
        if (node == null) {
            return null;
        }
        Node<K, V> node2 = node;
        synchronized (node2) {
            if (!node.isAlive()) {
                return null;
            }
            oldWeight = node.getWeight();
            oldValue = node.getValue();
            node.setValue(value, this.valueReferenceQueue());
            node.setWeight(weight);
        }
        int weightedDifference = weight - oldWeight;
        if (weightedDifference == 0) {
            node.setWriteTime(this.ticker().read());
            this.afterRead(node, false);
        } else {
            this.afterWrite(node, new UpdateTask(node, weightedDifference));
        }
        if (this.hasRemovalListener() && value != oldValue) {
            this.notifyRemoval(key, value, RemovalCause.REPLACED);
        }
        return oldValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        int oldWeight;
        Objects.requireNonNull(key);
        Objects.requireNonNull(oldValue);
        Objects.requireNonNull(newValue);
        int weight = this.weigher.weigh(key, newValue);
        Node<K, V> node = this.data.get(this.nodeFactory.newLookupKey(key));
        this.tracer().recordWrite(this.id, key, weight);
        if (node == null) {
            return false;
        }
        Node<K, V> node2 = node;
        synchronized (node2) {
            if (!node.isAlive() || !node.containsValue(oldValue)) {
                return false;
            }
            oldWeight = node.getWeight();
            node.setValue(newValue, this.valueReferenceQueue());
            node.setWeight(weight);
        }
        int weightedDifference = weight - oldWeight;
        if (weightedDifference == 0) {
            node.setWriteTime(this.ticker().read());
            this.afterRead(node, false);
        } else {
            this.afterWrite(node, new UpdateTask(node, weightedDifference));
        }
        if (this.hasRemovalListener() && oldValue != newValue) {
            this.notifyRemoval(key, oldValue, RemovalCause.REPLACED);
        }
        return true;
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction, boolean isAsync) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(mappingFunction);
        long now = this.ticker().read();
        V value = this.prescreen(key, mappingFunction, now);
        return value == null ? this.doComputeIfAbsent(key, mappingFunction, isAsync, now) : value;
    }

    V prescreen(K key, Function<? super K, ? extends V> mappingFunction, long now) {
        Node<K, V> node = this.data.get(this.nodeFactory.newLookupKey(key));
        if (node != null) {
            V value = node.getValue();
            RemovalCause cause = null;
            if (node.getKey() == null || value == null) {
                cause = RemovalCause.COLLECTED;
            } else if (this.hasExpired(node, now)) {
                cause = RemovalCause.EXPIRED;
            }
            if (cause == null) {
                this.afterRead(node, true);
                if (Tracer.isEnabled()) {
                    this.tracer().recordWrite(this.id, key, this.weigher.weigh(key, value));
                }
                return value;
            }
            if (this.data.remove(node.getKeyReference(), node)) {
                this.afterWrite(node, new RemovalTask(node));
                if (this.hasRemovalListener()) {
                    this.notifyRemoval(key, node.getValue(), cause);
                }
                this.statsCounter().recordEviction();
            }
        }
        return null;
    }

    V doComputeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction, boolean isAsync, long now) {
        Object val;
        int[] weight = new int[1];
        Object[] value = new Object[1];
        Object keyRef = this.nodeFactory.newReferenceKey(key, this.keyReferenceQueue());
        Node node = this.data.computeIfAbsent(keyRef, k -> {
            objectArray[0] = this.statsAware(mappingFunction, isAsync).apply(key);
            if (value[0] == null) {
                return null;
            }
            nArray[0] = this.weigher.weigh(key, value[0]);
            return this.nodeFactory.newNode(key, this.keyReferenceQueue(), value[0], this.valueReferenceQueue(), weight[0], now);
        });
        if (node == null) {
            return null;
        }
        if (value[0] == null) {
            val = node.getValue();
            this.afterRead(node, true);
        } else {
            val = value[0];
            this.afterWrite(node, new AddTask(node, weight[0]));
        }
        if (Tracer.isEnabled() && val != null) {
            this.tracer().recordWrite(this.id, key, this.weigher.weigh(key, val));
        }
        return val;
    }

    @Override
    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        Objects.requireNonNull(remappingFunction);
        Object ref = this.nodeFactory.newLookupKey(key);
        if (!this.data.containsKey(ref)) {
            return null;
        }
        Object[] newValue = new Object[1];
        Runnable[] task = new Runnable[1];
        Node node = this.data.computeIfPresent(ref, (keyRef, prior) -> {
            Node node = prior;
            synchronized (node) {
                Object oldValue = prior.getValue();
                objectArray[0] = this.statsAware(remappingFunction, false, false).apply(key, oldValue);
                if (newValue[0] == null) {
                    prior.retire();
                    runnableArray[0] = new RemovalTask(prior);
                    if (this.hasRemovalListener()) {
                        this.notifyRemoval(key, oldValue, RemovalCause.EXPLICIT);
                    }
                    return null;
                }
                prior.setValue(newValue[0], this.valueReferenceQueue());
                int oldWeight = prior.getWeight();
                int newWeight = this.weigher.weigh(key, newValue[0]);
                prior.setWeight(newWeight);
                int weightedDifference = newWeight - oldWeight;
                if (weightedDifference != 0) {
                    runnableArray[0] = new UpdateTask(prior, weightedDifference);
                }
                if (this.hasRemovalListener() && newValue[0] != oldValue) {
                    this.notifyRemoval(key, oldValue, RemovalCause.REPLACED);
                }
                this.tracer().recordWrite(this.id, key, newWeight);
                return prior;
            }
        });
        if (task[0] == null) {
            this.afterRead(node, false);
        } else {
            this.afterWrite(node, task[0]);
        }
        return (V)newValue[0];
    }

    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, boolean recordMiss, boolean isAsync) {
        return this.remap(key, this.statsAware(remappingFunction, recordMiss, isAsync));
    }

    private V remap(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(remappingFunction);
        Object[] newValue = new Object[1];
        Object keyRef = this.nodeFactory.newReferenceKey(key, this.keyReferenceQueue());
        Runnable[] task = new Runnable[2];
        Node node = this.data.compute(keyRef, (k, prior) -> {
            if (prior == null) {
                objectArray[0] = remappingFunction.apply((K)key, (V)null);
                if (newValue[0] == null) {
                    this.tracer().recordDelete(this.id, key);
                    return null;
                }
                long now = this.ticker().read();
                int weight = this.weigher.weigh(key, newValue[0]);
                Node newNode = this.nodeFactory.newNode(keyRef, newValue[0], this.valueReferenceQueue(), weight, now);
                runnableArray[0] = new AddTask(newNode, weight);
                this.tracer().recordWrite(this.id, key, weight);
                return newNode;
            }
            Node node = prior;
            synchronized (node) {
                V oldValue = null;
                if (prior.isAlive()) {
                    oldValue = prior.getValue();
                } else {
                    runnableArray[1] = new RemovalTask(prior);
                    if (this.hasRemovalListener()) {
                        Object value = prior.getValue();
                        if (value == null) {
                            this.notifyRemoval(key, value, RemovalCause.COLLECTED);
                        } else {
                            this.notifyRemoval(key, value, RemovalCause.EXPLICIT);
                        }
                    }
                }
                objectArray[0] = remappingFunction.apply((K)key, (V)oldValue);
                if (newValue[0] == null && oldValue != null) {
                    runnableArray[0] = new RemovalTask(prior);
                    if (this.hasRemovalListener()) {
                        this.notifyRemoval(key, oldValue, RemovalCause.EXPLICIT);
                    }
                    this.tracer().recordDelete(this.id, key);
                    return null;
                }
                int oldWeight = prior.getWeight();
                int newWeight = this.weigher.weigh(key, newValue[0]);
                if (task[1] == null) {
                    prior.setWeight(newWeight);
                    prior.setValue(newValue[0], this.valueReferenceQueue());
                    int weightedDifference = newWeight - oldWeight;
                    if (weightedDifference != 0) {
                        runnableArray[0] = new UpdateTask(prior, weightedDifference);
                    }
                    if (this.hasRemovalListener() && newValue[0] != oldValue) {
                        this.notifyRemoval(key, oldValue, RemovalCause.REPLACED);
                    }
                    this.tracer().recordWrite(this.id, key, newWeight);
                    return prior;
                }
                long now = this.ticker().read();
                Node newNode = this.nodeFactory.newNode(keyRef, newValue[0], this.valueReferenceQueue(), newWeight, now);
                runnableArray[0] = new AddTask(newNode, newWeight);
                return newNode;
            }
        });
        if (task[0] != null) {
            this.afterWrite(node, task[0]);
        }
        if (task[1] != null) {
            this.afterWrite(node, task[1]);
        }
        return (V)newValue[0];
    }

    @Override
    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        Objects.requireNonNull(remappingFunction);
        Objects.requireNonNull(value);
        return (V)this.remap(key, (k, oldValue) -> oldValue == null ? value : this.statsAware(remappingFunction).apply(oldValue, value));
    }

    @Override
    public void cleanUp() {
        this.evictionLock.lock();
        try {
            this.drainBuffers();
        }
        finally {
            this.evictionLock.unlock();
        }
    }

    void asyncCleanup() {
        this.executor().execute(this::cleanUp);
    }

    @Override
    public Set<K> keySet() {
        KeySet ks = this.keySet;
        return ks == null ? (this.keySet = new KeySet()) : ks;
    }

    @Override
    public Collection<V> values() {
        Values vs = this.values;
        return vs == null ? (this.values = new Values()) : vs;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet es = this.entrySet;
        return es == null ? (this.entrySet = new EntrySet()) : es;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<K, V> orderedMap(LinkedDeque<Node<K, V>> deque, Function<V, V> transformer, boolean ascending, int limit) {
        Caffeine.requireArgument(limit >= 0);
        this.evictionLock.lock();
        try {
            Iterator iterator;
            this.drainBuffers();
            int initialCapacity = this.weigher == Weigher.singleton() ? Math.min(limit, this.evicts() ? (int)this.adjustedWeightedSize() : this.size()) : 16;
            LinkedHashMap map = new LinkedHashMap(initialCapacity);
            Iterator iterator2 = iterator = ascending ? deque.iterator() : deque.descendingIterator();
            while (iterator.hasNext() && limit > map.size()) {
                Node node = (Node)iterator.next();
                Object key = node.getKey();
                V value = transformer.apply(node.getValue());
                if (key == null || value == null || !node.isAlive()) continue;
                map.put(key, value);
            }
            Map map2 = Collections.unmodifiableMap(map);
            return map2;
        }
        finally {
            this.evictionLock.unlock();
        }
    }

    static <K, V> SerializationProxy<K, V> makeSerializationProxy(BoundedLocalCache<?, ?> cache) {
        SerializationProxy proxy = new SerializationProxy();
        proxy.weakKeys = cache.collectKeys();
        proxy.weakValues = cache.nodeFactory.weakValues();
        proxy.softValues = cache.nodeFactory.softValues();
        proxy.isRecordingStats = cache.isRecordingStats();
        proxy.removalListener = cache.removalListener();
        proxy.ticker = cache.ticker();
        if (cache.expiresAfterAccess()) {
            proxy.expiresAfterAccessNanos = cache.expiresAfterAccessNanos();
        }
        if (cache.expiresAfterWrite()) {
            proxy.expiresAfterWriteNanos = cache.expiresAfterWriteNanos();
        }
        if (cache.evicts()) {
            if (cache.weigher == Weigher.singleton()) {
                proxy.maximumSize = cache.maximum();
            } else {
                proxy.weigher = cache.weigher;
                proxy.maximumWeight = cache.maximum();
            }
        }
        return proxy;
    }

    static final class BoundedLocalAsyncLoadingCache<K, V>
    extends LocalAsyncLoadingCache<BoundedLocalCache<K, CompletableFuture<V>>, K, V>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        final boolean isWeighted;
        transient Policy<K, V> policy;

        BoundedLocalAsyncLoadingCache(Caffeine<K, V> builder, CacheLoader<? super K, V> loader) {
            super(LocalCacheFactory.newBoundedLocalCache(builder, BoundedLocalAsyncLoadingCache.asyncLoader(loader, builder), true), loader);
            this.isWeighted = builder.isWeighted();
        }

        private static <K, V> CacheLoader<? super K, CompletableFuture<V>> asyncLoader(CacheLoader<? super K, V> loader, Caffeine<?, ?> builder) {
            Executor executor = builder.getExecutor();
            return key -> loader.asyncLoad(key, executor);
        }

        @Override
        protected Policy<K, V> policy() {
            if (this.policy == null) {
                Function<CompletableFuture, Object> transformer;
                BoundedLocalCache castedCache = (BoundedLocalCache)this.cache;
                Function<CompletableFuture, Object> castedTransformer = transformer = Async::getIfReady;
                this.policy = new BoundedPolicy(castedCache, castedTransformer, this.isWeighted);
            }
            return this.policy;
        }

        private void readObject(ObjectInputStream stream) throws InvalidObjectException {
            throw new InvalidObjectException("Proxy required");
        }

        Object writeReplace() {
            SerializationProxy proxy = BoundedLocalCache.makeSerializationProxy((BoundedLocalCache)this.cache);
            if (((BoundedLocalCache)this.cache).refreshAfterWrite()) {
                proxy.refreshAfterWriteNanos = ((BoundedLocalCache)this.cache).refreshAfterWriteNanos();
            }
            proxy.loader = this.loader;
            proxy.async = true;
            return proxy;
        }
    }

    static final class BoundedLocalLoadingCache<K, V>
    extends BoundedLocalManualCache<K, V>
    implements LocalLoadingCache<BoundedLocalCache<K, V>, K, V> {
        private static final long serialVersionUID = 1L;
        final boolean hasBulkLoader;

        BoundedLocalLoadingCache(Caffeine<K, V> builder, CacheLoader<? super K, V> loader) {
            super(builder, loader);
            Objects.requireNonNull(loader);
            this.hasBulkLoader = this.hasLoadAll(loader);
        }

        @Override
        public CacheLoader<? super K, V> cacheLoader() {
            return this.cache.cacheLoader();
        }

        @Override
        public boolean hasBulkLoader() {
            return this.hasBulkLoader;
        }

        private void readObject(ObjectInputStream stream) throws InvalidObjectException {
            throw new InvalidObjectException("Proxy required");
        }

        @Override
        Object writeReplace() {
            SerializationProxy proxy = (SerializationProxy)super.writeReplace();
            if (this.cache.refreshAfterWrite()) {
                proxy.refreshAfterWriteNanos = this.cache.refreshAfterWriteNanos();
            }
            proxy.loader = this.cache.cacheLoader();
            return proxy;
        }
    }

    static final class BoundedPolicy<K, V>
    implements Policy<K, V> {
        final BoundedLocalCache<K, V> cache;
        final Function<V, V> transformer;
        final boolean isWeighted;
        Optional<Policy.Eviction<K, V>> eviction;
        Optional<Policy.Expiration<K, V>> refreshes;
        Optional<Policy.Expiration<K, V>> afterWrite;
        Optional<Policy.Expiration<K, V>> afterAccess;

        BoundedPolicy(BoundedLocalCache<K, V> cache, Function<V, V> transformer, boolean isWeighted) {
            this.transformer = transformer;
            this.isWeighted = isWeighted;
            this.cache = cache;
        }

        @Override
        public Optional<Policy.Eviction<K, V>> eviction() {
            Optional<Policy.Eviction<K, V>> optional;
            if (this.cache.evicts()) {
                if (this.eviction == null) {
                    this.eviction = Optional.of(new BoundedEviction());
                    optional = this.eviction;
                } else {
                    optional = this.eviction;
                }
            } else {
                optional = Optional.empty();
            }
            return optional;
        }

        @Override
        public Optional<Policy.Expiration<K, V>> expireAfterAccess() {
            if (!this.cache.expiresAfterAccess()) {
                return Optional.empty();
            }
            return this.afterAccess == null ? (this.afterAccess = Optional.of(new BoundedExpireAfterAccess())) : this.afterAccess;
        }

        @Override
        public Optional<Policy.Expiration<K, V>> expireAfterWrite() {
            if (!this.cache.expiresAfterWrite()) {
                return Optional.empty();
            }
            return this.afterWrite == null ? (this.afterWrite = Optional.of(new BoundedExpireAfterWrite())) : this.afterWrite;
        }

        @Override
        public Optional<Policy.Expiration<K, V>> refreshAfterWrite() {
            if (!this.cache.refreshAfterWrite()) {
                return Optional.empty();
            }
            return this.refreshes == null ? (this.refreshes = Optional.of(new BoundedRefreshAfterWrite())) : this.refreshes;
        }

        final class BoundedRefreshAfterWrite
        implements Policy.Expiration<K, V> {
            BoundedRefreshAfterWrite() {
            }

            @Override
            public OptionalLong ageOf(K key, TimeUnit unit) {
                Object keyRef = BoundedPolicy.this.cache.nodeFactory.newLookupKey(key);
                Node node = BoundedPolicy.this.cache.data.get(keyRef);
                if (node == null) {
                    return OptionalLong.empty();
                }
                long age = BoundedPolicy.this.cache.ticker().read() - node.getWriteTime();
                return age > BoundedPolicy.this.cache.refreshAfterWriteNanos() ? OptionalLong.empty() : OptionalLong.of(unit.convert(age, TimeUnit.NANOSECONDS));
            }

            @Override
            public long getExpiresAfter(TimeUnit unit) {
                return unit.convert(BoundedPolicy.this.cache.refreshAfterWriteNanos(), TimeUnit.NANOSECONDS);
            }

            @Override
            public void setExpiresAfter(long duration, TimeUnit unit) {
                Caffeine.requireArgument(duration >= 0L);
                BoundedPolicy.this.cache.setRefreshAfterWriteNanos(unit.toNanos(duration));
                BoundedPolicy.this.cache.asyncCleanup();
            }

            @Override
            public Map<K, V> oldest(int limit) {
                return BoundedPolicy.this.cache.expiresAfterWrite() ? BoundedPolicy.this.expireAfterWrite().get().oldest(limit) : this.sortedByWriteTime(true, limit);
            }

            @Override
            public Map<K, V> youngest(int limit) {
                return BoundedPolicy.this.cache.expiresAfterWrite() ? BoundedPolicy.this.expireAfterWrite().get().youngest(limit) : this.sortedByWriteTime(false, limit);
            }

            private Map<K, V> sortedByWriteTime(boolean ascending, int limit) {
                Caffeine.requireArgument(limit >= 0);
                int initialCapacity = BoundedPolicy.this.cache.weigher == Weigher.singleton() ? Math.min(limit, BoundedPolicy.this.cache.evicts() ? (int)BoundedPolicy.this.cache.adjustedWeightedSize() : BoundedPolicy.this.cache.size()) : 16;
                LinkedHashMap map = new LinkedHashMap(initialCapacity);
                Iterator iterator = BoundedPolicy.this.cache.data.values().stream().sorted((a, b) -> {
                    int comparison = Long.compare(a.getWriteTime(), b.getWriteTime());
                    return ascending ? comparison : -comparison;
                }).iterator();
                while (iterator.hasNext() && limit > map.size()) {
                    Node node = (Node)iterator.next();
                    Object key = node.getKey();
                    Object value = BoundedPolicy.this.transformer.apply(node.getValue());
                    if (key == null || value == null || !node.isAlive()) continue;
                    map.put(key, value);
                }
                return Collections.unmodifiableMap(map);
            }
        }

        final class BoundedExpireAfterWrite
        implements Policy.Expiration<K, V> {
            BoundedExpireAfterWrite() {
            }

            @Override
            public OptionalLong ageOf(K key, TimeUnit unit) {
                Object keyRef = BoundedPolicy.this.cache.nodeFactory.newLookupKey(key);
                Node node = BoundedPolicy.this.cache.data.get(keyRef);
                if (node == null) {
                    return OptionalLong.empty();
                }
                long age = BoundedPolicy.this.cache.ticker().read() - node.getWriteTime();
                return age > BoundedPolicy.this.cache.expiresAfterWriteNanos() ? OptionalLong.empty() : OptionalLong.of(unit.convert(age, TimeUnit.NANOSECONDS));
            }

            @Override
            public long getExpiresAfter(TimeUnit unit) {
                return unit.convert(BoundedPolicy.this.cache.expiresAfterWriteNanos(), TimeUnit.NANOSECONDS);
            }

            @Override
            public void setExpiresAfter(long duration, TimeUnit unit) {
                Caffeine.requireArgument(duration >= 0L);
                BoundedPolicy.this.cache.setExpiresAfterWriteNanos(unit.toNanos(duration));
                BoundedPolicy.this.cache.asyncCleanup();
            }

            @Override
            public Map<K, V> oldest(int limit) {
                return BoundedPolicy.this.cache.orderedMap(BoundedPolicy.this.cache.writeOrderDeque(), BoundedPolicy.this.transformer, true, limit);
            }

            @Override
            public Map<K, V> youngest(int limit) {
                return BoundedPolicy.this.cache.orderedMap(BoundedPolicy.this.cache.writeOrderDeque(), BoundedPolicy.this.transformer, false, limit);
            }
        }

        final class BoundedExpireAfterAccess
        implements Policy.Expiration<K, V> {
            BoundedExpireAfterAccess() {
            }

            @Override
            public OptionalLong ageOf(K key, TimeUnit unit) {
                Object keyRef = BoundedPolicy.this.cache.nodeFactory.newLookupKey(key);
                Node node = BoundedPolicy.this.cache.data.get(keyRef);
                if (node == null) {
                    return OptionalLong.empty();
                }
                long age = BoundedPolicy.this.cache.ticker().read() - node.getAccessTime();
                return age > BoundedPolicy.this.cache.expiresAfterAccessNanos() ? OptionalLong.empty() : OptionalLong.of(unit.convert(age, TimeUnit.NANOSECONDS));
            }

            @Override
            public long getExpiresAfter(TimeUnit unit) {
                return unit.convert(BoundedPolicy.this.cache.expiresAfterAccessNanos(), TimeUnit.NANOSECONDS);
            }

            @Override
            public void setExpiresAfter(long duration, TimeUnit unit) {
                Caffeine.requireArgument(duration >= 0L);
                BoundedPolicy.this.cache.setExpiresAfterAccessNanos(unit.toNanos(duration));
                BoundedPolicy.this.cache.asyncCleanup();
            }

            @Override
            public Map<K, V> oldest(int limit) {
                return BoundedPolicy.this.cache.orderedMap(BoundedPolicy.this.cache.accessOrderDeque(), BoundedPolicy.this.transformer, true, limit);
            }

            @Override
            public Map<K, V> youngest(int limit) {
                return BoundedPolicy.this.cache.orderedMap(BoundedPolicy.this.cache.accessOrderDeque(), BoundedPolicy.this.transformer, false, limit);
            }
        }

        final class BoundedEviction
        implements Policy.Eviction<K, V> {
            BoundedEviction() {
            }

            @Override
            public boolean isWeighted() {
                return BoundedPolicy.this.isWeighted;
            }

            @Override
            public OptionalLong weightedSize() {
                if (BoundedPolicy.this.cache.evicts() && this.isWeighted()) {
                    return OptionalLong.of(BoundedPolicy.this.cache.adjustedWeightedSize());
                }
                return OptionalLong.empty();
            }

            @Override
            public long getMaximum() {
                return BoundedPolicy.this.cache.maximum();
            }

            @Override
            public void setMaximum(long maximumSize) {
                BoundedPolicy.this.cache.setMaximum(maximumSize);
            }

            @Override
            public Map<K, V> coldest(int limit) {
                return BoundedPolicy.this.cache.orderedMap(BoundedPolicy.this.cache.accessOrderDeque(), BoundedPolicy.this.transformer, true, limit);
            }

            @Override
            public Map<K, V> hottest(int limit) {
                return BoundedPolicy.this.cache.orderedMap(BoundedPolicy.this.cache.accessOrderDeque(), BoundedPolicy.this.transformer, false, limit);
            }
        }
    }

    static class BoundedLocalManualCache<K, V>
    implements LocalManualCache<BoundedLocalCache<K, V>, K, V>,
    Serializable {
        private static final long serialVersionUID = 1L;
        final BoundedLocalCache<K, V> cache;
        final boolean isWeighted;
        Policy<K, V> policy;

        BoundedLocalManualCache(Caffeine<K, V> builder) {
            this(builder, null);
        }

        BoundedLocalManualCache(Caffeine<K, V> builder, CacheLoader<? super K, V> loader) {
            this.cache = LocalCacheFactory.newBoundedLocalCache(builder, loader, false);
            this.isWeighted = builder.weigher != null;
        }

        @Override
        public BoundedLocalCache<K, V> cache() {
            return this.cache;
        }

        @Override
        public Policy<K, V> policy() {
            return this.policy == null ? (this.policy = new BoundedPolicy<K, V>(this.cache, Function.identity(), this.isWeighted)) : this.policy;
        }

        private void readObject(ObjectInputStream stream) throws InvalidObjectException {
            throw new InvalidObjectException("Proxy required");
        }

        Object writeReplace() {
            return BoundedLocalCache.makeSerializationProxy(this.cache);
        }
    }

    final class EntryIterator
    implements Iterator<Map.Entry<K, V>> {
        final Iterator<Node<K, V>> iterator;
        final long now;
        K key;
        V value;
        K removalKey;
        Node<K, V> next;

        EntryIterator() {
            this.iterator = BoundedLocalCache.this.data.values().iterator();
            this.now = BoundedLocalCache.this.ticker().read();
        }

        @Override
        public boolean hasNext() {
            if (this.next != null) {
                return true;
            }
            while (this.iterator.hasNext()) {
                this.next = this.iterator.next();
                this.value = this.next.getValue();
                this.key = this.next.getKey();
                if (BoundedLocalCache.this.hasExpired(this.next, this.now) || this.key == null || this.value == null || !this.next.isAlive()) {
                    this.value = null;
                    this.next = null;
                    this.key = null;
                    continue;
                }
                return true;
            }
            return false;
        }

        @Override
        public Map.Entry<K, V> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            WriteThroughEntry entry = new WriteThroughEntry(BoundedLocalCache.this, this.key, this.value);
            this.removalKey = this.key;
            this.value = null;
            this.next = null;
            this.key = null;
            return entry;
        }

        @Override
        public void remove() {
            Caffeine.requireState(this.removalKey != null);
            BoundedLocalCache.this.remove(this.removalKey);
            this.removalKey = null;
        }
    }

    final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        final BoundedLocalCache<K, V> map;

        EntrySet() {
            this.map = BoundedLocalCache.this;
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean contains(Object obj) {
            if (!(obj instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)obj;
            Node node = this.map.data.get(BoundedLocalCache.this.nodeFactory.newLookupKey(entry.getKey()));
            return node != null && Objects.equals(node.getValue(), entry.getValue());
        }

        @Override
        public boolean remove(Object obj) {
            if (!(obj instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)obj;
            return this.map.remove(entry.getKey(), entry.getValue());
        }
    }

    final class ValueIterator
    implements Iterator<V> {
        final Iterator<Map.Entry<K, V>> iterator;

        ValueIterator() {
            this.iterator = BoundedLocalCache.this.entrySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public V next() {
            return this.iterator.next().getValue();
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }

    final class Values
    extends AbstractCollection<V> {
        Values() {
        }

        @Override
        public int size() {
            return BoundedLocalCache.this.size();
        }

        @Override
        public void clear() {
            BoundedLocalCache.this.clear();
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public boolean contains(Object o) {
            return BoundedLocalCache.this.containsValue(o);
        }
    }

    final class KeyIterator
    implements Iterator<K> {
        final Iterator<Map.Entry<K, V>> iterator;
        K current;

        KeyIterator() {
            this.iterator = BoundedLocalCache.this.entrySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public K next() {
            Object castedKey = this.iterator.next().getKey();
            this.current = castedKey;
            return this.current;
        }

        @Override
        public void remove() {
            Caffeine.requireState(this.current != null);
            BoundedLocalCache.this.remove(this.current);
            this.current = null;
        }
    }

    final class KeySet
    extends AbstractSet<K> {
        final BoundedLocalCache<K, V> map;

        KeySet() {
            this.map = BoundedLocalCache.this;
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator();
        }

        @Override
        public boolean contains(Object obj) {
            return BoundedLocalCache.this.containsKey(obj);
        }

        @Override
        public boolean remove(Object obj) {
            return this.map.remove(obj) != null;
        }

        @Override
        public Object[] toArray() {
            if (BoundedLocalCache.this.collectKeys()) {
                ArrayList keys = new ArrayList(this.size());
                for (Object key : this) {
                    keys.add(key);
                }
                return keys.toArray();
            }
            return ((ConcurrentHashMap.CollectionView)((Object)this.map.data.keySet())).toArray();
        }

        @Override
        public <T> T[] toArray(T[] array) {
            if (BoundedLocalCache.this.collectKeys()) {
                ArrayList keys = new ArrayList(this.size());
                for (Object key : this) {
                    keys.add(key);
                }
                return keys.toArray(array);
            }
            return ((ConcurrentHashMap.CollectionView)((Object)this.map.data.keySet())).toArray(array);
        }
    }

    static enum DrainStatus {
        IDLE{

            @Override
            boolean shouldDrainBuffers(boolean delayable) {
                return !delayable;
            }
        }
        ,
        REQUIRED{

            @Override
            boolean shouldDrainBuffers(boolean delayable) {
                return true;
            }
        }
        ,
        PROCESSING{

            @Override
            boolean shouldDrainBuffers(boolean delayable) {
                return false;
            }
        };


        abstract boolean shouldDrainBuffers(boolean var1);
    }

    final class UpdateTask
    implements Runnable {
        final int weightDifference;
        final Node<K, V> node;

        public UpdateTask(Node<K, V> node, int weightDifference) {
            this.weightDifference = weightDifference;
            this.node = node;
        }

        @Override
        @GuardedBy(value="evictionLock")
        public void run() {
            if (BoundedLocalCache.this.evicts()) {
                BoundedLocalCache.this.lazySetWeightedSize(BoundedLocalCache.this.weightedSize() + (long)this.weightDifference);
            }
            if (BoundedLocalCache.this.evicts() || BoundedLocalCache.this.expiresAfterAccess()) {
                BoundedLocalCache.reorder(BoundedLocalCache.this.accessOrderDeque(), this.node);
            }
            if (BoundedLocalCache.this.expiresAfterWrite()) {
                BoundedLocalCache.reorder(BoundedLocalCache.this.writeOrderDeque(), this.node);
            }
            BoundedLocalCache.this.evictEntries();
        }
    }

    final class RemovalTask
    implements Runnable {
        final Node<K, V> node;

        RemovalTask(Node<K, V> node) {
            this.node = node;
        }

        @Override
        @GuardedBy(value="evictionLock")
        public void run() {
            if (BoundedLocalCache.this.evicts() || BoundedLocalCache.this.expiresAfterAccess()) {
                BoundedLocalCache.this.accessOrderDeque().remove(this.node);
            }
            if (BoundedLocalCache.this.expiresAfterWrite()) {
                BoundedLocalCache.this.writeOrderDeque().remove(this.node);
            }
            BoundedLocalCache.this.makeDead(this.node);
        }
    }

    final class AddTask
    implements Runnable {
        final Node<K, V> node;
        final int weight;

        AddTask(Node<K, V> node, int weight) {
            this.weight = weight;
            this.node = node;
        }

        @Override
        @GuardedBy(value="evictionLock")
        public void run() {
            if (BoundedLocalCache.this.evicts()) {
                BoundedLocalCache.this.lazySetWeightedSize(BoundedLocalCache.this.weightedSize() + (long)this.weight);
            }
            if (this.node.isAlive()) {
                if (BoundedLocalCache.this.expiresAfterWrite()) {
                    BoundedLocalCache.this.writeOrderDeque().add(this.node);
                }
                if (BoundedLocalCache.this.evicts() || BoundedLocalCache.this.expiresAfterAccess()) {
                    BoundedLocalCache.this.accessOrderDeque().add(this.node);
                }
                BoundedLocalCache.this.evictEntries();
            }
            if (BoundedLocalCache.this.isComputingAsync(this.node)) {
                this.node.setAccessTime(Long.MAX_VALUE);
                this.node.setWriteTime(Long.MAX_VALUE);
                ((CompletableFuture)this.node.getValue()).thenRun(() -> {
                    long now = BoundedLocalCache.this.ticker().read();
                    this.node.setAccessTime(now);
                    this.node.setWriteTime(now);
                });
            }
        }
    }
}

