/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine;

import com.github.benmanes.caffeine.Beta;
import com.github.benmanes.caffeine.base.UnsafeAccess;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Queue;
import javax.annotation.Nullable;

@Beta
public final class SingleConsumerQueue<E>
implements Queue<E>,
Serializable {
    static final long HEAD_OFFSET = UnsafeAccess.objectFieldOffset(SingleConsumerQueue.class, "head");
    static final long TAIL_OFFSET = UnsafeAccess.objectFieldOffset(SingleConsumerQueue.class, "tail");
    volatile transient Node<E> head;
    volatile transient Node<E> tail;
    static final long serialVersionUID = 1L;

    public SingleConsumerQueue(Collection<E> c) {
        this();
        this.addAll(c);
    }

    public SingleConsumerQueue() {
        Node<Object> node = new Node<Object>(null);
        this.lazySetHead(node);
        this.lazySetTail(node);
    }

    void lazySetHead(Node<E> next) {
        UnsafeAccess.UNSAFE.putOrderedObject(this, HEAD_OFFSET, next);
    }

    boolean casHead(Node<E> expect, Node<E> update) {
        return UnsafeAccess.UNSAFE.compareAndSwapObject(this, HEAD_OFFSET, expect, update);
    }

    Node<E> getTailRelaxed() {
        return (Node)UnsafeAccess.UNSAFE.getObject(this, TAIL_OFFSET);
    }

    void lazySetTail(Node<E> next) {
        UnsafeAccess.UNSAFE.putOrderedObject(this, TAIL_OFFSET, next);
    }

    @Override
    public boolean isEmpty() {
        return this.head == this.tail;
    }

    @Override
    public int size() {
        Node<E> t = this.tail;
        Node<E> cursor = t.getNextRelaxed();
        int size = 0;
        while (cursor != null) {
            cursor = cursor.getNextRelaxed();
            ++size;
        }
        return size;
    }

    @Override
    public void clear() {
        this.lazySetTail(this.head);
    }

    @Override
    public boolean contains(@Nullable Object o) {
        if (o == null) {
            return false;
        }
        Node<E> cursor = this.tail.getNextRelaxed();
        while (cursor != null) {
            if (o.equals(cursor.value)) {
                return true;
            }
            cursor = cursor.next;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        Objects.requireNonNull(c);
        for (Object e : c) {
            if (this.contains(e)) continue;
            return false;
        }
        return true;
    }

    @Override
    public E peek() {
        Node<E> next = this.tail.getNextRelaxed();
        return next == null ? null : (E)next.value;
    }

    @Override
    public E element() {
        E e = this.peek();
        if (e == null) {
            throw new NoSuchElementException();
        }
        return e;
    }

    @Override
    public boolean offer(E e) {
        Node<E> h;
        Objects.requireNonNull(e);
        Node<E> node = new Node<E>(e);
        while (!this.casHead(h = this.head, node)) {
        }
        h.lazySetNext(node);
        return true;
    }

    @Override
    public E poll() {
        Node<E> next = this.tail.getNextRelaxed();
        if (next == null) {
            return null;
        }
        this.lazySetTail(next);
        Object e = next.value;
        next.value = null;
        return e;
    }

    @Override
    public boolean add(E e) {
        return this.offer(e);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        Node<E> h;
        Objects.requireNonNull(c);
        Node<E> first = null;
        Node<E> last = null;
        for (E e : c) {
            Objects.requireNonNull(e);
            if (first == null) {
                last = first = new Node<E>(e);
                continue;
            }
            Node<E> newLast = new Node<E>(e);
            last.lazySetNext(newLast);
            last = newLast;
        }
        if (first == null) {
            return false;
        }
        while (!this.casHead(h = this.head, last)) {
        }
        h.lazySetNext(first);
        return true;
    }

    @Override
    public E remove() {
        E e = this.poll();
        if (e == null) {
            throw new NoSuchElementException();
        }
        return e;
    }

    @Override
    public boolean remove(Object o) {
        Objects.requireNonNull(o);
        Node<E> h = this.head;
        Node<E> prev = this.getTailRelaxed();
        Node<E> cursor = prev.getNextRelaxed();
        while (cursor != null) {
            Node<E> next = cursor.getNextRelaxed();
            if (o.equals(cursor.value)) {
                if (h == cursor && !this.casHead(h, prev) && next == null) {
                    next = h.next;
                }
                prev.lazySetNext(next);
                return true;
            }
            prev = cursor;
            cursor = next;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.removeByPresentce(c, false);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.removeByPresentce(c, true);
    }

    boolean removeByPresentce(Collection<?> c, boolean retain) {
        Objects.requireNonNull(c);
        Node<E> h = this.head;
        Node<E> prev = this.getTailRelaxed();
        Node<E> cursor = prev.getNextRelaxed();
        boolean modified = false;
        while (cursor != null) {
            boolean present = c.contains(cursor.value);
            Node<E> next = cursor.getNextRelaxed();
            if (present != retain) {
                if (h == cursor && !this.casHead(h, prev) && next == null) {
                    next = h.next;
                }
                prev.lazySetNext(next);
                modified = true;
            } else {
                prev = cursor;
            }
            cursor = prev.getNextRelaxed();
        }
        return modified;
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            Node<E> h;
            Node<E> prev;
            Node<E> cursor;
            boolean failOnRemoval;
            {
                this.h = SingleConsumerQueue.this.head;
                this.prev = null;
                this.cursor = SingleConsumerQueue.this.getTailRelaxed();
                this.failOnRemoval = true;
            }

            @Override
            public boolean hasNext() {
                return this.cursor != this.h;
            }

            @Override
            public E next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.advance();
                this.failOnRemoval = false;
                return this.cursor.value;
            }

            private void advance() {
                if (this.prev == null || !this.failOnRemoval) {
                    this.prev = this.cursor;
                }
                this.cursor = this.cursor.getNextRelaxed();
            }

            @Override
            public void remove() {
                if (this.failOnRemoval) {
                    throw new IllegalStateException();
                }
                if (this.h == this.cursor && !SingleConsumerQueue.this.casHead(this.h, this.prev) && this.cursor.getNextRelaxed() == null) {
                    this.prev.lazySetNext(this.h.next);
                } else {
                    this.prev.lazySetNext(this.cursor.getNextRelaxed());
                }
                this.failOnRemoval = true;
            }
        };
    }

    @Override
    public Object[] toArray() {
        ArrayList<E> list = new ArrayList<E>();
        for (E e : this) {
            list.add(e);
        }
        return list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        ArrayList<E> list = new ArrayList<E>();
        for (E e : this) {
            list.add(e);
        }
        return list.toArray(a);
    }

    public String toString() {
        if (this.isEmpty()) {
            return "[]";
        }
        Node<E> t = this.tail;
        Node<E> cursor = t.getNextRelaxed();
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        while (true) {
            sb.append(cursor.value);
            cursor = cursor.getNextRelaxed();
            if (cursor == null) break;
            sb.append(',').append(' ');
        }
        sb.append(']');
        return sb.toString();
    }

    Object writeReplace() {
        return new SerializationProxy(this);
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Proxy required");
    }

    static final class Node<E> {
        static final long NEXT_OFFSET = UnsafeAccess.objectFieldOffset(Node.class, "next");
        volatile transient long q0;
        volatile transient long q1;
        volatile transient long q2;
        volatile transient long q3;
        volatile transient long q4;
        volatile transient long q5;
        volatile transient long q6;
        volatile transient long q7;
        volatile transient long q8;
        volatile transient long q9;
        volatile transient long qa;
        volatile transient long qb;
        volatile transient long qc;
        volatile transient long qd;
        volatile transient long qe;
        volatile Node<E> next;
        E value;

        Node(@Nullable E value) {
            this.value = value;
        }

        @Nullable
        Node<E> getNextRelaxed() {
            return (Node)UnsafeAccess.UNSAFE.getObject(this, NEXT_OFFSET);
        }

        void lazySetNext(@Nullable Node<E> newNext) {
            UnsafeAccess.UNSAFE.putOrderedObject(this, NEXT_OFFSET, newNext);
        }

        public String toString() {
            return "Node[" + this.value + "]";
        }
    }

    static final class SerializationProxy<E>
    implements Serializable {
        final List<E> list;
        static final long serialVersionUID = 1L;

        SerializationProxy(SingleConsumerQueue<E> queue) {
            this.list = new ArrayList<E>(queue);
        }

        Object readResolve() {
            return new SingleConsumerQueue<E>(this.list);
        }
    }
}

