/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine;

import com.github.benmanes.caffeine.Beta;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@Beta
@ThreadSafe
public final class EliminationStack<E>
extends AbstractCollection<E>
implements Serializable {
    static final int NCPU = Runtime.getRuntime().availableProcessors();
    static final int ARENA_LENGTH = EliminationStack.ceilingNextPowerOfTwo((NCPU + 1) / 2);
    static int ARENA_MASK = ARENA_LENGTH - 1;
    static final int LOOKAHEAD = Math.min(4, NCPU);
    static final int SPINS = NCPU == 1 ? 0 : 2000;
    static final int SPINS_PER_STEP = SPINS / LOOKAHEAD;
    static final Object FREE = null;
    static final Object WAITER = new Object();
    final AtomicReference<Node<E>> top = new AtomicReference();
    final AtomicReference<Object>[] arena = new AtomicReference[ARENA_LENGTH];
    static final long serialVersionUID = 1L;

    static int ceilingNextPowerOfTwo(int x) {
        return 1 << 32 - Integer.numberOfLeadingZeros(x - 1);
    }

    public EliminationStack() {
        for (int i = 0; i < ARENA_LENGTH; ++i) {
            this.arena[i] = new AtomicReference();
        }
    }

    public EliminationStack(Collection<? extends E> c) {
        this();
        this.addAll(c);
    }

    @Override
    public boolean isEmpty() {
        while (true) {
            Node<E> node;
            if ((node = this.top.get()) == null) {
                return true;
            }
            Object e = node.get();
            if (e != null) break;
            this.top.compareAndSet(node, node.next);
        }
        return false;
    }

    @Override
    public int size() {
        int size = 0;
        Node<E> node = this.top.get();
        while (node != null) {
            if (node.get() != null) {
                ++size;
            }
            node = node.next;
        }
        return size;
    }

    @Override
    public void clear() {
        this.top.set(null);
    }

    @Override
    public boolean contains(@Nullable Object o) {
        Objects.requireNonNull(o);
        Node<E> node = this.top.get();
        while (node != null) {
            Object value = node.get();
            if (o.equals(value)) {
                return true;
            }
            node = node.next;
        }
        return false;
    }

    @Nullable
    public E peek() {
        Object e;
        while (true) {
            Node<E> node;
            if ((node = this.top.get()) == null) {
                return null;
            }
            e = node.get();
            if (e != null) break;
            this.top.compareAndSet(node, node.next);
        }
        return (E)e;
    }

    @Nullable
    public E pop() {
        E e;
        do {
            Node<E> current;
            if ((current = this.top.get()) == null) {
                return null;
            }
            if (this.top.get() != current || !this.top.compareAndSet(current, current.next)) continue;
            return (E)current.get();
        } while ((e = this.tryReceive()) == null);
        return e;
    }

    public void push(@Nonnull E e) {
        Objects.requireNonNull(e);
        Node<E> node = new Node<E>(e);
        do {
            node.next = this.top.get();
            if (this.top.get() != node.next || !this.top.compareAndSet(node.next, node)) continue;
            return;
        } while (!this.tryTransfer(e));
    }

    @Override
    public boolean add(E e) {
        this.push(e);
        return true;
    }

    @Override
    public boolean remove(Object o) {
        Objects.requireNonNull(o);
        Node<E> node = this.top.get();
        while (node != null) {
            Object value = node.get();
            if (o.equals(value) && node.compareAndSet(value, null)) {
                return true;
            }
            node = node.next;
        }
        return false;
    }

    @Override
    public Iterator<E> iterator() {
        return new StackIterator();
    }

    public Queue<E> asLifoQueue() {
        return new AsLifoQueue(this);
    }

    boolean tryTransfer(E e) {
        int start = EliminationStack.startIndex();
        return this.scanAndTransferToWaiter(e, start) || this.awaitExchange(e, start);
    }

    boolean scanAndTransferToWaiter(E e, int start) {
        for (int i = 0; i < ARENA_LENGTH; ++i) {
            int index = start + i & ARENA_MASK;
            AtomicReference<Object> slot = this.arena[index];
            if (slot.get() != WAITER || !slot.compareAndSet(WAITER, e)) continue;
            return true;
        }
        return false;
    }

    boolean awaitExchange(E e, int start) {
        int totalSpins = 0;
        block0: for (int step = 0; step < ARENA_LENGTH && totalSpins < SPINS; ++step) {
            int index = start + step & ARENA_MASK;
            AtomicReference<Object> slot = this.arena[index];
            Object found = slot.get();
            if (found == WAITER && slot.compareAndSet(WAITER, e)) {
                return true;
            }
            if (found != FREE || !slot.compareAndSet(FREE, e)) continue;
            int slotSpins = 0;
            while ((found = slot.get()) == e) {
                if (slotSpins >= SPINS_PER_STEP && slot.compareAndSet(e, FREE)) {
                    totalSpins += slotSpins;
                    continue block0;
                }
                ++slotSpins;
            }
            return true;
        }
        return false;
    }

    @Nullable
    E tryReceive() {
        int start = EliminationStack.startIndex();
        E e = this.scanAndMatch(start);
        return e == null ? this.awaitMatch(start) : e;
    }

    @Nullable
    E scanAndMatch(int start) {
        for (int i = 0; i < ARENA_LENGTH; ++i) {
            int index = start + i & ARENA_MASK;
            AtomicReference<Object> slot = this.arena[index];
            Object found = slot.get();
            if (found == FREE || found == WAITER || !slot.compareAndSet(found, FREE)) continue;
            Object e = found;
            return (E)e;
        }
        return null;
    }

    @Nullable
    E awaitMatch(int start) {
        int totalSpins = 0;
        block0: for (int step = 0; step < ARENA_LENGTH && totalSpins < SPINS; ++step) {
            int index = start + step & ARENA_MASK;
            AtomicReference<Object> slot = this.arena[index];
            Object found = slot.get();
            if (found == FREE) {
                if (!slot.compareAndSet(FREE, WAITER)) continue;
                int slotSpins = 0;
                while (true) {
                    if ((found = slot.get()) != WAITER && slot.compareAndSet(found, FREE)) {
                        Object e = found;
                        return (E)e;
                    }
                    if (slotSpins >= SPINS_PER_STEP && found == WAITER && slot.compareAndSet(WAITER, FREE)) {
                        totalSpins += slotSpins;
                        continue block0;
                    }
                    ++slotSpins;
                }
            }
            if (found == WAITER || !slot.compareAndSet(found, FREE)) continue;
            Object e = found;
            return (E)e;
        }
        return null;
    }

    static int startIndex() {
        int id = (int)Thread.currentThread().getId();
        return (id ^ 0x811C9DC5) * 16777619;
    }

    Object writeReplace() {
        return new SerializationProxy(this);
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Proxy required");
    }

    static class AsLifoQueue<E>
    extends AbstractQueue<E>
    implements Queue<E>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final EliminationStack<E> stack;

        AsLifoQueue(EliminationStack<E> stack) {
            this.stack = stack;
        }

        @Override
        public boolean offer(E e) {
            return this.stack.add(e);
        }

        @Override
        public E poll() {
            return this.stack.pop();
        }

        @Override
        public E peek() {
            return this.stack.peek();
        }

        @Override
        public void clear() {
            this.stack.clear();
        }

        @Override
        public int size() {
            return this.stack.size();
        }

        @Override
        public boolean isEmpty() {
            return this.stack.isEmpty();
        }

        @Override
        public boolean contains(@Nullable Object o) {
            return this.stack.contains(o);
        }

        @Override
        public boolean remove(Object o) {
            return this.stack.remove(o);
        }

        @Override
        public Iterator<E> iterator() {
            return this.stack.iterator();
        }
    }

    static final class Node<E>
    extends AtomicReference<E> {
        private static final long serialVersionUID = 1L;
        Node<E> next;

        Node(E value) {
            super(value);
        }
    }

    static final class SerializationProxy<E>
    implements Serializable {
        final List<E> elements;
        static final long serialVersionUID = 1L;

        SerializationProxy(EliminationStack<E> stack) {
            this.elements = new ArrayList<E>(stack);
        }

        Object readResolve() {
            Collections.reverse(this.elements);
            return new EliminationStack<E>(this.elements);
        }
    }

    final class StackIterator
    implements Iterator<E> {
        Node<E> cursor;
        Node<E> next;
        E nextValue;

        StackIterator() {
            this.next = EliminationStack.this.top.get();
            if (this.next != null) {
                this.nextValue = this.next.get();
            }
        }

        @Override
        public boolean hasNext() {
            if (this.nextValue != null) {
                return true;
            }
            if (this.next == null) {
                return false;
            }
            this.computeNext();
            return this.nextValue != null;
        }

        void computeNext() {
            do {
                this.next = this.next.next;
                if (this.next == null) break;
                this.nextValue = this.next.get();
            } while (this.nextValue == null);
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.cursor = this.next;
            Object value = this.nextValue;
            this.nextValue = null;
            return value;
        }

        @Override
        public void remove() {
            if (this.cursor == null) {
                throw new IllegalStateException();
            }
            this.cursor.lazySet(null);
            this.cursor = null;
        }
    }
}

