/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ecat.fuzzy;

import gnu.trove.TIntIntHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.gbif.ecat.fuzzy.FuzzyNameMatch;
import org.gbif.ecat.fuzzy.FuzzyNameMatcher;
import org.gbif.ecat.fuzzy.ScientificNameDistance;
import org.gbif.ecat.fuzzy.StringDistance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FuzzyNameMatcherMem
implements FuzzyNameMatcher {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private ArrayList<FuzzyNameMatch> names;
    private Map<Character, TIntIntHashMap> index = new HashMap<Character, TIntIntHashMap>();
    private Map<Character, Integer> maxLength = new HashMap<Character, Integer>();
    private StringDistance distanceAlgorithm = new ScientificNameDistance();

    public FuzzyNameMatcherMem(Collection<FuzzyNameMatch> names) {
        this.initialize(names);
    }

    @Override
    public void initialize(Collection<FuzzyNameMatch> names) {
        this.names = new ArrayList(names.size());
        for (FuzzyNameMatch n : names) {
            if (StringUtils.isBlank((CharSequence)n.name)) continue;
            n.name = n.name.toLowerCase().trim();
            this.names.add(n);
        }
        this.buildIndex();
    }

    private static Character indexChar(String name) {
        char craw = Character.toLowerCase(name.charAt(0));
        return craw > 'z' || craw < 'a' ? null : Character.valueOf(craw);
    }

    private void buildIndex() {
        long start = System.currentTimeMillis();
        Collections.sort(this.names, new NameInitialLengthComp());
        System.out.println("Sorting " + this.names.size() + " names took " + (System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        Character cIdx = Character.valueOf('a');
        this.index.put(null, new TIntIntHashMap());
        this.maxLength.put(null, 0);
        while (cIdx.charValue() <= 'z') {
            this.index.put(cIdx, new TIntIntHashMap());
            this.maxLength.put(cIdx, 0);
            Character c = cIdx;
            Character c2 = cIdx = Character.valueOf((char)(cIdx.charValue() + '\u0001'));
        }
        cIdx = Character.valueOf('a');
        int idx = 0;
        int lastLength = 0;
        for (FuzzyNameMatch n : this.names) {
            Character c = FuzzyNameMatcherMem.indexChar(n.name);
            while (cIdx != null && !cIdx.equals(c)) {
                Character c3 = cIdx;
                Character c4 = cIdx = Character.valueOf((char)(cIdx.charValue() + '\u0001'));
                if (cIdx.charValue() > 'z') {
                    cIdx = null;
                }
                lastLength = 0;
            }
            int l = n.name.length();
            while (l > lastLength) {
                this.index.get(c).put(++lastLength, idx);
                this.maxLength.put(c, lastLength);
            }
            ++idx;
        }
        this.log.info("Building index for " + this.names.size() + " names took " + (System.currentTimeMillis() - start));
    }

    @Override
    public List<FuzzyNameMatch> fuzzyMatch(String name, float maxDistance) {
        if ((double)maxDistance >= 1.0) {
            return this.straightMatch(name);
        }
        ArrayList<FuzzyNameMatch> matches = new ArrayList<FuzzyNameMatch>();
        if (StringUtils.isBlank((CharSequence)name) || (double)maxDistance <= 0.0) {
            return matches;
        }
        name = name.toLowerCase();
        int min = this.lowestIndex(name, maxDistance);
        int max = this.highestIndex(name, maxDistance);
        if (min < 0 || max <= 0 || min > max) {
            return matches;
        }
        for (int idx = min; idx <= max; ++idx) {
            FuzzyNameMatch n = this.names.get(idx);
            n.similarity = this.distanceAlgorithm.getDistance(name, n.name);
            if (!(n.similarity >= maxDistance)) continue;
            matches.add(n);
        }
        return matches;
    }

    private int highestIndex(String name, float distance) {
        Character c = FuzzyNameMatcherMem.indexChar(name);
        int maxInCache = this.maxLength.get(c);
        int delta = this.lengthDelta(name, distance);
        if (maxInCache < name.length() - delta) {
            return -1;
        }
        int max = name.length() + delta + 1;
        if (maxInCache < max) {
            max = maxInCache;
            if (c != null && c.charValue() == 'z') {
                return this.index.get(null).get(1) - 1;
            }
            return this.index.get(c).get(max);
        }
        return this.index.get(c).get(max) - 1;
    }

    protected int lengthDelta(String name, float distance) {
        if (distance > 0.0f && distance < 1.0f) {
            return (int)((float)name.length() * (1.0f - distance)) + 1;
        }
        return 0;
    }

    private int lowestIndex(String name, float distance) {
        Character c = FuzzyNameMatcherMem.indexChar(name);
        int minLength = name.length() - this.lengthDelta(name, distance);
        if (minLength < 0) {
            minLength = 0;
        }
        return this.index.get(c).get(minLength);
    }

    @Override
    public List<FuzzyNameMatch> straightMatch(String name) {
        int idx;
        ArrayList<FuzzyNameMatch> matches = new ArrayList<FuzzyNameMatch>();
        if (StringUtils.isBlank((CharSequence)name)) {
            return matches;
        }
        int min = this.lowestIndex(name, 1.0f);
        int max = this.highestIndex(name, 1.0f);
        if (min < 0 || max < 0) {
            return matches;
        }
        name = name.toLowerCase();
        int mid = min + (max - min) / 2;
        while (max - min > 1) {
            mid = min + (max - min) / 2;
            int comp = name.compareTo(this.names.get((int)mid).name);
            if (comp == 0) break;
            if (comp < 0) {
                max = mid;
                continue;
            }
            if (comp <= 0) continue;
            min = mid;
        }
        FuzzyNameMatch n = this.names.get(mid);
        if (n.name.equals(name)) {
            matches.add(n);
        }
        for (idx = mid + 1; idx <= max; ++idx) {
            n = this.names.get(idx);
            if (!n.name.equals(name)) break;
            matches.add(n);
        }
        for (idx = mid - 1; idx >= min; --idx) {
            n = this.names.get(idx);
            if (!n.name.equals(name)) break;
            matches.add(n);
        }
        return matches;
    }

    public static class NameInitialLengthComp
    implements Comparator<FuzzyNameMatch> {
        private static int A_INT = 97;
        private static int Z_INT = 122;
        private static int OTHER_INT = 200;

        @Override
        public int compare(FuzzyNameMatch o1, FuzzyNameMatch o2) {
            int l2;
            int c2;
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null || StringUtils.isBlank((CharSequence)o1.name)) {
                return 1;
            }
            if (o2 == null || StringUtils.isBlank((CharSequence)o2.name)) {
                return -1;
            }
            Character char1 = FuzzyNameMatcherMem.indexChar(o1.name);
            int c1 = char1 == null ? OTHER_INT : (int)char1.charValue();
            Character char2 = FuzzyNameMatcherMem.indexChar(o2.name);
            int n = c2 = char2 == null ? OTHER_INT : (int)char2.charValue();
            if (c1 != c2) {
                return c1 - c2;
            }
            int l1 = o1.name.length();
            if (l1 != (l2 = o2.name.length())) {
                return l1 - l2;
            }
            return o1.name.compareTo(o2.name);
        }
    }
}

