/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ecat.cfg;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.gbif.ecat.cfg.DataDirConfigFactory;
import org.gbif.utils.file.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataDirConfig {
    protected static final Logger log = LoggerFactory.getLogger(DataDirConfig.class);
    protected static final String TMP_DIR = "tmp";
    protected static final String LOGGING_DIR = "logging";
    private static final String IMPORT_DIR = "checklists";
    private static final String LUCENE_DIR = "lucene";
    public static final String SESSION_USER = "user";
    protected static final String EXPORT_DIR = "export";
    protected Properties properties;
    protected File dataDir;

    private DataDirConfig() {
    }

    public DataDirConfig(InputStream configStream) throws IOException {
        this.properties = new Properties();
        this.properties.load(configStream);
        this.setDataDir(this.properties.getProperty("app.dataDir"));
        log.info("Using DATA DIRECTORY: " + this.dataDir());
    }

    public DataDirConfig(Properties properties) throws IOException {
        this.properties = properties;
        this.setDataDir(properties.getProperty("app.dataDir"));
        log.info("Using DATA DIRECTORY: " + this.dataDir());
    }

    public static void main(String[] args) {
        DataDirConfigFactory f = new DataDirConfigFactory();
        DataDirConfig cfg = f.getCfg();
    }

    @Deprecated
    public static File systemClasspathFile(String path) {
        File f = null;
        URL url = ClassLoader.getSystemResource(path);
        if (url != null) {
            f = new File(url.getFile());
        }
        return f;
    }

    public static InputStream systemClasspathStream(String path) {
        InputStream in = null;
        URL url = ClassLoader.getSystemResource(path);
        if (url != null) {
            try {
                in = url.openStream();
            }
            catch (IOException e) {
                log.warn("Cannot open system classpath stream " + path, (Throwable)e);
            }
        }
        return in;
    }

    public InputStream classpathStream(String path) {
        InputStream in = null;
        URL url = this.getClass().getClassLoader().getResource(path);
        if (url != null) {
            try {
                in = url.openStream();
            }
            catch (IOException e) {
                log.warn("Cannot open classpath stream " + path, (Throwable)e);
            }
        }
        return in;
    }

    public File dataDir() {
        return this.dataDir;
    }

    public File dataFile(String path) {
        if (path.startsWith("/")) {
            return new File(path);
        }
        return new File(this.dataDir, path);
    }

    public String domain() {
        String base = this.properties.getProperty("app.domain");
        while (base.endsWith("/")) {
            base = base.substring(0, base.length() - 1);
        }
        return base;
    }

    public File exportFile(String path) {
        return this.dataFile("export/" + path);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getProperty(String property) {
        return this.properties.getProperty(property);
    }

    public Integer getPropertyAsInteger(String property) {
        try {
            return Integer.valueOf(this.properties.getProperty(property));
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public File importDir() {
        return new File(this.dataDir, IMPORT_DIR);
    }

    public File importDir(Integer resourceID) {
        return new File(this.dataDir, "checklists/" + resourceID.toString());
    }

    public File importFile(Integer resourceID, String filename) {
        return new File(this.importDir(resourceID), filename);
    }

    public File loggingDir() {
        return this.dataFile(LOGGING_DIR);
    }

    public File loggingFile(String path) {
        return this.dataFile("logging/" + path);
    }

    public File luceneDir() {
        return this.dataFile(LUCENE_DIR);
    }

    public File luceneFile(String path) {
        return this.dataFile("lucene/" + path);
    }

    public void setDataDir(String datadir) {
        while (datadir.endsWith("/")) {
            datadir = datadir.substring(0, datadir.length() - 1);
        }
        if (datadir.startsWith("/")) {
            this.dataDir = new File(datadir);
        } else {
            log.warn("DataDir is a unpredictable relative path");
            this.dataDir = new File(datadir);
        }
    }

    public void setProperty(String property, String value) {
        this.properties.setProperty(property, value);
    }

    public File tmpDir() {
        return this.dataFile(TMP_DIR);
    }

    public File tmpFile(String path) {
        return this.dataFile("tmp/" + path);
    }

    public File tmpFile(URL url) {
        return this.dataFile("tmp/" + FileUtils.toFilePath((URL)url));
    }
}

