/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.utils.number;

import com.google.common.base.Preconditions;
import java.math.BigDecimal;

public class BigDecimalUtils {
    private BigDecimalUtils() {
    }

    public static BigDecimal fromDouble(Double value, boolean stripTrailingZeros) {
        Preconditions.checkNotNull((Object)value);
        BigDecimal bd = new BigDecimal(Double.toString(value));
        if (stripTrailingZeros && bd.remainder(BigDecimal.ONE).movePointRight(bd.scale()).intValue() == 0) {
            bd = new BigDecimal(value.intValue());
        }
        return bd;
    }
}

