/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.tool;

import au.com.bytecode.opencsv.CSVReader;
import au.com.bytecode.opencsv.CSVWriter;
import au.org.ala.biocache.Config$;
import au.org.ala.biocache.caches.LocationDAO$;
import au.org.ala.biocache.index.BulkProcessor$;
import au.org.ala.biocache.model.QualityAssertion;
import au.org.ala.biocache.processor.LocationProcessor;
import au.org.ala.biocache.tool.LoadSamplingConsumer;
import au.org.ala.biocache.tool.LocColumnExporter;
import au.org.ala.biocache.tool.PointsReader;
import au.org.ala.biocache.tool.Sampling$;
import au.org.ala.biocache.util.FileHelper$;
import au.org.ala.biocache.util.GISPoint;
import au.org.ala.biocache.util.Json$;
import au.org.ala.biocache.util.LayersStore;
import au.org.ala.layers.client.Client;
import au.org.ala.layers.dao.IntersectCallback;
import au.org.ala.layers.dao.LayerIntersectDAO;
import au.org.ala.layers.dto.IntersectionFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.Null$;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.StringAdd$;

@ScalaSignature(bytes="\u0006\u0001\t%q!B\u0001\u0003\u0011\u0003i\u0011\u0001C*b[Bd\u0017N\\4\u000b\u0005\r!\u0011\u0001\u0002;p_2T!!\u0002\u0004\u0002\u0011\tLwnY1dQ\u0016T!a\u0002\u0005\u0002\u0007\u0005d\u0017M\u0003\u0002\n\u0015\u0005\u0019qN]4\u000b\u0003-\t!!Y;\u0004\u0001A\u0011abD\u0007\u0002\u0005\u0019)\u0001C\u0001E\u0001#\tA1+Y7qY&twm\u0005\u0003\u0010%aq\u0002CA\n\u0017\u001b\u0005!\"\"A\u000b\u0002\u000bM\u001c\u0017\r\\1\n\u0005]!\"AB!osJ+g\r\u0005\u0002\u001a95\t!D\u0003\u0002\u001c\t\u0005\u00191-\u001c3\n\u0005uQ\"\u0001\u0002+p_2\u0004\"!G\u0010\n\u0005\u0001R\"aD%oGJ,W.\u001a8uC2$vn\u001c7\t\u000b\tzA\u0011A\u0012\u0002\rqJg.\u001b;?)\u0005i\u0001\"B\u000e\u0010\t\u0003)S#\u0001\u0014\u0011\u0005\u001dbS\"\u0001\u0015\u000b\u0005%R\u0013\u0001\u00027b]\u001eT\u0011aK\u0001\u0005U\u00064\u0018-\u0003\u0002.Q\t11\u000b\u001e:j]\u001eDQaL\b\u0005\u0002\u0015\nA\u0001Z3tG\"9\u0011g\u0004b\u0001\n#\u0011\u0014A\u00027pO\u001e,'/F\u00014!\t!\u0004(D\u00016\u0015\t1t'A\u0003tY\u001a$$NC\u0001\n\u0013\tITG\u0001\u0004M_\u001e<WM\u001d\u0005\u0007w=\u0001\u000b\u0011B\u001a\u0002\u000f1|wmZ3sA!)Qh\u0004C\u0001}\u0005!Q.Y5o)\ty$\t\u0005\u0002\u0014\u0001&\u0011\u0011\t\u0006\u0002\u0005+:LG\u000fC\u0003Dy\u0001\u0007A)\u0001\u0003be\u001e\u001c\bcA\nF\u000f&\u0011a\t\u0006\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003\u0011.s!aE%\n\u0005)#\u0012A\u0002)sK\u0012,g-\u0003\u0002.\u0019*\u0011!\n\u0006\u0005\u0006\u001d>!\taT\u0001\u001cY>\fGmU1na2LgnZ%oi>|5mY;se\u0016t7-Z:\u0015\u0005}\u0002\u0006\"B)N\u0001\u00049\u0015a\u00043bi\u0006\u0014Vm]8ve\u000e,W+\u001b3\t\u000bM{A\u0011\u0001+\u0002%M\fW\u000e\u001d7f\t\u0006$\u0018MU3t_V\u00148-\u001a\u000b\u0005\u007fU3\u0006\rC\u0003R%\u0002\u0007q\tC\u0004X%B\u0005\t\u0019\u0001-\u0002\u0011\r\fG\u000e\u001c2bG.\u0004\"!\u00170\u000e\u0003iS!a\u0017/\u0002\u0007\u0011\fwN\u0003\u0002^\r\u00051A.Y=feNL!a\u0018.\u0003#%sG/\u001a:tK\u000e$8)\u00197mE\u0006\u001c7\u000eC\u0004b%B\u0005\t\u0019A$\u0002\u001fMLgn\u001a7f\u0019\u0006LXM\u001d(b[\u0016DqaY\b\u0012\u0002\u0013\u0005A-\u0001\u000ftC6\u0004H.\u001a#bi\u0006\u0014Vm]8ve\u000e,G\u0005Z3gCVdG\u000f\n\u001a\u0016\u0003\u0015T#\u0001\u00174,\u0003\u001d\u0004\"\u0001[7\u000e\u0003%T!A[6\u0002\u0013Ut7\r[3dW\u0016$'B\u00017\u0015\u0003)\tgN\\8uCRLwN\\\u0005\u0003]&\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011\u001d\u0001x\"%A\u0005\u0002E\fAd]1na2,G)\u0019;b%\u0016\u001cx.\u001e:dK\u0012\"WMZ1vYR$3'F\u0001sU\t9eM\u0002\u0003\u0011\u0005\u0001!8CA:\u0013\u0011\u0015\u00113\u000f\"\u0001w)\u00059\bC\u0001\bt\u0011\u001d\t4O1A\u0005\u0002IBaaO:!\u0002\u0013\u0019\u0004\"B>t\t\u0003a\u0018A\u00055b]\u0012dW\rT1u\u0019>tw-\u00138NCB$baP?\u0002\u0006\u0005e\u0001\"\u0002@{\u0001\u0004y\u0018aA7baB)\u0001*!\u0001H\u000f&\u0019\u00111\u0001'\u0003\u00075\u000b\u0007\u000fC\u0004\u0002\bi\u0004\r!!\u0003\u0002\u0017\r|wN\u001d3j]\u0006$Xm\u001d\t\u0006\u0003\u0017\t)bR\u0007\u0003\u0003\u001bQA!a\u0004\u0002\u0012\u00059Q.\u001e;bE2,'bAA\n)\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005]\u0011Q\u0002\u0002\b\u0011\u0006\u001c\bnU3u\u0011\u001d\tYB\u001fa\u0001\u0003;\t!\u0001\u001c9\u0011\t\u0005}\u0011QE\u0007\u0003\u0003CQ1!a\t\u0005\u0003%\u0001(o\\2fgN|'/\u0003\u0003\u0002(\u0005\u0005\"!\u0005'pG\u0006$\u0018n\u001c8Qe>\u001cWm]:pe\"9\u00111F:\u0005\u0002\u00055\u0012a\u00045b]\u0012dWMU3d_J$W*\u00199\u0015\u000f}\ny#!\r\u00024!1a0!\u000bA\u0002}D\u0001\"a\u0002\u0002*\u0001\u0007\u0011\u0011\u0002\u0005\t\u00037\tI\u00031\u0001\u0002\u001e!I\u0011qG:C\u0002\u0013\u0005\u0011\u0011H\u0001\u000baJ|\u0007/\u001a:uS\u0016\u001cXCAA\u001e!\r\u0019RI\n\u0005\t\u0003\u007f\u0019\b\u0015!\u0003\u0002<\u0005Y\u0001O]8qKJ$\u0018.Z:!\u0011\u001d\t\u0019e\u001dC\u0001\u0003\u000b\nqdZ3u\t&\u001cH/\u001b8di\u000e{wN\u001d3j]\u0006$Xm\u001d$peJ{woS3z)\ry\u0014q\t\u0005\b\u0003\u0013\n\t\u00051\u0001H\u0003\u0019\u0011xn^&fs\"9\u0011QJ:\u0005\u0002\u0005=\u0013!H4fi\u0012K7\u000f^5oGR\u001cun\u001c:eS:\fG/Z:G_J4\u0015\u000e\\3\u0015\u000b}\n\t&!\u0016\t\u000f\u0005M\u00131\na\u0001\u000f\u0006YAn\\2GS2,\u0007+\u0019;i\u0011\u001d\t9&a\u0013A\u0002\u001d\u000b!B]8x\u0017\u0016Lh)\u001b7f\u0011\u001d\tYf\u001dC\u0001\u0003;\n\u0011fZ3u\t&\u001cH/\u001b8di\u000e{wN\u001d3j]\u0006$Xm\u001d$peJ+7o\\;sG\u0016$\u0006N]3bI\u0016$GcB \u0002`\u0005%\u00141\u000e\u0005\t\u0003C\nI\u00061\u0001\u0002d\u0005Qa.^7UQJ,\u0017\rZ:\u0011\u0007M\t)'C\u0002\u0002hQ\u00111!\u00138u\u0011\u001d\t\u0019&!\u0017A\u0002\u001dC\u0001\"UA-!\u0003\u0005\ra\u0012\u0005\b\u0003_\u001aH\u0011AA9\u0003!\u0019\u0018-\u001c9mS:<GcD \u0002t\u0005]\u00141PA?\u0003\u007f\n\u0019)!$\t\u000f\u0005U\u0014Q\u000ea\u0001\u000f\u0006Aa-\u001b7f!\u0006$\b\u000eC\u0004\u0002z\u00055\u0004\u0019A$\u0002\u001d=,H\u000f];u\r&dW\rU1uQ\"Aq+!\u001c\u0011\u0002\u0003\u0007\u0001\f\u0003\u0005b\u0003[\u0002\n\u00111\u0001H\u0011)\t\t)!\u001c\u0011\u0002\u0003\u0007\u00111M\u0001\nE\u0006$8\r[*ju\u0016D!\"!\"\u0002nA\u0005\t\u0019AAD\u0003E\u0019wN\\2veJ,g\u000e\u001e'pC\u0012Lgn\u001a\t\u0004'\u0005%\u0015bAAF)\t9!i\\8mK\u0006t\u0007BCAH\u0003[\u0002\n\u00111\u0001\u0002\b\u0006I1.Z3q\r&dWm\u001d\u0005\b\u0003'\u001bH\u0011BAK\u00031\u0001(o\\2fgN\u0014\u0015\r^2i)%y\u0014qSAX\u0003{\u000b\t\r\u0003\u0005\u0002\u001a\u0006E\u0005\u0019AAN\u0003\u00199(/\u001b;feB!\u0011QTAV\u001b\t\tyJ\u0003\u0003\u0002\"\u0006\r\u0016aB8qK:\u001c7O\u001e\u0006\u0005\u0003K\u000b9+\u0001\u0005csR,7m\u001c3f\u0015\r\tIKC\u0001\u0004G>l\u0017\u0002BAW\u0003?\u0013\u0011bQ*W/JLG/\u001a:\t\u0011\u0005E\u0016\u0011\u0013a\u0001\u0003g\u000ba\u0001]8j]R\u001c\b\u0003B\nF\u0003k\u0003BaE#\u00028B\u00191#!/\n\u0007\u0005mFC\u0001\u0004E_V\u0014G.\u001a\u0005\b\u0003\u007f\u000b\t\n1\u0001E\u0003\u00191\u0017.\u001a7eg\"Aq+!%\u0011\u0002\u0003\u0007\u0001\fC\u0004\u0002FN$I!a2\u0002%A\u0014xnY3tg\n\u000bGo\u00195SK6|G/\u001a\u000b\n\u007f\u0005%\u00171ZAg\u0003\u001fD\u0001\"!'\u0002D\u0002\u0007\u00111\u0014\u0005\t\u0003c\u000b\u0019\r1\u0001\u00024\"9\u0011qXAb\u0001\u0004!\u0005\u0002C,\u0002DB\u0005\t\u0019\u0001-\t\u000f\u0005M7\u000f\"\u0001\u0002V\u0006aAn\\1e'\u0006l\u0007\u000f\\5oOR)q(a6\u0002\\\"9\u0011\u0011\\Ai\u0001\u00049\u0015!D5oaV$h)\u001b7f\u001d\u0006lW\r\u0003\u0005X\u0003#\u0004\n\u00111\u0001Y\u0011!\tyn]I\u0001\n\u0003\t\u0018aM4fi\u0012K7\u000f^5oGR\u001cun\u001c:eS:\fG/Z:G_J\u0014Vm]8ve\u000e,G\u000b\u001b:fC\u0012,G\r\n3fM\u0006,H\u000e\u001e\u00134\u0011!\t\u0019o]I\u0001\n\u0003!\u0017AE:b[Bd\u0017N\\4%I\u00164\u0017-\u001e7uIMB\u0001\"a:t#\u0003%\t!]\u0001\u0013g\u0006l\u0007\u000f\\5oO\u0012\"WMZ1vYR$C\u0007C\u0005\u0002lN\f\n\u0011\"\u0001\u0002n\u0006\u00112/Y7qY&tw\r\n3fM\u0006,H\u000e\u001e\u00136+\t\tyOK\u0002\u0002d\u0019D\u0011\"a=t#\u0003%\t!!>\u0002%M\fW\u000e\u001d7j]\u001e$C-\u001a4bk2$HEN\u000b\u0003\u0003oT3!a\"g\u0011%\tYp]I\u0001\n\u0003\t)0\u0001\ntC6\u0004H.\u001b8hI\u0011,g-Y;mi\u0012:\u0004\u0002CA\u0000gF\u0005I\u0011\u00013\u0002-1|\u0017\rZ*b[Bd\u0017N\\4%I\u00164\u0017-\u001e7uIIB\u0001Ba\u0001t#\u0003%I\u0001Z\u0001\u001daJ|7-Z:t\u0005\u0006$8\r\u001b*f[>$X\r\n3fM\u0006,H\u000e\u001e\u00135\u0011!\u00119a]I\u0001\n\u0013!\u0017A\u00069s_\u000e,7o\u001d\"bi\u000eDG\u0005Z3gCVdG\u000f\n\u001b")
public class Sampling {
    private final Logger logger = LoggerFactory.getLogger((String)"Sampling");
    private final String[] properties = (String[])((Object[])new String[]{"decimalLatitude", "decimalLongitude", "decimalLatitude.p", "decimalLongitude.p", "verbatimLatitude", "verbatimLongitude", "originalDecimalLatitude", "originalDecimalLongitude", "originalSensitiveValues", "geodeticDatum", "verbatimSRS", "easting", "northing", "zone"});

    public static String help() {
        return Sampling$.MODULE$.help();
    }

    public static Tuple2<Object, Option<String>> hasRowKey(String string) {
        return Sampling$.MODULE$.hasRowKey(string);
    }

    public static Option<String> getDeleteRowFile(String string) {
        return Sampling$.MODULE$.getDeleteRowFile(string);
    }

    public static String sampleDataResource$default$3() {
        return Sampling$.MODULE$.sampleDataResource$default$3();
    }

    public static IntersectCallback sampleDataResource$default$2() {
        return Sampling$.MODULE$.sampleDataResource$default$2();
    }

    public static void sampleDataResource(String string, IntersectCallback intersectCallback, String string2) {
        Sampling$.MODULE$.sampleDataResource(string, intersectCallback, string2);
    }

    public static void loadSamplingIntoOccurrences(String string) {
        Sampling$.MODULE$.loadSamplingIntoOccurrences(string);
    }

    public static void main(String[] stringArray) {
        Sampling$.MODULE$.main(stringArray);
    }

    public static String desc() {
        return Sampling$.MODULE$.desc();
    }

    public static String cmd() {
        return Sampling$.MODULE$.cmd();
    }

    public Logger logger() {
        return this.logger;
    }

    public void handleLatLongInMap(scala.collection.immutable.Map<String, String> map, HashSet<String> coordinates, LocationProcessor lp) {
        Option<GISPoint> option;
        block4: {
            block3: {
                block2: {
                    Option<GISPoint> latLongWithOption = lp.processLatLong((String)map.getOrElse((Object)"decimalLatitude", (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Null$ apply() {
                            return null;
                        }
                    }), (String)map.getOrElse((Object)"decimalLongitude", (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Null$ apply() {
                            return null;
                        }
                    }), (String)map.getOrElse((Object)"geodeticDatum", (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Null$ apply() {
                            return null;
                        }
                    }), (String)map.getOrElse((Object)"verbatimLongitude", (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Null$ apply() {
                            return null;
                        }
                    }), (String)map.getOrElse((Object)"verbatimLongitude", (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Null$ apply() {
                            return null;
                        }
                    }), (String)map.getOrElse((Object)"verbatimSRS", (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Null$ apply() {
                            return null;
                        }
                    }), (String)map.getOrElse((Object)"easting", (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Null$ apply() {
                            return null;
                        }
                    }), (String)map.getOrElse((Object)"northing", (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Null$ apply() {
                            return null;
                        }
                    }), (String)map.getOrElse((Object)"zone", (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Null$ apply() {
                            return null;
                        }
                    }), (String)map.getOrElse((Object)"gridReference", (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Null$ apply() {
                            return null;
                        }
                    }), (ArrayBuffer<QualityAssertion>)new ArrayBuffer());
                    option = latLongWithOption;
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    GISPoint latLong = (GISPoint)some.x();
                    coordinates.$plus$eq((Object)new StringBuilder().append((Object)latLong.longitude()).append((Object)",").append((Object)latLong.latitude()).toString());
                    coordinates.$plus$eq((Object)new StringBuilder().append((Object)((Object)BoxesRunTime.boxToFloat((float)new StringOps(Predef$.MODULE$.augmentString(latLong.longitude())).toFloat())).toString().trim()).append((Object)",").append((Object)((Object)BoxesRunTime.boxToFloat((float)new StringOps(Predef$.MODULE$.augmentString(latLong.latitude())).toFloat())).toString().trim()).toString());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option<GISPoint> option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError(option);
    }

    /*
     * Unable to fully structure code
     */
    public void handleRecordMap(scala.collection.immutable.Map<String, String> map, HashSet<String> coordinates, LocationProcessor lp) {
        this.handleLatLongInMap(map, coordinates, lp);
        v0 = originalSensitiveValues = (String)map.getOrElse((Object)"originalSensitiveValues", (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        });
        var5_5 = "";
        if (v0 == null ? var5_5 != null : v0.equals(var5_5) == false) {
            sensitiveLatLong = Json$.MODULE$.toMap(originalSensitiveValues);
            lat = sensitiveLatLong.getOrElse((Object)"decimalLatitude", (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Null$ apply() {
                    return null;
                }
            });
            lon = sensitiveLatLong.getOrElse((Object)"decimalLongitude", (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Null$ apply() {
                    return null;
                }
            });
            if (lat != null && lon != null) {
                coordinates.$plus$eq((Object)new StringBuilder().append((Object)StringAdd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd(lon), ",")).append(lat).toString());
                newMap = map.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"decimalLatitude"), (Object)lat.toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"decimalLongitude"), (Object)lon.toString())})));
                this.handleLatLongInMap((scala.collection.immutable.Map<String, String>)newMap, coordinates, lp);
            }
        }
        originalDecimalLatitude = (String)map.getOrElse((Object)"originalDecimalLatitude", (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        });
        originalDecimalLongitude = (String)map.getOrElse((Object)"originalDecimalLongitude", (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        });
        v1 = originalDecimalLatitude;
        var12_12 = "";
        if (!(v1 == null ? var12_12 != null : v1.equals(var12_12) == false)) ** GOTO lbl-1000
        v2 = originalDecimalLongitude;
        var13_13 = "";
        if (!(v2 != null ? v2.equals(var13_13) == false : var13_13 != null)) lbl-1000:
        // 2 sources

        {
            v3 = BoxedUnit.UNIT;
        } else {
            v3 = coordinates.$plus$eq((Object)new StringBuilder().append((Object)originalDecimalLongitude).append((Object)",").append((Object)originalDecimalLatitude).toString());
        }
        processedDecimalLatitude = (String)map.getOrElse((Object)"decimalLatitude.p", (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        });
        processedDecimalLongitude = (String)map.getOrElse((Object)"decimalLongitude.p", (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        });
        v4 = processedDecimalLatitude;
        var16_16 = "";
        if (v4 == null ? var16_16 != null : v4.equals(var16_16) == false) {
            v5 = processedDecimalLongitude;
            var17_17 = "";
            if (v5 == null ? var17_17 != null : v5.equals(var17_17) == false) {
                coordinates.$plus$eq((Object)new StringBuilder().append((Object)processedDecimalLongitude).append((Object)",").append((Object)processedDecimalLatitude).toString());
            }
        }
    }

    public String[] properties() {
        return this.properties;
    }

    public void getDistinctCoordinatesForRowKey(String rowKey) {
        Option<scala.collection.immutable.Map<String, String>> values = Config$.MODULE$.persistenceManager().getSelected(rowKey, "occ", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])this.properties()));
        if (values.isDefined()) {
            HashSet coordinates = new HashSet();
            this.handleRecordMap((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)values.get()), (HashSet<String>)coordinates, new LocationProcessor());
            Predef$.MODULE$.println((Object)coordinates);
        }
    }

    public void getDistinctCoordinatesForFile(String locFilePath, String rowKeyFile) {
        this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Creating distinct list of coordinates for row keys in ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rowKeyFile})));
        IntRef counter = new IntRef(0);
        IntRef passed = new IntRef(0);
        File rowKeys = new File(rowKeyFile);
        HashSet coordinates = new HashSet();
        LocationProcessor lp = new LocationProcessor();
        FileHelper$.MODULE$.file2helper(rowKeys).foreachLine((Function1<String, BoxedUnit>)new Serializable(this, counter, passed, coordinates, lp){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Sampling $outer;
            private final IntRef counter$1;
            private final IntRef passed$1;
            private final HashSet coordinates$1;
            private final LocationProcessor lp$1;

            public final void apply(String line) {
                Option<scala.collection.immutable.Map<String, String>> values = Config$.MODULE$.persistenceManager().getSelected(line, "occ", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])this.$outer.properties()));
                if (values.isDefined()) {
                    this.$outer.handleRecordMap((scala.collection.immutable.Map<String, String>)this.map$1(values), (HashSet<String>)this.coordinates$1, this.lp$1);
                    if (this.counter$1.elem % 10000 == 0 && this.counter$1.elem > 0) {
                        this.$outer.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Distinct coordinates counter: ", " , current count: ", ".size"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.counter$1.elem), this.coordinates$1})));
                    }
                    ++this.counter$1.elem;
                    ++this.passed$1.elem;
                }
            }

            private final scala.collection.immutable.Map map$1(Option values$1) {
                return (scala.collection.immutable.Map)values$1.get();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.counter$1 = counter$1;
                this.passed$1 = passed$1;
                this.coordinates$1 = coordinates$1;
                this.lp$1 = lp$1;
            }
        });
        try {
            FileWriter fw = new FileWriter(locFilePath);
            coordinates.foreach((Function1)new Serializable(this, fw){
                public static final long serialVersionUID = 0L;
                private final FileWriter fw$1;

                public final void apply(String c) {
                    this.fw$1.write(c);
                    this.fw$1.write("\n");
                }
                {
                    this.fw$1 = fw$1;
                }
            });
            fw.flush();
            fw.close();
        }
        catch (Exception exception) {
            this.logger().error(new StringBuilder().append((Object)"Failed to write - ").append((Object)exception.getMessage()).toString(), (Throwable)exception);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void getDistinctCoordinatesForResourceThreaded(int numThreads, String locFilePath, String dataResourceUid) {
        Tuple3 tuple33;
        Tuple3 tuple3;
        this.logger().info("Creating distinct list of coordinates....");
        boolean passed = false;
        String string = dataResourceUid;
        String string2 = "";
        String startUuid = !(string != null ? !string.equals(string2) : string2 != null) ? "" : new StringBuilder().append((Object)dataResourceUid).append((Object)"|").toString();
        String string3 = dataResourceUid;
        String string4 = "";
        String endUuid = !(string3 != null ? !string3.equals(string4) : string4 != null) ? "" : new StringBuilder().append((Object)dataResourceUid).append((Object)"|~").toString();
        String string5 = dataResourceUid;
        String string6 = "";
        Tuple3 tuple32 = !(string5 != null ? !string5.equals(string6) : string6 != null) ? new Tuple3((Object)"*:*", (Object)"", (Object)"") : (tuple3 = new Tuple3((Object)new StringBuilder().append((Object)"data_resource_uid:").append((Object)dataResourceUid).toString(), (Object)new StringBuilder().append((Object)dataResourceUid).append((Object)"|").toString(), (Object)new StringBuilder().append((Object)dataResourceUid).append((Object)"|~").toString()));
        if (tuple3 == null) throw new MatchError((Object)tuple3);
        String query = (String)tuple3._1();
        String start = (String)tuple3._2();
        String end = (String)tuple3._3();
        Tuple3 tuple34 = tuple33 = new Tuple3((Object)query, (Object)start, (Object)end);
        String query2 = (String)tuple34._1();
        String start2 = (String)tuple34._2();
        String end2 = (String)tuple34._3();
        Tuple2<String, String>[] ranges = BulkProcessor$.MODULE$.calculateRanges(numThreads, query2, start2, end2);
        IntRef counter = new IntRef(0);
        ArrayBuffer threads = new ArrayBuffer();
        ArrayBuffer solrDirs = new ArrayBuffer();
        Predef$.MODULE$.refArrayOps((Object[])ranges).foreach((Function1)new Serializable(this, counter, threads){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Sampling $outer;
            private final IntRef counter$2;
            private final ArrayBuffer threads$1;

            public final void apply(Tuple2<String, String> x0$1) {
                Tuple2<String, String> tuple2 = x0$1;
                if (tuple2 != null) {
                    String startKey = (String)tuple2._1();
                    String endKey = (String)tuple2._2();
                    this.$outer.logger().info(new StringBuilder().append((Object)"start: ").append((Object)startKey).append((Object)", end key: ").append((Object)endKey).toString());
                    LocColumnExporter t = new LocColumnExporter(this.counter$2.elem, startKey, endKey, (Function3<scala.collection.immutable.Map<String, String>, HashSet<String>, LocationProcessor, BoxedUnit>)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$getDistinctCoordinatesForResourceThreaded$1 $outer;

                        public final void apply(scala.collection.immutable.Map<String, String> map, HashSet<String> coordinates, LocationProcessor lp) {
                            this.$outer.au$org$ala$biocache$tool$Sampling$$anonfun$$$outer().handleRecordMap(map, coordinates, lp);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    });
                    t.start();
                    this.threads$1.$plus$eq((Object)t);
                    ++this.counter$2.elem;
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }

            public /* synthetic */ Sampling au$org$ala$biocache$tool$Sampling$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.counter$2 = counter$2;
                this.threads$1 = threads$1;
            }
        });
        threads.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(LocColumnExporter thread) {
                thread.join();
            }
        });
        ObjectRef coordinates = new ObjectRef((Object)((Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)));
        threads.foreach((Function1)new Serializable(this, coordinates){
            public static final long serialVersionUID = 0L;
            private final ObjectRef coordinates$2;

            public final void apply(LocColumnExporter t) {
                this.coordinates$2.elem = (Set)((Set)this.coordinates$2.elem).$plus$plus(t.coordinates());
                t.coordinates().clear();
            }
            {
                this.coordinates$2 = coordinates$2;
            }
        });
        this.logger().info(new StringBuilder().append((Object)"All unique coordinates size: ").append((Object)BoxesRunTime.boxToInteger((int)((Set)coordinates.elem).size())).toString());
        try {
            FileWriter fw = new FileWriter(locFilePath);
            ((Set)coordinates.elem).foreach((Function1)new Serializable(this, fw){
                public static final long serialVersionUID = 0L;
                private final FileWriter fw$2;

                public final void apply(String c) {
                    this.fw$2.write(c);
                    this.fw$2.write("\n");
                }
                {
                    this.fw$2 = fw$2;
                }
            });
            fw.flush();
            fw.close();
            return;
        }
        catch (Exception exception) {
            this.logger().error(exception.getMessage(), (Throwable)exception);
        }
    }

    public String getDistinctCoordinatesForResourceThreaded$default$3() {
        return "";
    }

    public void sampling(String filePath, String outputFilePath, IntersectCallback callback, String singleLayerName, int batchSize, boolean concurrentLoading, boolean keepFiles) {
        this.logger().info("********* START - TEST BATCH SAMPLING FROM FILE ***************");
        PointsReader pointsReader = new PointsReader(filePath);
        String string = singleLayerName;
        String string2 = "";
        String[] fields = !(string != null ? !string.equals(string2) : string2 != null) ? Config$.MODULE$.fieldsToSample(Config$.MODULE$.fieldsToSample$default$1()) : (String[])((Object[])new String[]{singleLayerName});
        String filename = outputFilePath;
        CSVWriter writer = new CSVWriter((Writer)new FileWriter(filename));
        LinkedBlockingQueue<String> batch = new LinkedBlockingQueue<String>();
        int batchCount = 0;
        LoadSamplingConsumer sampleLoading = new LoadSamplingConsumer(batch);
        if (concurrentLoading) {
            sampleLoading.start();
        }
        writer.writeNext((String[])Predef$.MODULE$.refArrayOps((Object[])new String[]{"longitude", "latitude"}).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])fields), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        int totalProcessed = 0;
        double[][] points = pointsReader.loadPoints(batchSize);
        while (true) {
            if (Predef$.MODULE$.refArrayOps((Object[])points).isEmpty()) {
                pointsReader.close();
                writer.flush();
                writer.close();
                this.logger().info(new StringBuilder().append((Object)"Total points sampled : ").append((Object)BoxesRunTime.boxToInteger((int)totalProcessed)).append((Object)", output file: ").append((Object)outputFilePath).append((Object)" point file: ").append((Object)filePath).toString());
                this.logger().info("********* END - TEST BATCH SAMPLING FROM FILE ***************");
                if (concurrentLoading) {
                    while (sampleLoading.doneList().size() < batchCount) {
                        Thread.sleep(50L);
                    }
                    sampleLoading.interrupt();
                    if (!keepFiles) {
                        Predef$.MODULE$.refArrayOps(sampleLoading.doneList().toArray()).foreach((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(Object f) {
                                return new File(f.toString()).delete();
                            }
                        });
                    }
                }
                return;
            }
            if (Config$.MODULE$.layersServiceSampling()) {
                this.processBatchRemote(writer, points, fields, callback);
            } else {
                this.processBatch(writer, points, fields, callback);
            }
            this.logger().info(new StringBuilder().append((Object)"Total points sampled so far : ").append((Object)BoxesRunTime.boxToInteger((int)(totalProcessed += Predef$.MODULE$.refArrayOps((Object[])points).size()))).toString());
            points = pointsReader.loadPoints(batchSize);
            if (!concurrentLoading) continue;
            ++batchCount;
            batch.put(filename);
            writer.flush();
            writer.close();
            filename = new StringBuilder().append((Object)outputFilePath).append((Object)BoxesRunTime.boxToInteger((int)totalProcessed)).toString();
            writer = new CSVWriter((Writer)new FileWriter(filename));
            writer.writeNext((String[])Predef$.MODULE$.refArrayOps((Object[])new String[]{"longitude", "latitude"}).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])fields), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        }
    }

    public IntersectCallback sampling$default$3() {
        return null;
    }

    public String sampling$default$4() {
        return "";
    }

    public int sampling$default$5() {
        return 100000;
    }

    public boolean sampling$default$6() {
        return false;
    }

    public boolean sampling$default$7() {
        return true;
    }

    private void processBatch(CSVWriter writer, double[][] points, String[] fields, IntersectCallback callback) {
        LayerIntersectDAO layerIntersectDAO = Client.getLayerIntersectDao();
        ArrayList samples = layerIntersectDAO.sampling(fields, points, callback);
        String[][] columns = (String[][])Array$.MODULE$.ofDim(samples.size(), points.length, ClassTag$.MODULE$.apply(String.class));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), samples.size()).foreach$mVc$sp((Function1)new Serializable(this, samples, columns){
            public static final long serialVersionUID = 0L;
            private final ArrayList samples$1;
            private final String[][] columns$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.columns$1[i] = new StringOps(Predef$.MODULE$.augmentString((String)this.samples$1.get(i))).split('\n');
            }
            {
                this.samples$1 = samples$1;
                this.columns$1 = columns$1;
            }
        });
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), points.length).foreach$mVc$sp((Function1)new Serializable(this, writer, points, columns){
            public static final long serialVersionUID = 0L;
            private final CSVWriter writer$1;
            private final double[][] points$1;
            public final String[][] columns$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                String[] sampledPoint = (String[])Array$.MODULE$.fill(2 + this.columns$1.length, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "";
                    }
                }, ClassTag$.MODULE$.apply(String.class));
                sampledPoint[0] = ((Object)BoxesRunTime.boxToDouble((double)this.points$1[i][0])).toString();
                sampledPoint[1] = ((Object)BoxesRunTime.boxToDouble((double)this.points$1[i][1])).toString();
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.columns$1.length).foreach$mVc$sp((Function1)new Serializable(this, sampledPoint, i){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$processBatch$2 $outer;
                    private final String[] sampledPoint$1;
                    private final int i$1;

                    public final void apply(int j) {
                        this.apply$mcVI$sp(j);
                    }

                    public void apply$mcVI$sp(int j) {
                        if (this.i$1 < this.$outer.columns$1[j].length) {
                            String string = this.$outer.columns$1[j][this.i$1];
                            String string2 = "n/a";
                            if (string == null ? string2 != null : !string.equals(string2)) {
                                this.sampledPoint$1[j + 2] = this.$outer.columns$1[j][this.i$1];
                            }
                        }
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.sampledPoint$1 = sampledPoint$1;
                        this.i$1 = i$1;
                    }
                });
                this.writer$1.writeNext((String[])Predef$.MODULE$.refArrayOps((Object[])sampledPoint).toArray(ClassTag$.MODULE$.apply(String.class)));
                this.writer$1.flush();
            }
            {
                this.writer$1 = writer$1;
                this.points$1 = points$1;
                this.columns$1 = columns$1;
            }
        });
    }

    private IntersectCallback processBatch$default$4() {
        return null;
    }

    private void processBatchRemote(CSVWriter writer, double[][] points, String[] fields, IntersectCallback callback) {
        if (callback != null) {
            IntersectionFile[] intersectionFiles = new IntersectionFile[fields.length];
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), fields.length).foreach$mVc$sp((Function1)new Serializable(this, fields, intersectionFiles){
                public static final long serialVersionUID = 0L;
                private final String[] fields$1;
                private final IntersectionFile[] intersectionFiles$1;

                public final void apply(int j) {
                    this.apply$mcVI$sp(j);
                }

                public void apply$mcVI$sp(int j) {
                    this.intersectionFiles$1[j] = new IntersectionFile(this.fields$1[j], "", "", new StringBuilder().append((Object)"layer ").append((Object)BoxesRunTime.boxToInteger((int)(j + 1))).toString(), "", "", "", "", null);
                }
                {
                    this.fields$1 = fields$1;
                    this.intersectionFiles$1 = intersectionFiles$1;
                }
            });
            callback.setLayersToSample(intersectionFiles);
        }
        CSVReader samples = new CSVReader(this.layersStore$1().sample(fields, points, callback));
        String[] header = samples.readNext();
        String[] row = samples.readNext();
        Integer rowCounter = Predef$.MODULE$.int2Integer(0);
        while (true) {
            if (row == null) break;
            if (callback != null && Predef$.MODULE$.Integer2int(rowCounter) % 500 == 0) {
                callback.setCurrentLayer(new IntersectionFile("", "", "", new StringBuilder().append((Object)"finished. Loaded ").append((Object)rowCounter).toString(), "", "", "", "", null));
                callback.progressMessage("Loading sampling.");
            }
            rowCounter = Predef$.MODULE$.int2Integer(Predef$.MODULE$.Integer2int(rowCounter) + 1);
            String lng = row[0];
            row[0] = row[1];
            row[1] = lng;
            writer.writeNext(row);
            row = samples.readNext();
        }
        writer.flush();
        if (callback != null) {
            callback.setCurrentLayer(new IntersectionFile("", "", "", "finished. Load sampling finished", "", "", "", "", null));
            callback.progressMessage("Load sampling finished.");
        }
    }

    private IntersectCallback processBatchRemote$default$4() {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void loadSampling(String inputFileName, IntersectCallback callback) {
        this.logger().info("Loading the sampling into the database");
        long startTime = System.currentTimeMillis();
        long nextTime = System.currentTimeMillis();
        try {
            CSVReader csvReader = new CSVReader((Reader)new InputStreamReader((InputStream)new FileInputStream(inputFileName), "UTF-8"));
            String[] header = csvReader.readNext();
            int counter = 0;
            String[] line = csvReader.readNext();
            HashMap batches = new HashMap();
            int batchSize = 500;
            while (line != null) {
                try {
                    scala.collection.immutable.Map map = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])header).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])line), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).filter((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public final boolean apply(Tuple2<String, String> x) {
                            if (StringUtils.isEmpty((String)((String)x._2()).trim())) return false;
                            Object object = x._1();
                            String string = "latitude";
                            if (object == null) {
                                if (string == null) return false;
                            } else if (object.equals(string)) return false;
                            Object object2 = x._1();
                            String string2 = "longitude";
                            if (object2 != null) {
                                if (!object2.equals(string2)) return true;
                                return false;
                            }
                            if (string2 == null) return false;
                            return true;
                        }
                    })).toMap(Predef$.MODULE$.conforms());
                    scala.collection.immutable.Map el = (scala.collection.immutable.Map)((TraversableLike)map.filter((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public final boolean apply(Tuple2<String, String> x) {
                            if (!((String)x._1()).startsWith("el")) return false;
                            Object object = x._2();
                            String string = "n/a";
                            if (object == null) {
                                if (string == null) return false;
                                return true;
                            } else if (object.equals(string)) return false;
                            return true;
                        }
                    })).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Tuple2<String, Object> apply(Tuple2<String, String> y) {
                            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc(y._1()), (Object)BoxesRunTime.boxToFloat((float)new StringOps(Predef$.MODULE$.augmentString((String)y._2())).toFloat()));
                        }
                    }, Map$.MODULE$.canBuildFrom());
                    scala.collection.immutable.Map cl = ((scala.collection.immutable.Map)map.filter((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public final boolean apply(Tuple2<String, String> x) {
                            if (!((String)x._1()).startsWith("cl")) return false;
                            Object object = x._2();
                            String string = "n/a";
                            if (object == null) {
                                if (string == null) return false;
                                return true;
                            } else if (object.equals(string)) return false;
                            return true;
                        }
                    })).toMap(Predef$.MODULE$.conforms());
                    if (batches.size() == batchSize) {
                        LocationDAO$.MODULE$.writeLocBatch((Map<String, scala.collection.immutable.Map<String, String>>)batches);
                        batches.clear();
                    }
                    batches.$plus$eq(LocationDAO$.MODULE$.addLayerIntersects(line[1], line[0], (scala.collection.immutable.Map<String, String>)cl, (scala.collection.immutable.Map<String, Object>)el, true));
                    if (counter % 200 == 0 && callback != null) {
                        callback.setCurrentLayer(new IntersectionFile("", "", "", new StringBuilder().append((Object)"finished. Processing loaded samples ").append((Object)BoxesRunTime.boxToInteger((int)counter)).toString(), "", "", "", "", null));
                        callback.progressMessage("Loading sampling.");
                    }
                    if (counter % 1000 == 0) {
                        this.logger().info(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"writing to loc: ", " : records per sec: "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)counter)}))).append((Object)BoxesRunTime.boxToFloat((float)(1000.0f / ((float)(System.currentTimeMillis() - nextTime) / 1000.0f)))).toString());
                        nextTime = System.currentTimeMillis();
                    }
                    ++counter;
                }
                catch (Exception exception) {
                    this.logger().error(exception.getMessage(), (Throwable)exception);
                    this.logger().error(new StringBuilder().append((Object)"Problem writing line: ").append((Object)BoxesRunTime.boxToInteger((int)counter)).append((Object)", line length: ").append((Object)BoxesRunTime.boxToInteger((int)line.length)).append((Object)", header length: ").append((Object)BoxesRunTime.boxToInteger((int)header.length)).toString());
                }
                line = csvReader.readNext();
            }
            csvReader.close();
            if (batches.size() > 0) {
                LocationDAO$.MODULE$.writeLocBatch((Map<String, scala.collection.immutable.Map<String, String>>)batches.toMap(Predef$.MODULE$.conforms()));
            }
        }
        catch (Exception exception) {
            this.logger().error(new StringBuilder().append((Object)"Problem loading sampling. ").append((Object)exception.getMessage()).toString(), (Throwable)exception);
        }
        this.logger().info(new StringBuilder().append((Object)"Finished loading: ").append((Object)inputFileName).append((Object)" in ").append((Object)BoxesRunTime.boxToLong((long)(System.currentTimeMillis() - startTime))).append((Object)"ms").toString());
    }

    public IntersectCallback loadSampling$default$2() {
        return null;
    }

    private final LayersStore layersStore$1() {
        return new LayersStore(Config$.MODULE$.layersServiceUrl());
    }
}

