/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.processor;

import au.org.ala.biocache.Config$;
import au.org.ala.biocache.dao.OccurrenceDAO;
import au.org.ala.biocache.load.FullRecordMapper$;
import au.org.ala.biocache.model.FullRecord;
import au.org.ala.biocache.model.Processed$;
import au.org.ala.biocache.model.QualityAssertion;
import au.org.ala.biocache.model.Version;
import au.org.ala.biocache.model.Versions$;
import au.org.ala.biocache.processor.Processor;
import au.org.ala.biocache.processor.Processors$;
import java.util.Date;
import java.util.UUID;
import org.apache.commons.lang.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0005]c\u0001B\u0001\u0003\u00015\u0011qBU3d_J$\u0007K]8dKN\u001cxN\u001d\u0006\u0003\u0007\u0011\t\u0011\u0002\u001d:pG\u0016\u001c8o\u001c:\u000b\u0005\u00151\u0011\u0001\u00032j_\u000e\f7\r[3\u000b\u0005\u001dA\u0011aA1mC*\u0011\u0011BC\u0001\u0004_J<'\"A\u0006\u0002\u0005\u0005,8\u0001A\n\u0003\u00019\u0001\"a\u0004\n\u000e\u0003AQ\u0011!E\u0001\u0006g\u000e\fG.Y\u0005\u0003'A\u0011a!\u00118z%\u00164\u0007\"B\u000b\u0001\t\u00031\u0012A\u0002\u001fj]&$h\bF\u0001\u0018!\tA\u0002!D\u0001\u0003\u0011\u001dQ\u0002A1A\u0005\u0002m\ta\u0001\\8hO\u0016\u0014X#\u0001\u000f\u0011\u0005u\tS\"\u0001\u0010\u000b\u0005}\u0001\u0013!B:mMRR'\"A\u0005\n\u0005\tr\"A\u0002'pO\u001e,'\u000f\u0003\u0004%\u0001\u0001\u0006I\u0001H\u0001\bY><w-\u001a:!\u0011\u001d1\u0003A1A\u0005\u0002\u001d\n1\u0002\u001d:pG\u0016\u001c8\u000fV5nKV\t\u0001\u0006\u0005\u0002*]5\t!F\u0003\u0002,Y\u0005!A.\u00198h\u0015\u0005i\u0013\u0001\u00026bm\u0006L!a\f\u0016\u0003\rM#(/\u001b8h\u0011\u0019\t\u0004\u0001)A\u0005Q\u0005a\u0001O]8dKN\u001cH+[7fA!91\u0007\u0001b\u0001\n\u0003!\u0014A\u00033va2L7-\u0019;fgV\tQ\u0007E\u00027w!j\u0011a\u000e\u0006\u0003qe\n\u0011\"[7nkR\f'\r\\3\u000b\u0005i\u0002\u0012AC2pY2,7\r^5p]&\u0011Ah\u000e\u0002\u0005\u0019&\u001cH\u000f\u0003\u0004?\u0001\u0001\u0006I!N\u0001\fIV\u0004H.[2bi\u0016\u001c\b\u0005C\u0004A\u0001\t\u0007I\u0011A!\u0002\u001dA\u0014xnY3tgRKW.\u001b8hgV\t!\t\u0005\u0003D\r\"sU\"\u0001#\u000b\u0005\u0015K\u0014aB7vi\u0006\u0014G.Z\u0005\u0003\u000f\u0012\u00131!T1q!\tIEJ\u0004\u0002\u0010\u0015&\u00111\nE\u0001\u0007!J,G-\u001a4\n\u0005=j%BA&\u0011!\tyq*\u0003\u0002Q!\t!Aj\u001c8h\u0011\u0019\u0011\u0006\u0001)A\u0005\u0005\u0006y\u0001O]8dKN\u001cH+[7j]\u001e\u001c\b\u0005C\u0003U\u0001\u0011\u0005Q+A\u0007qe>\u001cWm]:SK\u000e|'\u000f\u001a\u000b\u0006-n\u001bWM\u001b\t\u0005\u0013^C\u0005,\u0003\u0002H\u001bB\u0011\u0011&W\u0005\u00035*\u0012aa\u00142kK\u000e$\b\"\u0002/T\u0001\u0004i\u0016a\u0001:boB\u0011a,Y\u0007\u0002?*\u0011\u0001\rB\u0001\u0006[>$W\r\\\u0005\u0003E~\u0013!BR;mYJ+7m\u001c:e\u0011\u0015!7\u000b1\u0001^\u0003A\u0019WO\u001d:f]R\u0004&o\\2fgN,G\rC\u0004g'B\u0005\t\u0019A4\u0002\u000b\t\fGo\u00195\u0011\u0005=A\u0017BA5\u0011\u0005\u001d\u0011un\u001c7fC:Dqa[*\u0011\u0002\u0003\u0007q-A\u0005gSJ\u001cH\u000fT8bI\")Q\u000e\u0001C\u0001]\u0006\trO]5uKB\u0013xnY3tg\n\u000bGo\u00195\u0015\u0005=\u0014\bCA\bq\u0013\t\t\bC\u0001\u0003V]&$\b\"\u00024m\u0001\u0004\u0019\bc\u0001;}-:\u0011QO\u001f\b\u0003mfl\u0011a\u001e\u0006\u0003q2\ta\u0001\u0010:p_Rt\u0014\"A\t\n\u0005m\u0004\u0012a\u00029bG.\fw-Z\u0005\u0003yuT!a\u001f\t\t\u000bQ\u0003A\u0011A@\u0015\t\u0005\u0005\u0011Q\u0003\t\u0007\u001f\u0005\rQ,a\u0002\n\u0007\u0005\u0015\u0001C\u0001\u0004UkBdWM\r\t\u0006\u0013^C\u0015\u0011\u0002\t\u0006\u001f\u0005-\u0011qB\u0005\u0004\u0003\u001b\u0001\"!B!se\u0006L\bc\u00010\u0002\u0012%\u0019\u00111C0\u0003!E+\u0018\r\\5us\u0006\u001b8/\u001a:uS>t\u0007\"\u0002/\u007f\u0001\u0004i\u0006bBA\r\u0001\u0011\u0005\u00111D\u0001\u0017aJ|7-Z:t%\u0016\u001cwN\u001d3B]\u0012,\u0006\u000fZ1uKR\u0019q.!\b\t\rq\u000b9\u00021\u0001^\u0011\u001d\t\t\u0003\u0001C\u0001\u0003G\t1#\u00193e%\u0016\u001cwN\u001d3B]\u0012\u0004&o\\2fgN$R\u0001SA\u0013\u0003SAq!a\n\u0002 \u0001\u0007\u0001*A\beCR\f'+Z:pkJ\u001cW-V5e\u0011!\tY#a\bA\u0002\u00055\u0012A\u00039s_B,'\u000f^5fgB!\u0011j\u0016%I\u0011\u001d\t\t\u0004\u0001C\u0001\u0003g\t\u0011\"\u00193e%\u0016\u001cwN\u001d3\u0015\u000b!\u000b)$a\u000e\t\u000f\u0005\u001d\u0012q\u0006a\u0001\u0011\"A\u00111FA\u0018\u0001\u0004\ti\u0003C\u0005\u0002<\u0001\t\n\u0011\"\u0001\u0002>\u00059\u0002O]8dKN\u001c(+Z2pe\u0012$C-\u001a4bk2$HeM\u000b\u0003\u0003\u007fQ3aZA!W\t\t\u0019\u0005\u0005\u0003\u0002F\u0005=SBAA$\u0015\u0011\tI%a\u0013\u0002\u0013Ut7\r[3dW\u0016$'bAA'!\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005E\u0013q\t\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007\"CA+\u0001E\u0005I\u0011AA\u001f\u0003]\u0001(o\\2fgN\u0014VmY8sI\u0012\"WMZ1vYR$C\u0007")
public class RecordProcessor {
    private final Logger logger = LoggerFactory.getLogger(RecordProcessor.class);
    private final String processTime = DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd'T'HH:mm:ss'Z'");
    private final List<String> duplicates = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"D", "D1", "D2"}));
    private final scala.collection.mutable.Map<String, Object> processTimings = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);

    public Logger logger() {
        return this.logger;
    }

    public String processTime() {
        return this.processTime;
    }

    public List<String> duplicates() {
        return this.duplicates;
    }

    public scala.collection.mutable.Map<String, Object> processTimings() {
        return this.processTimings;
    }

    public scala.collection.immutable.Map<String, Object> processRecord(FullRecord raw, FullRecord currentProcessed, boolean batch, boolean firstLoad) {
        scala.collection.immutable.Map map;
        try {
            String guid = raw.rowKey();
            OccurrenceDAO occurrenceDAO = (OccurrenceDAO)Config$.MODULE$.getInstance(OccurrenceDAO.class);
            FullRecord processed = raw.createNewProcessedRecord();
            ObjectRef assertions = new ObjectRef((Object)new HashMap());
            Processors$.MODULE$.foreach((Function1<Processor, BoxedUnit>)new Serializable(this, raw, currentProcessed, firstLoad, guid, processed, assertions){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ RecordProcessor $outer;
                private final FullRecord raw$2;
                private final FullRecord currentProcessed$1;
                private final boolean firstLoad$1;
                private final String guid$1;
                private final FullRecord processed$1;
                private final ObjectRef assertions$1;

                public final void apply(Processor processor) {
                    block5: {
                        if (!processor.getName().equals("offline") || !this.firstLoad$1) {
                            long start = System.currentTimeMillis();
                            try {
                                ((HashMap)this.assertions$1.elem).$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)processor.getName()), (Object)processor.process(this.guid$1, this.raw$2, this.processed$1, (Option<FullRecord>)new Some((Object)this.currentProcessed$1))));
                            }
                            catch (Exception exception) {
                                try {
                                    this.$outer.logger().warn(new StringBuilder().append((Object)"Non-fatal error processing record: ").append((Object)this.raw$2.rowKey()).append((Object)", processorName: ").append((Object)processor.getName()).append((Object)", error: ").append((Object)exception.getMessage()).toString(), (Throwable)exception);
                                }
                                catch (Throwable throwable) {
                                    long currentTime = System.currentTimeMillis() - start + BoxesRunTime.unboxToLong((Object)this.$outer.processTimings().getOrElse((Object)processor.getName(), (Function0)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final long apply() {
                                            return this.apply$mcJ$sp();
                                        }

                                        public long apply$mcJ$sp() {
                                            return 0L;
                                        }
                                    }));
                                    this.$outer.processTimings().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)processor.getName()), (Object)BoxesRunTime.boxToLong((long)currentTime)));
                                    throw throwable;
                                }
                            }
                            long currentTime = System.currentTimeMillis() - start + BoxesRunTime.unboxToLong((Object)this.$outer.processTimings().getOrElse((Object)processor.getName(), (Function0)new /* invalid duplicate definition of identical inner class */));
                            this.$outer.processTimings().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)processor.getName()), (Object)BoxesRunTime.boxToLong((long)currentTime)));
                            break block5;
                            currentTime = System.currentTimeMillis() - start + BoxesRunTime.unboxToLong((Object)this.$outer.processTimings().getOrElse((Object)processor.getName(), (Function0)new /* invalid duplicate definition of identical inner class */));
                            this.$outer.processTimings().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)processor.getName()), (Object)BoxesRunTime.boxToLong((long)currentTime)));
                        }
                    }
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.raw$2 = raw$2;
                    this.currentProcessed$1 = currentProcessed$1;
                    this.firstLoad$1 = firstLoad$1;
                    this.guid$1 = guid$1;
                    this.processed$1 = processed$1;
                    this.assertions$1 = assertions$1;
                }
            });
            processed.lastModifiedTime_$eq(this.processTime());
            Some systemAssertions = new Some((Object)((HashMap)assertions.elem).toMap(Predef$.MODULE$.conforms()));
            if (batch) {
                map = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"rowKey"), (Object)guid), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"oldRecord"), (Object)currentProcessed), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"newRecord"), (Object)processed), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"assertions"), (Object)systemAssertions), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"version"), (Object)Processed$.MODULE$)}));
            } else {
                occurrenceDAO.updateOccurrence(guid, currentProcessed, processed, (Option<scala.collection.immutable.Map<String, QualityAssertion[]>>)systemAssertions, Processed$.MODULE$);
                map = null;
            }
        }
        catch (Exception exception) {
            this.logger().error(new StringBuilder().append((Object)"Error processing record: ").append((Object)raw.rowKey()).append((Object)", ").append((Object)exception.getMessage()).toString(), (Throwable)exception);
            map = null;
        }
        return map;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeProcessBatch(List<scala.collection.immutable.Map<String, Object>> batch) {
        OccurrenceDAO occurrenceDAO = (OccurrenceDAO)Config$.MODULE$.getInstance(OccurrenceDAO.class);
        int retries = 0;
        boolean processedOK = false;
        if (processedOK) return;
        if (retries >= 6) return;
        {
            occurrenceDAO.updateOccurrenceBatch(batch);
            return;
        }
    }

    public Tuple2<FullRecord, scala.collection.immutable.Map<String, QualityAssertion[]>> processRecord(FullRecord raw) {
        FullRecord processed = raw.createNewProcessedRecord();
        HashMap assertions = new HashMap();
        Processors$.MODULE$.foreach((Function1<Processor, BoxedUnit>)new Serializable(this, raw, processed, assertions){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RecordProcessor $outer;
            private final FullRecord raw$1;
            private final FullRecord processed$2;
            private final HashMap assertions$2;

            public final void apply(Processor processor) {
                if (this.$outer.logger().isDebugEnabled()) {
                    this.$outer.logger().debug(new StringBuilder().append((Object)"Running processor ").append((Object)processor.getName()).toString());
                }
                this.assertions$2.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)processor.getName()), (Object)processor.process(this.raw$1.rowKey(), this.raw$1, this.processed$2, processor.process$default$4())));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.raw$1 = raw$1;
                this.processed$2 = processed$2;
                this.assertions$2 = assertions$2;
            }
        });
        return new Tuple2((Object)processed, (Object)assertions.toMap(Predef$.MODULE$.conforms()));
    }

    public boolean processRecord$default$3() {
        return false;
    }

    public boolean processRecord$default$4() {
        return false;
    }

    public void processRecordAndUpdate(FullRecord raw) {
        Tuple2<FullRecord, scala.collection.immutable.Map<String, QualityAssertion[]>> tuple2 = this.processRecord(raw);
        if (tuple2 != null) {
            Tuple2 tuple22;
            FullRecord processed = (FullRecord)tuple2._1();
            scala.collection.immutable.Map assertions = (scala.collection.immutable.Map)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)processed, (Object)assertions);
            FullRecord processed2 = (FullRecord)tuple23._1();
            scala.collection.immutable.Map assertions2 = (scala.collection.immutable.Map)tuple23._2();
            Some systemAssertions = new Some((Object)assertions2);
            processed2.lastModifiedTime_$eq(this.processTime());
            Config$.MODULE$.occurrenceDAO().updateOccurrence(raw.rowKey(), processed2, (Option<scala.collection.immutable.Map<String, QualityAssertion[]>>)systemAssertions, Processed$.MODULE$);
            return;
        }
        throw new MatchError(tuple2);
    }

    /*
     * WARNING - void declaration
     */
    public String addRecordAndProcess(String dataResourceUid, scala.collection.immutable.Map<String, String> properties) {
        void var3_3;
        String uuid = (String)properties.getOrElse((Object)"uuid", (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return UUID.randomUUID().toString();
            }
        });
        String rowKey = new StringBuilder().append((Object)dataResourceUid).append((Object)"|").append((Object)uuid).toString();
        FullRecord raw = FullRecordMapper$.MODULE$.createFullRecord(rowKey, (Map<String, String>)properties, (Version)Versions$.MODULE$.RAW());
        raw.uuid_$eq(uuid);
        raw.attribution().dataResourceUid_$eq(dataResourceUid);
        Config$.MODULE$.occurrenceDAO().updateOccurrence(raw.rowKey(), raw, (Version)Versions$.MODULE$.RAW());
        RecordProcessor processor = new RecordProcessor();
        processor.processRecordAndUpdate(raw);
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public String addRecord(String dataResourceUid, scala.collection.immutable.Map<String, String> properties) {
        void var3_3;
        String uuid = (String)properties.getOrElse((Object)"uuid", (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return UUID.randomUUID().toString();
            }
        });
        String rowKey = new StringBuilder().append((Object)dataResourceUid).append((Object)"|").append((Object)uuid).toString();
        FullRecord raw = FullRecordMapper$.MODULE$.createFullRecord(rowKey, (Map<String, String>)properties, (Version)Versions$.MODULE$.RAW());
        raw.uuid_$eq(uuid);
        raw.attribution().dataResourceUid_$eq(dataResourceUid);
        Config$.MODULE$.occurrenceDAO().updateOccurrence(raw.rowKey(), raw, (Version)Versions$.MODULE$.RAW());
        boolean downloaded = Config$.MODULE$.occurrenceDAO().downloadMedia(raw);
        if (downloaded) {
            Config$.MODULE$.occurrenceDAO().updateOccurrence(raw.rowKey(), raw, (Version)Versions$.MODULE$.RAW());
        }
        return var3_3;
    }
}

