/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.processor;

import au.org.ala.biocache.Config$;
import au.org.ala.biocache.caches.LocationDAO$;
import au.org.ala.biocache.caches.SpatialLayerDAO$;
import au.org.ala.biocache.caches.TaxonProfileDAO$;
import au.org.ala.biocache.load.FullRecordMapper$;
import au.org.ala.biocache.model.Feet$;
import au.org.ala.biocache.model.FullRecord;
import au.org.ala.biocache.model.MeasurementUnit;
import au.org.ala.biocache.model.QualityAssertion;
import au.org.ala.biocache.model.QualityAssertion$;
import au.org.ala.biocache.model.TaxonProfile;
import au.org.ala.biocache.parser.DistanceRangeParser$;
import au.org.ala.biocache.parser.VerbatimLatLongParser$;
import au.org.ala.biocache.processor.Processor;
import au.org.ala.biocache.processor.Processor$class;
import au.org.ala.biocache.util.GISPoint;
import au.org.ala.biocache.util.GISPoint$;
import au.org.ala.biocache.util.GISUtil$;
import au.org.ala.biocache.util.GridUtil$;
import au.org.ala.biocache.util.StringHelper$;
import au.org.ala.biocache.vocab.AssertionCodes$;
import au.org.ala.biocache.vocab.AssertionStatus$;
import au.org.ala.biocache.vocab.BBox;
import au.org.ala.biocache.vocab.Countries$;
import au.org.ala.biocache.vocab.CountryCentrePoints$;
import au.org.ala.biocache.vocab.HabitatMap$;
import au.org.ala.biocache.vocab.LatLng;
import au.org.ala.biocache.vocab.StateProvinceCentrePoints$;
import au.org.ala.biocache.vocab.StateProvinceToCountry$;
import au.org.ala.biocache.vocab.StateProvinces$;
import au.org.ala.biocache.vocab.Term;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;

@ScalaSignature(bytes="\u0006\u0001\t\u0015a\u0001B\u0001\u0003\u00015\u0011\u0011\u0003T8dCRLwN\u001c)s_\u000e,7o]8s\u0015\t\u0019A!A\u0005qe>\u001cWm]:pe*\u0011QAB\u0001\tE&|7-Y2iK*\u0011q\u0001C\u0001\u0004C2\f'BA\u0005\u000b\u0003\ry'o\u001a\u0006\u0002\u0017\u0005\u0011\u0011-^\u0002\u0001'\r\u0001a\u0002\u0006\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0002#\u0005)1oY1mC&\u00111\u0003\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0005U1R\"\u0001\u0002\n\u0005]\u0011!!\u0003)s_\u000e,7o]8s\u0011\u0015I\u0002\u0001\"\u0001\u001b\u0003\u0019a\u0014N\\5u}Q\t1\u0004\u0005\u0002\u0016\u0001!9Q\u0004\u0001b\u0001\n\u0003q\u0012A\u00027pO\u001e,'/F\u0001 !\t\u0001C%D\u0001\"\u0015\t\u00113%A\u0003tY\u001a$$NC\u0001\n\u0013\t)\u0013E\u0001\u0004M_\u001e<WM\u001d\u0005\u0007O\u0001\u0001\u000b\u0011B\u0010\u0002\u000f1|wmZ3sA!)\u0011\u0006\u0001C\u0001U\u00059\u0001O]8dKN\u001cH#B\u00165{\t#\u0005cA\b-]%\u0011Q\u0006\u0005\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003_Ij\u0011\u0001\r\u0006\u0003c\u0011\tQ!\\8eK2L!a\r\u0019\u0003!E+\u0018\r\\5us\u0006\u001b8/\u001a:uS>t\u0007\"B\u001b)\u0001\u00041\u0014\u0001B4vS\u0012\u0004\"a\u000e\u001e\u000f\u0005=A\u0014BA\u001d\u0011\u0003\u0019\u0001&/\u001a3fM&\u00111\b\u0010\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005e\u0002\u0002\"\u0002 )\u0001\u0004y\u0014a\u0001:boB\u0011q\u0006Q\u0005\u0003\u0003B\u0012!BR;mYJ+7m\u001c:e\u0011\u0015\u0019\u0005\u00061\u0001@\u0003%\u0001(o\\2fgN,G\rC\u0004FQA\u0005\t\u0019\u0001$\u0002\u001b1\f7\u000f\u001e)s_\u000e,7o]3e!\ryqiP\u0005\u0003\u0011B\u0011aa\u00149uS>t\u0007\"\u0002&\u0001\t\u0003Y\u0015!F2iK\u000e\\Gj\\2bi&|gnU;qa2LW\r\u001a\u000b\u0005\u0019R+f\u000bE\u0002N%:j\u0011A\u0014\u0006\u0003\u001fB\u000bq!\\;uC\ndWM\u0003\u0002R!\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005Ms%aC!se\u0006L()\u001e4gKJDQAP%A\u0002}BQaQ%A\u0002}BQaV%A\u00021\u000b!\"Y:tKJ$\u0018n\u001c8t\u0011\u0015I\u0006\u0001\"\u0003[\u0003e\u0001(o\\2fgN\u001cF/\u0019;f\u0007>,h\u000e\u001e:z-\u0006dW/Z:\u0015\tmsv\f\u0019\t\u0003\u001fqK!!\u0018\t\u0003\tUs\u0017\u000e\u001e\u0005\u0006}a\u0003\ra\u0010\u0005\u0006\u0007b\u0003\ra\u0010\u0005\u0006/b\u0003\r\u0001\u0014\u0005\u0006E\u0002!IaY\u0001\u0014m\u0006d\u0017\u000eZ1uK\u000e{wN\u001d3j]\u0006$Xm\u001d\u000b\u00057\u0012,g\rC\u0003?C\u0002\u0007q\bC\u0003DC\u0002\u0007q\bC\u0003XC\u0002\u0007A\nC\u0003i\u0001\u0011%\u0011.A\fqe>\u001cWm]:BYRLG/\u001e3f\u0003:$G)\u001a9uQR)1L[6m[\")Qg\u001aa\u0001m!)ah\u001aa\u0001\u007f!)1i\u001aa\u0001\u007f!)qk\u001aa\u0001\u0019\")q\u000e\u0001C\u0005a\u0006\u0011\u0002O]8dKN\u001cX*\u001b8NCb$U\r\u001d;i)\u0011Y\u0016O]:\t\u000byr\u0007\u0019A \t\u000b\rs\u0007\u0019A \t\u000b]s\u0007\u0019\u0001'\t\u000bU\u0004A\u0011\u0002<\u00021A\u0014xnY3tgZ+'OY1uS6,E.\u001a<bi&|g\u000e\u0006\u0003\\obL\b\"\u0002 u\u0001\u0004y\u0004\"B\"u\u0001\u0004y\u0004\"B,u\u0001\u0004a\u0005\"B>\u0001\t\u0013a\u0018\u0001\u00069s_\u000e,7o\u001d,fe\n\fG/[7EKB$\b\u000e\u0006\u0003\\{z|\b\"\u0002 {\u0001\u0004y\u0004\"B\"{\u0001\u0004y\u0004\"B,{\u0001\u0004a\u0005bBA\u0002\u0001\u0011%\u0011QA\u0001\u0018g\u0016$\bK]8dKN\u001cX\rZ\"p_J$\u0017N\\1uKN$raWA\u0004\u0003\u0013\tY\u0001\u0003\u0004?\u0003\u0003\u0001\ra\u0010\u0005\u0007\u0007\u0006\u0005\u0001\u0019A \t\r]\u000b\t\u00011\u0001M\u0011\u001d\ty\u0001\u0001C\u0001\u0003#\ta\u0002\u001d:pG\u0016\u001c8\u000fT1u\u0019>tw\r\u0006\r\u0002\u0014\u0005\u0005\u0012QEA\u0015\u0003[\t\t$!\u000e\u0002:\u0005u\u0012\u0011IA#\u0003\u0013\u0002BaD$\u0002\u0016A!\u0011qCA\u000f\u001b\t\tIBC\u0002\u0002\u001c\u0011\tA!\u001e;jY&!\u0011qDA\r\u0005!9\u0015j\u0015)pS:$\bbBA\u0012\u0003\u001b\u0001\rAN\u0001\fe\u0006<H*\u0019;jiV$W\rC\u0004\u0002(\u00055\u0001\u0019\u0001\u001c\u0002\u0019I\fw\u000fT8oO&$X\u000fZ3\t\u000f\u0005-\u0012Q\u0002a\u0001m\u0005\u0001\"/Y<HK>$W\r^5d\t\u0006$X/\u001c\u0005\b\u0003_\ti\u00011\u00017\u0003A1XM\u001d2bi&lG*\u0019;jiV$W\rC\u0004\u00024\u00055\u0001\u0019\u0001\u001c\u0002#Y,'OY1uS6duN\\4jiV$W\rC\u0004\u00028\u00055\u0001\u0019\u0001\u001c\u0002\u0017Y,'OY1uS6\u001c&k\u0015\u0005\b\u0003w\ti\u00011\u00017\u0003\u001d)\u0017m\u001d;j]\u001eDq!a\u0010\u0002\u000e\u0001\u0007a'\u0001\u0005o_J$\b.\u001b8h\u0011\u001d\t\u0019%!\u0004A\u0002Y\nAA_8oK\"9\u0011qIA\u0007\u0001\u00041\u0014!D4sS\u0012\u0014VMZ3sK:\u001cW\r\u0003\u0004X\u0003\u001b\u0001\r\u0001\u0014\u0005\b\u0003\u001b\u0002A\u0011BA(\u0003e\u0001(o\\2fgN$UmY5nC2\u001cun\u001c:eS:\fG/Z:\u0015\u0015\u0005M\u0011\u0011KA*\u0003+\n9\u0006C\u0004\u0002$\u0005-\u0003\u0019\u0001\u001c\t\u000f\u0005\u001d\u00121\na\u0001m!9\u00111FA&\u0001\u00041\u0004BB,\u0002L\u0001\u0007A\nC\u0004\u0002\\\u0001!I!!\u0018\u00025A\u0014xnY3tgZ+'OY1uS6\u001cun\u001c:eS:\fG/Z:\u0015\u0015\u0005M\u0011qLA1\u0003G\ny\u0007C\u0004\u00028\u0005e\u0003\u0019\u0001\u001c\t\r]\u000bI\u00061\u0001M\u0011!\t)'!\u0017A\u0002\u0005\u001d\u0014A\u00053fG&l\u0017\r\u001c,fe\n\fG/[7MCR\u0004BaD$\u0002jA\u0019q\"a\u001b\n\u0007\u00055\u0004CA\u0003GY>\fG\u000f\u0003\u0005\u0002r\u0005e\u0003\u0019AA4\u0003M!WmY5nC24VM\u001d2bi&lGj\u001c8h\u0011\u001d\t)\b\u0001C\u0001\u0003o\n\u0001eZ3u\u001dVl'-\u001a:PM\u0012+7-[7bYBc\u0017mY3t\u0013:$u.\u001e2mKR!\u0011\u0011PA@!\ry\u00111P\u0005\u0004\u0003{\u0002\"aA%oi\"9\u0011\u0011QA:\u0001\u00041\u0014a\u00043fG&l\u0017\r\\!t'R\u0014\u0018N\\4\t\u000f\u0005\u0015\u0005\u0001\"\u0003\u0002\b\u0006Q2\r[3dW\u000e{wN\u001d3j]\u0006$X-\u00168dKJ$\u0018-\u001b8usR91,!#\u0002\f\u00065\u0005B\u0002 \u0002\u0004\u0002\u0007q\b\u0003\u0004D\u0003\u0007\u0003\ra\u0010\u0005\u0007/\u0006\r\u0005\u0019\u0001'\t\u000f\u0005E\u0005\u0001\"\u0003\u0002\u0014\u0006)2\r[3dW\u001a{'OQ5p[\u0016l\u0015n]7bi\u000eDGcB.\u0002\u0016\u0006]\u0015\u0011\u0014\u0005\u0007}\u0005=\u0005\u0019A \t\r\r\u000by\t1\u0001@\u0011\u00199\u0016q\u0012a\u0001\u0019\"9\u0011Q\u0014\u0001\u0005\n\u0005}\u0015!F1eI\u000e{gn]3sm\u0006$\u0018n\u001c8Ti\u0006$Xo\u001d\u000b\u00067\u0006\u0005\u00161\u0015\u0005\u0007}\u0005m\u0005\u0019A \t\r\r\u000bY\n1\u0001@\u0011\u001d\t9\u000b\u0001C\u0005\u0003S\u000bQc\u00195fG.4uN]*uCR,W*[:nCR\u001c\u0007\u000eF\u0004\\\u0003W\u000bi+a,\t\ry\n)\u000b1\u0001@\u0011\u0019\u0019\u0015Q\u0015a\u0001\u007f!1q+!*A\u00021Cq!a-\u0001\t\u0003\t),\u0001\u000ewC2LG-\u0019;f\u000f\u0016|'/\u001a4fe\u0016t7-\u001a,bYV,7\u000fF\u0004M\u0003o\u000bI,a/\t\ry\n\t\f1\u0001@\u0011\u0019\u0019\u0015\u0011\u0017a\u0001\u007f!1q+!-A\u00021Cq!a0\u0001\t\u0003\t\t-A\rwC2LG-\u0019;f\u0007>|'\u000fZ5oCR,7OV1mk\u0016\u001cH\u0003CAb\u0003\u0013\fY-!4\u0011\u0007=\t)-C\u0002\u0002HB\u00111!\u00118z\u0011\u0019q\u0014Q\u0018a\u0001\u007f!11)!0A\u0002}BaaVA_\u0001\u0004a\u0005bBAi\u0001\u0011%\u00111[\u0001\u0010O\u0016$X\t_1diN\u001b\u0017NT1nKR\u0019a'!6\t\ry\ny\r1\u0001@\u0011\u001d\tI\u000e\u0001C\u0001\u00037\fqaZ3u\u001d\u0006lW-\u0006\u0002\u0002^B!\u0011q\\Au\u001b\t\t\tO\u0003\u0003\u0002d\u0006\u0015\u0018\u0001\u00027b]\u001eT!!a:\u0002\t)\fg/Y\u0005\u0004w\u0005\u0005\b\"CAw\u0001E\u0005I\u0011IAx\u0003E\u0001(o\\2fgN$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003cT3ARAzW\t\t)\u0010\u0005\u0003\u0002x\n\u0005QBAA}\u0015\u0011\tY0!@\u0002\u0013Ut7\r[3dW\u0016$'bAA\u0000!\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t\r\u0011\u0011 \u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public class LocationProcessor
implements Processor {
    private final Logger logger;

    public Logger logger() {
        return this.logger;
    }

    @Override
    public QualityAssertion[] process(String guid, FullRecord raw, FullRecord processed, Option<FullRecord> lastProcessed) {
        this.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Processing location for guid: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{guid})));
        ArrayBuffer assertions = new ArrayBuffer();
        this.setProcessedCoordinates(raw, processed, (ArrayBuffer<QualityAssertion>)assertions);
        this.processAltitudeAndDepth(guid, raw, processed, (ArrayBuffer<QualityAssertion>)assertions);
        if (processed.location().decimalLatitude() != null && processed.location().decimalLongitude() != null) {
            LocationDAO$.MODULE$.storePointForSampling(processed.location().decimalLatitude(), processed.location().decimalLongitude());
            this.validateCoordinatesValues(raw, processed, (ArrayBuffer<QualityAssertion>)assertions);
            this.checkCoordinateUncertainty(raw, processed, (ArrayBuffer<QualityAssertion>)assertions);
            Map<String, String> intersectValues = SpatialLayerDAO$.MODULE$.intersect(processed.location().decimalLongitude(), processed.location().decimalLatitude());
            processed.location().stateProvince_$eq((String)intersectValues.getOrElse((Object)Config$.MODULE$.stateProvinceLayerID(), (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Null$ apply() {
                    return null;
                }
            }));
            processed.location().lga_$eq((String)intersectValues.getOrElse((Object)Config$.MODULE$.localGovLayerID(), (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Null$ apply() {
                    return null;
                }
            }));
            processed.location().country_$eq((String)intersectValues.getOrElse((Object)Config$.MODULE$.countriesLayerID(), (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Null$ apply() {
                    return null;
                }
            }));
            if (processed.location().country() == null && processed.location().stateProvince() != null) {
                processed.location().country_$eq(Config$.MODULE$.defaultCountry());
            }
            processed.location().habitat_$eq(raw.location().habitat());
            processed.location().biome_$eq((String)(intersectValues.getOrElse((Object)Config$.MODULE$.terrestrialLayerID(), (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Null$ apply() {
                    return null;
                }
            }) == null ? (intersectValues.getOrElse((Object)Config$.MODULE$.marineLayerID(), (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Null$ apply() {
                    return null;
                }
            }) == null ? null : "Marine") : "Terrestrial"));
            this.checkForStateMismatch(raw, processed, (ArrayBuffer<QualityAssertion>)assertions);
            this.addConservationStatus(raw, processed);
            this.checkForBiomeMismatch(raw, processed, (ArrayBuffer<QualityAssertion>)assertions);
        }
        this.checkLocationSupplied(raw, processed, (ArrayBuffer<QualityAssertion>)assertions);
        this.validateCoordinates(raw, processed, (ArrayBuffer<QualityAssertion>)assertions);
        this.processStateCountryValues(raw, processed, (ArrayBuffer<QualityAssertion>)assertions);
        this.validateGeoreferenceValues(raw, processed, (ArrayBuffer<QualityAssertion>)assertions);
        return (QualityAssertion[])assertions.toArray(ClassTag$.MODULE$.apply(QualityAssertion.class));
    }

    @Override
    public Option<FullRecord> process$default$4() {
        return None$.MODULE$;
    }

    public ArrayBuffer<QualityAssertion> checkLocationSupplied(FullRecord raw, FullRecord processed, ArrayBuffer<QualityAssertion> assertions) {
        return processed.location().decimalLatitude() == null || processed.location().decimalLongitude() == null ? (raw.location().footprintWKT() == null && raw.location().locality() == null && raw.location().locationID() == null ? assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.LOCATION_NOT_SUPPLIED())) : assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.LOCATION_NOT_SUPPLIED(), AssertionStatus$.MODULE$.PASSED()))) : assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.LOCATION_NOT_SUPPLIED(), AssertionStatus$.MODULE$.PASSED()));
    }

    private void processStateCountryValues(FullRecord raw, FullRecord processed, ArrayBuffer<QualityAssertion> assertions) {
        Option<Term> countryCodeTerm;
        Option<Term> countryTerm;
        Option<Term> stateTerm;
        if (processed.location().stateProvince() == null && raw.location().decimalLatitude() == null && raw.location().decimalLongitude() == null && !(stateTerm = StateProvinces$.MODULE$.matchTerm(raw.location().stateProvince())).isEmpty()) {
            processed.location().stateProvince_$eq(((Term)stateTerm.get()).canonical());
            processed.location().country_$eq((String)StateProvinceToCountry$.MODULE$.map().getOrElse((Object)processed.location().stateProvince(), (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "";
                }
            }));
        }
        if (processed.location().country() == null && raw.location().decimalLatitude() == null && raw.location().decimalLongitude() == null && !(countryTerm = Countries$.MODULE$.matchTerm(raw.location().country())).isEmpty()) {
            processed.location().country_$eq(((Term)countryTerm.get()).canonical());
        }
        if (processed.location().country() == null && raw.location().countryCode() != null && !(countryCodeTerm = Countries$.MODULE$.matchTerm(raw.location().countryCode())).isEmpty()) {
            processed.location().country_$eq(((Term)countryCodeTerm.get()).canonical());
        }
    }

    private void validateCoordinates(FullRecord raw, FullRecord processed, ArrayBuffer<QualityAssertion> assertions) {
        ArrayBuffer arrayBuffer = raw.location().country() == null && processed.location().country() != null ? assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.COUNTRY_INFERRED_FROM_COORDINATES(), AssertionStatus$.MODULE$.FAILED())) : assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.COUNTRY_INFERRED_FROM_COORDINATES(), AssertionStatus$.MODULE$.PASSED()));
        ArrayBuffer arrayBuffer2 = StateProvinceCentrePoints$.MODULE$.coordinatesMatchCentre(processed.location().stateProvince(), raw.location().decimalLatitude(), raw.location().decimalLongitude()) ? assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.COORDINATES_CENTRE_OF_STATEPROVINCE(), new StringBuilder().append((Object)"Coordinates are centre point of ").append((Object)processed.location().stateProvince()).toString())) : assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.COORDINATES_CENTRE_OF_STATEPROVINCE(), AssertionStatus$.MODULE$.PASSED()));
        if (CountryCentrePoints$.MODULE$.coordinatesMatchCentre(processed.location().country(), raw.location().decimalLatitude(), raw.location().decimalLongitude())) {
            assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.COORDINATES_CENTRE_OF_COUNTRY(), new StringBuilder().append((Object)"Coordinates are centre point of ").append((Object)processed.location().country()).toString()));
        } else {
            assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.COORDINATES_CENTRE_OF_COUNTRY(), AssertionStatus$.MODULE$.PASSED()));
        }
    }

    private void processAltitudeAndDepth(String guid, FullRecord raw, FullRecord processed, ArrayBuffer<QualityAssertion> assertions) {
        this.processVerbatimDepth(raw, processed, assertions);
        this.processVerbatimElevation(raw, processed, assertions);
        this.processMinMaxDepth(raw, processed, assertions);
    }

    private void processMinMaxDepth(FullRecord raw, FullRecord processed, ArrayBuffer<QualityAssertion> assertions) {
        BoxedUnit boxedUnit;
        if (raw.location().minimumDepthInMeters() == null || raw.location().maximumDepthInMeters() == null) {
            boxedUnit = BoxedUnit.UNIT;
        } else {
            try {
                float min = new StringOps(Predef$.MODULE$.augmentString(raw.location().minimumDepthInMeters())).toFloat();
                float max = new StringOps(Predef$.MODULE$.augmentString(raw.location().maximumDepthInMeters())).toFloat();
                if (min > max) {
                    processed.location().minimumDepthInMeters_$eq(((Object)BoxesRunTime.boxToFloat((float)max)).toString());
                    processed.location().maximumDepthInMeters_$eq(((Object)BoxesRunTime.boxToFloat((float)min)).toString());
                    boxedUnit = assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MIN_MAX_DEPTH_REVERSED(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The minimum, ", " and maximum, ", " depths have been transposed."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToFloat((float)min), BoxesRunTime.boxToFloat((float)max)}))));
                } else {
                    processed.location().minimumDepthInMeters_$eq(((Object)BoxesRunTime.boxToFloat((float)min)).toString());
                    processed.location().maximumDepthInMeters_$eq(((Object)BoxesRunTime.boxToFloat((float)max)).toString());
                    boxedUnit = assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MIN_MAX_DEPTH_REVERSED(), AssertionStatus$.MODULE$.PASSED()));
                }
            }
            catch (Exception exception) {
                this.logger().debug(new StringBuilder().append((Object)"Exception thrown processing minimumDepthInMeters:").append((Object)exception.getMessage()).toString());
                boxedUnit = BoxedUnit.UNIT;
            }
        }
        if (raw.location().minimumElevationInMeters() != null && raw.location().maximumElevationInMeters() != null) {
            try {
                float min = new StringOps(Predef$.MODULE$.augmentString(raw.location().minimumElevationInMeters())).toFloat();
                float max = new StringOps(Predef$.MODULE$.augmentString(raw.location().maximumElevationInMeters())).toFloat();
                if (min > max) {
                    processed.location().minimumElevationInMeters_$eq(((Object)BoxesRunTime.boxToFloat((float)max)).toString());
                    processed.location().maximumElevationInMeters_$eq(((Object)BoxesRunTime.boxToFloat((float)min)).toString());
                    assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MIN_MAX_ALTITUDE_REVERSED(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The minimum, ", ", and maximum, ", ", elevations have been transposed."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToFloat((float)min), BoxesRunTime.boxToFloat((float)max)}))));
                } else {
                    processed.location().minimumElevationInMeters_$eq(((Object)BoxesRunTime.boxToFloat((float)min)).toString());
                    processed.location().maximumElevationInMeters_$eq(((Object)BoxesRunTime.boxToFloat((float)max)).toString());
                    assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MIN_MAX_ALTITUDE_REVERSED(), AssertionStatus$.MODULE$.PASSED()));
                }
            }
            catch (Exception exception) {
                this.logger().debug(new StringBuilder().append((Object)"Exception thrown processing elevation:").append((Object)exception.getMessage()).toString());
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processVerbatimElevation(FullRecord raw, FullRecord processed, ArrayBuffer<QualityAssertion> assertions) {
        if (raw.location().verbatimElevation() == null) return;
        Option<Tuple2<Object, MeasurementUnit>> parseElevationResult = DistanceRangeParser$.MODULE$.parse(raw.location().verbatimElevation());
        if (parseElevationResult.isDefined()) {
            Tuple2 tuple2;
            Tuple2 tuple22 = (Tuple2)parseElevationResult.get();
            if (tuple22 == null) throw new MatchError((Object)tuple22);
            float velevation = BoxesRunTime.unboxToFloat((Object)tuple22._1());
            MeasurementUnit sourceUnit = (MeasurementUnit)tuple22._2();
            Tuple2 tuple23 = tuple2 = new Tuple2((Object)BoxesRunTime.boxToFloat((float)velevation), (Object)sourceUnit);
            float velevation2 = BoxesRunTime.unboxToFloat((Object)tuple23._1());
            MeasurementUnit sourceUnit2 = (MeasurementUnit)tuple23._2();
            processed.location().verbatimElevation_$eq(((Object)BoxesRunTime.boxToFloat((float)velevation2)).toString());
            ArrayBuffer arrayBuffer = velevation2 > (float)10000 || velevation2 < (float)-100 ? assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.ALTITUDE_OUT_OF_RANGE(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Elevation ", " is greater than 10,000 metres or less than -100 metres."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToFloat((float)velevation2)})))) : assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.ALTITUDE_OUT_OF_RANGE(), AssertionStatus$.MODULE$.PASSED()));
            assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.ALTITUDE_NON_NUMERIC(), AssertionStatus$.MODULE$.PASSED()));
            MeasurementUnit measurementUnit = sourceUnit2;
            Feet$ feet$ = Feet$.MODULE$;
            if (!(measurementUnit != null ? !measurementUnit.equals(feet$) : feet$ != null)) {
                assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.ALTITUDE_IN_FEET(), "The supplied altitude was in feet it has been converted to metres"));
                return;
            } else {
                assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.ALTITUDE_IN_FEET(), AssertionStatus$.MODULE$.PASSED()));
            }
            return;
        } else {
            assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.ALTITUDE_NON_NUMERIC(), new StringBuilder().append((Object)"Can't parse verbatimElevation ").append((Object)raw.location().verbatimElevation()).toString()));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processVerbatimDepth(FullRecord raw, FullRecord processed, ArrayBuffer<QualityAssertion> assertions) {
        if (raw.location().verbatimDepth() == null) return;
        Option<Tuple2<Object, MeasurementUnit>> parseDepthResult = DistanceRangeParser$.MODULE$.parse(raw.location().verbatimDepth());
        if (parseDepthResult.isDefined()) {
            Tuple2 tuple2;
            Tuple2 tuple22 = (Tuple2)parseDepthResult.get();
            if (tuple22 == null) throw new MatchError((Object)tuple22);
            float vdepth = BoxesRunTime.unboxToFloat((Object)tuple22._1());
            MeasurementUnit sourceUnit = (MeasurementUnit)tuple22._2();
            Tuple2 tuple23 = tuple2 = new Tuple2((Object)BoxesRunTime.boxToFloat((float)vdepth), (Object)sourceUnit);
            float vdepth2 = BoxesRunTime.unboxToFloat((Object)tuple23._1());
            MeasurementUnit sourceUnit2 = (MeasurementUnit)tuple23._2();
            processed.location().verbatimDepth_$eq(((Object)BoxesRunTime.boxToFloat((float)vdepth2)).toString());
            ArrayBuffer arrayBuffer = vdepth2 > (float)10000 ? assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DEPTH_OUT_OF_RANGE(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Depth ", " is greater than 10,000 metres"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToFloat((float)vdepth2)})))) : assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DEPTH_OUT_OF_RANGE(), AssertionStatus$.MODULE$.PASSED()));
            assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DEPTH_NON_NUMERIC(), AssertionStatus$.MODULE$.PASSED()));
            MeasurementUnit measurementUnit = sourceUnit2;
            Feet$ feet$ = Feet$.MODULE$;
            if (!(measurementUnit != null ? !measurementUnit.equals(feet$) : feet$ != null)) {
                assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DEPTH_IN_FEET(), "The supplied depth was in feet it has been converted to metres"));
                return;
            } else {
                assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DEPTH_IN_FEET(), AssertionStatus$.MODULE$.PASSED()));
            }
            return;
        } else {
            assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DEPTH_NON_NUMERIC(), new StringBuilder().append((Object)"Can't parse verbatimDepth ").append((Object)raw.location().verbatimDepth()).toString()));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setProcessedCoordinates(FullRecord raw, FullRecord processed, ArrayBuffer<QualityAssertion> assertions) {
        if (raw.location().originalDecimalLatitude() == null || raw.location().originalDecimalLongitude() == null) {
            Option<GISPoint> gisPointOption = this.processLatLong(raw.location().decimalLatitude(), raw.location().decimalLongitude(), raw.location().geodeticDatum(), raw.location().verbatimLatitude(), raw.location().verbatimLongitude(), raw.location().verbatimSRS(), raw.location().easting(), raw.location().northing(), raw.location().zone(), raw.location().gridReference(), assertions);
            Option<GISPoint> option = gisPointOption;
            if (option instanceof Some) {
                Some some = (Some)option;
                GISPoint gisPoint = (GISPoint)some.x();
                processed.location().decimalLatitude_$eq(gisPoint.latitude());
                processed.location().decimalLongitude_$eq(gisPoint.longitude());
                processed.location().geodeticDatum_$eq(gisPoint.datum());
                processed.location().coordinateUncertaintyInMeters_$eq(gisPoint.coordinateUncertaintyInMeters());
                processed.location().bbox_$eq(gisPoint.bboxString());
                processed.location().northing_$eq(gisPoint.northing());
                processed.location().easting_$eq(gisPoint.easting());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            } else {
                None$ none$ = None$.MODULE$;
                Option<GISPoint> option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) throw new MatchError(option);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        } else {
            processed.location().decimalLatitude_$eq(raw.location().originalDecimalLatitude());
            processed.location().decimalLongitude_$eq(raw.location().originalDecimalLongitude());
            processed.location().verbatimLatitude_$eq(raw.location().originalVerbatimLatitude());
            processed.location().verbatimLongitude_$eq(raw.location().originalVerbatimLongitude());
            raw.location().decimalLatitude_$eq(raw.location().originalDecimalLatitude());
            raw.location().decimalLongitude_$eq(raw.location().originalDecimalLongitude());
        }
    }

    public Option<GISPoint> processLatLong(String rawLatitude, String rawLongitude, String rawGeodeticDatum, String verbatimLatitude, String verbatimLongitude, String verbatimSRS, String easting, String northing, String zone, String gridReference, ArrayBuffer<QualityAssertion> assertions) {
        Option<GISPoint> option;
        if (rawLatitude == null || rawLongitude == null || StringHelper$.MODULE$.string2helper(rawLatitude).toFloatWithOption().isEmpty() || StringHelper$.MODULE$.string2helper(rawLongitude).toFloatWithOption().isEmpty()) {
            assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DECIMAL_COORDINATES_NOT_SUPPLIED()));
            if (verbatimLatitude == null || verbatimLongitude == null) {
                if (easting == null || northing == null || zone == null) {
                    if (gridReference == null) {
                        option = None$.MODULE$;
                    } else {
                        Option<GISPoint> result = GridUtil$.MODULE$.processGridReference(gridReference);
                        Object object = result.isEmpty() ? BoxedUnit.UNIT : assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DECIMAL_LAT_LONG_CALCULATED_FROM_GRID_REF()));
                        option = result;
                    }
                } else {
                    option = GridUtil$.MODULE$.processNorthingEastingZone(verbatimSRS, easting, northing, zone, assertions);
                }
            } else {
                Option<Object> decimalVerbatimLat = StringHelper$.MODULE$.string2helper(verbatimLatitude).toFloatWithOption();
                Option<Object> decimalVerbatimLong = StringHelper$.MODULE$.string2helper(verbatimLongitude).toFloatWithOption();
                if (decimalVerbatimLat.isEmpty() || decimalVerbatimLong.isEmpty()) {
                    decimalVerbatimLat = VerbatimLatLongParser$.MODULE$.parse(verbatimLatitude);
                    decimalVerbatimLong = VerbatimLatLongParser$.MODULE$.parse(verbatimLongitude);
                }
                option = decimalVerbatimLat.isEmpty() || decimalVerbatimLong.isEmpty() ? None$.MODULE$ : this.processVerbatimCoordinates(verbatimSRS, assertions, decimalVerbatimLat, decimalVerbatimLong);
            }
        } else {
            option = this.processDecimalCoordinates(rawLatitude, rawLongitude, rawGeodeticDatum, assertions);
        }
        return option;
    }

    private Option<GISPoint> processDecimalCoordinates(String rawLatitude, String rawLongitude, String rawGeodeticDatum, ArrayBuffer<QualityAssertion> assertions) {
        Tuple2 tuple2;
        block7: {
            Some some;
            block3: {
                Tuple2 tuple22;
                Option<Tuple2<String, String>> reprojectedCoords;
                block6: {
                    Option<String> sourceEpsgCode;
                    block5: {
                        block4: {
                            block2: {
                                assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DECIMAL_COORDINATES_NOT_SUPPLIED(), AssertionStatus$.MODULE$.PASSED()));
                                if (rawGeodeticDatum != null) break block2;
                                assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.GEODETIC_DATUM_ASSUMED_WGS84(), "Geodetic datum assumed to be WGS84 (EPSG:4326)"));
                                some = new Some((Object)new GISPoint(rawLatitude, rawLongitude, GISUtil$.MODULE$.WGS84_EPSG_Code(), null, GISPoint$.MODULE$.apply$default$5(), GISPoint$.MODULE$.apply$default$6(), GISPoint$.MODULE$.apply$default$7(), GISPoint$.MODULE$.apply$default$8(), GISPoint$.MODULE$.apply$default$9(), GISPoint$.MODULE$.apply$default$10()));
                                break block3;
                            }
                            assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.GEODETIC_DATUM_ASSUMED_WGS84(), AssertionStatus$.MODULE$.PASSED()));
                            sourceEpsgCode = GridUtil$.MODULE$.lookupEpsgCode(rawGeodeticDatum);
                            if (!sourceEpsgCode.isEmpty()) break block4;
                            assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.UNRECOGNIZED_GEODETIC_DATUM(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Geodetic datum ", " not recognized."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rawGeodeticDatum}))));
                            some = new Some((Object)new GISPoint(rawLatitude, rawLongitude, rawGeodeticDatum, null, GISPoint$.MODULE$.apply$default$5(), GISPoint$.MODULE$.apply$default$6(), GISPoint$.MODULE$.apply$default$7(), GISPoint$.MODULE$.apply$default$8(), GISPoint$.MODULE$.apply$default$9(), GISPoint$.MODULE$.apply$default$10()));
                            break block3;
                        }
                        assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.UNRECOGNIZED_GEODETIC_DATUM(), AssertionStatus$.MODULE$.PASSED()));
                        Object object = sourceEpsgCode.get();
                        String string = GISUtil$.MODULE$.WGS84_EPSG_Code();
                        if (object != null ? !object.equals(string) : string != null) break block5;
                        some = new Some((Object)new GISPoint(rawLatitude, rawLongitude, GISUtil$.MODULE$.WGS84_EPSG_Code(), null, GISPoint$.MODULE$.apply$default$5(), GISPoint$.MODULE$.apply$default$6(), GISPoint$.MODULE$.apply$default$7(), GISPoint$.MODULE$.apply$default$8(), GISPoint$.MODULE$.apply$default$9(), GISPoint$.MODULE$.apply$default$10()));
                        break block3;
                    }
                    int desiredNoDecimalPlaces = package$.MODULE$.min(this.getNumberOfDecimalPlacesInDouble(rawLatitude), this.getNumberOfDecimalPlacesInDouble(rawLongitude));
                    reprojectedCoords = GISUtil$.MODULE$.reprojectCoordinatesToWGS84(new StringOps(Predef$.MODULE$.augmentString(rawLatitude)).toDouble(), new StringOps(Predef$.MODULE$.augmentString(rawLongitude)).toDouble(), (String)sourceEpsgCode.get(), desiredNoDecimalPlaces);
                    if (!reprojectedCoords.isEmpty()) break block6;
                    assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DECIMAL_LAT_LONG_CONVERSION_FAILED(), "Transformation of decimal latiude and longitude to WGS84 failed"));
                    some = None$.MODULE$;
                    break block3;
                }
                assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DECIMAL_LAT_LONG_CONVERSION_FAILED(), AssertionStatus$.MODULE$.PASSED()));
                assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DECIMAL_LAT_LONG_CONVERTED(), "Decimal latitude and longitude were converted to WGS84 (EPSG:4326)"));
                tuple2 = (Tuple2)reprojectedCoords.get();
                if (tuple2 == null) break block7;
                String reprojectedLatitude = (String)tuple2._1();
                String reprojectedLongitude = (String)tuple2._2();
                Tuple2 tuple23 = tuple22 = new Tuple2((Object)reprojectedLatitude, (Object)reprojectedLongitude);
                String reprojectedLatitude2 = (String)tuple23._1();
                String reprojectedLongitude2 = (String)tuple23._2();
                some = new Some((Object)new GISPoint(reprojectedLatitude2, reprojectedLongitude2, GISUtil$.MODULE$.WGS84_EPSG_Code(), null, GISPoint$.MODULE$.apply$default$5(), GISPoint$.MODULE$.apply$default$6(), GISPoint$.MODULE$.apply$default$7(), GISPoint$.MODULE$.apply$default$8(), GISPoint$.MODULE$.apply$default$9(), GISPoint$.MODULE$.apply$default$10()));
            }
            return some;
        }
        throw new MatchError((Object)tuple2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Option<GISPoint> processVerbatimCoordinates(String verbatimSRS, ArrayBuffer<QualityAssertion> assertions, Option<Object> decimalVerbatimLat, Option<Object> decimalVerbatimLong) {
        None$ none$;
        if (StringHelper$.MODULE$.string2helper(decimalVerbatimLat.get().toString()).isLatitude() && StringHelper$.MODULE$.string2helper(decimalVerbatimLong.get().toString()).isLongitude()) {
            if (verbatimSRS == null) {
                if (StringHelper$.MODULE$.string2helper(decimalVerbatimLat.get().toString()).isLatitude() && StringHelper$.MODULE$.string2helper(decimalVerbatimLong.get().toString()).isLongitude()) {
                    assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DECIMAL_LAT_LONG_CALCULATION_FROM_VERBATIM_FAILED(), AssertionStatus$.MODULE$.PASSED()));
                    assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DECIMAL_LAT_LONG_CALCULATED_FROM_VERBATIM(), "Decimal latitude and longitude were calculated using verbatimLatitude, verbatimLongitude and verbatimSRS"));
                    none$ = new Some((Object)new GISPoint(decimalVerbatimLat.get().toString(), decimalVerbatimLong.get().toString(), GISUtil$.MODULE$.WGS84_EPSG_Code(), null, GISPoint$.MODULE$.apply$default$5(), GISPoint$.MODULE$.apply$default$6(), GISPoint$.MODULE$.apply$default$7(), GISPoint$.MODULE$.apply$default$8(), GISPoint$.MODULE$.apply$default$9(), GISPoint$.MODULE$.apply$default$10()));
                    return none$;
                } else {
                    assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DECIMAL_LAT_LONG_CALCULATION_FROM_VERBATIM_FAILED(), "Could not parse verbatim latitude and longitude"));
                    none$ = None$.MODULE$;
                }
                return none$;
            } else {
                Option<String> sourceEpsgCode = GridUtil$.MODULE$.lookupEpsgCode(verbatimSRS);
                if (sourceEpsgCode.isEmpty()) {
                    assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DECIMAL_LAT_LONG_CALCULATION_FROM_VERBATIM_FAILED(), new StringBuilder().append((Object)"Unrecognized verbatimSRS ").append((Object)verbatimSRS).toString()));
                    none$ = None$.MODULE$;
                    return none$;
                } else {
                    assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DECIMAL_LAT_LONG_CALCULATION_FROM_VERBATIM_FAILED(), AssertionStatus$.MODULE$.PASSED()));
                    Object object = sourceEpsgCode.get();
                    String string = GISUtil$.MODULE$.WGS84_EPSG_Code();
                    if (!(object != null ? !object.equals(string) : string != null)) {
                        assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DECIMAL_LAT_LONG_CALCULATED_FROM_VERBATIM(), "Decimal latitude and longitude were calculated using verbatimLatitude, verbatimLongitude and verbatimSRS"));
                        none$ = new Some((Object)new GISPoint(decimalVerbatimLat.get().toString(), decimalVerbatimLong.get().toString(), GISUtil$.MODULE$.WGS84_EPSG_Code(), null, GISPoint$.MODULE$.apply$default$5(), GISPoint$.MODULE$.apply$default$6(), GISPoint$.MODULE$.apply$default$7(), GISPoint$.MODULE$.apply$default$8(), GISPoint$.MODULE$.apply$default$9(), GISPoint$.MODULE$.apply$default$10()));
                        return none$;
                    } else {
                        int desiredNoDecimalPlaces = package$.MODULE$.min(this.getNumberOfDecimalPlacesInDouble(decimalVerbatimLat.get().toString()), this.getNumberOfDecimalPlacesInDouble(decimalVerbatimLong.get().toString()));
                        Option<Tuple2<String, String>> reprojectedCoords = GISUtil$.MODULE$.reprojectCoordinatesToWGS84(BoxesRunTime.unboxToFloat((Object)decimalVerbatimLat.get()), BoxesRunTime.unboxToFloat((Object)decimalVerbatimLong.get()), (String)sourceEpsgCode.get(), desiredNoDecimalPlaces);
                        if (reprojectedCoords.isEmpty()) {
                            assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DECIMAL_LAT_LONG_CALCULATION_FROM_VERBATIM_FAILED(), "Transformation of verbatim latiude and longitude to WGS84 failed"));
                            none$ = None$.MODULE$;
                            return none$;
                        } else {
                            Tuple2 tuple2;
                            assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DECIMAL_LAT_LONG_CALCULATION_FROM_VERBATIM_FAILED(), AssertionStatus$.MODULE$.PASSED()));
                            assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.DECIMAL_LAT_LONG_CALCULATED_FROM_VERBATIM(), "Decimal latitude and longitude were calculated using verbatimLatitude, verbatimLongitude and verbatimSRS"));
                            Tuple2 tuple22 = (Tuple2)reprojectedCoords.get();
                            if (tuple22 == null) throw new MatchError((Object)tuple22);
                            String reprojectedLatitude = (String)tuple22._1();
                            String reprojectedLongitude = (String)tuple22._2();
                            Tuple2 tuple23 = tuple2 = new Tuple2((Object)reprojectedLatitude, (Object)reprojectedLongitude);
                            String reprojectedLatitude2 = (String)tuple23._1();
                            String reprojectedLongitude2 = (String)tuple23._2();
                            none$ = new Some((Object)new GISPoint(reprojectedLatitude2, reprojectedLongitude2, GISUtil$.MODULE$.WGS84_EPSG_Code(), null, GISPoint$.MODULE$.apply$default$5(), GISPoint$.MODULE$.apply$default$6(), GISPoint$.MODULE$.apply$default$7(), GISPoint$.MODULE$.apply$default$8(), GISPoint$.MODULE$.apply$default$9(), GISPoint$.MODULE$.apply$default$10()));
                        }
                    }
                }
            }
            return none$;
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public int getNumberOfDecimalPlacesInDouble(String decimalAsString) {
        String[] tokens = new StringOps(Predef$.MODULE$.augmentString(decimalAsString)).split('.');
        return tokens.length == 2 ? tokens[1].length() : 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkCoordinateUncertainty(FullRecord raw, FullRecord processed, ArrayBuffer<QualityAssertion> assertions) {
        ArrayBuffer arrayBuffer;
        BoxedUnit boxedUnit;
        boolean checkedPrecision = false;
        if (raw.location().coordinateUncertaintyInMeters() != null && raw.location().coordinateUncertaintyInMeters().length() > 0) {
            Option<Tuple2<Object, MeasurementUnit>> parsedResult = DistanceRangeParser$.MODULE$.parse(raw.location().coordinateUncertaintyInMeters());
            if (parsedResult.isEmpty()) {
                String comment = new StringBuilder().append((Object)"Supplied uncertainty, ").append((Object)raw.location().coordinateUncertaintyInMeters()).append((Object)", is not a supported format").toString();
                boxedUnit = assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.UNCERTAINTY_RANGE_MISMATCH(), comment));
            } else {
                ArrayBuffer arrayBuffer2;
                Tuple2 tuple2;
                Tuple2 tuple22 = (Tuple2)parsedResult.get();
                if (tuple22 == null) throw new MatchError((Object)tuple22);
                float parsedValue = BoxesRunTime.unboxToFloat((Object)tuple22._1());
                MeasurementUnit rawUnit = (MeasurementUnit)tuple22._2();
                Tuple2 tuple23 = tuple2 = new Tuple2((Object)BoxesRunTime.boxToFloat((float)parsedValue), (Object)rawUnit);
                float parsedValue2 = BoxesRunTime.unboxToFloat((Object)tuple23._1());
                MeasurementUnit rawUnit2 = (MeasurementUnit)tuple23._2();
                if (parsedValue2 > 0.0f) {
                    arrayBuffer2 = assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.UNCERTAINTY_RANGE_MISMATCH(), AssertionStatus$.MODULE$.PASSED()));
                } else {
                    String comment = new StringBuilder().append((Object)"Supplied uncertainty, ").append((Object)raw.location().coordinateUncertaintyInMeters()).append((Object)", is not a supported format").toString();
                    arrayBuffer2 = assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.UNCERTAINTY_RANGE_MISMATCH(), comment));
                }
                processed.location().coordinateUncertaintyInMeters_$eq(((Object)BoxesRunTime.boxToFloat((float)parsedValue2)).toString());
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            Option<Object> value;
            if (raw.location().coordinatePrecision() != null && !(value = StringHelper$.MODULE$.string2helper(raw.location().coordinatePrecision()).toFloatWithOption()).isEmpty() && BoxesRunTime.unboxToFloat((Object)value.get()) > 1.0f) {
                processed.location().coordinateUncertaintyInMeters_$eq(((Object)BoxesRunTime.boxToInteger((int)((int)BoxesRunTime.unboxToFloat((Object)value.get())))).toString());
                String comment = new StringBuilder().append((Object)"Supplied precision, ").append((Object)raw.location().coordinatePrecision()).append((Object)", is assumed to be uncertainty in metres").toString();
                assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.UNCERTAINTY_IN_PRECISION(), comment));
                checkedPrecision = true;
            }
            boxedUnit = BoxedUnit.UNIT;
        }
        if (StringUtils.isBlank((String)raw.location().coordinatePrecision())) {
            arrayBuffer = assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MISSING_COORDINATEPRECISION(), "Missing coordinatePrecision"));
        } else {
            assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MISSING_COORDINATEPRECISION(), AssertionStatus$.MODULE$.PASSED()));
            if (checkedPrecision) {
                arrayBuffer = BoxedUnit.UNIT;
            } else {
                Option<Object> value = StringHelper$.MODULE$.string2helper(raw.location().coordinatePrecision()).toFloatWithOption();
                if (value.isDefined()) {
                    if (BoxesRunTime.unboxToFloat((Object)value.get()) > 0.0f && BoxesRunTime.unboxToFloat((Object)value.get()) <= 1.0f) {
                        int lonp;
                        assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.PRECISION_RANGE_MISMATCH(), AssertionStatus$.MODULE$.PASSED()));
                        int pre = raw.location().coordinatePrecision().contains(".") ? raw.location().coordinatePrecision().split("\\.")[1].length() : 0;
                        String lat2 = processed.location().decimalLatitude();
                        String string = processed.location().decimalLongitude();
                        int latp = lat2.contains(".") ? lat2.split("\\.")[1].length() : 0;
                        int n = lonp = string.contains(".") ? string.split("\\.")[1].length() : 0;
                        arrayBuffer = pre == latp && pre == lonp ? assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.COORDINATE_PRECISION_MISMATCH(), AssertionStatus$.MODULE$.PASSED())) : assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.COORDINATE_PRECISION_MISMATCH()));
                    } else {
                        arrayBuffer = assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.PRECISION_RANGE_MISMATCH(), "Coordinate precision is not between 0 and 1"));
                    }
                } else {
                    arrayBuffer = assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.PRECISION_RANGE_MISMATCH(), "Unable to parse the coordinate precision"));
                }
            }
        }
        if (processed.location().coordinateUncertaintyInMeters() == null) {
            assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.UNCERTAINTY_NOT_SPECIFIED(), "Uncertainty was not supplied"));
            return;
        } else {
            assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.UNCERTAINTY_NOT_SPECIFIED(), AssertionStatus$.MODULE$.PASSED()));
        }
    }

    /*
     * Unable to fully structure code
     */
    private void checkForBiomeMismatch(FullRecord raw, FullRecord processed, ArrayBuffer<QualityAssertion> assertions) {
        block9: {
            block8: {
                if (processed.location().biome() == null) {
                    assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.COORDINATE_HABITAT_MISMATCH(), 2));
                    return;
                }
                taxonProfileWithOption = TaxonProfileDAO$.MODULE$.getByGuid(processed.classification().taxonConceptID());
                genusProfileWithOption = TaxonProfileDAO$.MODULE$.getByGuid(processed.classification().genusID());
                if (taxonProfileWithOption.isEmpty()) break block8;
                if (((TaxonProfile)taxonProfileWithOption.get()).habitats() == null || Predef$.MODULE$.refArrayOps((Object[])((TaxonProfile)taxonProfileWithOption.get()).habitats()).isEmpty()) break block8;
                v0 = ((TaxonProfile)taxonProfileWithOption.get()).habitats();
                break block9;
            }
            if (genusProfileWithOption.isEmpty()) ** GOTO lbl-1000
            if (((TaxonProfile)genusProfileWithOption.get()).habitats() != null && !Predef$.MODULE$.refArrayOps((Object[])((TaxonProfile)genusProfileWithOption.get()).habitats()).isEmpty()) {
                v0 = ((TaxonProfile)genusProfileWithOption.get()).habitats();
            } else lbl-1000:
            // 2 sources

            {
                v0 = habitats = (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class));
            }
        }
        if (Predef$.MODULE$.refArrayOps((Object[])habitats).isEmpty()) {
            assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.COORDINATE_HABITAT_MISMATCH(), AssertionStatus$.MODULE$.UNCHECKED()));
        } else {
            habitatsAsString = Predef$.MODULE$.refArrayOps((Object[])habitats).mkString(",");
            habitatFromPoint = processed.location().biome();
            validHabitat = HabitatMap$.MODULE$.areTermsCompatible(habitatFromPoint, habitatsForSpecies = habitats);
            if (!validHabitat.isEmpty()) {
                if (BoxesRunTime.unboxToBoolean((Object)validHabitat.get())) {
                    assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.COORDINATE_HABITAT_MISMATCH(), AssertionStatus$.MODULE$.PASSED()));
                } else {
                    this.logger().debug(new StringBuilder().append((Object)"[QualityAssertion] ******** Biomes incompatible for ROWKEY: ").append((Object)raw.rowKey()).append((Object)", processed:").append((Object)processed.location().biome()).append((Object)", retrieved:").append((Object)habitatsAsString).append((Object)", http://maps.google.com/?ll=").append((Object)processed.location().decimalLatitude()).append((Object)",").append((Object)processed.location().decimalLongitude()).toString());
                    comment = new StringBuilder().append((Object)"Recognised habitats for species: ").append((Object)habitatsAsString).append((Object)", Value determined from coordinates: ").append((Object)habitatFromPoint).toString();
                    assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.COORDINATE_HABITAT_MISMATCH(), comment));
                }
            }
        }
    }

    private void addConservationStatus(FullRecord raw, FullRecord processed) {
        Option<TaxonProfile> taxonProfileWithOption = TaxonProfileDAO$.MODULE$.getByGuid(processed.classification().taxonConceptID());
        if (!taxonProfileWithOption.isEmpty()) {
            TaxonProfile taxonProfile = (TaxonProfile)taxonProfileWithOption.get();
            if (taxonProfile.conservation() != null) {
                Option<String> country = taxonProfile.retrieveConservationStatus(processed.location().country());
                processed.occurrence().countryConservation_$eq((String)country.getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Null$ apply() {
                        return null;
                    }
                }));
                Option<String> state = taxonProfile.retrieveConservationStatus(processed.location().stateProvince());
                processed.occurrence().stateConservation_$eq((String)state.getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Null$ apply() {
                        return null;
                    }
                }));
                Option<String> global = taxonProfile.retrieveConservationStatus("Global");
                processed.occurrence().globalConservation_$eq((String)global.getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Null$ apply() {
                        return null;
                    }
                }));
            }
        }
    }

    private void checkForStateMismatch(FullRecord raw, FullRecord processed, ArrayBuffer<QualityAssertion> assertions) {
        if (processed.location().stateProvince() == null || raw.location().stateProvince() == null) {
            assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.STATE_COORDINATE_MISMATCH(), AssertionStatus$.MODULE$.UNCHECKED()));
        } else {
            Option<Term> stateTerm = StateProvinces$.MODULE$.matchTerm(raw.location().stateProvince());
            if (stateTerm.isEmpty() || processed.location().stateProvince().equalsIgnoreCase(((Term)stateTerm.get()).canonical())) {
                assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.STATE_COORDINATE_MISMATCH(), AssertionStatus$.MODULE$.PASSED()));
            } else {
                this.logger().debug(new StringBuilder().append((Object)"[QualityAssertion] ").append((Object)raw.rowKey()).append((Object)", processed:").append((Object)processed.location().stateProvince()).append((Object)", raw:").append((Object)raw.location().stateProvince()).toString());
                String comment = new StringBuilder().append((Object)"Supplied: ").append((Object)((Term)stateTerm.get()).canonical()).append((Object)", calculated: ").append((Object)processed.location().stateProvince()).toString();
                assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.STATE_COORDINATE_MISMATCH(), comment));
            }
        }
    }

    public ArrayBuffer<QualityAssertion> validateGeoreferenceValues(FullRecord raw, FullRecord processed, ArrayBuffer<QualityAssertion> assertions) {
        ArrayBuffer arrayBuffer = raw.location().geodeticDatum() == null && processed.location().geodeticDatum() == null ? assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MISSING_GEODETICDATUM(), "Missing geodeticDatum")) : assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MISSING_GEODETICDATUM(), AssertionStatus$.MODULE$.PASSED()));
        ArrayBuffer arrayBuffer2 = raw.location().georeferencedBy() == null && processed.location().georeferencedBy() == null ? assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MISSING_GEOREFERNCEDBY(), "Missing georeferencedBy")) : assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MISSING_GEOREFERNCEDBY(), AssertionStatus$.MODULE$.PASSED()));
        ArrayBuffer arrayBuffer3 = raw.location().georeferenceProtocol() == null && processed.location().georeferenceProtocol() == null ? assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MISSING_GEOREFERENCEPROTOCOL(), "Missing georeferenceProtocol")) : assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MISSING_GEOREFERENCEPROTOCOL(), AssertionStatus$.MODULE$.PASSED()));
        ArrayBuffer arrayBuffer4 = raw.location().georeferenceSources() == null && processed.location().georeferenceSources() == null ? assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MISSING_GEOREFERENCESOURCES(), "Missing georeferenceSources")) : assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MISSING_GEOREFERENCESOURCES(), AssertionStatus$.MODULE$.PASSED()));
        ArrayBuffer arrayBuffer5 = raw.location().georeferenceVerificationStatus() == null && processed.location().georeferenceVerificationStatus() == null ? assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MISSING_GEOREFERENCEVERIFICATIONSTATUS(), "Missing georeferenceVerificationStatus")) : assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MISSING_GEOREFERENCEVERIFICATIONSTATUS(), AssertionStatus$.MODULE$.PASSED()));
        return StringUtils.isBlank((String)raw.location().georeferencedDate()) && !raw.miscProperties().containsKey("georeferencedDate") ? assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MISSING_GEOREFERENCE_DATE())) : assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.MISSING_GEOREFERENCE_DATE(), AssertionStatus$.MODULE$.PASSED()));
    }

    /*
     * Enabled aggressive block sorting
     */
    public Object validateCoordinatesValues(FullRecord raw, FullRecord processed, ArrayBuffer<QualityAssertion> assertions) {
        BoxedUnit boxedUnit;
        Some some;
        Tuple2 tuple2;
        float lon2;
        float lat2;
        BoxedUnit boxedUnit2;
        block20: {
            block19: {
                ArrayBuffer arrayBuffer;
                ArrayBuffer arrayBuffer2;
                Option<Object> latWithOption = StringHelper$.MODULE$.string2helper(processed.location().decimalLatitude()).toFloatWithOption();
                Option<Object> lonWithOption = StringHelper$.MODULE$.string2helper(processed.location().decimalLongitude()).toFloatWithOption();
                if (latWithOption.isEmpty() || lonWithOption.isEmpty()) {
                    boxedUnit2 = BoxedUnit.UNIT;
                    return boxedUnit2;
                }
                lat2 = BoxesRunTime.unboxToFloat((Object)latWithOption.get());
                lon2 = BoxesRunTime.unboxToFloat((Object)lonWithOption.get());
                if (lat2 < (float)-90 || lat2 > (float)90 || lon2 < (float)-180 || lon2 > (float)180) {
                    if (lon2 >= (float)-90 && lon2 <= (float)90 && lat2 >= (float)-180 && lat2 <= (float)180) {
                        assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.INVERTED_COORDINATES(), new StringBuilder().append((Object)"Assume that coordinates have been inverted. Original values: ").append((Object)processed.location().decimalLatitude()).append((Object)",").append((Object)processed.location().decimalLongitude()).toString()));
                        String tmp = processed.location().decimalLatitude();
                        processed.location().decimalLatitude_$eq(processed.location().decimalLongitude());
                        processed.location().decimalLongitude_$eq(tmp);
                        arrayBuffer2 = assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.COORDINATES_OUT_OF_RANGE(), AssertionStatus$.MODULE$.PASSED()));
                    } else {
                        assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.COORDINATES_OUT_OF_RANGE(), new StringBuilder().append((Object)"Coordinates are out of range: ").append((Object)processed.location().decimalLatitude()).append((Object)",").append((Object)processed.location().decimalLongitude()).toString()));
                        arrayBuffer2 = assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.INVERTED_COORDINATES(), AssertionStatus$.MODULE$.PASSED()));
                    }
                } else {
                    arrayBuffer2 = assertions.$plus$plus$eq((TraversableOnce)Predef$.MODULE$.refArrayOps((Object[])new QualityAssertion[]{QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.INVERTED_COORDINATES(), AssertionStatus$.MODULE$.PASSED()), QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.COORDINATES_OUT_OF_RANGE(), AssertionStatus$.MODULE$.PASSED())}));
                }
                if (lat2 == 0.0f && lon2 == 0.0f) {
                    assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.ZERO_COORDINATES(), "Coordinates 0,0"));
                    processed.location().decimalLatitude_$eq(null);
                    processed.location().decimalLongitude_$eq(null);
                    arrayBuffer = BoxedUnit.UNIT;
                } else {
                    arrayBuffer = assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.ZERO_COORDINATES(), AssertionStatus$.MODULE$.PASSED()));
                }
                ArrayBuffer arrayBuffer3 = lat2 == 0.0f ? assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.ZERO_LATITUDE_COORDINATES(), "Latitude 0,0")) : assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.ZERO_LATITUDE_COORDINATES(), AssertionStatus$.MODULE$.PASSED()));
                ArrayBuffer arrayBuffer4 = lon2 == 0.0f ? assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.ZERO_LONGITUDE_COORDINATES(), "Longitude 0,0")) : assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.ZERO_LONGITUDE_COORDINATES(), AssertionStatus$.MODULE$.PASSED()));
                if (raw.location().country() == null) break block19;
                String string = raw.location().country();
                String string2 = "";
                if (string != null ? !string.equals(string2) : string2 != null) break block20;
            }
            boxedUnit2 = BoxedUnit.UNIT;
            return boxedUnit2;
        }
        Option<Term> country = Countries$.MODULE$.matchTerm(raw.location().country());
        if (country.isEmpty()) {
            boxedUnit2 = assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.UNKNOWN_COUNTRY_NAME(), new StringBuilder().append((Object)"Country name '").append((Object)raw.location().country()).append((Object)"' not recognised.").toString()));
            return boxedUnit2;
        }
        assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.UNKNOWN_COUNTRY_NAME(), AssertionStatus$.MODULE$.PASSED()));
        Option<Tuple2<LatLng, BBox>> option = CountryCentrePoints$.MODULE$.matchName(((Term)country.get()).canonical());
        if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).x()) != null) {
            BoxedUnit boxedUnit3;
            BBox bbox = (BBox)tuple2._2();
            if (bbox.containsPoint(lat2, lon2)) {
                boxedUnit3 = BoxedUnit.UNIT;
            } else {
                boolean hasCoordinateMismatch = true;
                if (bbox.containsPoint(lat2 * (float)-1, lon2)) {
                    assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.NEGATED_LATITUDE(), new StringBuilder().append((Object)"Latitude seems to be negated. Original value:").append((Object)processed.location().decimalLatitude()).toString()));
                    processed.location().decimalLatitude_$eq(((Object)BoxesRunTime.boxToFloat((float)(lat2 * (float)-1))).toString());
                    hasCoordinateMismatch = false;
                }
                if (bbox.containsPoint(lat2, lon2 * (float)-1)) {
                    assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.NEGATED_LONGITUDE(), new StringBuilder().append((Object)"Longitude seems to be negated. Original value: ").append((Object)processed.location().decimalLongitude()).toString()));
                    processed.location().decimalLongitude_$eq(((Object)BoxesRunTime.boxToFloat((float)(lon2 * (float)-1))).toString());
                    hasCoordinateMismatch = false;
                }
                boxedUnit3 = hasCoordinateMismatch ? assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.COUNTRY_COORDINATE_MISMATCH())) : assertions.$plus$eq((Object)QualityAssertion$.MODULE$.apply(AssertionCodes$.MODULE$.COUNTRY_COORDINATE_MISMATCH(), AssertionStatus$.MODULE$.PASSED()));
            }
            boxedUnit = boxedUnit3;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        boxedUnit2 = boxedUnit;
        return boxedUnit2;
    }

    private String getExactSciName(FullRecord raw) {
        return raw.classification().scientificName() == null ? (raw.classification().subspecies() == null ? (raw.classification().species() == null ? (raw.classification().genus() == null ? (raw.classification().vernacularName() == null ? raw.classification().scientificName() : raw.classification().vernacularName()) : (raw.classification().specificEpithet() == null ? raw.classification().genus() : (raw.classification().infraspecificEpithet() == null ? new StringBuilder().append((Object)raw.classification().genus()).append((Object)" ").append((Object)raw.classification().specificEpithet()).toString() : new StringBuilder().append((Object)raw.classification().genus()).append((Object)" ").append((Object)raw.classification().specificEpithet()).append((Object)" ").append((Object)raw.classification().infraspecificEpithet()).toString()))) : raw.classification().species()) : raw.classification().subspecies()) : raw.classification().scientificName();
    }

    @Override
    public String getName() {
        return FullRecordMapper$.MODULE$.geospatialQa();
    }

    public LocationProcessor() {
        Processor$class.$init$(this);
        this.logger = LoggerFactory.getLogger((String)"LocationProcessor");
    }
}

