/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.persistence;

import au.org.ala.biocache.persistence.CassandraPersistenceManager$;
import au.org.ala.biocache.persistence.PersistenceManager;
import au.org.ala.biocache.persistence.PersistenceManager$class;
import au.org.ala.biocache.util.Json$;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.UUID;
import org.apache.cassandra.thrift.Column;
import org.apache.cassandra.thrift.ConsistencyLevel;
import org.apache.cassandra.thrift.IndexClause;
import org.apache.cassandra.thrift.IndexExpression;
import org.apache.cassandra.thrift.IndexOperator;
import org.apache.cassandra.thrift.KeyRange;
import org.apache.cassandra.thrift.SlicePredicate;
import org.scale7.cassandra.pelops.Bytes;
import org.scale7.cassandra.pelops.Cluster;
import org.scale7.cassandra.pelops.Mutator;
import org.scale7.cassandra.pelops.OperandPolicy;
import org.scale7.cassandra.pelops.Pelops;
import org.scale7.cassandra.pelops.RowDeletor;
import org.scale7.cassandra.pelops.Selector;
import org.scale7.cassandra.pelops.exceptions.NotFoundException;
import org.scale7.cassandra.pelops.pool.CommonsBackedPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0011\u001db\u0001B\u0001\u0003\u00015\u00111dQ1tg\u0006tGM]1QKJ\u001c\u0018n\u001d;f]\u000e,W*\u00198bO\u0016\u0014(BA\u0002\u0005\u0003-\u0001XM]:jgR,gnY3\u000b\u0005\u00151\u0011\u0001\u00032j_\u000e\f7\r[3\u000b\u0005\u001dA\u0011aA1mC*\u0011\u0011BC\u0001\u0004_J<'\"A\u0006\u0002\u0005\u0005,8\u0001A\n\u0004\u00019!\u0002CA\b\u0013\u001b\u0005\u0001\"\"A\t\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0001\"AB!osJ+g\r\u0005\u0002\u0016-5\t!!\u0003\u0002\u0018\u0005\t\u0011\u0002+\u001a:tSN$XM\\2f\u001b\u0006t\u0017mZ3s\u0011!I\u0002A!b\u0001\n\u0003Q\u0012\u0001\u00025pgR,\u0012a\u0007\t\u00039}q!aD\u000f\n\u0005y\u0001\u0012A\u0002)sK\u0012,g-\u0003\u0002!C\t11\u000b\u001e:j]\u001eT!A\b\t\t\u0011\r\u0002!\u0011!Q\u0001\nm\tQ\u0001[8ti\u0002B\u0001\"\n\u0001\u0003\u0006\u0004%\tAJ\u0001\u0005a>\u0014H/F\u0001(!\ty\u0001&\u0003\u0002*!\t\u0019\u0011J\u001c;\t\u0011-\u0002!\u0011!Q\u0001\n\u001d\nQ\u0001]8si\u0002B\u0001\"\f\u0001\u0003\u0006\u0004%\tAG\u0001\ta>|GNT1nK\"Aq\u0006\u0001B\u0001B\u0003%1$A\u0005q_>dg*Y7fA!A\u0011\u0007\u0001BC\u0002\u0013\u0005!$\u0001\u0005lKf\u001c\b/Y2f\u0011!\u0019\u0004A!A!\u0002\u0013Y\u0012!C6fsN\u0004\u0018mY3!\u0011!)\u0004A!b\u0001\n\u00031\u0013AD7bq\u000e{gN\\3di&|gn\u001d\u0005\to\u0001\u0011\t\u0011)A\u0005O\u0005yQ.\u0019=D_:tWm\u0019;j_:\u001c\b\u0005\u0003\u0005:\u0001\t\u0015\r\u0011\"\u0001'\u0003)i\u0017\r\u001f*fiJLWm\u001d\u0005\tw\u0001\u0011\t\u0011)A\u0005O\u0005YQ.\u0019=SKR\u0014\u0018.Z:!\u0011!i\u0004A!b\u0001\n\u00031\u0013\u0001E8qKJ\fG/[8o)&lWm\\;u\u0011!y\u0004A!A!\u0002\u00139\u0013!E8qKJ\fG/[8o)&lWm\\;uA!)\u0011\t\u0001C\u0001\u0005\u00061A(\u001b8jiz\"\u0002b\u0011#V3v\u000bW-\u001b\t\u0003+\u0001Aq!\u0007!\u0011\u0002\u0003\u00071\u0004\u000b\u0003E\rJ\u001b\u0006CA$Q\u001b\u0005A%BA%K\u0003\u0011q\u0017-\\3\u000b\u0005-c\u0015AB5oU\u0016\u001cGO\u0003\u0002N\u001d\u00061qm\\8hY\u0016T\u0011aT\u0001\u0004G>l\u0017BA)I\u0005\u0015q\u0015-\\3e\u0003\u00151\u0018\r\\;fC\u0005!\u0016aD2bgN\fg\u000e\u001a:b]!|7\u000f^:\t\u000f\u0015\u0002\u0005\u0013!a\u0001O!\"QK\u0012*XC\u0005A\u0016AD2bgN\fg\u000e\u001a:b]A|'\u000f\u001e\u0005\b[\u0001\u0003\n\u00111\u0001\u001cQ\u0011IfIU.\"\u0003q\u000babY1tg\u0006tGM]1/a>|G\u000eC\u00042\u0001B\u0005\t\u0019A\u000e)\tu3%kX\u0011\u0002A\u0006\u00112-Y:tC:$'/\u0019\u0018lKf\u001c\b/Y2f\u0011\u001d)\u0004\t%AA\u0002\u001dBC!\u0019$SG\u0006\nA-A\rdCN\u001c\u0018M\u001c3sC:j\u0017\r\u001f\u0018d_:tWm\u0019;j_:\u001c\bbB\u001dA!\u0003\u0005\ra\n\u0015\u0005K\u001a\u0013v-I\u0001i\u0003U\u0019\u0017m]:b]\u0012\u0014\u0018ML7bq:\u0012X\r\u001e:jKNDq!\u0010!\u0011\u0002\u0003\u0007q\u0005\u000b\u0003j\rJ[\u0017%\u00017\u00021QD'/\u001b4u]=\u0004XM]1uS>tg\u0006^5nK>,H\u000f\u000b\u0002A]B\u0011q\u000e]\u0007\u0002\u0015&\u0011\u0011O\u0013\u0002\u0007\u0013:TWm\u0019;\t\u000fM\u0004!\u0019!C\u0001i\u00061An\\4hKJ,\u0012!\u001e\t\u0003mjl\u0011a\u001e\u0006\u0003qf\fQa\u001d7gi)T\u0011!C\u0005\u0003w^\u0014a\u0001T8hO\u0016\u0014\bBB?\u0001A\u0003%Q/A\u0004m_\u001e<WM\u001d\u0011\t\u000f}\u0004!\u0019!C\u0001M\u0005qQ.\u0019=D_2,XN\u001c'j[&$\bbBA\u0002\u0001\u0001\u0006IaJ\u0001\u0010[\u0006D8i\u001c7v[:d\u0015.\\5uA!I\u0011q\u0001\u0001C\u0002\u0013\u0005\u0011\u0011B\u0001\bG2,8\u000f^3s+\t\tY\u0001\u0005\u0003\u0002\u000e\u0005mQBAA\b\u0015\u0011\t\t\"a\u0005\u0002\rA,Gn\u001c9t\u0015\u0011\t)\"a\u0006\u0002\u0013\r\f7o]1oIJ\f'bAA\rs\u000611oY1mK^JA!!\b\u0002\u0010\t91\t\\;ti\u0016\u0014\b\u0002CA\u0011\u0001\u0001\u0006I!a\u0003\u0002\u0011\rdWo\u001d;fe\u0002B\u0011\"!\n\u0001\u0005\u0004%\t!a\n\u0002\rA|G.[2z+\t\tI\u0003\u0005\u0003\u0002,\u0005]b\u0002BA\u0017\u0003gi!!a\f\u000b\t\u0005E\u0012qB\u0001\u0005a>|G.\u0003\u0003\u00026\u0005=\u0012!E\"p[6|gn\u001d\"bG.,G\rU8pY&!\u0011\u0011HA\u001e\u0005\u0019\u0001v\u000e\\5ds*!\u0011QGA\u0018\u0011!\ty\u0004\u0001Q\u0001\n\u0005%\u0012a\u00029pY&\u001c\u0017\u0010\t\u0005\n\u0003\u0007\u0002!\u0019!C\u0001\u0003\u000b\nQb\u001c9fe\u0006tG\rU8mS\u000eLXCAA$!\u0011\ti!!\u0013\n\t\u0005-\u0013q\u0002\u0002\u000e\u001fB,'/\u00198e!>d\u0017nY=\t\u0011\u0005=\u0003\u0001)A\u0005\u0003\u000f\nab\u001c9fe\u0006tG\rU8mS\u000eL\b\u0005C\u0004\u0002T\u0001!\t!!\u0016\u0002\u0015%t\u0017\u000e^5bY&\u001cX-\u0006\u0002\u0002XA\u0019q\"!\u0017\n\u0007\u0005m\u0003C\u0001\u0003V]&$\bbBA0\u0001\u0011\u0005\u0011\u0011M\u0001\u0004O\u0016$HCBA2\u0003_\n\u0019\bE\u0003\u0010\u0003K\nI'C\u0002\u0002hA\u0011aa\u00149uS>t\u0007#\u0002\u000f\u0002lmY\u0012bAA7C\t\u0019Q*\u00199\t\u000f\u0005E\u0014Q\fa\u00017\u0005!Q/^5e\u0011\u001d\t)(!\u0018A\u0002m\t!\"\u001a8uSRLh*Y7f\u0011\u001d\ty\u0006\u0001C\u0001\u0003s\"\"\"a\u001f\u0002 \u0006\u0005\u00161UAT!\u0015y\u0011QMA?!\u0019\ty(!#\u0002\u000e6\u0011\u0011\u0011\u0011\u0006\u0005\u0003\u0007\u000b))\u0001\u0003vi&d'BAAD\u0003\u0011Q\u0017M^1\n\t\u0005-\u0015\u0011\u0011\u0002\u0005\u0019&\u001cH\u000f\u0005\u0003\u0002\u0010\u0006mUBAAI\u0015\u0011\t\u0019*!&\u0002\rQD'/\u001b4u\u0015\u0011\t)\"a&\u000b\u0007\u0005e\u00150\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0005\u0003;\u000b\tJ\u0001\u0004D_2,XN\u001c\u0005\b\u0003c\n9\b1\u0001\u001c\u0011\u001d\t)(a\u001eA\u0002mAq!!*\u0002x\u0001\u00071$A\u0007ti\u0006\u0014H\u000f\u0015:pa\u0016\u0014H/\u001f\u0005\b\u0003S\u000b9\b1\u0001\u001c\u0003-)g\u000e\u001a)s_B,'\u000f^=\t\u000f\u00055\u0006\u0001\"\u0001\u00020\u0006Ar-\u001a;D_2,XN\\:XSRDG+[7fgR\fW\u000e]:\u0015\r\u0005E\u00161XA_!\u0015y\u0011QMAZ!\u0019a\u00121N\u000e\u00026B\u0019q\"a.\n\u0007\u0005e\u0006C\u0001\u0003M_:<\u0007bBA9\u0003W\u0003\ra\u0007\u0005\b\u0003k\nY\u000b1\u0001\u001c\u0011\u001d\t\t\r\u0001C\u0001\u0003\u0007\f!bZ3u\u0005fLe\u000eZ3y)!\t\u0019'!2\u0002H\u0006%\u0007bBA9\u0003\u007f\u0003\ra\u0007\u0005\b\u0003k\ny\f1\u0001\u001c\u0011\u001d\tY-a0A\u0002m\t\u0011\"\u001b3y\u0007>dW/\u001c8\t\u000f\u0005\u0005\u0007\u0001\"\u0001\u0002PRQ\u0011\u0011[Aj\u0003+\f9.!7\u0011\t=\t)g\u0007\u0005\b\u0003c\ni\r1\u0001\u001c\u0011\u001d\t)(!4A\u0002mAq!a3\u0002N\u0002\u00071\u0004C\u0004\u0002\\\u00065\u0007\u0019A\u000e\u0002\u0019A\u0014x\u000e]3sift\u0015-\\3\t\u000f\u0005}\u0007\u0001\"\u0001\u0002b\u00069r-\u001a;GSJ\u001cHOV1mk\u0016\u001chI]8n\u0013:$W\r\u001f\u000b\u000b\u0003G\n\u0019/!:\u0002h\u0006%\bbBA;\u0003;\u0004\ra\u0007\u0005\b\u0003\u0017\fi\u000e1\u0001\u001c\u0011\u0019\u0011\u0016Q\u001ca\u00017!A\u00111^Ao\u0001\u0004\ti/\u0001\btY&\u001cW\r\u0015:fI&\u001c\u0017\r^3\u0011\t\u0005=\u0015q^\u0005\u0005\u0003c\f\tJ\u0001\bTY&\u001cW\r\u0015:fI&\u001c\u0017\r^3\t\u000f\u0005}\u0003\u0001\"\u0001\u0002vRA\u0011\u0011[A|\u0003s\fY\u0010C\u0004\u0002r\u0005M\b\u0019A\u000e\t\u000f\u0005U\u00141\u001fa\u00017!9\u00111\\Az\u0001\u0004Y\u0002bBA\u0000\u0001\u0011\u0005!\u0011A\u0001\fO\u0016$8+\u001a7fGR,G\r\u0006\u0005\u0002d\t\r!Q\u0001B\u0004\u0011\u001d\t\t(!@A\u0002mAq!!\u001e\u0002~\u0002\u00071\u0004\u0003\u0005\u0003\n\u0005u\b\u0019\u0001B\u0006\u00035\u0001(o\u001c9feRLh*Y7fgB)!Q\u0002B\u000f79!!q\u0002B\r\u001d\u0011\u0011\tBa\u0006\u000e\u0005\tM!b\u0001B\u000b\u0019\u00051AH]8pizJ\u0011!E\u0005\u0004\u00057\u0001\u0012a\u00029bG.\fw-Z\u0005\u0005\u0005?\u0011\tCA\u0002TKFT1Aa\u0007\u0011\u0011\u001d\u0011)\u0003\u0001C\u0001\u0005O\t\u0001\u0002];u\u0005\u0006$8\r\u001b\u000b\t\u0003/\u0012ICa\u000b\u0003:!9\u0011Q\u000fB\u0012\u0001\u0004Y\u0002\u0002\u0003B\u0017\u0005G\u0001\rAa\f\u0002\u000b\t\fGo\u00195\u0011\u000f\tE\"qG\u000e\u0002j5\u0011!1\u0007\u0006\u0004\u0005k\u0001\u0012AC2pY2,7\r^5p]&!\u0011Q\u000eB\u001a\u0011!\u0011YDa\tA\u0002\tu\u0012\u0001\u0005:f[>4XMT;mY\u001aKW\r\u001c3t!\ry!qH\u0005\u0004\u0005\u0003\u0002\"a\u0002\"p_2,\u0017M\u001c\u0005\b\u0005\u000b\u0002A\u0011\u0001B$\u0003\r\u0001X\u000f\u001e\u000b\n7\t%#1\nB'\u0005#Bq!!\u001d\u0003D\u0001\u00071\u0004C\u0004\u0002v\t\r\u0003\u0019A\u000e\t\u0011\t=#1\ta\u0001\u0003S\nQb[3z-\u0006dW/\u001a)bSJ\u001c\b\u0002\u0003B\u001e\u0005\u0007\u0002\rA!\u0010\t\u000f\t\u0015\u0003\u0001\"\u0001\u0003VQY1Da\u0016\u0003Z\tm#Q\fB1\u0011\u001d\t\tHa\u0015A\u0002mAq!!\u001e\u0003T\u0001\u00071\u0004C\u0004\u0002\\\nM\u0003\u0019A\u000e\t\u000f\t}#1\u000ba\u00017\u0005i\u0001O]8qKJ$\u0018PV1mk\u0016D\u0001Ba\u000f\u0003T\u0001\u0007!Q\b\u0005\b\u0005K\u0002A\u0011\u0001B4\u0003\u001d9W\r\u001e'jgR,BA!\u001b\u0003tQQ!1\u000eBC\u0005\u000f\u0013IIa#\u0011\r\t5!Q\u000eB8\u0013\u0011\tYI!\t\u0011\t\tE$1\u000f\u0007\u0001\t!\u0011)Ha\u0019C\u0002\t]$!A!\u0012\t\te$q\u0010\t\u0004\u001f\tm\u0014b\u0001B?!\t9aj\u001c;iS:<\u0007cA\b\u0003\u0002&\u0019!1\u0011\t\u0003\u0007\u0005s\u0017\u0010C\u0004\u0002r\t\r\u0004\u0019A\u000e\t\u000f\u0005U$1\ra\u00017!9\u00111\u001cB2\u0001\u0004Y\u0002\u0002\u0003BG\u0005G\u0002\rAa$\u0002\u0011QDWm\u00117bgN\u0004DA!%\u0003 B1!1\u0013BM\u0005;k!A!&\u000b\t\t]\u0015QQ\u0001\u0005Y\u0006tw-\u0003\u0003\u0003\u001c\nU%!B\"mCN\u001c\b\u0003\u0002B9\u0005?#AB!)\u0003\f\u0006\u0005\t\u0011!B\u0001\u0005o\u00121a\u0018\u00132\u0011\u001d\u0011)\u000b\u0001C\u0001\u0005O\u000bq\u0001];u\u0019&\u001cH/\u0006\u0003\u0003*\neFcD\u000e\u0003,\n5&q\u0016BY\u0005w\u00139Ma3\t\u000f\u0005E$1\u0015a\u00017!9\u0011Q\u000fBR\u0001\u0004Y\u0002bBAn\u0005G\u0003\ra\u0007\u0005\t\u0005g\u0013\u0019\u000b1\u0001\u00036\u00069a.Z<MSN$\bC\u0002B\u0007\u0005;\u00119\f\u0005\u0003\u0003r\teF\u0001\u0003B;\u0005G\u0013\rAa\u001e\t\u0011\t5%1\u0015a\u0001\u0005{\u0003DAa0\u0003DB1!1\u0013BM\u0005\u0003\u0004BA!\u001d\u0003D\u0012a!Q\u0019B^\u0003\u0003\u0005\tQ!\u0001\u0003x\t\u0019q\f\n\u001a\t\u0011\t%'1\u0015a\u0001\u0005{\t\u0011b\u001c<fe^\u0014\u0018\u000e^3\t\u0011\tm\"1\u0015a\u0001\u0005{AqAa4\u0001\t\u0003\u0011\t.\u0001\u0005qC\u001e,wJ^3s)A\t9Fa5\u0003V\n}'1\u001dBs\u0005S\u0014i\u000fC\u0004\u0002v\t5\u0007\u0019A\u000e\t\u0011\t]'Q\u001aa\u0001\u00053\fA\u0001\u001d:pGBAqBa7\u001c\u0003S\u0012i$C\u0002\u0003^B\u0011\u0011BR;oGRLwN\u001c\u001a\t\u000f\t\u0005(Q\u001aa\u0001O\u0005A\u0001/Y4f'&TX\r\u0003\u0005\u0002l\n5\u0007\u0019AAw\u0011)\u00119O!4\u0011\u0002\u0003\u0007!QH\u0001\u000bG\",7m[#naRL\b\"\u0003Bv\u0005\u001b\u0004\n\u00111\u0001\u001c\u0003%\u0019H/\u0019:u+VLG\rC\u0005\u0003p\n5\u0007\u0013!a\u00017\u00059QM\u001c3Vk&$\u0007b\u0002Bz\u0001\u0011%!Q_\u0001\u001eO\u0016$8i\u001c7v[:\u001chI]8n%><8oV5uQJ+GO]5fgRa!q_B\u0001\u0007\u0007\u0019iaa\u0004\u0004\u001aAA\u0011q\u0010B}\u0005w\fi(\u0003\u0003\u0002n\u0005\u0005\u0005\u0003BA\u0007\u0005{LAAa@\u0002\u0010\t)!)\u001f;fg\"9\u0011Q\u000fBy\u0001\u0004Y\u0002\u0002CB\u0003\u0005c\u0004\raa\u0002\u0002\u0011-,\u0017PU1oO\u0016\u0004B!a$\u0004\n%!11BAI\u0005!YU-\u001f*b]\u001e,\u0007\u0002CAv\u0005c\u0004\r!!<\t\u0011\rE!\u0011\u001fa\u0001\u0007'\t!a\u00197\u0011\t\u0005=5QC\u0005\u0005\u0007/\t\tJ\u0001\tD_:\u001c\u0018n\u001d;f]\u000eLH*\u001a<fY\"911\u0004By\u0001\u00049\u0013\u0001\u00059fe6LG\u000f^3e%\u0016$(/[3t\u0011\u001d\u0019y\u0002\u0001C\u0001\u0007C\ta\u0002]1hK>3XM]*fY\u0016\u001cG\u000f\u0006\b\u0002X\r\r2QEB\u0014\u0007S\u0019Yc!\f\t\u000f\u0005U4Q\u0004a\u00017!A!q[B\u000f\u0001\u0004\u0011I\u000eC\u0004\u0003l\u000eu\u0001\u0019A\u000e\t\u000f\t=8Q\u0004a\u00017!9!\u0011]B\u000f\u0001\u00049\u0003\u0002CB\u0018\u0007;\u0001\ra!\r\u0002\u0015\r|G.^7o\u001d\u0006lW\r\u0005\u0003\u0010\u0007gY\u0012bAB\u001b!\tQAH]3qK\u0006$X\r\u001a \t\u000f\re\u0002\u0001\"\u0001\u0004<\u0005\u0019\u0002/Y4f\u001fZ,'oQ8mk6t'+\u00198hKR\u0001\u0012qKB\u001f\u0007\u007f\u0019\tea\u0011\u0004F\r\u001d31\n\u0005\b\u0003k\u001a9\u00041\u0001\u001c\u0011!\u00119na\u000eA\u0002\te\u0007\"\u0003Bv\u0007o\u0001\n\u00111\u0001\u001c\u0011%\u0011yoa\u000e\u0011\u0002\u0003\u00071\u0004C\u0005\u0003b\u000e]\u0002\u0013!a\u0001O!I1\u0011JB\u001c!\u0003\u0005\raG\u0001\fgR\f'\u000f^\"pYVlg\u000eC\u0005\u0004N\r]\u0002\u0013!a\u00017\u0005IQM\u001c3D_2,XN\u001c\u0005\b\u0007#\u0002A\u0011AB*\u0003-\u0001\u0018mZ3Pm\u0016\u0014\u0018\t\u001c7\u0015\u0019\u0005]3QKB,\u00073\u001aYf!\u0018\t\u000f\u0005U4q\na\u00017!A!q[B(\u0001\u0004\u0011I\u000eC\u0005\u0003l\u000e=\u0003\u0013!a\u00017!I!q^B(!\u0003\u0005\ra\u0007\u0005\n\u0005C\u001cy\u0005%AA\u0002\u001dBqa!\u0019\u0001\t\u0003\u0019\u0019'\u0001\u0006tK2,7\r\u001e*poN$\"\"a\u0016\u0004f\r%41NB8\u0011!\u00199ga\u0018A\u0002\t-\u0011a\u0002:po.,\u0017p\u001d\u0005\b\u0003k\u001ay\u00061\u0001\u001c\u0011!\u0019iga\u0018A\u0002\t-\u0011A\u00024jK2$7\u000f\u0003\u0005\u0003X\u000e}\u0003\u0019AB9!\u001dy11OA5\u0003/J1a!\u001e\u0011\u0005%1UO\\2uS>t\u0017\u0007C\u0004\u0004z\u0001!\tba\u001f\u0002\u001d\r|G.^7o\u0019&\u001cHOM'baR!\u0011\u0011NB?\u0011!\u0019yha\u001eA\u0002\u0005u\u0014AC2pYVlg\u000eT5ti\"911\u0011\u0001\u0005\u0012\r\u0015\u0015AE2pYVlg\u000eT5tiJ\"\u0016.\\3NCB$B!a-\u0004\b\"A1qPBA\u0001\u0004\ti\bC\u0004\u0004\f\u0002!\tb!$\u0002\u0013\u001d,GoQ8mk6tG\u0003CBH\u0007#\u001b\u0019ja&\u0011\u000b=\t)'!$\t\u000f\u0005E4\u0011\u0012a\u00017!91QSBE\u0001\u0004Y\u0012\u0001D2pYVlgNR1nS2L\bbBB\u0018\u0007\u0013\u0003\ra\u0007\u0005\b\u00077\u0003A\u0011AA+\u0003!\u0019\b.\u001e;e_^t\u0007bBBP\u0001\u0011\u00051\u0011U\u0001\u000eI\u0016dW\r^3D_2,XN\\:\u0015\u0011\u0005]31UBS\u0007OCq!!\u001d\u0004\u001e\u0002\u00071\u0004C\u0004\u0002v\ru\u0005\u0019A\u000e\t\u0011\r=2Q\u0014a\u0001\u0007cAqaa+\u0001\t\u0003\u0019i+\u0001\u0004eK2,G/\u001a\u000b\u0007\u0003/\u001ayk!-\t\u000f\u0005E4\u0011\u0016a\u00017!9\u0011QOBU\u0001\u0004Y\u0002\"CB[\u0001E\u0005I\u0011AB\\\u0003I\u0001\u0018mZ3Pm\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\re&\u0006\u0002B\u001f\u0007w[#a!0\u0011\t\r}6\u0011Z\u0007\u0003\u0007\u0003TAaa1\u0004F\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0007\u000f\u0004\u0012AC1o]>$\u0018\r^5p]&!11ZBa\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\n\u0007\u001f\u0004\u0011\u0013!C\u0001\u0007#\f!\u0003]1hK>3XM\u001d\u0013eK\u001a\fW\u000f\u001c;%mU\u001111\u001b\u0016\u00047\rm\u0006\"CBl\u0001E\u0005I\u0011ABi\u0003I\u0001\u0018mZ3Pm\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001c\t\u0013\rm\u0007!%A\u0005B\rE\u0017!\b9bO\u0016|e/\u001a:D_2,XN\u001c*b]\u001e,G\u0005Z3gCVdG\u000fJ\u001a\t\u0013\r}\u0007!%A\u0005B\rE\u0017!\b9bO\u0016|e/\u001a:D_2,XN\u001c*b]\u001e,G\u0005Z3gCVdG\u000f\n\u001b\t\u0013\r\r\b!%A\u0005B\r\u0015\u0018!\b9bO\u0016|e/\u001a:D_2,XN\u001c*b]\u001e,G\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\r\u001d(fA\u0014\u0004<\"I11\u001e\u0001\u0012\u0002\u0013\u00053\u0011[\u0001\u001ea\u0006<Wm\u0014<fe\u000e{G.^7o%\u0006tw-\u001a\u0013eK\u001a\fW\u000f\u001c;%m!I1q\u001e\u0001\u0012\u0002\u0013\u00053\u0011[\u0001\u001ea\u0006<Wm\u0014<fe\u000e{G.^7o%\u0006tw-\u001a\u0013eK\u001a\fW\u000f\u001c;%o!I11\u001f\u0001\u0012\u0002\u0013\u00053\u0011[\u0001\u0016a\u0006<Wm\u0014<fe\u0006cG\u000e\n3fM\u0006,H\u000e\u001e\u00134\u0011%\u00199\u0010AI\u0001\n\u0003\u001a\t.A\u000bqC\u001e,wJ^3s\u00032dG\u0005Z3gCVdG\u000f\n\u001b\t\u0013\rm\b!%A\u0005B\r\u0015\u0018!\u00069bO\u0016|e/\u001a:BY2$C-\u001a4bk2$H%N\u0004\n\u0007\u007f\u0014\u0011\u0011!E\u0001\t\u0003\t1dQ1tg\u0006tGM]1QKJ\u001c\u0018n\u001d;f]\u000e,W*\u00198bO\u0016\u0014\bcA\u000b\u0005\u0004\u0019A\u0011AAA\u0001\u0012\u0003!)aE\u0002\u0005\u00049Aq!\u0011C\u0002\t\u0003!I\u0001\u0006\u0002\u0005\u0002!QAQ\u0002C\u0002#\u0003%\ta!5\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00132\u0011)!\t\u0002b\u0001\u0012\u0002\u0013\u00051Q]\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\t\u0015\u0011UA1AI\u0001\n\u0003\u0019\t.A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$He\r\u0005\u000b\t3!\u0019!%A\u0005\u0002\rE\u0017a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$C\u0007\u0003\u0006\u0005\u001e\u0011\r\u0011\u0013!C\u0001\u0007K\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012*\u0004B\u0003C\u0011\t\u0007\t\n\u0011\"\u0001\u0004f\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIYB!\u0002\"\n\u0005\u0004E\u0005I\u0011ABs\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%o\u0001")
public class CassandraPersistenceManager
implements PersistenceManager {
    private final String host;
    private final int port;
    private final String poolName;
    private final String keyspace;
    private final int maxConnections;
    private final int maxRetries;
    private final int operationTimeout;
    private final Logger logger;
    private final int maxColumnLimit;
    private final Cluster cluster;
    private final CommonsBackedPool.Policy policy;
    private final OperandPolicy operandPolicy;

    public static int $lessinit$greater$default$7() {
        return CassandraPersistenceManager$.MODULE$.$lessinit$greater$default$7();
    }

    public static int $lessinit$greater$default$6() {
        return CassandraPersistenceManager$.MODULE$.$lessinit$greater$default$6();
    }

    public static int $lessinit$greater$default$5() {
        return CassandraPersistenceManager$.MODULE$.$lessinit$greater$default$5();
    }

    public static String $lessinit$greater$default$4() {
        return CassandraPersistenceManager$.MODULE$.$lessinit$greater$default$4();
    }

    public static String $lessinit$greater$default$3() {
        return CassandraPersistenceManager$.MODULE$.$lessinit$greater$default$3();
    }

    public static int $lessinit$greater$default$2() {
        return CassandraPersistenceManager$.MODULE$.$lessinit$greater$default$2();
    }

    public static String $lessinit$greater$default$1() {
        return CassandraPersistenceManager$.MODULE$.$lessinit$greater$default$1();
    }

    @Override
    public char fieldDelimiter() {
        return PersistenceManager$class.fieldDelimiter(this);
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public String poolName() {
        return this.poolName;
    }

    public String keyspace() {
        return this.keyspace;
    }

    public int maxConnections() {
        return this.maxConnections;
    }

    public int maxRetries() {
        return this.maxRetries;
    }

    public int operationTimeout() {
        return this.operationTimeout;
    }

    public Logger logger() {
        return this.logger;
    }

    public int maxColumnLimit() {
        return this.maxColumnLimit;
    }

    public Cluster cluster() {
        return this.cluster;
    }

    public CommonsBackedPool.Policy policy() {
        return this.policy;
    }

    public OperandPolicy operandPolicy() {
        return this.operandPolicy;
    }

    public void initialise() {
        this.logger().debug(new StringBuilder().append((Object)"Initialising cassandra connection pool with pool name: ").append((Object)this.poolName()).toString());
        this.logger().debug(new StringBuilder().append((Object)"Initialising cassandra connection pool with hosts: ").append((Object)this.host()).toString());
        this.logger().debug(new StringBuilder().append((Object)"Initialising cassandra connection pool with port: ").append((Object)BoxesRunTime.boxToInteger((int)this.port())).toString());
        this.logger().debug(new StringBuilder().append((Object)"Initialising cassandra connection pool with max connections: ").append((Object)BoxesRunTime.boxToInteger((int)this.maxConnections())).toString());
        this.logger().debug(new StringBuilder().append((Object)"Initialising cassandra connection pool with max retries: ").append((Object)BoxesRunTime.boxToInteger((int)this.maxRetries())).toString());
        this.logger().debug(new StringBuilder().append((Object)"Initialising cassandra connection pool with operation timeout: ").append((Object)BoxesRunTime.boxToInteger((int)this.operationTimeout())).toString());
        Pelops.addPool((String)this.poolName(), (Cluster)this.cluster(), (String)this.keyspace(), (CommonsBackedPool.Policy)this.policy(), (OperandPolicy)this.operandPolicy());
    }

    @Override
    public Option<scala.collection.immutable.Map<String, String>> get(String uuid, String entityName) {
        Object object;
        Selector selector = Pelops.createSelector((String)this.poolName());
        SlicePredicate slicePredicate = Selector.newColumnsPredicateAll((boolean)true, (int)this.maxColumnLimit());
        try {
            java.util.List columnList = selector.getColumnsFromRow(entityName, uuid, slicePredicate, ConsistencyLevel.ONE);
            object = columnList.isEmpty() ? None$.MODULE$ : new Some(this.columnList2Map(columnList));
        }
        catch (Exception exception) {
            this.logger().trace(exception.getMessage(), (Throwable)exception);
            object = None$.MODULE$;
        }
        return object;
    }

    public Option<java.util.List<Column>> get(String uuid, String entityName, String startProperty, String endProperty) {
        Some some;
        Selector selector = Pelops.createSelector((String)this.poolName());
        SlicePredicate slicePredicate = Selector.newColumnsPredicate((String)startProperty, (String)endProperty, (boolean)false, (int)this.maxColumnLimit());
        try {
            some = new Some((Object)selector.getColumnsFromRow(entityName, uuid, slicePredicate, ConsistencyLevel.ONE));
        }
        catch (Exception exception) {
            some = None$.MODULE$;
        }
        return some;
    }

    @Override
    public Option<scala.collection.immutable.Map<String, Object>> getColumnsWithTimestamps(String uuid, String entityName) {
        Object object;
        Selector selector = Pelops.createSelector((String)this.poolName());
        SlicePredicate slicePredicate = Selector.newColumnsPredicateAll((boolean)true, (int)this.maxColumnLimit());
        try {
            java.util.List columnList = selector.getColumnsFromRow(entityName, uuid, slicePredicate, ConsistencyLevel.ONE);
            object = columnList.isEmpty() ? None$.MODULE$ : new Some(this.columnList2TimeMap(columnList));
        }
        catch (Exception exception) {
            this.logger().debug(exception.getMessage(), (Throwable)exception);
            object = None$.MODULE$;
        }
        return object;
    }

    @Override
    public Option<scala.collection.immutable.Map<String, String>> getByIndex(String uuid, String entityName, String idxColumn) {
        return this.getFirstValuesFromIndex(entityName, idxColumn, uuid, Selector.newColumnsPredicateAll((boolean)true, (int)this.maxColumnLimit()));
    }

    @Override
    public Option<String> getByIndex(String uuid, String entityName, String idxColumn, String propertyName) {
        Option<scala.collection.immutable.Map<String, String>> map = this.getFirstValuesFromIndex(entityName, idxColumn, uuid, Selector.newColumnsPredicate((String[])new String[]{propertyName}));
        return map.isEmpty() ? None$.MODULE$ : new Some(((MapLike)map.get()).getOrElse((Object)propertyName, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        }));
    }

    public Option<scala.collection.immutable.Map<String, String>> getFirstValuesFromIndex(String entityName, String idxColumn, String value, SlicePredicate slicePredicate) {
        None$ none$;
        Selector selector = Pelops.createSelector((String)this.poolName());
        IndexClause indexClause = Selector.newIndexClause((Bytes)Bytes.EMPTY, (int)1, (IndexExpression[])new IndexExpression[]{Selector.newIndexExpression((String)idxColumn, (IndexOperator)IndexOperator.EQ, (Bytes)Bytes.fromUTF8((String)value))});
        try {
            LinkedHashMap columnMap = selector.getIndexedColumns(entityName, indexClause, slicePredicate, ConsistencyLevel.ONE);
            if (columnMap == null || columnMap.isEmpty()) {
                none$ = None$.MODULE$;
            } else {
                java.util.List columnList = (java.util.List)columnMap.entrySet().iterator().next().getValue();
                scala.collection.immutable.Map<String, String> map = this.columnList2Map(columnList);
                none$ = new Some(map);
            }
        }
        catch (Exception exception) {
            this.logger().warn(exception.getMessage(), (Throwable)exception);
            none$ = None$.MODULE$;
        }
        return none$;
    }

    @Override
    public Option<String> get(String uuid, String entityName, String propertyName) {
        None$ none$;
        try {
            Selector selector = Pelops.createSelector((String)this.poolName());
            Column column = selector.getColumnFromRow(entityName, uuid, propertyName, ConsistencyLevel.ONE);
            none$ = new Some((Object)new String(column.getValue(), "UTF-8"));
        }
        catch (Exception exception) {
            this.logger().error(exception.getMessage(), (Throwable)exception);
            throw exception;
        }
        catch (NotFoundException notFoundException) {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    @Override
    public Option<scala.collection.immutable.Map<String, String>> getSelected(String uuid, String entityName, Seq<String> propertyNames) {
        Object object;
        Selector selector = Pelops.createSelector((String)this.poolName());
        SlicePredicate slicePredicate = Selector.newColumnsPredicate((String[])((String[])propertyNames.toArray(ClassTag$.MODULE$.apply(String.class))));
        try {
            java.util.List columnList = selector.getColumnsFromRow(entityName, uuid, slicePredicate, ConsistencyLevel.ONE);
            object = columnList.isEmpty() ? None$.MODULE$ : new Some(this.columnList2Map(columnList));
        }
        catch (Exception exception) {
            this.logger().trace(exception.getMessage(), (Throwable)exception);
            object = None$.MODULE$;
        }
        return object;
    }

    @Override
    public void putBatch(String entityName, Map<String, scala.collection.immutable.Map<String, String>> batch, boolean removeNullFields) {
        Mutator mutator = Pelops.createMutator((String)this.poolName());
        batch.foreach((Function1)new Serializable(this, entityName, removeNullFields, mutator){
            public static final long serialVersionUID = 0L;
            public final String entityName$1;
            public final boolean removeNullFields$1;
            public final Mutator mutator$1;

            public final void apply(Tuple2<String, scala.collection.immutable.Map<String, String>> uuidMap) {
                String uuid = (String)uuidMap._1();
                scala.collection.immutable.Map keyValuePairs = (scala.collection.immutable.Map)uuidMap._2();
                keyValuePairs.foreach((Function1)new Serializable(this, uuid){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$putBatch$1 $outer;
                    private final String uuid$1;

                    public final Mutator apply(Tuple2<String, String> keyValue) {
                        return this.$outer.mutator$1.writeColumn(this.$outer.entityName$1, Bytes.fromUTF8((String)this.uuid$1), this.$outer.mutator$1.newColumn((String)keyValue._1(), (String)keyValue._2()), this.$outer.removeNullFields$1);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.uuid$1 = uuid$1;
                    }
                });
            }
            {
                this.entityName$1 = entityName$1;
                this.removeNullFields$1 = removeNullFields$1;
                this.mutator$1 = mutator$1;
            }
        });
        mutator.execute(ConsistencyLevel.ONE);
    }

    @Override
    public String put(String uuid, String entityName, scala.collection.immutable.Map<String, String> keyValuePairs, boolean removeNullFields) {
        String recordId = uuid == null ? UUID.randomUUID().toString() : uuid;
        Mutator mutator = Pelops.createMutator((String)this.poolName());
        keyValuePairs.foreach((Function1)new Serializable(this, entityName, removeNullFields, recordId, mutator){
            public static final long serialVersionUID = 0L;
            private final String entityName$2;
            private final boolean removeNullFields$2;
            private final String recordId$1;
            private final Mutator mutator$2;

            public final Object apply(Tuple2<String, String> keyValue) {
                return this.removeNullFields$2 ? this.mutator$2.writeColumn(this.entityName$2, Bytes.fromUTF8((String)this.recordId$1), this.mutator$2.newColumn((String)keyValue._1(), (String)keyValue._2()), this.removeNullFields$2) : (keyValue._2() == null ? BoxedUnit.UNIT : this.mutator$2.writeColumn(this.entityName$2, this.recordId$1, this.mutator$2.newColumn((String)keyValue._1(), (String)keyValue._2())));
            }
            {
                this.entityName$2 = entityName$2;
                this.removeNullFields$2 = removeNullFields$2;
                this.recordId$1 = recordId$1;
                this.mutator$2 = mutator$2;
            }
        });
        Object object = uuid == null ? mutator.writeColumn(entityName, Bytes.fromUTF8((String)recordId), mutator.newColumn("uuid", recordId), removeNullFields) : BoxedUnit.UNIT;
        mutator.execute(ConsistencyLevel.ONE);
        return recordId;
    }

    @Override
    public String put(String uuid, String entityName, String propertyName, String propertyValue, boolean removeNullFields) {
        String recordId = uuid == null ? UUID.randomUUID().toString() : uuid;
        Mutator mutator = Pelops.createMutator((String)this.poolName());
        mutator.writeColumn(entityName, Bytes.fromUTF8((String)recordId), mutator.newColumn(propertyName, propertyValue), removeNullFields);
        Object object = uuid == null ? mutator.writeColumn(entityName, Bytes.fromUTF8((String)recordId), mutator.newColumn("uuid", recordId), removeNullFields) : BoxedUnit.UNIT;
        mutator.execute(ConsistencyLevel.ONE);
        return recordId;
    }

    @Override
    public <A> List<A> getList(String uuid, String entityName, String propertyName, Class<?> theClass) {
        List list;
        Option<Column> column = this.getColumn(uuid, entityName, propertyName);
        if (column.isEmpty()) {
            list = Nil$.MODULE$;
        } else {
            String json = new String(((Column)column.get()).getValue());
            list = Json$.MODULE$.toListWithGeneric(json, theClass);
        }
        return list;
    }

    @Override
    public <A> String putList(String uuid, String entityName, String propertyName, Seq<A> newList, Class<?> theClass, boolean overwrite, boolean removeNullFields) {
        Mutator mutator;
        String recordId = uuid == null ? UUID.randomUUID().toString() : uuid;
        Mutator mutator2 = Pelops.createMutator((String)this.poolName());
        if (overwrite) {
            String json = Json$.MODULE$.toJSONWithGeneric(newList);
            mutator = mutator2.writeColumn(entityName, Bytes.fromUTF8((String)recordId), mutator2.newColumn(propertyName, json), removeNullFields);
        } else {
            Option<Column> column = this.getColumn(uuid, entityName, propertyName);
            if (column.isEmpty()) {
                String json = Json$.MODULE$.toJSONWithGeneric(newList);
                mutator = mutator2.writeColumn(entityName, Bytes.fromUTF8((String)recordId), mutator2.newColumn(propertyName, json), removeNullFields);
            } else {
                String currentJson = new String(((Column)column.get()).getValue());
                List currentList = Json$.MODULE$.toListWithGeneric(currentJson, theClass);
                ObjectRef buffer = new ObjectRef((Object)new ListBuffer());
                currentList.foreach((Function1)new Serializable(this, newList, buffer){
                    public static final long serialVersionUID = 0L;
                    private final Seq newList$1;
                    private final ObjectRef buffer$1;

                    public final Object apply(Nothing$ theObject) {
                        Seq seq = this.newList$1;
                        throw theObject;
                    }
                    {
                        this.newList$1 = newList$1;
                        this.buffer$1 = buffer$1;
                    }
                });
                ((ListBuffer)buffer.elem).$plus$plus$eq(newList);
                String newJson = Json$.MODULE$.toJSONWithGeneric(((ListBuffer)buffer.elem).toList());
                mutator = mutator2.writeColumn(entityName, Bytes.fromUTF8((String)recordId), mutator2.newColumn(propertyName, newJson), removeNullFields);
            }
        }
        mutator2.execute(ConsistencyLevel.ONE);
        return recordId;
    }

    public void pageOver(String entityName, Function2<String, scala.collection.immutable.Map<String, String>, Object> proc, int pageSize, SlicePredicate slicePredicate, boolean checkEmpty, String startUuid, String endUuid) {
        Bytes startKey = new Bytes(startUuid.getBytes());
        Bytes endKey = new Bytes(endUuid.getBytes());
        KeyRange keyRange = Selector.newKeyRange((Bytes)startKey, (Bytes)endKey, (int)(pageSize + 1));
        int counter = 0;
        BooleanRef booleanRef = new BooleanRef(true);
        ObjectRef columnMap = new ObjectRef(this.getColumnsFromRowsWithRetries(entityName, keyRange, slicePredicate, ConsistencyLevel.ONE, 10));
        while (!((java.util.Map)columnMap.elem).isEmpty() && booleanRef.elem) {
            List columnsObj;
            List keys = columnsObj = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray(((java.util.Map)columnMap.elem).keySet().toArray()));
            startKey = (Bytes)keys.last();
            keys.foreach((Function1)new Serializable(this, proc, checkEmpty, booleanRef, columnMap){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ CassandraPersistenceManager $outer;
                private final Function2 proc$1;
                private final boolean checkEmpty$1;
                private final BooleanRef continue$1;
                private final ObjectRef columnMap$1;

                public final void apply(Bytes buuid) {
                    java.util.List columnList = (java.util.List)((java.util.Map)this.columnMap$1.elem).get(buuid);
                    if (!this.checkEmpty$1 || !columnList.isEmpty()) {
                        scala.collection.immutable.Map<String, String> map = this.$outer.columnList2Map(columnList);
                        String uuid = (String)map.getOrElse((Object)"rowKey", (Function0)new Serializable(this, buuid){
                            public static final long serialVersionUID = 0L;
                            private final Bytes buuid$1;

                            public final String apply() {
                                return this.buuid$1.toUTF8();
                            }
                            {
                                this.buuid$1 = buuid$1;
                            }
                        });
                        this.continue$1.elem = BoxesRunTime.unboxToBoolean((Object)this.proc$1.apply((Object)uuid, map));
                    }
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.proc$1 = proc$1;
                    this.checkEmpty$1 = checkEmpty$1;
                    this.continue$1 = continue$1;
                    this.columnMap$1 = columnMap$1;
                }
            });
            counter += keys.size();
            keyRange = Selector.newKeyRange((Bytes)startKey, (Bytes)endKey, (int)(pageSize + 1));
            columnMap.elem = this.getColumnsFromRowsWithRetries(entityName, keyRange, slicePredicate, ConsistencyLevel.ONE, 10);
            ((java.util.Map)columnMap.elem).remove(startKey);
        }
        if (counter > 0) {
            this.logger().debug(new StringBuilder().append((Object)"Finished paging. Records paged over : ").append((Object)BoxesRunTime.boxToInteger((int)counter)).toString());
        }
    }

    public boolean pageOver$default$5() {
        return false;
    }

    public String pageOver$default$6() {
        return "";
    }

    public String pageOver$default$7() {
        return "";
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private java.util.Map<Bytes, java.util.List<Column>> getColumnsFromRowsWithRetries(String entityName, KeyRange keyRange, SlicePredicate slicePredicate, ConsistencyLevel cl, int permittedRetries) {
        boolean success = false;
        boolean noOfRetries = false;
        HashMap columnMap = null;
        while (!success) {
            try {
                Selector selector = Pelops.createSelector((String)this.poolName());
                LinkedHashMap linkedHashMap = selector.getColumnsFromRows(entityName, keyRange, slicePredicate, cl);
                boolean bl = true;
                continue;
            }
            catch (Exception exception) {
                void var7_7;
                this.logger().warn(new StringBuilder().append((Object)"Problem retrieving data. Number of retries left:").append((Object)BoxesRunTime.boxToInteger((int)(permittedRetries - var7_7))).append((Object)", Error: ").append((Object)exception.getMessage()).toString());
                Thread.sleep(20000L);
                try {
                    this.initialise();
                }
                catch (Exception exception2) {
                    this.logger().warn(new StringBuilder().append((Object)"Problem reinitialising Cassandra connection Error: ").append((Object)exception2.getMessage()).toString());
                }
                if (var7_7 == permittedRetries) {
                    this.logger().error(new StringBuilder().append((Object)"Problem retrieving data. Number of DB connection retries exceeded. Error: ").append((Object)exception.getMessage()).toString(), (Throwable)exception);
                    throw new RuntimeException(exception);
                }
                ++var7_7;
                continue;
            }
            break;
        }
        return columnMap;
    }

    @Override
    public void pageOverSelect(String entityName, Function2<String, scala.collection.immutable.Map<String, String>, Object> proc, String startUuid, String endUuid, int pageSize, Seq<String> columnName) {
        SlicePredicate slicePredicate = Selector.newColumnsPredicate((String[])((String[])columnName.toArray(ClassTag$.MODULE$.apply(String.class))));
        String x$1 = entityName;
        Function2<String, scala.collection.immutable.Map<String, String>, Object> x$2 = proc;
        int x$3 = pageSize;
        SlicePredicate x$4 = slicePredicate;
        String x$5 = startUuid;
        String x$6 = endUuid;
        boolean x$7 = this.pageOver$default$5();
        this.pageOver(x$1, x$2, x$3, x$4, x$7, x$5, x$6);
    }

    @Override
    public void pageOverColumnRange(String entityName, Function2<String, scala.collection.immutable.Map<String, String>, Object> proc, String startUuid, String endUuid, int pageSize, String startColumn, String endColumn) {
        SlicePredicate slicePredicate = Selector.newColumnsPredicate((String)startColumn, (String)endColumn, (boolean)false, (int)this.maxColumnLimit());
        Bytes startKey = new Bytes(startUuid.getBytes());
        Bytes endKey = new Bytes(endUuid.getBytes());
        KeyRange keyRange = Selector.newKeyRange((Bytes)startKey, (Bytes)endKey, (int)(pageSize + 1));
        int counter = 0;
        BooleanRef booleanRef = new BooleanRef(true);
        ObjectRef columnMap = new ObjectRef(this.getColumnsFromRowsWithRetries(entityName, keyRange, slicePredicate, ConsistencyLevel.ONE, 10));
        while (!((java.util.Map)columnMap.elem).isEmpty() && booleanRef.elem) {
            List columnsObj;
            List keys = columnsObj = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray(((java.util.Map)columnMap.elem).keySet().toArray()));
            startKey = (Bytes)keys.last();
            keys.foreach((Function1)new Serializable(this, entityName, proc, endColumn, booleanRef, columnMap){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ CassandraPersistenceManager $outer;
                private final String entityName$3;
                private final Function2 proc$2;
                private final String endColumn$1;
                private final BooleanRef continue$2;
                private final ObjectRef columnMap$2;

                public final void apply(Bytes buuid) {
                    java.util.List columnList = (java.util.List)((java.util.Map)this.columnMap$2.elem).get(buuid);
                    boolean moreCols = true;
                    String uuid = buuid.toUTF8();
                    if (columnList != null && !columnList.isEmpty()) {
                        String startCol = new String(((Column)columnList.get(columnList.size() - 1)).getName(), "UTF-8");
                        while (moreCols) {
                            Option<java.util.List<Column>> nextCols = this.$outer.get(uuid, this.entityName$3, startCol, this.endColumn$1);
                            if (!nextCols.isDefined()) continue;
                            ((java.util.List)nextCols.get()).remove(0);
                            if (((java.util.List)nextCols.get()).isEmpty()) {
                                moreCols = false;
                                continue;
                            }
                            columnList.addAll((Collection)nextCols.get());
                            startCol = new String(((Column)columnList.get(columnList.size() - 1)).getName(), "UTF-8");
                        }
                        scala.collection.immutable.Map<String, String> map = this.$outer.columnList2Map(columnList);
                        this.continue$2.elem = BoxesRunTime.unboxToBoolean((Object)this.proc$2.apply((Object)uuid, map));
                    }
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.entityName$3 = entityName$3;
                    this.proc$2 = proc$2;
                    this.endColumn$1 = endColumn$1;
                    this.continue$2 = continue$2;
                    this.columnMap$2 = columnMap$2;
                }
            });
            counter += keys.size();
            keyRange = Selector.newKeyRange((Bytes)startKey, (Bytes)endKey, (int)(pageSize + 1));
            columnMap.elem = this.getColumnsFromRowsWithRetries(entityName, keyRange, slicePredicate, ConsistencyLevel.ONE, 10);
            ((java.util.Map)columnMap.elem).remove(startKey);
        }
        if (counter > 0) {
            this.logger().debug(new StringBuilder().append((Object)"Finished paging. Records paged over : ").append((Object)BoxesRunTime.boxToInteger((int)counter)).toString());
        }
    }

    @Override
    public String pageOverColumnRange$default$3() {
        return "";
    }

    @Override
    public String pageOverColumnRange$default$4() {
        return "";
    }

    @Override
    public int pageOverColumnRange$default$5() {
        return 1000;
    }

    @Override
    public String pageOverColumnRange$default$6() {
        return "";
    }

    @Override
    public String pageOverColumnRange$default$7() {
        return "";
    }

    @Override
    public void pageOverAll(String entityName, Function2<String, scala.collection.immutable.Map<String, String>, Object> proc, String startUuid, String endUuid, int pageSize) {
        SlicePredicate slicePredicate = Selector.newColumnsPredicateAll((boolean)true, (int)this.maxColumnLimit());
        this.pageOver(entityName, proc, pageSize, slicePredicate, true, startUuid, endUuid);
    }

    @Override
    public String pageOverAll$default$3() {
        return "";
    }

    @Override
    public String pageOverAll$default$4() {
        return "";
    }

    @Override
    public int pageOverAll$default$5() {
        return 1000;
    }

    @Override
    public void selectRows(Seq<String> rowkeys, String entityName, Seq<String> fields, Function1<scala.collection.immutable.Map<String, String>, BoxedUnit> proc) {
        Selector selector = Pelops.createSelector((String)this.poolName());
        SlicePredicate slicePredicate = Selector.newColumnsPredicate((String[])((String[])fields.toArray(ClassTag$.MODULE$.apply(String.class))));
        LinkedHashMap columnMap = selector.getColumnsFromRowsUtf8Keys(entityName, JavaConversions$.MODULE$.seqAsJavaList((Seq)rowkeys.toList()), slicePredicate, ConsistencyLevel.ONE);
        List keys = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray(columnMap.keySet().toArray()));
        keys.foreach((Function1)new Serializable(this, proc, columnMap){
            public static final long serialVersionUID = 0L;
            private final Function1 proc$3;
            private final LinkedHashMap columnMap$3;

            public final void apply(Object key) {
                java.util.List columnsList = (java.util.List)this.columnMap$3.get(key);
                Tuple2[] fieldValues = (Tuple2[])((TraversableOnce)JavaConversions$.MODULE$.asScalaBuffer(columnsList).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<String, String> apply(Column column) {
                        return new Tuple2((Object)new String(column.getName(), "UTF-8"), (Object)new String(column.getValue(), "UTF-8"));
                    }
                }, Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Tuple2.class));
                scala.collection.mutable.Map map = Map$.MODULE$.empty();
                Predef$.MODULE$.refArrayOps((Object[])fieldValues).foreach((Function1)new Serializable(this, map){
                    public static final long serialVersionUID = 0L;
                    private final scala.collection.mutable.Map map$1;

                    public final void apply(Tuple2<String, String> fieldValue) {
                        this.map$1.update(fieldValue._1(), fieldValue._2());
                    }
                    {
                        this.map$1 = map$1;
                    }
                });
                this.proc$3.apply((Object)map.toMap(Predef$.MODULE$.conforms()));
            }
            {
                this.proc$3 = proc$3;
                this.columnMap$3 = columnMap$3;
            }
        });
    }

    public scala.collection.immutable.Map<String, String> columnList2Map(java.util.List<Column> columnList) {
        scala.collection.mutable.HashMap map = new scala.collection.mutable.HashMap();
        for (Column c : columnList) {
            map.put((Object)new String(c.getName(), "UTF-8"), (Object)new String(c.getValue(), "UTF-8"));
        }
        return map.toMap(Predef$.MODULE$.conforms());
    }

    public scala.collection.immutable.Map<String, Object> columnList2TimeMap(java.util.List<Column> columnList) {
        scala.collection.mutable.HashMap map = new scala.collection.mutable.HashMap();
        for (Column c : columnList) {
            map.put((Object)new String(c.getName(), "UTF-8"), (Object)BoxesRunTime.boxToLong((long)(c.getTimestamp() / 1000L)));
        }
        return map.toMap(Predef$.MODULE$.conforms());
    }

    public Option<Column> getColumn(String uuid, String columnFamily, String columnName) {
        Some some;
        try {
            Selector selector = Pelops.createSelector((String)this.poolName());
            some = new Some((Object)selector.getColumnFromRow(columnFamily, uuid, columnName, ConsistencyLevel.ONE));
        }
        catch (Exception exception) {
            this.logger().debug(new StringBuilder().append((Object)exception.getMessage()).append((Object)" for ").append((Object)uuid).append((Object)" - ").append((Object)columnFamily).append((Object)" - ").append((Object)columnName).toString());
            some = None$.MODULE$;
        }
        return some;
    }

    @Override
    public void shutdown() {
        try {
            Pelops.shutdown();
        }
        catch (Exception exception) {
            this.logger().warn(exception.getMessage(), (Throwable)exception);
        }
    }

    @Override
    public void deleteColumns(String uuid, String entityName, Seq<String> columnName) {
        if (uuid != null && entityName != null && columnName != null) {
            Mutator mutator = Pelops.createMutator((String)this.poolName());
            mutator.deleteColumns(entityName, uuid, (String[])columnName.toArray(ClassTag$.MODULE$.apply(String.class)));
            mutator.execute(ConsistencyLevel.ONE);
        }
    }

    @Override
    public void delete(String uuid, String entityName) {
        if (uuid != null && entityName != null) {
            RowDeletor deletor = Pelops.createRowDeletor((String)this.poolName());
            deletor.deleteRow(entityName, uuid, ConsistencyLevel.ONE);
        }
    }

    @Inject
    public CassandraPersistenceManager(@Named(value="cassandra.hosts") String host, @Named(value="cassandra.port") int port, @Named(value="cassandra.pool") String poolName, @Named(value="cassandra.keyspace") String keyspace, @Named(value="cassandra.max.connections") int maxConnections, @Named(value="cassandra.max.retries") int maxRetries, @Named(value="thrift.operation.timeout") int operationTimeout) {
        this.host = host;
        this.port = port;
        this.poolName = poolName;
        this.keyspace = keyspace;
        this.maxConnections = maxConnections;
        this.maxRetries = maxRetries;
        this.operationTimeout = operationTimeout;
        PersistenceManager$class.$init$(this);
        this.logger = LoggerFactory.getLogger((String)"CassandraPersistenceManager");
        this.maxColumnLimit = 10000;
        this.cluster = new Cluster(host, port, operationTimeout, false);
        this.policy = new CommonsBackedPool.Policy();
        this.policy().setMaxTotal(maxConnections);
        this.policy().setMaxWaitForConnection(3 * operationTimeout);
        this.operandPolicy = new OperandPolicy(maxRetries, false);
        this.initialise();
    }
}

