/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.index.lucene;

import au.org.ala.biocache.index.lucene.LuceneIndexing;
import au.org.ala.biocache.index.lucene.RecycleDoc;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexableField;
import org.apache.solr.schema.CopyField;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;

public class DocBuilder {
    static final Logger logger = Logger.getLogger(DocBuilder.class);
    LuceneIndexing index;
    IndexSchema schema;
    Map<String, Object[]> schemaMap = new HashMap<String, Object[]>();
    String currentId = "";
    RecycleDoc doc;
    boolean closed = true;
    private Map<String, List<IndexableField>> storedFields = new HashMap<String, List<IndexableField>>();

    DocBuilder(IndexSchema schema, LuceneIndexing index) {
        this.schema = schema;
        this.index = index;
    }

    public String getId() {
        return this.currentId;
    }

    public void newDoc(String id) throws InterruptedException {
        this.currentId = id;
        if (this.closed) {
            this.doc = this.index.nextDoc();
        } else {
            logger.warn((Object)"Document was not indexed or released before calling DocBuilder.newDoc again.");
        }
        this.doc.reset();
        this.closed = false;
    }

    public void release() throws InterruptedException {
        if (!this.closed) {
            this.index.release(this.doc);
            this.closed = true;
        }
    }

    public void index() throws IOException, InterruptedException {
        if (this.closed) {
            logger.error((Object)"DocBuilder.index() was called before newDoc() or after release(). Document not indexed.");
        } else {
            this.index.addDoc(this.doc);
            this.closed = true;
        }
    }

    public void addField(String field, Object value) {
        if (value == null || value.toString().length() == 0) {
            return;
        }
        boolean reused = false;
        if (this.doc.setField(field, value)) {
            reused = true;
        }
        boolean used = false;
        Object[] s = this.schemaMap.get(field);
        if (s == null) {
            s = new Object[]{this.schema.getFieldOrNull(field), this.schema.getCopyFieldsList(field)};
            this.schemaMap.put(field, s);
        }
        SchemaField sf = (SchemaField)s[0];
        List copyField = (List)s[1];
        try {
            if (sf != null && !reused) {
                used = true;
                this.addField(this.doc, sf, value);
            }
            if (copyField != null) {
                for (CopyField cf : copyField) {
                    SchemaField destinationField = cf.getDestination();
                    used = true;
                    if (value instanceof String && cf.getMaxChars() > 0) {
                        value = cf.getLimitedValue((String)value);
                    }
                    if (this.doc.setField(destinationField.getName(), value)) continue;
                    this.addField(this.doc, destinationField, value);
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)("ERROR: Error adding field to id:'" + this.currentId + "' '" + field + "'='" + value + "' msg=" + ex.getMessage()));
        }
        if (!used && !reused) {
            logger.error((Object)("ERROR: unknown field id:'" + this.currentId + "' '" + field + "'"));
        }
    }

    private void addField(RecycleDoc doc, SchemaField field, Object val) {
        try {
            if (val instanceof IndexableField) {
                ((Field)val).setBoost(1.0f);
                doc.add(field, (IndexableField)((Field)val));
            } else {
                for (IndexableField f : field.getType().createFields(field, val, 1.0f)) {
                    if (f == null) continue;
                    doc.add(field, (IndexableField)((Field)f));
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("ERROR adding one field '" + this.currentId + "' '" + field.getName() + "' = '" + val.toString() + "' > " + e.getMessage()));
        }
    }

    public RecycleDoc getDoc() {
        return this.doc;
    }
}

