/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.index;

import au.org.ala.biocache.Config$;
import au.org.ala.biocache.cmd.Tool;
import au.org.ala.biocache.cmd.Tool$class;
import au.org.ala.biocache.index.BulkProcessor$;
import au.org.ala.biocache.index.ColumnExporter;
import au.org.ala.biocache.index.ColumnReporterRunner;
import au.org.ala.biocache.index.Counter;
import au.org.ala.biocache.index.Counter$class;
import au.org.ala.biocache.index.DatumRecordsRunner;
import au.org.ala.biocache.index.IndexMergeTool$;
import au.org.ala.biocache.index.IndexRunner;
import au.org.ala.biocache.index.LoadSamplingRunner;
import au.org.ala.biocache.index.RangeCalculator;
import au.org.ala.biocache.index.RangeCalculator$class;
import au.org.ala.biocache.index.RepairRecordsRunner;
import au.org.ala.biocache.index.lucene.LuceneIndexing;
import au.org.ala.biocache.tool.ProcessRecords$;
import au.org.ala.biocache.util.OptionParser;
import java.io.File;
import org.apache.commons.io.FileUtils;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.IndexSchemaFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.CharRef;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

public final class BulkProcessor$
implements Tool,
Counter,
RangeCalculator {
    public static final BulkProcessor$ MODULE$;
    private final Logger logger;
    private int counter;
    private long startTime;
    private long finishTime;

    static {
        new BulkProcessor$();
    }

    @Override
    public void au$org$ala$biocache$index$RangeCalculator$_setter_$logger_$eq(Logger x$1) {
    }

    @Override
    public Tuple2<String, String>[] calculateRanges(int threads, String query, String start, String end) {
        return RangeCalculator$class.calculateRanges(this, threads, query, start, end);
    }

    @Override
    public Tuple2<String, String>[] generateRanges(String[] keys, String start, String end) {
        return RangeCalculator$class.generateRanges(this, keys, start, end);
    }

    @Override
    public String calculateRanges$default$2() {
        return RangeCalculator$class.calculateRanges$default$2(this);
    }

    @Override
    public String calculateRanges$default$3() {
        return RangeCalculator$class.calculateRanges$default$3(this);
    }

    @Override
    public String calculateRanges$default$4() {
        return RangeCalculator$class.calculateRanges$default$4(this);
    }

    @Override
    public int counter() {
        return this.counter;
    }

    @Override
    public void counter_$eq(int x$1) {
        this.counter = x$1;
    }

    @Override
    public long startTime() {
        return this.startTime;
    }

    @Override
    public void startTime_$eq(long x$1) {
        this.startTime = x$1;
    }

    @Override
    public long finishTime() {
        return this.finishTime;
    }

    @Override
    public void finishTime_$eq(long x$1) {
        this.finishTime = x$1;
    }

    @Override
    public void au$org$ala$biocache$index$Counter$_setter_$logger_$eq(Logger x$1) {
    }

    @Override
    public void addToCounter(int amount) {
        Counter$class.addToCounter(this, amount);
    }

    @Override
    public void printOutStatus(int threadId, String lastKey, String runnerType, long totalTime) {
        Counter$class.printOutStatus(this, threadId, lastKey, runnerType, totalTime);
    }

    @Override
    public long printOutStatus$default$4() {
        return Counter$class.printOutStatus$default$4(this);
    }

    @Override
    public String help() {
        return Tool$class.help(this);
    }

    @Override
    public String cmd() {
        return "bulk-processor";
    }

    @Override
    public String desc() {
        return "Bulk processor for regenerating indexes and reprocessing the entire cache";
    }

    @Override
    public Logger logger() {
        return this.logger;
    }

    @Override
    public void main(String[] args) {
        IntRef numThreads = new IntRef(8);
        IntRef threadsPerWriter = new IntRef(1);
        IntRef threadsPerProcess = new IntRef(1);
        IntRef ramPerWriter = new IntRef(50);
        IntRef writerSegmentSize = new IntRef(500000);
        IntRef writerBufferSize = new IntRef(3000);
        IntRef processorBufferSize = new IntRef(100);
        BooleanRef singleWriter = new BooleanRef(false);
        IntRef pageSize = new IntRef(200);
        ObjectRef dirPrefix = new ObjectRef((Object)"/data/biocache-reindex");
        ObjectRef keys = new ObjectRef((Object)None$.MODULE$);
        ObjectRef columns = new ObjectRef((Object)None$.MODULE$);
        ObjectRef action = new ObjectRef((Object)"");
        ObjectRef start = new ObjectRef((Object)"");
        ObjectRef end = new ObjectRef((Object)"");
        ObjectRef dr = new ObjectRef((Object)None$.MODULE$);
        List validActions = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"range", "process", "index", "col", "repair", "datum", "load-sampling", "avro-export"}));
        BooleanRef forceMerge = new BooleanRef(true);
        IntRef mergeSegments = new IntRef(1);
        BooleanRef deleteSources = new BooleanRef(false);
        BooleanRef includeRowkey = new BooleanRef(true);
        CharRef charSeparator = new CharRef('\t');
        String cassandraFilterFile = "";
        OptionParser parser = new OptionParser(numThreads, threadsPerWriter, threadsPerProcess, ramPerWriter, writerSegmentSize, writerBufferSize, processorBufferSize, singleWriter, pageSize, dirPrefix, keys, columns, action, start, end, dr, forceMerge, mergeSegments, deleteSources, includeRowkey, charSeparator){
            {
                this.arg("<action>", "The action to perform. Supported values :  range, process or index, col", (Function1<String, BoxedUnit>)new Serializable(this, action$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef action$1;

                    public final void apply(String v) {
                        this.action$1.elem = v;
                    }
                    {
                        this.action$1 = action$1;
                    }
                });
                this.intOpt("t", "threads", new StringBuilder().append((Object)"The number of threads to perform the indexing on. Default is ").append((Object)BoxesRunTime.boxToInteger((int)numThreads$1.elem)).toString(), (Function1<Object, BoxedUnit>)new Serializable(this, numThreads$1){
                    public static final long serialVersionUID = 0L;
                    private final IntRef numThreads$1;

                    public final void apply(int v) {
                        this.apply$mcVI$sp(v);
                    }

                    public void apply$mcVI$sp(int v) {
                        this.numThreads$1.elem = v;
                    }
                    {
                        this.numThreads$1 = numThreads$1;
                    }
                });
                this.intOpt("wt", "writerthreads", new StringBuilder().append((Object)"The number of threads for each indexing writer. There is 1 writer for each -t. Default is ").append((Object)BoxesRunTime.boxToInteger((int)threadsPerWriter$1.elem)).toString(), (Function1<Object, BoxedUnit>)new Serializable(this, threadsPerWriter$1){
                    public static final long serialVersionUID = 0L;
                    private final IntRef threadsPerWriter$1;

                    public final void apply(int v) {
                        this.apply$mcVI$sp(v);
                    }

                    public void apply$mcVI$sp(int v) {
                        this.threadsPerWriter$1.elem = v;
                    }
                    {
                        this.threadsPerWriter$1 = threadsPerWriter$1;
                    }
                });
                this.opt("sw", "singlewriter", new StringBuilder().append((Object)"Use one index writer instead of one writer per 'thread'. Default is ").append((Object)BoxesRunTime.boxToBoolean((boolean)singleWriter$1.elem)).toString(), (Function0<BoxedUnit>)new Serializable(this, singleWriter$1){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef singleWriter$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.singleWriter$1.elem = true;
                    }
                    {
                        this.singleWriter$1 = singleWriter$1;
                    }
                });
                this.intOpt("wb", "writerbuffer", new StringBuilder().append((Object)"Size of indexing write buffer. The default is ").append((Object)BoxesRunTime.boxToInteger((int)writerBufferSize$1.elem)).toString(), (Function1<Object, BoxedUnit>)new Serializable(this, writerBufferSize$1){
                    public static final long serialVersionUID = 0L;
                    private final IntRef writerBufferSize$1;

                    public final void apply(int v) {
                        this.apply$mcVI$sp(v);
                    }

                    public void apply$mcVI$sp(int v) {
                        this.writerBufferSize$1.elem = v;
                    }
                    {
                        this.writerBufferSize$1 = writerBufferSize$1;
                    }
                });
                this.intOpt("pt", "processthreads", new StringBuilder().append((Object)"The number of threads for each indexing process. There is 1 process for each -t. Default is ").append((Object)BoxesRunTime.boxToInteger((int)threadsPerProcess$1.elem)).toString(), (Function1<Object, BoxedUnit>)new Serializable(this, threadsPerProcess$1){
                    public static final long serialVersionUID = 0L;
                    private final IntRef threadsPerProcess$1;

                    public final void apply(int v) {
                        this.apply$mcVI$sp(v);
                    }

                    public void apply$mcVI$sp(int v) {
                        this.threadsPerProcess$1.elem = v;
                    }
                    {
                        this.threadsPerProcess$1 = threadsPerProcess$1;
                    }
                });
                this.intOpt("pb", "processbuffer", new StringBuilder().append((Object)"Size of the indexing process buffer. Default is ").append((Object)BoxesRunTime.boxToInteger((int)processorBufferSize$1.elem)).toString(), (Function1<Object, BoxedUnit>)new Serializable(this, processorBufferSize$1){
                    public static final long serialVersionUID = 0L;
                    private final IntRef processorBufferSize$1;

                    public final void apply(int v) {
                        this.apply$mcVI$sp(v);
                    }

                    public void apply$mcVI$sp(int v) {
                        this.processorBufferSize$1.elem = v;
                    }
                    {
                        this.processorBufferSize$1 = processorBufferSize$1;
                    }
                });
                this.intOpt("r", "writerram", new StringBuilder().append((Object)"Ram allocation for each writer (MB). There is 1 writer for each -t. Default is ").append((Object)BoxesRunTime.boxToInteger((int)ramPerWriter$1.elem)).toString(), (Function1<Object, BoxedUnit>)new Serializable(this, ramPerWriter$1){
                    public static final long serialVersionUID = 0L;
                    private final IntRef ramPerWriter$1;

                    public final void apply(int v) {
                        this.apply$mcVI$sp(v);
                    }

                    public void apply$mcVI$sp(int v) {
                        this.ramPerWriter$1.elem = v;
                    }
                    {
                        this.ramPerWriter$1 = ramPerWriter$1;
                    }
                });
                this.intOpt("ws", "writersegmentsize", new StringBuilder().append((Object)"Maximum number of occurrences in a writer segment. There is 1 writer for each -t. Default is ").append((Object)BoxesRunTime.boxToInteger((int)writerSegmentSize$1.elem)).toString(), (Function1<Object, BoxedUnit>)new Serializable(this, writerSegmentSize$1){
                    public static final long serialVersionUID = 0L;
                    private final IntRef writerSegmentSize$1;

                    public final void apply(int v) {
                        this.apply$mcVI$sp(v);
                    }

                    public void apply$mcVI$sp(int v) {
                        this.writerSegmentSize$1.elem = v;
                    }
                    {
                        this.writerSegmentSize$1 = writerSegmentSize$1;
                    }
                });
                this.intOpt("ps", "pagesize", new StringBuilder().append((Object)"The page size for the records. Default is ").append((Object)BoxesRunTime.boxToInteger((int)pageSize$1.elem)).toString(), (Function1<Object, BoxedUnit>)new Serializable(this, pageSize$1){
                    public static final long serialVersionUID = 0L;
                    private final IntRef pageSize$1;

                    public final void apply(int v) {
                        this.apply$mcVI$sp(v);
                    }

                    public void apply$mcVI$sp(int v) {
                        this.pageSize$1.elem = v;
                    }
                    {
                        this.pageSize$1 = pageSize$1;
                    }
                });
                this.opt("p", "prefix", new StringBuilder().append((Object)"The prefix to apply to the solr directories. Default is ").append((Object)((String)dirPrefix$1.elem)).toString(), (Function1<String, BoxedUnit>)new Serializable(this, dirPrefix$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef dirPrefix$1;

                    public final void apply(String v) {
                        this.dirPrefix$1.elem = v;
                    }
                    {
                        this.dirPrefix$1 = dirPrefix$1;
                    }
                });
                this.opt("k", "keys", "A comma separated list of keys on which to perform the range threads. Prevents the need to query SOLR for the ranges.", (Function1<String, BoxedUnit>)new Serializable(this, keys$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef keys$1;

                    public final void apply(String v) {
                        this.keys$1.elem = new Some((Object)v.split(","));
                    }
                    {
                        this.keys$1 = keys$1;
                    }
                });
                this.opt("s", "start", "The rowKey in which to start the range", (Function1<String, BoxedUnit>)new Serializable(this, start$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef start$1;

                    public final void apply(String v) {
                        this.start$1.elem = v;
                    }
                    {
                        this.start$1 = start$1;
                    }
                });
                this.opt("e", "end", "The rowKey in which to end the range", (Function1<String, BoxedUnit>)new Serializable(this, end$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef end$1;

                    public final void apply(String v) {
                        this.end$1.elem = v;
                    }
                    {
                        this.end$1 = end$1;
                    }
                });
                this.opt("dr", "dr", "The data resource over which to obtain the range", (Function1<String, BoxedUnit>)new Serializable(this, dr$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef dr$1;

                    public final void apply(String v) {
                        this.dr$1.elem = new Some((Object)v);
                    }
                    {
                        this.dr$1 = dr$1;
                    }
                });
                this.opt("c", "columns", "The columns to export", (Function1<String, BoxedUnit>)new Serializable(this, columns$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef columns$1;

                    public final void apply(String v) {
                        this.columns$1.elem = new Some((Object)v.split(","));
                    }
                    {
                        this.columns$1 = columns$1;
                    }
                });
                this.opt("c", "columns", "The columns to export", (Function1<String, BoxedUnit>)new Serializable(this, columns$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef columns$1;

                    public final void apply(String v) {
                        this.columns$1.elem = new Some((Object)v.split(","));
                    }
                    {
                        this.columns$1 = columns$1;
                    }
                });
                this.opt("erk", "exclude-rowkey", "Exclude rowkey from export.", (Function0<BoxedUnit>)new Serializable(this, includeRowkey$1){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef includeRowkey$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.includeRowkey$1.elem = false;
                    }
                    {
                        this.includeRowkey$1 = includeRowkey$1;
                    }
                });
                this.opt("sep", "char=separator", "Character separator for CSV exports. Defaults to tab.", (Function1<String, BoxedUnit>)new Serializable(this, charSeparator$1){
                    public static final long serialVersionUID = 0L;
                    private final CharRef charSeparator$1;

                    public final void apply(String v) {
                        this.charSeparator$1.elem = v.trim().charAt(0);
                    }
                    {
                        this.charSeparator$1 = charSeparator$1;
                    }
                });
                this.opt("sm", "skipMerge", new StringBuilder().append((Object)"Force merge of segments. Default is ").append((Object)BoxesRunTime.boxToBoolean((boolean)forceMerge$1.elem)).append((Object)". For index only.").toString(), (Function0<BoxedUnit>)new Serializable(this, forceMerge$1){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef forceMerge$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.forceMerge$1.elem = false;
                    }
                    {
                        this.forceMerge$1 = forceMerge$1;
                    }
                });
                this.intOpt("ms", "max segments", new StringBuilder().append((Object)"Max merge segments. Default ").append((Object)BoxesRunTime.boxToInteger((int)mergeSegments$1.elem)).append((Object)". For index only.").toString(), (Function1<Object, BoxedUnit>)new Serializable(this, mergeSegments$1){
                    public static final long serialVersionUID = 0L;
                    private final IntRef mergeSegments$1;

                    public final void apply(int v) {
                        this.apply$mcVI$sp(v);
                    }

                    public void apply$mcVI$sp(int v) {
                        this.mergeSegments$1.elem = v;
                    }
                    {
                        this.mergeSegments$1 = mergeSegments$1;
                    }
                });
                this.opt("ds", "delete-sources", new StringBuilder().append((Object)"Delete sources if successful. Defaults to ").append((Object)BoxesRunTime.boxToBoolean((boolean)deleteSources$1.elem)).append((Object)". For index only.").toString(), (Function0<BoxedUnit>)new Serializable(this, deleteSources$1){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef deleteSources$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.deleteSources$1.elem = true;
                    }
                    {
                        this.deleteSources$1 = deleteSources$1;
                    }
                });
            }
        };
        if (parser.parse((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])args)) && validActions.contains((Object)((String)action.elem))) {
            Tuple3 tuple3;
            Tuple3 tuple32 = tuple3 = ((Option)dr.elem).isDefined() ? new Tuple3((Object)new StringBuilder().append((Object)"data_resource_uid:").append(((Option)dr.elem).get()).toString(), (Object)new StringBuilder().append((Object)((String)((Option)dr.elem).get())).append((Object)"|").toString(), (Object)new StringBuilder().append((Object)((String)((Option)dr.elem).get())).append((Object)"|~").toString()) : new Tuple3((Object)"*:*", (Object)((String)start.elem), (Object)((String)end.elem));
            if (tuple3 != null) {
                BoxedUnit boxedUnit;
                Tuple3 tuple33;
                String query = (String)tuple3._1();
                String startValue = (String)tuple3._2();
                String endValue = (String)tuple3._3();
                Tuple3 tuple34 = tuple33 = new Tuple3((Object)query, (Object)startValue, (Object)endValue);
                String query2 = (String)tuple34._1();
                String startValue2 = (String)tuple34._2();
                String endValue2 = (String)tuple34._3();
                Tuple2<String, String>[] ranges = ((Option)keys.elem).isEmpty() ? this.calculateRanges(numThreads.elem, query2, startValue2, endValue2) : this.generateRanges((String[])((Option)keys.elem).get(), startValue2, endValue2);
                ObjectRef luceneIndexing = new ObjectRef((Object)new ArrayBuffer());
                String string = (String)action.elem;
                String string2 = "index";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    String h = new StringBuilder().append((Object)((String)dirPrefix.elem)).append((Object)"/solr-create/biocache-thread-0/conf").toString();
                    File newIndexDir = new File(h);
                    if (newIndexDir.exists()) {
                        FileUtils.deleteDirectory((File)newIndexDir.getParentFile());
                    }
                    FileUtils.forceMkdir((File)newIndexDir);
                    File sourceConfDir = new File(new StringBuilder().append((Object)((String)dirPrefix.elem)).append((Object)"/solr-template/biocache/conf").toString());
                    FileUtils.copyDirectory((File)sourceConfDir, (File)newIndexDir);
                    FileUtils.copyFileToDirectory((File)new File(new StringBuilder().append((Object)sourceConfDir.getParent()).append((Object)"/solr.xml").toString()), (File)newIndexDir.getParentFile());
                    IndexSchema schema = IndexSchemaFactory.buildIndexSchema((String)"schema.xml", (SolrConfig)SolrConfig.readFromResourceLoader((SolrResourceLoader)new SolrResourceLoader(new StringBuilder().append((Object)((String)dirPrefix.elem)).append((Object)"/solr-template/biocache").toString()), (String)"solrconfig.xml"));
                    if (singleWriter.elem) {
                        boxedUnit = ((ArrayBuffer)luceneIndexing.elem).$plus$eq((Object)new LuceneIndexing(schema, Predef$.MODULE$.long2Long((long)writerSegmentSize.elem), new StringBuilder().append((Object)newIndexDir.getParent()).append((Object)"/data0-").toString(), Predef$.MODULE$.int2Integer(ramPerWriter.elem), Predef$.MODULE$.int2Integer(writerBufferSize.elem), Predef$.MODULE$.int2Integer(writerBufferSize.elem / 2), Predef$.MODULE$.int2Integer(threadsPerWriter.elem)));
                    } else {
                        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numThreads.elem).foreach((Function1)new Serializable(threadsPerWriter, ramPerWriter, writerSegmentSize, writerBufferSize, luceneIndexing, newIndexDir, schema){
                            public static final long serialVersionUID = 0L;
                            private final IntRef threadsPerWriter$1;
                            private final IntRef ramPerWriter$1;
                            private final IntRef writerSegmentSize$1;
                            private final IntRef writerBufferSize$1;
                            private final ObjectRef luceneIndexing$1;
                            private final File newIndexDir$1;
                            private final IndexSchema schema$1;

                            public final ArrayBuffer<LuceneIndexing> apply(int i) {
                                return ((ArrayBuffer)this.luceneIndexing$1.elem).$plus$eq((Object)new LuceneIndexing(this.schema$1, Predef$.MODULE$.long2Long((long)this.writerSegmentSize$1.elem), new StringBuilder().append((Object)this.newIndexDir$1.getParent()).append((Object)"/data").append((Object)BoxesRunTime.boxToInteger((int)i)).append((Object)"-").toString(), Predef$.MODULE$.int2Integer(this.ramPerWriter$1.elem), Predef$.MODULE$.int2Integer(this.writerBufferSize$1.elem), Predef$.MODULE$.int2Integer(this.writerBufferSize$1.elem / (this.threadsPerWriter$1.elem + 2)), Predef$.MODULE$.int2Integer(this.threadsPerWriter$1.elem)));
                            }
                            {
                                this.threadsPerWriter$1 = threadsPerWriter$1;
                                this.ramPerWriter$1 = ramPerWriter$1;
                                this.writerSegmentSize$1 = writerSegmentSize$1;
                                this.writerBufferSize$1 = writerBufferSize$1;
                                this.luceneIndexing$1 = luceneIndexing$1;
                                this.newIndexDir$1 = newIndexDir$1;
                                this.schema$1 = schema$1;
                            }
                        });
                        boxedUnit = BoxedUnit.UNIT;
                    }
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                String string3 = (String)action.elem;
                String string4 = "range";
                if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                    this.logger().info(Predef$.MODULE$.refArrayOps((Object[])ranges).mkString("\n"));
                } else {
                    String string5 = (String)action.elem;
                    String string6 = "process";
                    if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
                        ProcessRecords$.MODULE$.processRecords(numThreads.elem, (Option<String>)Option$.MODULE$.apply((Object)((String)start.elem)), (Option<String>)((Option)dr.elem), false, null, (Option<String>)Option$.MODULE$.apply((Object)((String)end.elem)));
                    } else {
                        IntRef counter = new IntRef(0);
                        ArrayBuffer threads = new ArrayBuffer();
                        ArrayBuffer columnRunners = new ArrayBuffer();
                        ArrayBuffer solrDirs = new ArrayBuffer();
                        Predef$.MODULE$.refArrayOps((Object[])ranges).foreach((Function1)new Serializable(numThreads, threadsPerProcess, processorBufferSize, singleWriter, pageSize, dirPrefix, columns, action, includeRowkey, charSeparator, luceneIndexing, counter, threads, columnRunners){
                            public static final long serialVersionUID = 0L;
                            private final IntRef numThreads$1;
                            private final IntRef threadsPerProcess$1;
                            private final IntRef processorBufferSize$1;
                            private final BooleanRef singleWriter$1;
                            private final IntRef pageSize$1;
                            private final ObjectRef dirPrefix$1;
                            private final ObjectRef columns$1;
                            private final ObjectRef action$1;
                            private final BooleanRef includeRowkey$1;
                            private final CharRef charSeparator$1;
                            private final ObjectRef luceneIndexing$1;
                            private final IntRef counter$1;
                            private final ArrayBuffer threads$1;
                            private final ArrayBuffer columnRunners$1;

                            /*
                             * Unable to fully structure code
                             * Could not resolve type clashes
                             */
                            public final void apply(Tuple2<String, String> x0$1) {
                                block2: {
                                    block4: {
                                        block7: {
                                            block6: {
                                                block5: {
                                                    block3: {
                                                        var2_2 = x0$1;
                                                        if (var2_2 == null) break block2;
                                                        startKey = (String)var2_2._1();
                                                        endKey = (String)var2_2._2();
                                                        BulkProcessor$.MODULE$.logger().info(new StringBuilder().append((Object)"start: ").append((Object)startKey).append((Object)", end key: ").append((Object)endKey).toString());
                                                        v0 = (String)this.action$1.elem;
                                                        var7_5 = "datum";
                                                        if (v0 != null ? v0.equals(var7_5) == false : var7_5 != null) break block3;
                                                        v1 /* !! */  = new DatumRecordsRunner(BulkProcessor$.MODULE$, this.counter$1.elem, startKey, endKey);
                                                        break block4;
                                                    }
                                                    v2 = (String)this.action$1.elem;
                                                    var8_6 = "repair";
                                                    if (v2 != null ? v2.equals(var8_6) == false : var8_6 != null) break block5;
                                                    v1 /* !! */  = new RepairRecordsRunner(BulkProcessor$.MODULE$, this.counter$1.elem, startKey, endKey);
                                                    break block4;
                                                }
                                                v3 = (String)this.action$1.elem;
                                                var9_7 = "index";
                                                if (v3 != null ? v3.equals(var9_7) == false : var9_7 != null) break block6;
                                                index = this.singleWriter$1.elem != false ? (LuceneIndexing)((ArrayBuffer)this.luceneIndexing$1.elem).apply(0) : (LuceneIndexing)((ArrayBuffer)this.luceneIndexing$1.elem).apply(this.counter$1.elem % this.numThreads$1.elem);
                                                v1 /* !! */  = new IndexRunner(BulkProcessor$.MODULE$, this.counter$1.elem, startKey, endKey, new StringBuilder().append((Object)((String)this.dirPrefix$1.elem)).append((Object)"/solr-template/biocache/conf").toString(), new StringBuilder().append((Object)((String)this.dirPrefix$1.elem)).append((Object)"/solr-create/biocache-thread-").append((Object)BoxesRunTime.boxToInteger((int)this.counter$1.elem)).append((Object)"/conf").toString(), this.pageSize$1.elem, index, Predef$.MODULE$.int2Integer(this.threadsPerProcess$1.elem), Predef$.MODULE$.int2Integer(this.processorBufferSize$1.elem), this.singleWriter$1.elem);
                                                break block4;
                                            }
                                            v4 = (String)this.action$1.elem;
                                            var11_9 = "load-sampling";
                                            if (v4 != null ? v4.equals(var11_9) == false : var11_9 != null) break block7;
                                            v1 /* !! */  = new LoadSamplingRunner(BulkProcessor$.MODULE$, this.counter$1.elem, startKey, endKey);
                                            break block4;
                                        }
                                        v5 = (String)this.action$1.elem;
                                        var12_10 = "col";
                                        if (!(v5 == null ? var12_10 != null : v5.equals(var12_10) == false)) ** GOTO lbl-1000
                                        v6 = (String)this.action$1.elem;
                                        var13_11 = "column-export";
                                        if (!(v6 != null ? v6.equals(var13_11) == false : var13_11 != null)) lbl-1000:
                                        // 2 sources

                                        {
                                            v1 /* !! */  = ((Option)this.columns$1.elem).isEmpty() ? new ColumnReporterRunner(BulkProcessor$.MODULE$, this.counter$1.elem, startKey, endKey) : new ColumnExporter(BulkProcessor$.MODULE$, this.counter$1.elem, startKey, endKey, (List<String>)Predef$.MODULE$.refArrayOps((Object[])((Option)this.columns$1.elem).get()).toList(), this.includeRowkey$1.elem, this.charSeparator$1.elem);
                                        } else {
                                            v1 /* !! */  = new Thread();
                                        }
                                    }
                                    ir = v1 /* !! */ ;
                                    t = new Thread(ir);
                                    t.start();
                                    this.threads$1.$plus$eq((Object)t);
                                    v7 /* !! */  = ir instanceof ColumnReporterRunner != false ? this.columnRunners$1.$plus$eq((Object)((ColumnReporterRunner)ir)) : BoxedUnit.UNIT;
                                    ++this.counter$1.elem;
                                    var5_14 = BoxedUnit.UNIT;
                                    return;
                                }
                                throw new MatchError(var2_2);
                            }
                            {
                                this.numThreads$1 = numThreads$1;
                                this.threadsPerProcess$1 = threadsPerProcess$1;
                                this.processorBufferSize$1 = processorBufferSize$1;
                                this.singleWriter$1 = singleWriter$1;
                                this.pageSize$1 = pageSize$1;
                                this.dirPrefix$1 = dirPrefix$1;
                                this.columns$1 = columns$1;
                                this.action$1 = action$1;
                                this.includeRowkey$1 = includeRowkey$1;
                                this.charSeparator$1 = charSeparator$1;
                                this.luceneIndexing$1 = luceneIndexing$1;
                                this.counter$1 = counter$1;
                                this.threads$1 = threads$1;
                                this.columnRunners$1 = columnRunners$1;
                            }
                        });
                        threads.foreach((Function1)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final void apply(Thread thread) {
                                thread.join();
                            }
                        });
                        String string7 = (String)action.elem;
                        String string8 = "index";
                        if (!(string7 != null ? !string7.equals(string8) : string8 != null)) {
                            ArrayBuffer dirs = new ArrayBuffer();
                            if (singleWriter.elem) {
                                ((LuceneIndexing)((ArrayBuffer)luceneIndexing.elem).apply(0)).close(true, false);
                            }
                            ((ArrayBuffer)luceneIndexing.elem).foreach((Function1)new Serializable(dirs){
                                public static final long serialVersionUID = 0L;
                                public final ArrayBuffer dirs$1;

                                public final void apply(LuceneIndexing i) {
                                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), i.getOutputDirectories().size()).foreach((Function1)new Serializable(this, i){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ anonfun.main.4 $outer;
                                        private final LuceneIndexing i$1;

                                        public final ArrayBuffer<String> apply(int j) {
                                            return this.$outer.dirs$1.$plus$eq((Object)this.i$1.getOutputDirectories().get(j).getPath());
                                        }
                                        {
                                            if ($outer == null) {
                                                throw new NullPointerException();
                                            }
                                            this.$outer = $outer;
                                            this.i$1 = i$1;
                                        }
                                    });
                                }
                                {
                                    this.dirs$1 = dirs$1;
                                }
                            });
                            luceneIndexing.elem = null;
                            threads.clear();
                            System.gc();
                            int mem = (int)Math.max((double)Runtime.getRuntime().freeMemory() * 0.75 / (double)1024 / (double)1024, (double)(numThreads.elem * ramPerWriter.elem));
                            this.logger().info("Merging index segments");
                            IndexMergeTool$.MODULE$.merge(new StringBuilder().append((Object)((String)dirPrefix.elem)).append((Object)"/solr/merged").toString(), (String[])dirs.toArray(ClassTag$.MODULE$.apply(String.class)), forceMerge.elem, mergeSegments.elem, deleteSources.elem, mem);
                            this.logger().info("Shutting down persistence manager");
                            Config$.MODULE$.persistenceManager().shutdown();
                        } else {
                            String string9 = (String)action.elem;
                            String string10 = "col";
                            if (!(string9 != null ? !string9.equals(string10) : string10 != null)) {
                                ObjectRef allSet = new ObjectRef((Object)((Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)));
                                columnRunners.foreach((Function1)new Serializable(allSet){
                                    public static final long serialVersionUID = 0L;
                                    private final ObjectRef allSet$1;

                                    public final void apply(ColumnReporterRunner c) {
                                        this.allSet$1.elem = (Set)((Set)this.allSet$1.elem).$plus$plus(c.myset());
                                    }
                                    {
                                        this.allSet$1 = allSet$1;
                                    }
                                });
                                allSet.elem = (Set)((Set)allSet.elem).filterNot((Function1)new Serializable(){
                                    public static final long serialVersionUID = 0L;

                                    public final boolean apply(String it) {
                                        return it.endsWith(".p") || it.endsWith(".qa");
                                    }
                                });
                                this.logger().info(new StringBuilder().append((Object)"All set: ").append((Object)((Set)allSet.elem)).toString());
                            }
                        }
                    }
                }
            } else {
                throw new MatchError((Object)tuple3);
            }
        }
    }

    private BulkProcessor$() {
        MODULE$ = this;
        Tool$class.$init$(this);
        Counter$class.$init$(this);
        RangeCalculator$class.$init$(this);
        this.logger = LoggerFactory.getLogger((String)"BulkProcessor");
    }
}

