/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.caches;

import au.com.bytecode.opencsv.CSVReader;
import au.org.ala.biocache.Config$;
import java.io.Reader;
import java.io.StringReader;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.GenTraversableOnce;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.StringBuilder;
import scala.io.Source$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.util.parsing.json.JSON$;

public final class TaxonSpeciesListDAO$ {
    public static final TaxonSpeciesListDAO$ MODULE$;
    private final Logger logger;
    private final Object lock;
    private scala.collection.immutable.Map<String, Seq<String>> speciesListMap;
    private scala.collection.immutable.Map<String, scala.collection.immutable.Map<String, String>> speciesListColumnsMap;

    static {
        new TaxonSpeciesListDAO$();
    }

    public Logger logger() {
        return this.logger;
    }

    private Object lock() {
        return this.lock;
    }

    private scala.collection.immutable.Map<String, Seq<String>> speciesListMap() {
        return this.speciesListMap;
    }

    private void speciesListMap_$eq(scala.collection.immutable.Map<String, Seq<String>> x$1) {
        this.speciesListMap = x$1;
    }

    private scala.collection.immutable.Map<String, scala.collection.immutable.Map<String, String>> speciesListColumnsMap() {
        return this.speciesListColumnsMap;
    }

    private void speciesListColumnsMap_$eq(scala.collection.immutable.Map<String, scala.collection.immutable.Map<String, String>> x$1) {
        this.speciesListColumnsMap = x$1;
    }

    public void main(String[] args) {
        scala.collection.immutable.Map<String, Seq<String>> map = this.buildTaxonListMap();
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Number of species in lists: ").append((Object)BoxesRunTime.boxToInteger((int)map.keys().size())).toString());
        HashMap counts = new HashMap();
        map.keys().foreach((Function1)new Serializable(map){
            public static final long serialVersionUID = 0L;
            private final scala.collection.immutable.Map map$1;

            public final void apply(String key) {
                Seq specieslistIds = (Seq)this.map$1.get((Object)key).get();
                Predef$.MODULE$.println((Object)new StringBuilder().append((Object)key).append((Object)" - ").append((Object)specieslistIds).toString());
            }
            {
                this.map$1 = map$1;
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Seq<String> getCachedListsForTaxon(String conceptLsid) {
        BoxedUnit boxedUnit;
        if (StringUtils.isEmpty((String)Config$.MODULE$.listToolUrl())) {
            return List$.MODULE$.empty();
        }
        if (this.speciesListMap() != null) {
            boxedUnit = BoxedUnit.UNIT;
            return (Seq)this.speciesListMap().getOrElse((Object)conceptLsid, (Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final List<Nothing$> apply() {
                    return Nil$.MODULE$;
                }
            });
        }
        Object object = this.lock();
        synchronized (object) {
            BoxedUnit boxedUnit2;
            if (this.speciesListMap() == null) {
                if (StringUtils.isNotEmpty((String)Config$.MODULE$.listToolUrl())) {
                    this.logger().info("Loading list information...");
                    this.speciesListMap_$eq(this.buildTaxonListMap());
                    this.logger().info("Loading list information...completed.");
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    this.logger().info("List tool URL is not configured. Skipping list loading...");
                    boxedUnit2 = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit3 = boxedUnit2;
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl21 : MonitorExitStatement: MONITOREXIT : object
            boxedUnit = boxedUnit3;
            return (Seq)this.speciesListMap().getOrElse((Object)conceptLsid, (Function0)new /* invalid duplicate definition of identical inner class */);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public scala.collection.immutable.Map<String, String> getCachedColumnsForTaxon(String conceptLsid) {
        BoxedUnit boxedUnit;
        if (StringUtils.isEmpty((String)Config$.MODULE$.listToolUrl())) {
            return Predef$.MODULE$.Map().empty();
        }
        if (this.speciesListColumnsMap() != null) {
            boxedUnit = BoxedUnit.UNIT;
            return (scala.collection.immutable.Map)this.speciesListColumnsMap().getOrElse((Object)conceptLsid, (Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final scala.collection.immutable.Map<String, String> apply() {
                    return (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
                }
            });
        }
        Object object = this.lock();
        synchronized (object) {
            BoxedUnit boxedUnit2;
            if (this.speciesListColumnsMap() == null) {
                if (StringUtils.isNotEmpty((String)Config$.MODULE$.listToolUrl())) {
                    this.logger().info("Loading list information...");
                    this.speciesListColumnsMap_$eq(this.buildTaxonListColumnsMap());
                    this.logger().info("Loading list information...completed.");
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    this.logger().info("List tool URL is not configured. Skipping list loading...");
                    boxedUnit2 = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit3 = boxedUnit2;
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl21 : MonitorExitStatement: MONITOREXIT : object
            boxedUnit = boxedUnit3;
            return (scala.collection.immutable.Map)this.speciesListColumnsMap().getOrElse((Object)conceptLsid, (Function0)new /* invalid duplicate definition of identical inner class */);
        }
    }

    public scala.collection.immutable.Map<String, Seq<String>> buildTaxonListMap() {
        scala.collection.immutable.Map map;
        try {
            HashMap guidMap = new HashMap();
            this.getListUids().foreach((Function1)new Serializable(guidMap){
                public static final long serialVersionUID = 0L;
                private final HashMap guidMap$1;

                public final void apply(String drUid) {
                    TaxonSpeciesListDAO$.MODULE$.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Loading data from ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{drUid})));
                    String downloadUrl = new StringBuilder().append((Object)Config$.MODULE$.listToolUrl()).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"/speciesListItem/downloadList/", "?fetch=%7BkvpValues%3Dselect%7D"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{drUid}))).toString();
                    TaxonSpeciesListDAO$.MODULE$.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Downloading list data from ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{downloadUrl})));
                    String data = Source$.MODULE$.fromURL(downloadUrl, "UTF-8").mkString();
                    CSVReader csvReader = new CSVReader((Reader)new StringReader(data));
                    String[] columnHdrs = csvReader.readNext();
                    int guidIdx = Predef$.MODULE$.refArrayOps((Object[])columnHdrs).indexOf((Object)"guid");
                    String[] currentLine = csvReader.readNext();
                    while (true) {
                        Seq specieslists;
                        if (currentLine == null) break;
                        String guid = currentLine[guidIdx];
                        Object object = guid.length() > 0 ? ((specieslists = (Seq)this.guidMap$1.getOrElse((Object)guid, (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final List<String> apply() {
                                return Nil$.MODULE$;
                            }
                        })).isEmpty() ? this.guidMap$1.put((Object)guid, (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{drUid}))) : (specieslists.contains((Object)drUid) ? BoxedUnit.UNIT : this.guidMap$1.put((Object)guid, specieslists.$colon$plus((Object)drUid, Seq$.MODULE$.canBuildFrom())))) : BoxedUnit.UNIT;
                        currentLine = csvReader.readNext();
                    }
                }
                {
                    this.guidMap$1 = guidMap$1;
                }
            });
            map = guidMap.toMap(Predef$.MODULE$.conforms());
        }
        catch (Exception exception) {
            this.logger().error(new StringBuilder().append((Object)"Problem loading lists to intersect with.").append((Object)exception.getMessage()).toString(), (Throwable)exception);
            map = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
        }
        return map;
    }

    public scala.collection.immutable.Map<String, scala.collection.immutable.Map<String, String>> buildTaxonListColumnsMap() {
        scala.collection.immutable.Map map;
        try {
            HashMap guidMap = new HashMap();
            this.getListUids().foreach((Function1)new Serializable(guidMap){
                public static final long serialVersionUID = 0L;
                private final HashMap guidMap$2;

                public final void apply(String drUid) {
                    try {
                        TaxonSpeciesListDAO$.MODULE$.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Loading data from ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{drUid})));
                        String downloadUrl = new StringBuilder().append((Object)Config$.MODULE$.listToolUrl()).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"/speciesListItem/downloadList/", "?fetch=%7BkvpValues%3Dselect%7D"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{drUid}))).toString();
                        TaxonSpeciesListDAO$.MODULE$.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Downloading list data from ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{downloadUrl})));
                        String data = Source$.MODULE$.fromURL(downloadUrl, "UTF-8").mkString();
                        CSVReader csvReader = new CSVReader((Reader)new StringReader(data));
                        String[] columnHdrs = csvReader.readNext();
                        int guidIdx = Predef$.MODULE$.refArrayOps((Object[])columnHdrs).indexOf((Object)"guid");
                        ObjectRef currentLine = new ObjectRef((Object)csvReader.readNext());
                        while (true) {
                            if ((String[])currentLine.elem != null) {
                                BoxedUnit boxedUnit;
                                String guid = ((String[])currentLine.elem)[guidIdx];
                                if (guid.length() > 0) {
                                    HashMap item = new HashMap();
                                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), columnHdrs.length).foreach((Function1)new Serializable(this, drUid, columnHdrs, currentLine, item){
                                        public static final long serialVersionUID = 0L;
                                        private final String drUid$1;
                                        private final String[] columnHdrs$1;
                                        private final ObjectRef currentLine$1;
                                        private final HashMap item$1;

                                        public final Option<String> apply(int i) {
                                            return this.item$1.put((Object)new StringBuilder().append((Object)this.drUid$1).append((Object)"_").append((Object)this.columnHdrs$1[i]).toString(), (Object)((String[])this.currentLine$1.elem)[i]);
                                        }
                                        {
                                            this.drUid$1 = drUid$1;
                                            this.columnHdrs$1 = columnHdrs$1;
                                            this.currentLine$1 = currentLine$1;
                                            this.item$1 = item$1;
                                        }
                                    });
                                    Map items = (Map)this.guidMap$2.getOrElse((Object)guid, (Function0)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final HashMap<String, String> apply() {
                                            return (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
                                        }
                                    });
                                    boxedUnit = items.isEmpty() ? this.guidMap$2.put((Object)guid, (Object)item.toMap(Predef$.MODULE$.conforms())) : this.guidMap$2.put((Object)guid, (Object)items.$plus$plus((GenTraversableOnce)item).toMap(Predef$.MODULE$.conforms()));
                                } else {
                                    boxedUnit = BoxedUnit.UNIT;
                                }
                                currentLine.elem = csvReader.readNext();
                                continue;
                            }
                            break;
                        }
                    }
                    catch (Exception exception) {
                        TaxonSpeciesListDAO$.MODULE$.logger().error("failed to get a list $drUid", (Throwable)exception);
                    }
                }
                {
                    this.guidMap$2 = guidMap$2;
                }
            });
            map = guidMap.toMap(Predef$.MODULE$.conforms());
        }
        catch (Exception exception) {
            this.logger().error(new StringBuilder().append((Object)"Problem loading lists to intersect with.").append((Object)exception.getMessage()).toString(), (Throwable)exception);
            map = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
        }
        return map;
    }

    private Seq<String> getListUids() {
        Option option;
        block7: {
            Nil$ nil$;
            block6: {
                block2: {
                    Option option2;
                    block5: {
                        Nil$ nil$2;
                        block4: {
                            block3: {
                                String listsUrl = new StringBuilder().append((Object)Config$.MODULE$.listToolUrl()).append((Object)"/ws/speciesList?isAuthoritative=eq:true&max=1000").toString();
                                String jsonString = Source$.MODULE$.fromURL(listsUrl, "UTF-8").mkString();
                                option = JSON$.MODULE$.parseFull(jsonString);
                                if (!(option instanceof Some)) break block2;
                                Some some = (Some)option;
                                Object json = some.x();
                                scala.collection.immutable.Map map = (scala.collection.immutable.Map)json;
                                option2 = map.get((Object)"lists");
                                if (!(option2 instanceof Some)) break block3;
                                Some some2 = (Some)option2;
                                Object lists = some2.x();
                                nil$2 = ((TraversableOnce)((Seq)lists).map((Function1)new Serializable(){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply(scala.collection.immutable.Map<String, Object> listDetails) {
                                        return listDetails.getOrElse((Object)"dataResourceUid", (Function0)new Serializable(this){
                                            public static final long serialVersionUID = 0L;

                                            public final String apply() {
                                                return "";
                                            }
                                        }).toString();
                                    }
                                }, Seq$.MODULE$.canBuildFrom())).toList();
                                break block4;
                            }
                            None$ none$ = None$.MODULE$;
                            Option option3 = option2;
                            if (none$ != null ? !none$.equals(option3) : option3 != null) break block5;
                            this.logger().warn("Unable to load ids of authoritative lists");
                            nil$2 = Nil$.MODULE$;
                        }
                        nil$ = nil$2;
                        break block6;
                    }
                    throw new MatchError((Object)option2);
                }
                None$ none$ = None$.MODULE$;
                Option option4 = option;
                if (none$ != null ? !none$.equals(option4) : option4 != null) break block7;
                this.logger().warn("Unable to load ids of authoritative lists");
                nil$ = Nil$.MODULE$;
            }
            return nil$;
        }
        throw new MatchError((Object)option);
    }

    private TaxonSpeciesListDAO$() {
        MODULE$ = this;
        this.logger = LoggerFactory.getLogger((String)"TaxonSpeciesListDAO");
        this.lock = new Object();
    }
}

