/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import org.geotools.geometry.jts.Decimator;
import org.geotools.geometry.jts.GeomCollectionIterator;
import org.geotools.geometry.jts.LiteShape2;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.geotools.renderer.lite.DashedShape;
import org.geotools.renderer.lite.LabelCache;
import org.geotools.renderer.style.GraphicStyle2D;
import org.geotools.renderer.style.IconStyle2D;
import org.geotools.renderer.style.LineStyle2D;
import org.geotools.renderer.style.MarkStyle2D;
import org.geotools.renderer.style.PolygonStyle2D;
import org.geotools.renderer.style.Style2D;
import org.geotools.util.logging.Logging;
import org.opengis.filter.expression.Literal;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.style.ExternalGraphic;
import org.opengis.style.GraphicLegend;
import org.opengis.style.GraphicalSymbol;

public final class StyledShapePainter {
    public static final RenderingHints.Key TEXTURE_ANCHOR_HINT_KEY = new TextureAnchorKey();
    private static final AffineTransform IDENTITY_TRANSFORM = new AffineTransform();
    private static final Logger LOGGER = Logging.getLogger((String)StyledShapePainter.class.getName());
    public static boolean ROUND_ICON_COORDS = Boolean.parseBoolean(System.getProperty("org.geotools.renderer.lite.roundIconCoords", "true"));
    LabelCache labelCache;

    public StyledShapePainter() {
    }

    @Deprecated
    public StyledShapePainter(LabelCache cache) {
        this.labelCache = cache;
    }

    public void paint(Graphics2D graphics, LiteShape2 shape, Style2D style, double scale) {
        this.paint(graphics, shape, style, scale, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics2D graphics, LiteShape2 shape, Style2D style, double scale, boolean isLabelObstacle) {
        if (style == null) {
            LOGGER.severe("ShapePainter has been asked to paint a null style!!");
            return;
        }
        if (!style.isScaleInRange(scale)) {
            LOGGER.fine("Out of scale");
            return;
        }
        if (style instanceof IconStyle2D) {
            AffineTransform temp = graphics.getTransform();
            try {
                IconStyle2D icoStyle = (IconStyle2D)style;
                Icon icon = icoStyle.getIcon();
                graphics.setComposite(icoStyle.getComposite());
                float dx = -((float)((double)icon.getIconWidth() / 2.0 + (double)icoStyle.getDisplacementX()));
                float dy = -((float)((double)icon.getIconHeight() / 2.0 + (double)icoStyle.getDisplacementY()));
                float[] coords = new float[2];
                PathIterator citer = this.getPathIterator(shape);
                AffineTransform markAT = new AffineTransform(temp);
                while (!citer.isDone()) {
                    citer.currentSegment(coords);
                    markAT.setTransform(temp);
                    double x = coords[0] + dx;
                    double y = coords[1] + dy;
                    markAT.translate(x, y);
                    markAT.rotate(icoStyle.getRotation());
                    graphics.setTransform(markAT);
                    icon.paintIcon(null, graphics, 0, 0);
                    if (isLabelObstacle) {
                        this.labelCache.put(new Rectangle2D.Double(x, y, icon.getIconWidth(), icon.getIconHeight()));
                    }
                    citer.next();
                }
            }
            finally {
                graphics.setTransform(temp);
            }
        }
        if (style instanceof MarkStyle2D) {
            PathIterator citer = this.getPathIterator(shape);
            float[] coords = new float[2];
            MarkStyle2D ms2d = (MarkStyle2D)style;
            while (!citer.isDone()) {
                citer.currentSegment(coords);
                Shape transformedShape = ms2d.getTransformedShape(coords[0], coords[1]);
                if (transformedShape == null) continue;
                if (ms2d.getFill() != null) {
                    graphics.setPaint(ms2d.getFill());
                    graphics.setComposite(ms2d.getFillComposite());
                    graphics.fill(transformedShape);
                }
                if (ms2d.getContour() != null) {
                    graphics.setPaint(ms2d.getContour());
                    graphics.setStroke(ms2d.getStroke());
                    graphics.setComposite(ms2d.getContourComposite());
                    graphics.draw(transformedShape);
                }
                if (isLabelObstacle) {
                    this.labelCache.put(transformedShape.getBounds2D());
                }
                citer.next();
            }
        } else if (style instanceof GraphicStyle2D) {
            float[] coords = new float[2];
            PathIterator iter = this.getPathIterator(shape);
            iter.currentSegment(coords);
            GraphicStyle2D gs2d = (GraphicStyle2D)style;
            while (!iter.isDone()) {
                iter.currentSegment(coords);
                this.renderImage(graphics, coords[0], coords[1], gs2d.getImage(), gs2d.getRotation(), gs2d.getOpacity(), isLabelObstacle);
                iter.next();
            }
        } else {
            LineStyle2D ls2d;
            BufferedImage image;
            TexturePaint tp;
            Paint paint;
            if (isLabelObstacle) {
                this.labelCache.put(shape.getBounds2D());
            }
            if (style instanceof PolygonStyle2D) {
                PolygonStyle2D ps2d = (PolygonStyle2D)style;
                if (ps2d.getFill() != null) {
                    paint = ps2d.getFill();
                    if (paint instanceof TexturePaint) {
                        tp = (TexturePaint)paint;
                        image = tp.getImage();
                        Rectangle2D cornerRect = tp.getAnchorRect();
                        Point2D anchorPoint = (Point2D)graphics.getRenderingHint(TEXTURE_ANCHOR_HINT_KEY);
                        Rectangle2D.Double alignedRect = null;
                        alignedRect = anchorPoint != null ? new Rectangle2D.Double(Math.round(anchorPoint.getX()), Math.round(anchorPoint.getY()), cornerRect.getWidth(), cornerRect.getHeight()) : new Rectangle2D.Double(0.0, 0.0, cornerRect.getWidth(), cornerRect.getHeight());
                        paint = new TexturePaint(image, alignedRect);
                    }
                    graphics.setPaint(paint);
                    graphics.setComposite(ps2d.getFillComposite());
                    this.fillLiteShape(graphics, shape);
                }
                if (ps2d.getGraphicFill() != null) {
                    Shape oldClip = graphics.getClip();
                    try {
                        this.paintGraphicFill(graphics, (Shape)shape, ps2d.getGraphicFill(), scale);
                    }
                    finally {
                        graphics.setClip(oldClip);
                    }
                }
            }
            if (style instanceof LineStyle2D && (ls2d = (LineStyle2D)style).getStroke() != null) {
                if (ls2d.getGraphicStroke() != null) {
                    this.drawWithGraphicsStroke(graphics, this.dashShape((Shape)shape, ls2d.getStroke()), ls2d.getGraphicStroke(), isLabelObstacle);
                } else {
                    paint = ls2d.getContour();
                    if (paint instanceof TexturePaint) {
                        tp = (TexturePaint)paint;
                        image = tp.getImage();
                        Rectangle2D rect = tp.getAnchorRect();
                        AffineTransform at = graphics.getTransform();
                        double width = rect.getWidth() * at.getScaleX();
                        double height = rect.getHeight() * at.getScaleY();
                        Rectangle2D.Double scaledRect = new Rectangle2D.Double(0.0, 0.0, width, height);
                        paint = new TexturePaint(image, scaledRect);
                    }
                    Stroke stroke = ls2d.getStroke();
                    if (graphics.getRenderingHint(RenderingHints.KEY_ANTIALIASING) == RenderingHints.VALUE_ANTIALIAS_ON && stroke instanceof BasicStroke) {
                        BasicStroke bs = (BasicStroke)stroke;
                        stroke = new BasicStroke(bs.getLineWidth() + 0.5f, bs.getEndCap(), bs.getLineJoin(), bs.getMiterLimit(), bs.getDashArray(), bs.getDashPhase());
                    }
                    graphics.setPaint(paint);
                    graphics.setStroke(stroke);
                    graphics.setComposite(ls2d.getContourComposite());
                    graphics.draw((Shape)shape);
                }
            }
        }
    }

    public void paint(Graphics2D graphics, LiteShape2 shape, GraphicLegend legend, double symbolScale, boolean isLabelObstacle) {
        if (legend == null) {
            throw new NullPointerException("ShapePainter has been asked to paint a null legend!!");
        }
        for (GraphicalSymbol symbol : legend.graphicalSymbols()) {
            if (!(symbol instanceof ExternalGraphic)) continue;
            float[] coords = new float[2];
            PathIterator iter = this.getPathIterator(shape);
            iter.currentSegment(coords);
            double rotation = Math.toRadians((Double)((Literal)legend.getRotation()).evaluate(null, Double.class));
            float opacity = ((Float)((Literal)legend.getOpacity()).evaluate(null, Float.class)).floatValue();
            ExternalGraphic graphic = (ExternalGraphic)symbol;
            while (!iter.isDone()) {
                iter.currentSegment(coords);
                try {
                    BufferedImage image = ImageIO.read(graphic.getOnlineResource().getLinkage().toURL());
                    if (symbolScale != 1.0) {
                        int w = (int)((double)image.getWidth() / symbolScale);
                        int h = (int)((double)image.getHeight() / symbolScale);
                        int imageType = image.getType() == 0 ? 6 : image.getType();
                        BufferedImage rescaled = new BufferedImage(w, h, imageType);
                        Graphics2D g = rescaled.createGraphics();
                        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                        g.drawImage(image, 0, 0, w, h, 0, 0, image.getWidth(), image.getHeight(), null);
                        g.dispose();
                        image = rescaled;
                    }
                    this.renderImage(graphics, coords[0], coords[1], image, rotation, opacity, isLabelObstacle);
                }
                catch (IOException ex) {
                    Logger.getLogger(StyledShapePainter.class.getName()).log(Level.SEVERE, null, ex);
                }
                iter.next();
            }
        }
    }

    Shape dashShape(Shape shape, Stroke stroke) {
        if (!(stroke instanceof BasicStroke)) {
            return shape;
        }
        BasicStroke bs = (BasicStroke)stroke;
        if (bs.getDashArray() == null || bs.getDashArray().length == 0) {
            return shape;
        }
        return new DashedShape(shape, bs.getDashArray(), bs.getDashPhase());
    }

    private PathIterator getPathIterator(LiteShape2 shape) {
        GeometryCollection gc;
        if (shape.getGeometry() instanceof GeometryCollection) {
            gc = (GeometryCollection)shape.getGeometry();
        } else {
            Geometry[] gs = new Geometry[]{shape.getGeometry()};
            gc = shape.getGeometry().getFactory().createGeometryCollection(gs);
        }
        GeomCollectionIterator citer = new GeomCollectionIterator(gc, IDENTITY_TRANSFORM, false, 1.0);
        return citer;
    }

    void debugShape(Shape shape) {
        float[] pt = new float[2];
        PathIterator iter = shape.getPathIterator(null);
        while (!iter.isDone()) {
            int type = iter.currentSegment(pt);
            String event = "unknown";
            if (type == 4) {
                event = "SEG_CLOSE";
            }
            if (type == 3) {
                event = "SEG_CUBIC";
            }
            if (type == 1) {
                event = "SEG_LINETO";
            }
            if (type == 0) {
                event = "SEG_MOVETO";
            }
            if (type == 2) {
                event = "SEG_QUADTO";
            }
            System.out.println(event + " " + pt[0] + "," + pt[1]);
            iter.next();
        }
    }

    private void drawWithGraphicsStroke(Graphics2D graphics, Shape shape, Style2D graphicStroke, boolean isLabelObstacle) {
        double imageSize;
        PathIterator pi = shape.getPathIterator(null);
        double[] coords = new double[4];
        double graphicRotation = 0.0;
        if (graphicStroke instanceof MarkStyle2D) {
            imageSize = ((MarkStyle2D)graphicStroke).getSize();
            graphicRotation = ((MarkStyle2D)graphicStroke).getRotation();
        } else if (graphicStroke instanceof IconStyle2D) {
            imageSize = ((IconStyle2D)graphicStroke).getIcon().getIconWidth();
            graphicRotation = ((IconStyle2D)graphicStroke).getRotation();
        } else {
            GraphicStyle2D gs = (GraphicStyle2D)graphicStroke;
            imageSize = gs.getImage().getWidth() - gs.getBorder();
            graphicRotation = ((GraphicStyle2D)graphicStroke).getRotation();
        }
        double[] first = new double[2];
        double[] previous = new double[2];
        int type = pi.currentSegment(coords);
        first[0] = coords[0];
        first[1] = coords[1];
        previous[0] = coords[0];
        previous[1] = coords[1];
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("starting at " + first[0] + "," + first[1]);
        }
        pi.next();
        double remainder = imageSize / 2.0;
        while (!pi.isDone()) {
            type = pi.currentSegment(coords);
            switch (type) {
                case 0: {
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.finest("moving to " + coords[0] + "," + coords[1]);
                    }
                    first[0] = coords[0];
                    first[1] = coords[1];
                    remainder = imageSize / 2.0;
                    break;
                }
                case 4: {
                    coords[0] = first[0];
                    coords[1] = first[1];
                    remainder = imageSize / 2.0;
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.finest("closing from " + previous[0] + "," + previous[1] + " to " + coords[0] + "," + coords[1]);
                    }
                }
                case 1: {
                    double dy;
                    double dx;
                    double len;
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.finest("drawing from " + previous[0] + "," + previous[1] + " to " + coords[0] + "," + coords[1]);
                    }
                    if ((len = Math.sqrt((dx = coords[0] - previous[0]) * dx + (dy = coords[1] - previous[1]) * dy)) < remainder) {
                        remainder -= len;
                        break;
                    }
                    double theta = Math.atan2(dx, dy);
                    dx = Math.sin(theta) * imageSize;
                    dy = Math.cos(theta) * imageSize;
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.finest("dx = " + dx + " dy " + dy + " step = " + Math.sqrt(dx * dx + dy * dy));
                    }
                    double rotation = -(theta - 1.5707963267948966) + graphicRotation;
                    double x = previous[0] + Math.sin(theta) * remainder;
                    double y = previous[1] + Math.cos(theta) * remainder;
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.finest("len =" + len + " imageSize " + imageSize);
                    }
                    double dist = 0.0;
                    for (dist = remainder; dist < len; dist += imageSize) {
                        this.renderGraphicsStroke(graphics, x, y, graphicStroke, rotation, 1.0f, isLabelObstacle);
                        x += dx;
                        y += dy;
                    }
                    remainder = dist - len;
                    if (!LOGGER.isLoggable(Level.FINEST)) break;
                    LOGGER.finest("loop end dist " + dist + " len " + len + " " + (len - dist));
                    break;
                }
                default: {
                    LOGGER.warning("default branch reached in drawWithGraphicStroke");
                }
            }
            previous[0] = coords[0];
            previous[1] = coords[1];
            pi.next();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderImage(Graphics2D graphics, double x, double y, BufferedImage image, double rotation, float opacity, boolean isLabelObstacle) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("drawing Image @" + x + "," + y);
        }
        AffineTransform markAT = new AffineTransform();
        if (ROUND_ICON_COORDS && rotation == 0.0) {
            markAT.translate(Math.round(x - (double)(image.getWidth() / 2)), Math.round(y - (double)(image.getHeight() / 2)));
        } else {
            markAT.translate(x, y);
            markAT.rotate(rotation);
            markAT.translate((double)(-image.getWidth()) / 2.0, (double)(-image.getHeight()) / 2.0);
        }
        if (isLabelObstacle) {
            int w = Math.max(image.getWidth() * 1, 1);
            int h = Math.max(image.getHeight() * 1, 1);
            this.labelCache.put(new Rectangle2D.Double(x - (double)w / 2.0, y - (double)h / 2.0, w, h));
        }
        graphics.setComposite(AlphaComposite.getInstance(3, opacity));
        Object interpolation = graphics.getRenderingHint(RenderingHints.KEY_INTERPOLATION);
        if (interpolation == null) {
            interpolation = RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR;
        }
        try {
            graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            graphics.drawRenderedImage(image, markAT);
        }
        finally {
            graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, interpolation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderGraphicsStroke(Graphics2D graphics, double x, double y, Style2D style, double rotation, float opacity, boolean isLabelObstacle) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("drawing GraphicsStroke@" + x + "," + y);
        }
        graphics.setComposite(AlphaComposite.getInstance(3, opacity));
        if (style instanceof GraphicStyle2D) {
            BufferedImage image = ((GraphicStyle2D)style).getImage();
            this.renderImage(graphics, x, y, image, rotation, opacity, isLabelObstacle);
        } else if (style instanceof MarkStyle2D) {
            MarkStyle2D ms2d = (MarkStyle2D)style;
            Shape transformedShape = ms2d.getTransformedShape((float)x, (float)y, (float)rotation);
            if (transformedShape != null) {
                if (ms2d.getFill() != null) {
                    graphics.setPaint(ms2d.getFill());
                    graphics.fill(transformedShape);
                }
                if (ms2d.getContour() != null) {
                    graphics.setPaint(ms2d.getContour());
                    graphics.setStroke(ms2d.getStroke());
                    graphics.draw(transformedShape);
                }
                if (isLabelObstacle) {
                    this.labelCache.put(transformedShape.getBounds2D());
                }
            }
        } else if (style instanceof IconStyle2D) {
            IconStyle2D icons = (IconStyle2D)style;
            Icon icon = icons.getIcon();
            AffineTransform markAT = new AffineTransform(graphics.getTransform());
            markAT.translate(x, y);
            markAT.rotate(rotation);
            double dx = (double)(-icon.getIconWidth()) / 2.0;
            double dy = (double)(-icon.getIconHeight()) / 2.0;
            markAT.translate(dx, dy);
            AffineTransform temp = graphics.getTransform();
            try {
                graphics.setTransform(markAT);
                icon.paintIcon(null, graphics, 0, 0);
            }
            finally {
                graphics.setTransform(temp);
            }
            if (isLabelObstacle) {
                this.labelCache.put(new Rectangle2D.Double(x + dx, y + dy, icon.getIconWidth(), icon.getIconHeight()));
            }
        }
    }

    void fillLiteShape(Graphics2D g, LiteShape2 shape) {
        if (shape.getGeometry() instanceof MultiPolygon && shape.getGeometry().getNumGeometries() > 1) {
            MultiPolygon mp = (MultiPolygon)shape.getGeometry();
            for (int i = 0; i < mp.getNumGeometries(); ++i) {
                Polygon p = (Polygon)mp.getGeometryN(i);
                try {
                    g.fill((Shape)new LiteShape2((Geometry)p, null, null, false, false));
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException("Unexpected error occurred while rendering a multipolygon", e);
                }
            }
        } else {
            g.fill((Shape)shape);
        }
    }

    private void paintGraphicFill(Graphics2D graphics, Shape shape, Style2D graphicFill, double scale) {
        Rectangle2D boundsShape = shape.getBounds2D();
        Rectangle2D.Double stippleSize = null;
        if (graphicFill instanceof MarkStyle2D) {
            Rectangle2D boundsFill = ((MarkStyle2D)graphicFill).getShape().getBounds2D();
            double size = ((MarkStyle2D)graphicFill).getSize();
            double aspect = boundsFill.getHeight() > 0.0 && boundsFill.getWidth() > 0.0 ? boundsFill.getWidth() / boundsFill.getHeight() : 1.0;
            stippleSize = new Rectangle2D.Double(0.0, 0.0, size * aspect, size);
        } else if (graphicFill instanceof IconStyle2D) {
            Icon icon = ((IconStyle2D)graphicFill).getIcon();
            stippleSize = new Rectangle2D.Double(0.0, 0.0, icon.getIconWidth(), icon.getIconHeight());
        } else {
            return;
        }
        int toX = (int)Math.ceil(boundsShape.getWidth() / ((RectangularShape)stippleSize).getWidth());
        int toY = (int)Math.ceil(boundsShape.getHeight() / ((RectangularShape)stippleSize).getHeight());
        Graphics2D g = (Graphics2D)graphics.create();
        g.clip(shape);
        Shape clipShape = g.getClip();
        Rectangle2D boundsClip = clipShape.getBounds2D();
        int fromX = 0;
        if (boundsClip.getMinX() > boundsShape.getMinX()) {
            fromX = (int)Math.floor((boundsClip.getMinX() - boundsShape.getMinX()) / ((RectangularShape)stippleSize).getWidth());
        }
        if (boundsClip.getMaxX() < boundsShape.getMaxX()) {
            toX -= (int)Math.floor((boundsShape.getMaxX() - boundsClip.getMaxX()) / ((RectangularShape)stippleSize).getWidth());
        }
        int fromY = 0;
        if (boundsClip.getMinY() > boundsShape.getMinY()) {
            fromY = (int)Math.floor((boundsClip.getMinY() - boundsShape.getMinY()) / ((RectangularShape)stippleSize).getHeight());
        }
        if (boundsClip.getMaxY() < boundsShape.getMaxY()) {
            toY -= (int)Math.floor((boundsShape.getMaxY() - boundsClip.getMaxY()) / ((RectangularShape)stippleSize).getHeight());
        }
        for (int i = fromX; i < toX; ++i) {
            for (int j = fromY; j < toY; ++j) {
                double translateY;
                double translateX = boundsShape.getMinX() + (double)i * ((RectangularShape)stippleSize).getWidth();
                if (!clipShape.intersects(translateX, translateY = boundsShape.getMinY() + (double)j * ((RectangularShape)stippleSize).getHeight(), ((RectangularShape)stippleSize).getWidth(), ((RectangularShape)stippleSize).getHeight())) continue;
                LiteShape2 stippleShape = this.createStippleShape(stippleSize, translateX, translateY);
                this.paint(g, stippleShape, graphicFill, scale);
            }
        }
    }

    private LiteShape2 createStippleShape(Rectangle2D stippleSize, double translateX, double translateY) {
        LiteShape2 stippleShape;
        GeometryFactory geomFactory = new GeometryFactory();
        Coordinate coord = new Coordinate(stippleSize.getCenterX() + translateX, stippleSize.getCenterY() + translateY);
        Point geom = geomFactory.createPoint(coord);
        AffineTransform2D identityTransf = new AffineTransform2D(new AffineTransform());
        Decimator nullDecimator = new Decimator(-1.0, -1.0);
        try {
            stippleShape = new LiteShape2((Geometry)geom, (MathTransform)identityTransf, nullDecimator, false);
        }
        catch (Exception e) {
            throw new RuntimeException("Unxpected exception building lite shape", e);
        }
        return stippleShape;
    }

    public static class TextureAnchorKey
    extends RenderingHints.Key {
        protected TextureAnchorKey() {
            super(0);
        }

        @Override
        public boolean isCompatibleValue(Object val) {
            return val instanceof Point2D;
        }
    }
}

