/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.TopologyException;
import org.geotools.filter.FilterVisitor;
import org.geotools.filter.FilterVisitorFilterWrapper;
import org.geotools.filter.GeometryFilter;
import org.geotools.filter.IllegalFilterException;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.BinaryComparisonOperator;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.MultiValuedFilter;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.BinarySpatialOperator;
import org.opengis.geometry.BoundingBox;

class FastBBOX
implements BBOX,
BinarySpatialOperator,
BinaryComparisonOperator,
GeometryFilter {
    PropertyName property;
    Envelope envelope;
    FilterFactory factory;

    public FastBBOX(PropertyName propertyName, Envelope env, FilterFactory factory) {
        this.property = propertyName;
        this.envelope = env;
        this.factory = factory;
    }

    public double getMaxX() {
        return this.envelope.getMaxX();
    }

    public double getMaxY() {
        return this.envelope.getMaxY();
    }

    public double getMinX() {
        return this.envelope.getMinX();
    }

    public double getMinY() {
        return this.envelope.getMinY();
    }

    public PropertyName getProperty() {
        return this.property;
    }

    public String getPropertyName() {
        return this.property.getPropertyName();
    }

    public String getSRS() {
        return null;
    }

    public Envelope getEnvelope() {
        return this.envelope;
    }

    public BoundingBox getBounds() {
        return ReferencedEnvelope.reference((Envelope)this.envelope);
    }

    public Expression getExpression1() {
        return this.property;
    }

    public Expression getExpression2() {
        Coordinate[] coords = new Coordinate[]{new Coordinate(this.envelope.getMinX(), this.envelope.getMinY()), new Coordinate(this.envelope.getMinX(), this.envelope.getMaxY()), new Coordinate(this.envelope.getMaxX(), this.envelope.getMaxY()), new Coordinate(this.envelope.getMaxX(), this.envelope.getMinY()), new Coordinate(this.envelope.getMinX(), this.envelope.getMinY())};
        LinearRing ring = null;
        GeometryFactory gfac = new GeometryFactory();
        try {
            ring = gfac.createLinearRing(coords);
        }
        catch (TopologyException tex) {
            throw new IllegalFilterException(tex.toString());
        }
        Polygon polygon = gfac.createPolygon(ring, null);
        if (this.envelope instanceof ReferencedEnvelope) {
            ReferencedEnvelope refEnv = (ReferencedEnvelope)this.envelope;
            polygon.setUserData(refEnv.getCoordinateReferenceSystem());
        }
        return this.factory.literal((Object)polygon);
    }

    public Object accept(org.opengis.filter.FilterVisitor visitor, Object context) {
        Object result = visitor.visit((BBOX)this, context);
        if (!(result instanceof BBOX)) {
            return result;
        }
        BBOX clone = (BBOX)result;
        if (clone.getExpression1().equals(this.getExpression1()) && clone.getExpression2().equals(this.getExpression2())) {
            return new FastBBOX(this.property, this.envelope, this.factory);
        }
        return result;
    }

    public boolean evaluate(Object feature) {
        SimpleFeature sf = (SimpleFeature)feature;
        if (feature == null) {
            return false;
        }
        Geometry other = (Geometry)this.property.evaluate((Object)sf);
        if (other == null) {
            return false;
        }
        return other.getEnvelopeInternal().intersects(this.envelope);
    }

    public boolean isMatchingCase() {
        return false;
    }

    public void addLeftGeometry(org.geotools.filter.Expression leftGeometry) throws IllegalFilterException {
        throw new UnsupportedOperationException("This filter cannot be modified");
    }

    public void addRightGeometry(org.geotools.filter.Expression rightGeometry) throws IllegalFilterException {
        throw new UnsupportedOperationException("This filter cannot be modified");
    }

    public boolean contains(SimpleFeature feature) {
        return this.evaluate((Object)feature);
    }

    public org.geotools.filter.Expression getLeftGeometry() {
        return (org.geotools.filter.Expression)this.getExpression1();
    }

    public org.geotools.filter.Expression getRightGeometry() {
        return (org.geotools.filter.Expression)this.getExpression2();
    }

    public void accept(FilterVisitor visitor) {
        this.accept((org.opengis.filter.FilterVisitor)new FilterVisitorFilterWrapper(visitor), null);
    }

    public org.geotools.filter.Filter and(Filter filter) {
        return (org.geotools.filter.Filter)this.factory.and((Filter)this, filter);
    }

    public org.geotools.filter.Filter or(Filter filter) {
        return (org.geotools.filter.Filter)this.factory.or((Filter)this, filter);
    }

    public org.geotools.filter.Filter not() {
        return (org.geotools.filter.Filter)this.factory.not((Filter)this);
    }

    public boolean evaluate(SimpleFeature feature) {
        return this.evaluate((Object)feature);
    }

    public short getFilterType() {
        return 4;
    }

    public MultiValuedFilter.MatchAction getMatchAction() {
        return MultiValuedFilter.MatchAction.ANY;
    }

    public String toString() {
        return "FastBBOX [property=" + this.property + ", envelope=" + this.envelope + "]";
    }
}

