/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.crs;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.util.ArrayList;
import java.util.List;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.renderer.crs.OffsetOrdinateFilter;
import org.geotools.renderer.crs.ProjectionHandler;
import org.geotools.renderer.crs.WrappingCoordinateFilter;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;

public class WrappingProjectionHandler
extends ProjectionHandler {
    protected double radius;
    private int maxWraps;

    public WrappingProjectionHandler(ReferencedEnvelope renderingEnvelope, ReferencedEnvelope validArea, CoordinateReferenceSystem sourceCrs, double centralMeridian, int maxWraps) throws FactoryException {
        super(sourceCrs, (Envelope)validArea, renderingEnvelope);
        this.maxWraps = maxWraps;
        try {
            CoordinateReferenceSystem targetCRS = renderingEnvelope.getCoordinateReferenceSystem();
            MathTransform mt = CRS.findMathTransform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, (CoordinateReferenceSystem)targetCRS, (boolean)true);
            double[] src = new double[]{centralMeridian, 0.0, 180.0 + centralMeridian, 0.0};
            double[] dst = new double[4];
            mt.transform(src, 0, dst, 0, 2);
            this.radius = CRS.getAxisOrder((CoordinateReferenceSystem)targetCRS) == CRS.AxisOrder.NORTH_EAST ? Math.abs(dst[3] - dst[1]) : Math.abs(dst[2] - dst[0]);
            if (this.radius <= 0.0) {
                throw new RuntimeException("Computed Earth radius is 0, what is going on?");
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected error computing the Earth radius in the current projection", e);
        }
    }

    @Override
    public Geometry postProcess(MathTransform mt, Geometry geometry) {
        double highLimit;
        double lowLimit;
        double curr;
        double base;
        double reWidth;
        double width;
        boolean northEast;
        Envelope env = geometry.getEnvelopeInternal();
        boolean bl = northEast = CRS.getAxisOrder((CoordinateReferenceSystem)this.targetCRS) == CRS.AxisOrder.NORTH_EAST;
        if (northEast) {
            width = env.getHeight();
            reWidth = this.renderingEnvelope.getHeight();
        } else {
            width = env.getWidth();
            reWidth = this.renderingEnvelope.getWidth();
        }
        if (width < this.radius && this.renderingEnvelope.contains(env) && reWidth <= this.radius * 2.0) {
            return geometry;
        }
        if (width > this.radius && width < this.radius * 2.0) {
            geometry.apply(new WrappingCoordinateFilter(this.radius, this.radius * 2.0, mt, northEast));
            geometry.geometryChanged();
            env = geometry.getEnvelopeInternal();
        }
        ArrayList<Geometry> geoms = new ArrayList<Geometry>();
        Class geomType = null;
        if (northEast) {
            base = env.getMinY();
            curr = env.getMinY();
            lowLimit = Math.max(this.renderingEnvelope.getMinY(), this.renderingEnvelope.getMedian(1) - (double)this.maxWraps * this.radius * 2.0);
            highLimit = Math.min(this.renderingEnvelope.getMaxY(), this.renderingEnvelope.getMedian(1) + (double)this.maxWraps * this.radius * 2.0);
        } else {
            base = env.getMinX();
            curr = env.getMinX();
            lowLimit = Math.max(this.renderingEnvelope.getMinX(), this.renderingEnvelope.getMedian(0) - (double)this.maxWraps * this.radius * 2.0);
            highLimit = Math.min(this.renderingEnvelope.getMaxX(), this.renderingEnvelope.getMedian(0) + (double)this.maxWraps * this.radius * 2.0);
        }
        while (curr > lowLimit) {
            curr -= this.radius * 2.0;
        }
        geomType = this.accumulate(geoms, geometry, geomType);
        while (curr <= highLimit) {
            double offset = curr - base;
            if (!(Math.abs(offset) < this.radius)) {
                Geometry offseted = (Geometry)geometry.clone();
                offseted.apply(new OffsetOrdinateFilter(northEast ? 1 : 0, offset));
                offseted.geometryChanged();
                geomType = this.accumulate(geoms, offseted, geomType);
            }
            curr += this.radius * 2.0;
        }
        if (geomType == null) {
            return null;
        }
        if (geoms.size() == 1) {
            return (Geometry)geoms.get(0);
        }
        if (Point.class.equals((Object)geomType)) {
            Point[] points = geoms.toArray(new Point[geoms.size()]);
            return geometry.getFactory().createMultiPoint(points);
        }
        if (LineString.class.isAssignableFrom(geomType)) {
            LineString[] lines = geoms.toArray(new LineString[geoms.size()]);
            return geometry.getFactory().createMultiLineString(lines);
        }
        if (Polygon.class.equals((Object)geomType)) {
            Polygon[] polys = geoms.toArray(new Polygon[geoms.size()]);
            return geometry.getFactory().createMultiPolygon(polys);
        }
        return geometry.getFactory().createGeometryCollection(geoms.toArray(new Geometry[geoms.size()]));
    }

    private Class accumulate(List<Geometry> geoms, Geometry geometry, Class geomType) {
        for (int i = 0; i < geometry.getNumGeometries(); ++i) {
            Geometry g = geometry.getGeometryN(i);
            Class<?> gtype = null;
            if (g instanceof GeometryCollection) {
                gtype = this.accumulate(geoms, g, geomType);
            } else if (this.renderingEnvelope.intersects(g.getEnvelopeInternal())) {
                geoms.add(g);
                gtype = g.getClass();
            }
            if (geomType == null) {
                geomType = g.getClass();
                continue;
            }
            if (g.getClass().equals(geomType)) continue;
            geomType = Geometry.class;
        }
        return geomType;
    }

    @Override
    public boolean requiresProcessing(Geometry geometry) {
        return true;
    }
}

