/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.crs;

import com.vividsolutions.jts.geom.Envelope;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.operation.projection.MapProjection;
import org.geotools.referencing.operation.projection.PolarStereographic;
import org.geotools.renderer.crs.ProjectionHandler;
import org.geotools.renderer.crs.ProjectionHandlerFactory;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValue;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class PolarStereographicHandlerFactory
implements ProjectionHandlerFactory {
    @Override
    public ProjectionHandler getHandler(ReferencedEnvelope renderingEnvelope, CoordinateReferenceSystem sourceCrs, boolean wrap, int maxWraps) throws FactoryException {
        MapProjection mapProjection = CRS.getMapProjection((CoordinateReferenceSystem)renderingEnvelope.getCoordinateReferenceSystem());
        if (renderingEnvelope != null && mapProjection instanceof PolarStereographic) {
            boolean north;
            ParameterValue stdParallel = null;
            try {
                stdParallel = mapProjection.getParameterValues().parameter(MapProjection.AbstractProvider.STANDARD_PARALLEL_1.getName().getCode());
            }
            catch (ParameterNotFoundException e) {
                // empty catch block
            }
            if (stdParallel != null) {
                north = stdParallel.doubleValue() > 0.0;
            } else {
                ParameterValue latOrigin = null;
                try {
                    latOrigin = mapProjection.getParameterValues().parameter(MapProjection.AbstractProvider.LATITUDE_OF_ORIGIN.getName().getCode());
                }
                catch (ParameterNotFoundException e) {
                    // empty catch block
                }
                if (latOrigin != null) {
                    north = latOrigin.doubleValue() > 0.0;
                } else {
                    return null;
                }
            }
            ReferencedEnvelope validArea = north ? new ReferencedEnvelope(-1.7976931348623157E308, Double.MAX_VALUE, 0.0, 90.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84) : new ReferencedEnvelope(-1.7976931348623157E308, Double.MAX_VALUE, -90.0, 0.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            return new ProjectionHandler(sourceCrs, (Envelope)validArea, renderingEnvelope);
        }
        return null;
    }
}

