/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.sds.util;

import au.org.ala.sds.validation.FactCollection;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;

public class DateHelper {
    public static Date parseDate(String date) {
        Date parsedDate = null;
        try {
            parsedDate = DateUtils.parseDateStrictly((String)date, (String[])new String[]{"yyyy-MM-dd", "yyyy", "yyyy-MM", "dd/mm/yy", "yyyy-MM-dd'T'HH:mm:ss'Z'"});
        }
        catch (ParseException pe) {
            throw new IllegalArgumentException("Date " + date + " cannot be parsed", pe);
        }
        return parsedDate;
    }

    public static Date validateDate(FactCollection facts) {
        String year = facts.get("year");
        String month = facts.get("month");
        String day = facts.get("day");
        String eventDate = facts.get("eventDate");
        if (StringUtils.isNotBlank((String)year)) {
            String date = year;
            if (StringUtils.isNotBlank((String)month)) {
                date = date + "-" + month;
                if (StringUtils.isNotBlank((String)day)) {
                    date = date + "-" + day;
                }
            }
            return DateHelper.parseDate(date);
        }
        if (StringUtils.isNotBlank((String)eventDate)) {
            return DateHelper.parseDate(eventDate);
        }
        return null;
    }

    public static String formattedIso8601Date(Date date) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        return df.format(date);
    }

    public static String formattedNiceDate(Date date) {
        SimpleDateFormat df = new SimpleDateFormat("dd MMM yyyy");
        return df.format(date);
    }

    public static String getYear(Date date) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy");
        return df.format(date);
    }

    public static boolean dateBefore(Date date, String dateStr) {
        return date.before(DateHelper.parseDate(dateStr));
    }

    public static boolean dateOnOrAfter(Date date, String dateStr) {
        Date refDate = DateHelper.parseDate(dateStr);
        return date.equals(refDate) || date.after(refDate);
    }
}

