/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.sds.model;

import java.io.Serializable;
import org.apache.commons.lang.builder.ToStringBuilder;

public class SensitivityCategory
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String NOT_EVALUATED = "NE";
    public static final String DATA_DEFICIENT = "DD";
    public static final String LEAST_CONCERN = "LC";
    public static final String NEAR_THREATENED = "NT";
    public static final String CONSERVATION_DEPENDENT = "CD";
    public static final String VULNERABLE = "VU";
    public static final String ENDANGERED = "EN";
    public static final String CRITICALLY_ENDANGERED = "CR";
    public static final String EXTINCT_IN_THE_WILD = "EW";
    public static final String EXTINCT = "EX";
    public static final String RARE = "R";
    public static final String WA_PRIORITY_1 = "P1";
    public static final String WA_PRIORITY_2 = "P2";
    public static final String WA_PRIORITY_3 = "P3";
    public static final String WA_PRIORITY_4 = "P4";
    public static final String WA_PRIORITY_5 = "P5";
    public static final String WA_SPECIALLY_PROTECTED = "SP";
    public static final String PLANT_PEST_NOT_KNOWN_IN_AUSTRALIA = "PBC1";
    public static final String PLANT_PEST_ERADICATED = "PBC2";
    public static final String PLANT_PEST_UNDER_ERADICATION = "PBC3";
    public static final String PLANT_PEST_SUBJECT_TO_OFFICIAL_CONTROL = "PBC4";
    public static final String PLANT_PEST_IN_TORRES_STRAIT_ZONE = "PBC5a";
    public static final String PLANT_PEST_IS_QUEENSLAND_FRUIT_FLY = "PBC5b";
    public static final String PLANT_PEST_NOTIFIABLE_UNDER_STATE_LEGISLATION = "PBC6";
    public static final String PLANT_PEST_NON_TRANSIENT = "PBC8";
    public static final String PLANT_PEST_EXOTIC_BIOLOGICAL_CONTROL_AGENT = "PBC9";
    public static final String PLANT_PEST_HIGHER_TAXON_ID = "PBC10";
    private final String id;
    private final String value;
    private final CategoryType type;
    public static final SensitivityCategory DEFAULT_CATEGORY = new SensitivityCategory("Sensitive", "Sensitive", CategoryType.CONSERVATION);

    public SensitivityCategory(String id, String value, CategoryType type) {
        this.id = id;
        this.value = value;
        this.type = type;
    }

    public String getId() {
        return this.id;
    }

    public String getValue() {
        return this.value;
    }

    public CategoryType getType() {
        return this.type;
    }

    public boolean isConservationSensitive() {
        return this.type.equals((Object)CategoryType.CONSERVATION);
    }

    public boolean isPlantPest() {
        return this.type.equals((Object)CategoryType.PLANT_PEST);
    }

    public String toString() {
        return new ToStringBuilder((Object)this.getClass().getName()).append("id", (Object)this.id).append("value", (Object)this.value).append("type", (Object)this.type.toString()).toString();
    }

    public String toJson() {
        return "{\"value\":\"" + this.value + "\",\"type\":\"" + this.type.toString() + "\"}";
    }

    public static enum CategoryType {
        CONSERVATION,
        PLANT_PEST;

    }
}

