/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.sds.dao;

import au.org.ala.sds.model.SensitivityZone;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public class SensitivityZonesXmlDao {
    protected static final Logger logger = Logger.getLogger(SensitivityZonesXmlDao.class);

    public Map<String, SensitivityZone> getMap(InputStream stream) throws Exception {
        HashMap<String, SensitivityZone> zones = new HashMap<String, SensitivityZone>();
        SAXBuilder builder = new SAXBuilder();
        Document doc = builder.build(stream);
        Element root = doc.getRootElement();
        List zonesList = root.getChildren();
        for (Element sze : zonesList) {
            SensitivityZone sz = SensitivityZonesXmlDao.createSensitiveZone(sze);
            zones.put(sz.getId(), sz);
        }
        return zones;
    }

    private static SensitivityZone createSensitiveZone(Element sze) {
        String id = sze.getAttributeValue("id");
        String name = sze.getAttributeValue("name");
        String layerId = sze.getAttributeValue("name");
        String pidsAsString = sze.getAttributeValue("pids", "");
        String[] pids = new String[]{};
        if (StringUtils.isNotBlank((String)pidsAsString)) {
            pids = pidsAsString.split(",");
            for (int i = 0; i < pids.length; ++i) {
                pids[i] = pids[i].trim();
            }
        }
        SensitivityZone.ZoneType type = SensitivityZone.ZoneType.valueOf(sze.getAttributeValue("type").toUpperCase());
        return new SensitivityZone(id, name, layerId, type);
    }
}

