/*
 * Decompiled with CFR 0.152.
 */
package org.scale7.cassandra.pelops;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.thrift.Column;
import org.apache.cassandra.thrift.ColumnOrSuperColumn;
import org.apache.cassandra.thrift.ColumnParent;
import org.apache.cassandra.thrift.ColumnPath;
import org.apache.cassandra.thrift.ConsistencyLevel;
import org.apache.cassandra.thrift.CounterColumn;
import org.apache.cassandra.thrift.IndexClause;
import org.apache.cassandra.thrift.IndexExpression;
import org.apache.cassandra.thrift.IndexOperator;
import org.apache.cassandra.thrift.KeyRange;
import org.apache.cassandra.thrift.KeySlice;
import org.apache.cassandra.thrift.SlicePredicate;
import org.apache.cassandra.thrift.SliceRange;
import org.apache.cassandra.thrift.SuperColumn;
import org.scale7.cassandra.pelops.Bytes;
import org.scale7.cassandra.pelops.ColumnIterator;
import org.scale7.cassandra.pelops.ColumnOrSuperColumnHelper;
import org.scale7.cassandra.pelops.ColumnRowIterator;
import org.scale7.cassandra.pelops.Operand;
import org.scale7.cassandra.pelops.SuperColumnIterator;
import org.scale7.cassandra.pelops.Validation;
import org.scale7.cassandra.pelops.exceptions.NotFoundException;
import org.scale7.cassandra.pelops.exceptions.PelopsException;
import org.scale7.cassandra.pelops.pool.IThriftPool;

public class Selector
extends Operand {
    private static final SlicePredicate COLUMNS_PREDICATE_ALL = Selector.newColumnsPredicateAll(false);
    private static final SlicePredicate COLUMNS_PREDICATE_ALL_REVERSED = Selector.newColumnsPredicateAll(true);

    public int getColumnCount(String columnFamily, Bytes rowKey, ConsistencyLevel cLevel) throws PelopsException {
        return this.getColumnCount(Selector.newColumnParent(columnFamily), rowKey, COLUMNS_PREDICATE_ALL, cLevel);
    }

    public int getColumnCount(String columnFamily, Bytes rowKey, SlicePredicate predicate, ConsistencyLevel cLevel) throws PelopsException {
        return this.getColumnCount(Selector.newColumnParent(columnFamily), rowKey, predicate, cLevel);
    }

    public int getColumnCount(String columnFamily, String rowKey, ConsistencyLevel cLevel) throws PelopsException {
        return this.getColumnCount(Selector.newColumnParent(columnFamily), Bytes.fromUTF8(rowKey), COLUMNS_PREDICATE_ALL, cLevel);
    }

    public int getColumnCount(String columnFamily, String rowKey, SlicePredicate predicate, ConsistencyLevel cLevel) throws PelopsException {
        return this.getColumnCount(Selector.newColumnParent(columnFamily), Bytes.fromUTF8(rowKey), predicate, cLevel);
    }

    public int getSubColumnCount(String columnFamily, String rowKey, Bytes superColName, ConsistencyLevel cLevel) throws PelopsException {
        return this.getColumnCount(Selector.newColumnParent(columnFamily, superColName), Bytes.fromUTF8(rowKey), COLUMNS_PREDICATE_ALL, cLevel);
    }

    public int getSubColumnCount(String columnFamily, String rowKey, Bytes superColName, SlicePredicate predicate, ConsistencyLevel cLevel) throws PelopsException {
        return this.getColumnCount(Selector.newColumnParent(columnFamily, superColName), Bytes.fromUTF8(rowKey), predicate, cLevel);
    }

    public int getSubColumnCount(String columnFamily, Bytes rowKey, Bytes superColName, ConsistencyLevel cLevel) throws PelopsException {
        return this.getColumnCount(Selector.newColumnParent(columnFamily, superColName), rowKey, COLUMNS_PREDICATE_ALL, cLevel);
    }

    public int getSubColumnCount(String columnFamily, Bytes rowKey, Bytes superColName, SlicePredicate predicate, ConsistencyLevel cLevel) throws PelopsException {
        return this.getColumnCount(Selector.newColumnParent(columnFamily, superColName), rowKey, predicate, cLevel);
    }

    public int getSubColumnCount(String columnFamily, String rowKey, String superColName, ConsistencyLevel cLevel) throws PelopsException {
        return this.getColumnCount(Selector.newColumnParent(columnFamily, superColName), Bytes.fromUTF8(rowKey), COLUMNS_PREDICATE_ALL, cLevel);
    }

    public int getSubColumnCount(String columnFamily, String rowKey, String superColName, SlicePredicate predicate, ConsistencyLevel cLevel) throws PelopsException {
        return this.getColumnCount(Selector.newColumnParent(columnFamily, superColName), Bytes.fromUTF8(rowKey), predicate, cLevel);
    }

    public int getSubColumnCount(String columnFamily, Bytes rowKey, String superColName, ConsistencyLevel cLevel) throws PelopsException {
        return this.getColumnCount(Selector.newColumnParent(columnFamily, superColName), rowKey, COLUMNS_PREDICATE_ALL, cLevel);
    }

    public int getSubColumnCount(String columnFamily, Bytes rowKey, String superColName, SlicePredicate predicate, ConsistencyLevel cLevel) throws PelopsException {
        return this.getColumnCount(Selector.newColumnParent(columnFamily, superColName), rowKey, predicate, cLevel);
    }

    public int getSuperColumnCount(String columnFamily, Bytes rowKey, ConsistencyLevel cLevel) throws PelopsException {
        return this.getColumnCount(Selector.newColumnParent(columnFamily), rowKey, COLUMNS_PREDICATE_ALL, cLevel);
    }

    public int getSuperColumnCount(String columnFamily, Bytes rowKey, SlicePredicate predicate, ConsistencyLevel cLevel) throws PelopsException {
        return this.getColumnCount(Selector.newColumnParent(columnFamily), rowKey, predicate, cLevel);
    }

    public int getSuperColumnCount(String columnFamily, String rowKey, ConsistencyLevel cLevel) throws PelopsException {
        return this.getColumnCount(Selector.newColumnParent(columnFamily), Bytes.fromUTF8(rowKey), COLUMNS_PREDICATE_ALL, cLevel);
    }

    public int getSuperColumnCount(String columnFamily, String rowKey, SlicePredicate predicate, ConsistencyLevel cLevel) throws PelopsException {
        return this.getColumnCount(Selector.newColumnParent(columnFamily), Bytes.fromUTF8(rowKey), predicate, cLevel);
    }

    private int getColumnCount(final ColumnParent colParent, final Bytes rowKey, final SlicePredicate predicate, final ConsistencyLevel cLevel) throws PelopsException {
        return this.tryOperation(new Operand.IOperation<Integer>(){

            @Override
            public Integer execute(IThriftPool.IPooledConnection conn) throws Exception {
                return conn.getAPI().get_count(Validation.safeGetRowKey(rowKey), colParent, predicate, cLevel);
            }
        });
    }

    public Column getColumnFromRow(String columnFamily, String rowKey, String colName, ConsistencyLevel cLevel) throws NotFoundException, PelopsException {
        return this.getColumnFromRow(columnFamily, rowKey, Bytes.fromUTF8(colName), cLevel);
    }

    public Column getColumnFromRow(String columnFamily, String rowKey, Bytes colName, ConsistencyLevel cLevel) throws NotFoundException, PelopsException {
        return this.getColumnFromRow(columnFamily, Bytes.fromUTF8(rowKey), colName, cLevel);
    }

    private ColumnOrSuperColumn getColumnOrSuperColumnFromRow(String columnFamily, final Bytes rowKey, Bytes superColName, Bytes colName, final ConsistencyLevel cLevel) throws NotFoundException, PelopsException {
        final ColumnPath cp = Selector.newColumnPath(columnFamily, superColName, colName);
        return this.tryOperation(new Operand.IOperation<ColumnOrSuperColumn>(){

            @Override
            public ColumnOrSuperColumn execute(IThriftPool.IPooledConnection conn) throws Exception {
                return conn.getAPI().get(Validation.safeGetRowKey(rowKey), cp, cLevel);
            }
        });
    }

    public Column getColumnFromRow(String columnFamily, Bytes rowKey, Bytes colName, ConsistencyLevel cLevel) throws NotFoundException, PelopsException {
        return this.getColumnOrSuperColumnFromRow((String)columnFamily, (Bytes)rowKey, null, (Bytes)colName, (ConsistencyLevel)cLevel).column;
    }

    public CounterColumn getCounterColumnFromRow(String columnFamily, String rowKey, String colName, ConsistencyLevel cLevel) throws NotFoundException, PelopsException {
        return this.getCounterColumnFromRow(columnFamily, Bytes.fromUTF8(rowKey), Bytes.fromUTF8(colName), cLevel);
    }

    public CounterColumn getCounterColumnFromRow(String columnFamily, String rowKey, Bytes colName, ConsistencyLevel cLevel) throws NotFoundException, PelopsException {
        return this.getCounterColumnFromRow(columnFamily, Bytes.fromUTF8(rowKey), colName, cLevel);
    }

    public CounterColumn getCounterColumnFromRow(String columnFamily, Bytes rowKey, Bytes colName, ConsistencyLevel cLevel) throws NotFoundException, PelopsException {
        return this.getColumnOrSuperColumnFromRow((String)columnFamily, (Bytes)rowKey, null, (Bytes)colName, (ConsistencyLevel)cLevel).counter_column;
    }

    public long getCounterColumnValueFromRow(String columnFamily, String rowKey, String colName, ConsistencyLevel cLevel) throws NotFoundException, PelopsException {
        return this.getCounterColumnValueFromRow(columnFamily, Bytes.fromUTF8(rowKey), Bytes.fromUTF8(colName), cLevel);
    }

    public long getCounterColumnValueFromRow(String columnFamily, String rowKey, Bytes colName, ConsistencyLevel cLevel) throws NotFoundException, PelopsException {
        return this.getCounterColumnValueFromRow(columnFamily, Bytes.fromUTF8(rowKey), colName, cLevel);
    }

    public long getCounterColumnValueFromRow(String columnFamily, Bytes rowKey, Bytes colName, ConsistencyLevel cLevel) throws NotFoundException, PelopsException {
        return this.getCounterColumnFromRow(columnFamily, rowKey, colName, cLevel).getValue();
    }

    public SuperColumn getSuperColumnFromRow(String columnFamily, String rowKey, String superColName, ConsistencyLevel cLevel) throws NotFoundException, PelopsException {
        return this.getSuperColumnFromRow(columnFamily, rowKey, Bytes.fromUTF8(superColName), cLevel);
    }

    public SuperColumn getSuperColumnFromRow(String columnFamily, String rowKey, Bytes superColName, ConsistencyLevel cLevel) throws NotFoundException, PelopsException {
        return this.getSuperColumnFromRow(columnFamily, Bytes.fromUTF8(rowKey), superColName, cLevel);
    }

    public SuperColumn getSuperColumnFromRow(String columnFamily, Bytes rowKey, Bytes superColName, ConsistencyLevel cLevel) throws NotFoundException, PelopsException {
        return this.getColumnOrSuperColumnFromRow((String)columnFamily, (Bytes)rowKey, (Bytes)superColName, null, (ConsistencyLevel)cLevel).super_column;
    }

    public Column getSubColumnFromRow(String columnFamily, String rowKey, Bytes superColName, String subColName, ConsistencyLevel cLevel) throws NotFoundException, PelopsException {
        return this.getSubColumnFromRow(columnFamily, Bytes.fromUTF8(rowKey), superColName, Bytes.fromUTF8(subColName), cLevel);
    }

    public Column getSubColumnFromRow(String columnFamily, String rowKey, String superColName, String subColName, ConsistencyLevel cLevel) throws NotFoundException, PelopsException {
        return this.getSubColumnFromRow(columnFamily, Bytes.fromUTF8(rowKey), Bytes.fromUTF8(superColName), Bytes.fromUTF8(subColName), cLevel);
    }

    public Column getSubColumnFromRow(String columnFamily, String rowKey, String superColName, Bytes subColName, ConsistencyLevel cLevel) throws NotFoundException, PelopsException {
        return this.getSubColumnFromRow(columnFamily, Bytes.fromUTF8(rowKey), Bytes.fromUTF8(superColName), subColName, cLevel);
    }

    public Column getSubColumnFromRow(String columnFamily, String rowKey, Bytes superColName, Bytes subColName, ConsistencyLevel cLevel) throws NotFoundException, PelopsException {
        return this.getSubColumnFromRow(columnFamily, Bytes.fromUTF8(rowKey), superColName, subColName, cLevel);
    }

    public Column getSubColumnFromRow(String columnFamily, Bytes rowKey, Bytes superColName, Bytes subColName, ConsistencyLevel cLevel) throws NotFoundException, PelopsException {
        return this.getColumnOrSuperColumnFromRow((String)columnFamily, (Bytes)rowKey, (Bytes)superColName, (Bytes)subColName, (ConsistencyLevel)cLevel).column;
    }

    public List<Column> getColumnsFromRow(String columnFamily, String rowKey, boolean reversed, ConsistencyLevel cLevel) throws PelopsException {
        return this.getColumnsFromRow(Selector.newColumnParent(columnFamily), rowKey, Selector.columnsPredicateAll(reversed), cLevel);
    }

    public List<Column> getColumnsFromRow(String columnFamily, String rowKey, SlicePredicate colPredicate, ConsistencyLevel cLevel) throws PelopsException {
        return this.getColumnsFromRow(Selector.newColumnParent(columnFamily), rowKey, colPredicate, cLevel);
    }

    public List<Column> getColumnsFromRow(String columnFamily, Bytes rowKey, boolean reversed, ConsistencyLevel cLevel) throws PelopsException {
        return this.getColumnsFromRow(Selector.newColumnParent(columnFamily), rowKey, Selector.columnsPredicateAll(reversed), cLevel);
    }

    public List<Column> getColumnsFromRow(String columnFamily, Bytes rowKey, SlicePredicate colPredicate, ConsistencyLevel cLevel) throws PelopsException {
        return this.getColumnsFromRow(Selector.newColumnParent(columnFamily), rowKey, colPredicate, cLevel);
    }

    public List<Column> getSubColumnsFromRow(String columnFamily, Bytes rowKey, Bytes superColName, boolean reversed, ConsistencyLevel cLevel) throws PelopsException {
        return this.getColumnsFromRow(Selector.newColumnParent(columnFamily, superColName), rowKey, Selector.columnsPredicateAll(reversed), cLevel);
    }

    public List<Column> getSubColumnsFromRow(String columnFamily, Bytes rowKey, Bytes superColName, SlicePredicate colPredicate, ConsistencyLevel cLevel) throws PelopsException {
        return this.getColumnsFromRow(Selector.newColumnParent(columnFamily, superColName), rowKey, colPredicate, cLevel);
    }

    public List<Column> getSubColumnsFromRow(String columnFamily, String rowKey, Bytes superColName, boolean reversed, ConsistencyLevel cLevel) throws PelopsException {
        return this.getColumnsFromRow(Selector.newColumnParent(columnFamily, superColName), rowKey, Selector.columnsPredicateAll(reversed), cLevel);
    }

    public List<Column> getSubColumnsFromRow(String columnFamily, String rowKey, Bytes superColName, SlicePredicate colPredicate, ConsistencyLevel cLevel) throws PelopsException {
        return this.getColumnsFromRow(Selector.newColumnParent(columnFamily, superColName), rowKey, colPredicate, cLevel);
    }

    public List<Column> getSubColumnsFromRow(String columnFamily, String rowKey, String superColName, boolean reversed, ConsistencyLevel cLevel) throws PelopsException {
        return this.getColumnsFromRow(Selector.newColumnParent(columnFamily, superColName), rowKey, Selector.columnsPredicateAll(reversed), cLevel);
    }

    public List<Column> getSubColumnsFromRow(String columnFamily, String rowKey, String superColName, SlicePredicate colPredicate, ConsistencyLevel cLevel) throws PelopsException {
        return this.getColumnsFromRow(Selector.newColumnParent(columnFamily, superColName), rowKey, colPredicate, cLevel);
    }

    private List<Column> getColumnsFromRow(ColumnParent colParent, String rowKey, SlicePredicate colPredicate, ConsistencyLevel cLevel) throws PelopsException {
        return this.getColumnsFromRow(colParent, Bytes.fromUTF8(rowKey), colPredicate, cLevel);
    }

    private List<ColumnOrSuperColumn> getColumnOrSuperColumnsFromRow(final ColumnParent colParent, final Bytes rowKey, final SlicePredicate colPredicate, final ConsistencyLevel cLevel) throws PelopsException {
        return this.tryOperation(new Operand.IOperation<List<ColumnOrSuperColumn>>(){

            @Override
            public List<ColumnOrSuperColumn> execute(IThriftPool.IPooledConnection conn) throws Exception {
                return conn.getAPI().get_slice(Validation.safeGetRowKey(rowKey), colParent, colPredicate, cLevel);
            }
        });
    }

    private List<Column> getColumnsFromRow(ColumnParent colParent, Bytes rowKey, SlicePredicate colPredicate, ConsistencyLevel cLevel) throws PelopsException {
        return ColumnOrSuperColumnHelper.transform(this.getColumnOrSuperColumnsFromRow(colParent, rowKey, colPredicate, cLevel), ColumnOrSuperColumnHelper.COLUMN);
    }

    public List<CounterColumn> getCounterColumnsFromRow(String columnFamily, String rowKey, boolean reversed, ConsistencyLevel cLevel) throws PelopsException {
        return this.getCounterColumnsFromRow(columnFamily, Bytes.fromUTF8(rowKey), reversed, cLevel);
    }

    public List<CounterColumn> getCounterColumnsFromRow(String columnFamily, Bytes rowKey, boolean reversed, ConsistencyLevel cLevel) throws PelopsException {
        return this.getCounterColumnsFromRow(Selector.newColumnParent(columnFamily), rowKey, Selector.columnsPredicateAll(reversed), cLevel);
    }

    public List<CounterColumn> getCounterColumnsFromRow(String columnFamily, String rowKey, SlicePredicate colPredicate, ConsistencyLevel cLevel) throws PelopsException {
        return this.getCounterColumnsFromRow(columnFamily, Bytes.fromUTF8(rowKey), colPredicate, cLevel);
    }

    public List<CounterColumn> getCounterColumnsFromRow(String columnFamily, Bytes rowKey, SlicePredicate colPredicate, ConsistencyLevel cLevel) throws PelopsException {
        return this.getCounterColumnsFromRow(Selector.newColumnParent(columnFamily), rowKey, colPredicate, cLevel);
    }

    private List<CounterColumn> getCounterColumnsFromRow(ColumnParent colParent, Bytes rowKey, SlicePredicate colPredicate, ConsistencyLevel cLevel) throws PelopsException {
        return ColumnOrSuperColumnHelper.transform(this.getColumnOrSuperColumnsFromRow(colParent, rowKey, colPredicate, cLevel), ColumnOrSuperColumnHelper.COUNTER_COLUMN);
    }

    public List<SuperColumn> getSuperColumnsFromRow(String columnFamily, String rowKey, boolean reversed, ConsistencyLevel cLevel) throws PelopsException {
        return this.getSuperColumnsFromRow(columnFamily, Bytes.fromUTF8(rowKey), Selector.columnsPredicateAll(reversed), cLevel);
    }

    public List<SuperColumn> getSuperColumnsFromRow(String columnFamily, String rowKey, SlicePredicate colPredicate, ConsistencyLevel cLevel) throws PelopsException {
        return this.getSuperColumnsFromRow(columnFamily, Bytes.fromUTF8(rowKey), colPredicate, cLevel);
    }

    public List<SuperColumn> getSuperColumnsFromRow(String columnFamily, Bytes rowKey, boolean reversed, ConsistencyLevel cLevel) throws PelopsException {
        return this.getSuperColumnsFromRow(columnFamily, rowKey, Selector.columnsPredicateAll(reversed), cLevel);
    }

    public List<SuperColumn> getSuperColumnsFromRow(String columnFamily, Bytes rowKey, SlicePredicate colPredicate, ConsistencyLevel cLevel) throws PelopsException {
        return ColumnOrSuperColumnHelper.transform(this.getColumnOrSuperColumnsFromRow(Selector.newColumnParent(columnFamily), rowKey, colPredicate, cLevel), ColumnOrSuperColumnHelper.SUPER_COLUMN);
    }

    public List<Column> getPageOfColumnsFromRow(String columnFamily, String rowKey, Bytes startBeyondName, boolean reversed, int count, ConsistencyLevel cLevel) throws PelopsException {
        return this.getPageOfColumnsFromRow(columnFamily, Bytes.fromUTF8(rowKey), startBeyondName, reversed, count, cLevel);
    }

    public List<Column> getPageOfColumnsFromRow(String columnFamily, String rowKey, String startBeyondName, boolean reversed, int count, ConsistencyLevel cLevel) throws PelopsException {
        return this.getPageOfColumnsFromRow(columnFamily, Bytes.fromUTF8(rowKey), Bytes.fromUTF8(startBeyondName), reversed, count, cLevel);
    }

    public List<Column> getPageOfColumnsFromRow(String columnFamily, Bytes rowKey, String startBeyondName, boolean reversed, int count, ConsistencyLevel cLevel) throws PelopsException {
        return this.getPageOfColumnsFromRow(columnFamily, rowKey, Bytes.fromUTF8(startBeyondName), reversed, count, cLevel);
    }

    public List<Column> getPageOfColumnsFromRow(String columnFamily, Bytes rowKey, Bytes startBeyondName, boolean reversed, int count, ConsistencyLevel cLevel) throws PelopsException {
        if (Bytes.nullSafeGet(startBeyondName) == null) {
            SlicePredicate predicate = Selector.newColumnsPredicateAll(reversed, count);
            return this.getColumnsFromRow(columnFamily, rowKey, predicate, cLevel);
        }
        int incrementedCount = count + 1;
        SlicePredicate predicate = Selector.newColumnsPredicate(startBeyondName, Bytes.EMPTY, reversed, incrementedCount);
        List<Column> columns = this.getColumnsFromRow(columnFamily, rowKey, predicate, cLevel);
        if (columns.size() > 0) {
            Column first = columns.get(0);
            if (first.name.equals(startBeyondName.getBytes())) {
                return columns.subList(1, columns.size());
            }
            if (columns.size() == incrementedCount) {
                return columns.subList(0, columns.size() - 1);
            }
        }
        return columns;
    }

    public List<Bytes> getPageOfColumnNamesFromRow(String columnFamily, Bytes rowKey, Bytes startBeyondName, boolean reversed, int count, ConsistencyLevel cLevel) throws PelopsException {
        List<Column> columns = this.getPageOfColumnsFromRow(columnFamily, rowKey, startBeyondName, reversed, count, cLevel);
        ArrayList<Bytes> columnNames = new ArrayList<Bytes>(columns.size());
        for (Column column : columns) {
            columnNames.add(Bytes.fromByteArray(column.getName()));
        }
        return columnNames;
    }

    public Iterator<Column> iterateColumnsFromRow(String columnFamily, Bytes rowKey, Bytes startBeyondName, boolean reversed, int batchSize, ConsistencyLevel cLevel) {
        return new ColumnIterator(this, columnFamily, rowKey, startBeyondName, reversed, batchSize, cLevel);
    }

    public Iterator<Column> iterateColumnsFromRow(String columnFamily, String rowKey, String startBeyondName, boolean reversed, int batchSize, ConsistencyLevel cLevel) {
        return this.iterateColumnsFromRow(columnFamily, Bytes.fromUTF8(rowKey), Bytes.fromUTF8(startBeyondName), reversed, batchSize, cLevel);
    }

    public Iterator<Map.Entry<Bytes, List<Column>>> iterateColumnsFromRows(String columnFamily, int batchSize, ConsistencyLevel cLevel) {
        return this.iterateColumnsFromRows(columnFamily, Bytes.EMPTY, batchSize, Selector.newColumnsPredicateAll(false), cLevel);
    }

    public Iterator<Map.Entry<Bytes, List<Column>>> iterateColumnsFromRows(String columnFamily, Bytes startBeyondKey, int batchSize, ConsistencyLevel cLevel) {
        return this.iterateColumnsFromRows(columnFamily, startBeyondKey, batchSize, Selector.newColumnsPredicateAll(false), cLevel);
    }

    public Iterator<Map.Entry<Bytes, List<Column>>> iterateColumnsFromRows(String columnFamily, Bytes startBeyondKey, int batchSize, SlicePredicate colPredicate, ConsistencyLevel cLevel) {
        return new ColumnRowIterator(this, columnFamily, startBeyondKey, batchSize, colPredicate, cLevel);
    }

    public List<SuperColumn> getPageOfSuperColumnsFromRow(String columnFamily, String rowKey, Bytes startBeyondName, boolean reversed, int count, ConsistencyLevel cLevel) throws PelopsException {
        return this.getPageOfSuperColumnsFromRow(columnFamily, Bytes.fromUTF8(rowKey), startBeyondName, reversed, count, cLevel);
    }

    public List<SuperColumn> getPageOfSuperColumnsFromRow(String columnFamily, String rowKey, String startBeyondName, boolean reversed, int count, ConsistencyLevel cLevel) throws PelopsException {
        return this.getPageOfSuperColumnsFromRow(columnFamily, Bytes.fromUTF8(rowKey), Bytes.fromUTF8(startBeyondName), reversed, count, cLevel);
    }

    public List<SuperColumn> getPageOfSuperColumnsFromRow(String columnFamily, Bytes rowKey, String startBeyondName, boolean reversed, int count, ConsistencyLevel cLevel) throws PelopsException {
        return this.getPageOfSuperColumnsFromRow(columnFamily, rowKey, Bytes.fromUTF8(startBeyondName), reversed, count, cLevel);
    }

    public List<SuperColumn> getPageOfSuperColumnsFromRow(String columnFamily, Bytes rowKey, Bytes startBeyondName, boolean reversed, int count, ConsistencyLevel cLevel) throws PelopsException {
        if (Bytes.nullSafeGet(startBeyondName) == null) {
            SlicePredicate predicate = Selector.newColumnsPredicateAll(reversed, count);
            return this.getSuperColumnsFromRow(columnFamily, rowKey, predicate, cLevel);
        }
        int incrementedCount = count + 1;
        SlicePredicate predicate = Selector.newColumnsPredicate(startBeyondName, Bytes.EMPTY, reversed, incrementedCount);
        List<SuperColumn> columns = this.getSuperColumnsFromRow(columnFamily, rowKey, predicate, cLevel);
        if (columns.size() > 0) {
            SuperColumn first = columns.get(0);
            if (first.name.equals(startBeyondName.getBytes())) {
                return columns.subList(1, columns.size());
            }
            if (columns.size() == incrementedCount) {
                return columns.subList(0, columns.size() - 1);
            }
        }
        return columns;
    }

    public Iterator<SuperColumn> iterateSuperColumnsFromRow(String columnFamily, Bytes rowKey, Bytes startBeyondName, boolean reversed, int batchSize, ConsistencyLevel cLevel) {
        return new SuperColumnIterator(this, columnFamily, rowKey, startBeyondName, reversed, batchSize, cLevel);
    }

    public Iterator<SuperColumn> iterateSuperColumnsFromRow(String columnFamily, String rowKey, String startBeyondName, boolean reversed, int batchSize, ConsistencyLevel cLevel) {
        return this.iterateSuperColumnsFromRow(columnFamily, Bytes.fromUTF8(rowKey), Bytes.fromUTF8(startBeyondName), reversed, batchSize, cLevel);
    }

    public LinkedHashMap<Bytes, List<Column>> getColumnsFromRows(String columnFamily, List<Bytes> rowKeys, boolean reversed, ConsistencyLevel cLevel) throws PelopsException {
        return this.getColumnsFromRows(Selector.newColumnParent(columnFamily), rowKeys, Selector.columnsPredicateAll(reversed), cLevel);
    }

    public LinkedHashMap<Bytes, List<CounterColumn>> getCounterColumnsFromRows(String columnFamily, List<Bytes> rowKeys, boolean reversed, ConsistencyLevel cLevel) throws PelopsException {
        return this.getCounterColumnsFromRows(Selector.newColumnParent(columnFamily), rowKeys, Selector.columnsPredicateAll(reversed), cLevel);
    }

    public LinkedHashMap<Bytes, List<Column>> getColumnsFromRows(String columnFamily, List<Bytes> rowKeys, SlicePredicate colPredicate, ConsistencyLevel cLevel) throws PelopsException {
        return this.getColumnsFromRows(Selector.newColumnParent(columnFamily), rowKeys, colPredicate, cLevel);
    }

    public LinkedHashMap<Bytes, List<CounterColumn>> getCounterColumnsFromRows(String columnFamily, List<Bytes> rowKeys, SlicePredicate colPredicate, ConsistencyLevel cLevel) throws PelopsException {
        return this.getCounterColumnsFromRows(Selector.newColumnParent(columnFamily), rowKeys, colPredicate, cLevel);
    }

    public LinkedHashMap<String, List<Column>> getColumnsFromRowsUtf8Keys(String columnFamily, List<String> rowKeys, boolean reversed, ConsistencyLevel cLevel) throws PelopsException {
        return this.getColumnsFromRowsUtf8Keys(Selector.newColumnParent(columnFamily), rowKeys, Selector.columnsPredicateAll(reversed), cLevel);
    }

    public LinkedHashMap<String, List<Column>> getColumnsFromRowsUtf8Keys(String columnFamily, List<String> rowKeys, SlicePredicate colPredicate, ConsistencyLevel cLevel) throws PelopsException {
        return this.getColumnsFromRowsUtf8Keys(Selector.newColumnParent(columnFamily), rowKeys, colPredicate, cLevel);
    }

    public LinkedHashMap<String, List<CounterColumn>> getCounterColumnsFromRowsUtf8Keys(String columnFamily, List<String> rowKeys, boolean reversed, ConsistencyLevel cLevel) throws PelopsException {
        return this.getCounterColumnsFromRowsUtf8Keys(Selector.newColumnParent(columnFamily), rowKeys, Selector.columnsPredicateAll(reversed), cLevel);
    }

    public LinkedHashMap<String, List<CounterColumn>> getCounterColumnsFromRowsUtf8Keys(String columnFamily, List<String> rowKeys, SlicePredicate colPredicate, ConsistencyLevel cLevel) throws PelopsException {
        return this.getCounterColumnsFromRowsUtf8Keys(Selector.newColumnParent(columnFamily), rowKeys, colPredicate, cLevel);
    }

    public LinkedHashMap<Bytes, List<Column>> getSubColumnsFromRows(String columnFamily, List<Bytes> rowKeys, String superColName, boolean reversed, ConsistencyLevel cLevel) throws PelopsException {
        return this.getColumnsFromRows(Selector.newColumnParent(columnFamily, superColName), rowKeys, Selector.columnsPredicateAll(reversed), cLevel);
    }

    public Map<Bytes, List<CounterColumn>> getSubCounterColumnsFromRows(String columnFamily, List<Bytes> rowKeys, String superColName, boolean reversed, ConsistencyLevel cLevel) throws PelopsException {
        return this.getCounterColumnsFromRows(Selector.newColumnParent(columnFamily, superColName), rowKeys, Selector.columnsPredicateAll(reversed), cLevel);
    }

    public Map<Bytes, List<Column>> getSubColumnsFromRows(String columnFamily, List<Bytes> rowKeys, String superColName, SlicePredicate colPredicate, ConsistencyLevel cLevel) throws PelopsException {
        return this.getColumnsFromRows(Selector.newColumnParent(columnFamily, superColName), rowKeys, colPredicate, cLevel);
    }

    public Map<Bytes, List<CounterColumn>> getSubCounterColumnsFromRows(String columnFamily, List<Bytes> rowKeys, String superColName, SlicePredicate colPredicate, ConsistencyLevel cLevel) throws PelopsException {
        return this.getCounterColumnsFromRows(Selector.newColumnParent(columnFamily, superColName), rowKeys, colPredicate, cLevel);
    }

    public Map<String, List<Column>> getSubColumnsFromRowsUtf8Keys(String columnFamily, List<String> rowKeys, String superColName, boolean reversed, ConsistencyLevel cLevel) throws PelopsException {
        return this.getColumnsFromRowsUtf8Keys(Selector.newColumnParent(columnFamily, superColName), rowKeys, Selector.columnsPredicateAll(reversed), cLevel);
    }

    public LinkedHashMap<String, List<CounterColumn>> getSubCounterColumnsFromRowsUtf8Keys(String columnFamily, List<String> rowKeys, String superColName, boolean reversed, ConsistencyLevel cLevel) throws PelopsException {
        return this.getCounterColumnsFromRowsUtf8Keys(Selector.newColumnParent(columnFamily, superColName), rowKeys, Selector.columnsPredicateAll(reversed), cLevel);
    }

    public LinkedHashMap<String, List<Column>> getSubColumnsFromRowsUtf8Keys(String columnFamily, List<String> rowKeys, String superColName, SlicePredicate colPredicate, ConsistencyLevel cLevel) throws PelopsException {
        return this.getColumnsFromRowsUtf8Keys(Selector.newColumnParent(columnFamily, superColName), rowKeys, colPredicate, cLevel);
    }

    public LinkedHashMap<String, List<CounterColumn>> getSubCounterColumnsFromRowsUtf8Keys(String columnFamily, List<String> rowKeys, String superColName, SlicePredicate colPredicate, ConsistencyLevel cLevel) throws PelopsException {
        return this.getCounterColumnsFromRowsUtf8Keys(Selector.newColumnParent(columnFamily, superColName), rowKeys, colPredicate, cLevel);
    }

    public LinkedHashMap<Bytes, List<Column>> getSubColumnsFromRows(String columnFamily, List<Bytes> rowKeys, Bytes superColName, boolean reversed, ConsistencyLevel cLevel) throws PelopsException {
        return this.getColumnsFromRows(Selector.newColumnParent(columnFamily, superColName), rowKeys, Selector.columnsPredicateAll(reversed), cLevel);
    }

    public LinkedHashMap<Bytes, List<CounterColumn>> getSubCounterColumnsFromRows(String columnFamily, List<Bytes> rowKeys, Bytes superColName, boolean reversed, ConsistencyLevel cLevel) throws PelopsException {
        return this.getCounterColumnsFromRows(Selector.newColumnParent(columnFamily, superColName), rowKeys, Selector.columnsPredicateAll(reversed), cLevel);
    }

    public LinkedHashMap<Bytes, List<Column>> getSubColumnsFromRows(String columnFamily, List<Bytes> rowKeys, Bytes superColName, SlicePredicate colPredicate, ConsistencyLevel cLevel) throws PelopsException {
        return this.getColumnsFromRows(Selector.newColumnParent(columnFamily, superColName), rowKeys, colPredicate, cLevel);
    }

    public LinkedHashMap<Bytes, List<CounterColumn>> getSubCounterColumnsFromRows(String columnFamily, List<Bytes> rowKeys, Bytes superColName, SlicePredicate colPredicate, ConsistencyLevel cLevel) throws PelopsException {
        return this.getCounterColumnsFromRows(Selector.newColumnParent(columnFamily, superColName), rowKeys, colPredicate, cLevel);
    }

    public LinkedHashMap<String, List<Column>> getSubColumnsFromRowsUtf8Keys(String columnFamily, List<String> rowKeys, Bytes superColName, boolean reversed, ConsistencyLevel cLevel) throws PelopsException {
        return this.getColumnsFromRowsUtf8Keys(Selector.newColumnParent(columnFamily, superColName), rowKeys, Selector.columnsPredicateAll(reversed), cLevel);
    }

    public LinkedHashMap<String, List<CounterColumn>> getSubCounterColumnsFromRowsUtf8Keys(String columnFamily, List<String> rowKeys, Bytes superColName, boolean reversed, ConsistencyLevel cLevel) throws PelopsException {
        return this.getCounterColumnsFromRowsUtf8Keys(Selector.newColumnParent(columnFamily, superColName), rowKeys, Selector.columnsPredicateAll(reversed), cLevel);
    }

    public LinkedHashMap<String, List<Column>> getSubColumnsFromRowsUtf8Keys(String columnFamily, List<String> rowKeys, Bytes superColName, SlicePredicate colPredicate, ConsistencyLevel cLevel) throws PelopsException {
        return this.getColumnsFromRowsUtf8Keys(Selector.newColumnParent(columnFamily, superColName), rowKeys, colPredicate, cLevel);
    }

    public LinkedHashMap<String, List<CounterColumn>> getSubCounterColumnsFromRowsUtf8Keys(String columnFamily, List<String> rowKeys, Bytes superColName, SlicePredicate colPredicate, ConsistencyLevel cLevel) throws PelopsException {
        return this.getCounterColumnsFromRowsUtf8Keys(Selector.newColumnParent(columnFamily, superColName), rowKeys, colPredicate, cLevel);
    }

    public LinkedHashMap<Bytes, List<SuperColumn>> getSuperColumnsFromRows(String columnFamily, List<Bytes> rowKeys, boolean reversed, ConsistencyLevel cLevel) throws PelopsException {
        return this.getSuperColumnsFromRows(columnFamily, rowKeys, Selector.columnsPredicateAll(reversed), cLevel);
    }

    public Map<ByteBuffer, List<ColumnOrSuperColumn>> getColumnOrSuperColumnsFromRows(final ColumnParent columnParent, final List<ByteBuffer> rowKeys, final SlicePredicate colPredicate, final ConsistencyLevel cLevel) throws PelopsException {
        return this.tryOperation(new Operand.IOperation<Map<ByteBuffer, List<ColumnOrSuperColumn>>>(){

            @Override
            public Map<ByteBuffer, List<ColumnOrSuperColumn>> execute(IThriftPool.IPooledConnection conn) throws Exception {
                return conn.getAPI().multiget_slice(rowKeys, columnParent, colPredicate, cLevel);
            }
        });
    }

    public LinkedHashMap<Bytes, List<SuperColumn>> getSuperColumnsFromRows(String columnFamily, List<Bytes> rowKeys, SlicePredicate colPredicate, ConsistencyLevel cLevel) throws PelopsException {
        ColumnParent columnParent = Selector.newColumnParent(columnFamily);
        List<ByteBuffer> keys = Bytes.transformBytesToList(Validation.validateRowKeys(rowKeys));
        return ColumnOrSuperColumnHelper.transform(this.getColumnOrSuperColumnsFromRows(columnParent, keys, colPredicate, cLevel), rowKeys, ColumnOrSuperColumnHelper.SUPER_COLUMN);
    }

    public LinkedHashMap<String, List<SuperColumn>> getSuperColumnsFromRowsUtf8Keys(String columnFamily, List<String> rowKeys, boolean reversed, ConsistencyLevel cLevel) throws PelopsException {
        return this.getSuperColumnsFromRowsUtf8Keys(columnFamily, rowKeys, Selector.columnsPredicateAll(reversed), cLevel);
    }

    public LinkedHashMap<String, List<SuperColumn>> getSuperColumnsFromRowsUtf8Keys(String columnFamily, List<String> rowKeys, SlicePredicate colPredicate, ConsistencyLevel cLevel) throws PelopsException {
        ColumnParent columnParent = Selector.newColumnParent(columnFamily);
        List<ByteBuffer> keys = Bytes.transformUTF8ToList(Validation.validateRowKeysUtf8(rowKeys));
        return ColumnOrSuperColumnHelper.transformUtf8(this.getColumnOrSuperColumnsFromRows(columnParent, keys, colPredicate, cLevel), rowKeys, keys, ColumnOrSuperColumnHelper.SUPER_COLUMN);
    }

    private LinkedHashMap<Bytes, List<Column>> getColumnsFromRows(ColumnParent colParent, List<Bytes> rowKeys, SlicePredicate colPredicate, ConsistencyLevel cLevel) throws PelopsException {
        List<ByteBuffer> keys = Bytes.transformBytesToList(Validation.validateRowKeys(rowKeys));
        return ColumnOrSuperColumnHelper.transform(this.getColumnOrSuperColumnsFromRows(colParent, keys, colPredicate, cLevel), rowKeys, ColumnOrSuperColumnHelper.COLUMN);
    }

    private LinkedHashMap<Bytes, List<CounterColumn>> getCounterColumnsFromRows(ColumnParent colParent, List<Bytes> rowKeys, SlicePredicate colPredicate, ConsistencyLevel cLevel) throws PelopsException {
        List<ByteBuffer> keys = Bytes.transformBytesToList(Validation.validateRowKeys(rowKeys));
        return ColumnOrSuperColumnHelper.transform(this.getColumnOrSuperColumnsFromRows(colParent, keys, colPredicate, cLevel), rowKeys, ColumnOrSuperColumnHelper.COUNTER_COLUMN);
    }

    private LinkedHashMap<String, List<Column>> getColumnsFromRowsUtf8Keys(ColumnParent colParent, List<String> rowKeys, SlicePredicate colPredicate, ConsistencyLevel cLevel) throws PelopsException {
        List<ByteBuffer> keys = Bytes.transformUTF8ToList(Validation.validateRowKeysUtf8(rowKeys));
        return ColumnOrSuperColumnHelper.transformUtf8(this.getColumnOrSuperColumnsFromRows(colParent, keys, colPredicate, cLevel), rowKeys, keys, ColumnOrSuperColumnHelper.COLUMN);
    }

    private LinkedHashMap<String, List<CounterColumn>> getCounterColumnsFromRowsUtf8Keys(ColumnParent colParent, List<String> rowKeys, SlicePredicate colPredicate, ConsistencyLevel cLevel) throws PelopsException {
        List<ByteBuffer> keys = Bytes.transformUTF8ToList(Validation.validateRowKeysUtf8(rowKeys));
        return ColumnOrSuperColumnHelper.transformUtf8(this.getColumnOrSuperColumnsFromRows(colParent, keys, colPredicate, cLevel), rowKeys, keys, ColumnOrSuperColumnHelper.COUNTER_COLUMN);
    }

    public LinkedHashMap<Bytes, List<Column>> getColumnsFromRows(String columnFamily, KeyRange keyRange, boolean reversed, ConsistencyLevel cLevel) throws PelopsException {
        return this.getColumnsFromRows(Selector.newColumnParent(columnFamily), keyRange, Selector.columnsPredicateAll(reversed), cLevel);
    }

    public LinkedHashMap<Bytes, List<Column>> getColumnsFromRows(String columnFamily, KeyRange keyRange, SlicePredicate colPredicate, ConsistencyLevel cLevel) throws PelopsException {
        return this.getColumnsFromRows(Selector.newColumnParent(columnFamily), keyRange, colPredicate, cLevel);
    }

    public LinkedHashMap<String, List<Column>> getColumnsFromRowsUtf8Keys(String columnFamily, KeyRange keyRange, boolean reversed, ConsistencyLevel cLevel) throws PelopsException {
        return this.getColumnsFromRowsUtf8Keys(Selector.newColumnParent(columnFamily), keyRange, Selector.columnsPredicateAll(reversed), cLevel);
    }

    public LinkedHashMap<String, List<Column>> getColumnsFromRowsUtf8Keys(String columnFamily, KeyRange keyRange, SlicePredicate colPredicate, ConsistencyLevel cLevel) throws PelopsException {
        return this.getColumnsFromRowsUtf8Keys(Selector.newColumnParent(columnFamily), keyRange, colPredicate, cLevel);
    }

    public LinkedHashMap<Bytes, List<Column>> getSubColumnsFromRows(String columnFamily, KeyRange keyRange, Bytes superColName, boolean reversed, ConsistencyLevel cLevel) throws PelopsException {
        return this.getColumnsFromRows(Selector.newColumnParent(columnFamily, superColName), keyRange, Selector.columnsPredicateAll(reversed), cLevel);
    }

    public LinkedHashMap<Bytes, List<Column>> getSubColumnsFromRows(String columnFamily, KeyRange keyRange, Bytes superColName, SlicePredicate colPredicate, ConsistencyLevel cLevel) throws PelopsException {
        return this.getColumnsFromRows(Selector.newColumnParent(columnFamily, superColName), keyRange, colPredicate, cLevel);
    }

    public Map<String, List<Column>> getSubColumnsFromRowsUtf8Keys(String columnFamily, KeyRange keyRange, Bytes superColName, boolean reversed, ConsistencyLevel cLevel) throws PelopsException {
        return this.getColumnsFromRowsUtf8Keys(Selector.newColumnParent(columnFamily, superColName), keyRange, Selector.columnsPredicateAll(reversed), cLevel);
    }

    public LinkedHashMap<String, List<Column>> getSubColumnsFromRowsUtf8Keys(String columnFamily, KeyRange keyRange, Bytes superColName, SlicePredicate colPredicate, ConsistencyLevel cLevel) throws PelopsException {
        return this.getColumnsFromRowsUtf8Keys(Selector.newColumnParent(columnFamily, superColName), keyRange, colPredicate, cLevel);
    }

    public LinkedHashMap<Bytes, List<Column>> getSubColumnsFromRows(String columnFamily, KeyRange keyRange, String superColName, boolean reversed, ConsistencyLevel cLevel) throws PelopsException {
        return this.getColumnsFromRows(Selector.newColumnParent(columnFamily, superColName), keyRange, Selector.columnsPredicateAll(reversed), cLevel);
    }

    public LinkedHashMap<Bytes, List<Column>> getSubColumnsFromRows(String columnFamily, KeyRange keyRange, String superColName, SlicePredicate colPredicate, ConsistencyLevel cLevel) throws PelopsException {
        return this.getColumnsFromRows(Selector.newColumnParent(columnFamily, superColName), keyRange, colPredicate, cLevel);
    }

    public LinkedHashMap<String, List<Column>> getSubColumnsFromRowsUtf8Keys(String columnFamily, KeyRange keyRange, String superColName, boolean reversed, ConsistencyLevel cLevel) throws PelopsException {
        return this.getColumnsFromRowsUtf8Keys(Selector.newColumnParent(columnFamily, superColName), keyRange, Selector.columnsPredicateAll(reversed), cLevel);
    }

    public LinkedHashMap<String, List<Column>> getSubColumnsFromRowsUtf8Keys(String columnFamily, KeyRange keyRange, String superColName, SlicePredicate colPredicate, ConsistencyLevel cLevel) throws PelopsException {
        return this.getColumnsFromRowsUtf8Keys(Selector.newColumnParent(columnFamily, superColName), keyRange, colPredicate, cLevel);
    }

    public LinkedHashMap<Bytes, List<SuperColumn>> getSuperColumnsFromRows(String columnFamily, KeyRange keyRange, boolean reversed, ConsistencyLevel cLevel) throws PelopsException {
        return this.getSuperColumnsFromRows(columnFamily, keyRange, Selector.columnsPredicateAll(reversed), cLevel);
    }

    public List<KeySlice> getKeySlices(final ColumnParent columnParent, final KeyRange keyRange, final SlicePredicate colPredicate, final ConsistencyLevel cLevel) throws PelopsException {
        return this.tryOperation(new Operand.IOperation<List<KeySlice>>(){

            @Override
            public List<KeySlice> execute(IThriftPool.IPooledConnection conn) throws Exception {
                return conn.getAPI().get_range_slices(columnParent, colPredicate, keyRange, cLevel);
            }
        });
    }

    public LinkedHashMap<Bytes, List<SuperColumn>> getSuperColumnsFromRows(String columnFamily, KeyRange keyRange, SlicePredicate colPredicate, ConsistencyLevel cLevel) throws PelopsException {
        return ColumnOrSuperColumnHelper.transformKeySlices(this.getKeySlices(Selector.newColumnParent(columnFamily), keyRange, colPredicate, cLevel), ColumnOrSuperColumnHelper.SUPER_COLUMN);
    }

    public LinkedHashMap<String, List<SuperColumn>> getSuperColumnsFromRowsUtf8Keys(String columnFamily, KeyRange keyRange, boolean reversed, ConsistencyLevel cLevel) throws PelopsException {
        return this.getSuperColumnsFromRowsUtf8Keys(columnFamily, keyRange, Selector.columnsPredicateAll(reversed), cLevel);
    }

    public LinkedHashMap<String, List<SuperColumn>> getSuperColumnsFromRowsUtf8Keys(String columnFamily, KeyRange keyRange, SlicePredicate colPredicate, ConsistencyLevel cLevel) throws PelopsException {
        return ColumnOrSuperColumnHelper.transformKeySlicesUtf8(this.getKeySlices(Selector.newColumnParent(columnFamily), keyRange, colPredicate, cLevel), ColumnOrSuperColumnHelper.SUPER_COLUMN);
    }

    private LinkedHashMap<Bytes, List<Column>> getColumnsFromRows(ColumnParent colParent, KeyRange keyRange, SlicePredicate colPredicate, ConsistencyLevel cLevel) throws PelopsException {
        return ColumnOrSuperColumnHelper.transformKeySlices(this.getKeySlices(colParent, keyRange, colPredicate, cLevel), ColumnOrSuperColumnHelper.COLUMN);
    }

    private LinkedHashMap<String, List<Column>> getColumnsFromRowsUtf8Keys(ColumnParent colParent, KeyRange keyRange, SlicePredicate colPredicate, ConsistencyLevel cLevel) throws PelopsException {
        return ColumnOrSuperColumnHelper.transformKeySlicesUtf8(this.getKeySlices(colParent, keyRange, colPredicate, cLevel), ColumnOrSuperColumnHelper.COLUMN);
    }

    public LinkedHashMap<Bytes, List<Column>> getIndexedColumns(String colParent, IndexClause indexClause, boolean reversed, ConsistencyLevel cLevel) throws PelopsException {
        return this.getIndexedColumns(Selector.newColumnParent(colParent), indexClause, Selector.columnsPredicateAll(reversed), cLevel);
    }

    public LinkedHashMap<Bytes, List<Column>> getIndexedColumns(String colParent, IndexClause indexClause, SlicePredicate colPredicate, ConsistencyLevel cLevel) throws PelopsException {
        return this.getIndexedColumns(Selector.newColumnParent(colParent), indexClause, colPredicate, cLevel);
    }

    public LinkedHashMap<Bytes, List<Column>> getIndexedColumns(ColumnParent colParent, IndexClause indexClause, boolean reversed, ConsistencyLevel cLevel) throws PelopsException {
        return this.getIndexedColumns(colParent, indexClause, Selector.columnsPredicateAll(reversed), cLevel);
    }

    public List<KeySlice> getKeySlices(final ColumnParent colParent, final IndexClause indexClause, final SlicePredicate colPredicate, final ConsistencyLevel cLevel) throws PelopsException {
        return this.tryOperation(new Operand.IOperation<List<KeySlice>>(){

            @Override
            public List<KeySlice> execute(IThriftPool.IPooledConnection conn) throws Exception {
                return conn.getAPI().get_indexed_slices(colParent, indexClause, colPredicate, cLevel);
            }
        });
    }

    public LinkedHashMap<Bytes, List<Column>> getIndexedColumns(ColumnParent colParent, IndexClause indexClause, SlicePredicate colPredicate, ConsistencyLevel cLevel) throws PelopsException {
        return ColumnOrSuperColumnHelper.transformKeySlices(this.getKeySlices(colParent, indexClause, colPredicate, cLevel), ColumnOrSuperColumnHelper.COLUMN);
    }

    public static IndexExpression newIndexExpression(Bytes colName, IndexOperator op, Bytes value) {
        return new IndexExpression(colName.getBytes(), op, value.getBytes());
    }

    public static IndexExpression newIndexExpression(String colName, IndexOperator op, Bytes value) {
        return Selector.newIndexExpression(Bytes.fromUTF8(colName), op, value);
    }

    public static IndexClause newIndexClause(String startName, int count, IndexExpression ... expressions) {
        return Selector.newIndexClause(Bytes.fromUTF8(startName), count, expressions);
    }

    public static IndexClause newIndexClause(Bytes startName, int count, IndexExpression ... expressions) {
        return new IndexClause(Arrays.asList(expressions), startName.getBytes(), count);
    }

    private static SlicePredicate columnsPredicateAll(boolean reversed) {
        return reversed ? COLUMNS_PREDICATE_ALL_REVERSED : COLUMNS_PREDICATE_ALL;
    }

    public static SlicePredicate newColumnsPredicateAll(boolean reversed) {
        return Selector.newColumnsPredicateAll(reversed, Integer.MAX_VALUE);
    }

    public static SlicePredicate newColumnsPredicateAll(boolean reversed, int maxColCount) {
        SlicePredicate predicate = new SlicePredicate();
        predicate.setSlice_range(new SliceRange(Bytes.EMPTY.getBytes(), Bytes.EMPTY.getBytes(), reversed, maxColCount));
        return predicate;
    }

    public static SlicePredicate newColumnsPredicate(Bytes startName, Bytes finishName, boolean reversed, int maxColCount) {
        SlicePredicate predicate = new SlicePredicate();
        predicate.setSlice_range(new SliceRange(Bytes.nullSafeGet(startName), Bytes.nullSafeGet(finishName), reversed, maxColCount));
        return predicate;
    }

    public static SlicePredicate newColumnsPredicate(String startName, String finishName, boolean reversed, int maxColCount) {
        return Selector.newColumnsPredicate(Bytes.fromUTF8(startName), Bytes.fromUTF8(finishName), reversed, maxColCount);
    }

    public static SlicePredicate newColumnsPredicate(String ... colNames) {
        ArrayList<ByteBuffer> asList = new ArrayList<ByteBuffer>(32);
        for (String colName : colNames) {
            asList.add(Bytes.fromUTF8(colName).getBytes());
        }
        SlicePredicate predicate = new SlicePredicate();
        predicate.setColumn_names(asList);
        return predicate;
    }

    public static SlicePredicate newColumnsPredicate(Bytes ... colNames) {
        ArrayList<ByteBuffer> asList = new ArrayList<ByteBuffer>(32);
        for (Bytes colName : colNames) {
            asList.add(Bytes.nullSafeGet(colName));
        }
        SlicePredicate predicate = new SlicePredicate();
        predicate.setColumn_names(asList);
        return predicate;
    }

    public static KeyRange newKeyRange(String startKey, String finishKey, int maxKeyCount) {
        return Selector.newKeyRange(Bytes.fromUTF8(startKey), Bytes.fromUTF8(finishKey), maxKeyCount);
    }

    public static KeyRange newKeyRange(Bytes startKey, Bytes finishKey, int maxKeyCount) {
        KeyRange keyRange = new KeyRange(maxKeyCount);
        keyRange.setStart_key(Bytes.nullSafeGet(startKey));
        keyRange.setEnd_key(Bytes.nullSafeGet(finishKey));
        return keyRange;
    }

    public static KeyRange newKeyRingRange(String startFollowingKey, String finishKey, int maxKeyCount) {
        KeyRange keyRange = new KeyRange(maxKeyCount);
        keyRange.setStart_token(startFollowingKey);
        keyRange.setEnd_token(finishKey);
        return keyRange;
    }

    public static boolean superColumnExists(List<SuperColumn> superColumns, String superColName) {
        return Selector.superColumnExists(superColumns, Bytes.fromUTF8(superColName));
    }

    public static boolean superColumnExists(List<SuperColumn> superColumns, Bytes superColName) {
        for (SuperColumn superColumn : superColumns) {
            if (!superColumn.name.equals(Bytes.nullSafeGet(superColName))) continue;
            return true;
        }
        return false;
    }

    public static SuperColumn getSuperColumn(List<SuperColumn> superColumns, Bytes superColName) throws ArrayIndexOutOfBoundsException {
        for (SuperColumn superColumn : superColumns) {
            if (!superColumn.name.equals(Bytes.nullSafeGet(superColName))) continue;
            return superColumn;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public static SuperColumn getSuperColumn(List<SuperColumn> superColumns, String superColName) throws ArrayIndexOutOfBoundsException {
        return Selector.getSuperColumn(superColumns, Bytes.fromUTF8(superColName));
    }

    public static String getColumnStringName(Column column) {
        return Bytes.toUTF8(column.getName());
    }

    public static String getColumnStringValue(Column column) {
        return Bytes.toUTF8(column.getValue());
    }

    public static String getColumnValue(List<Column> columns, String colName, String defaultValue) {
        return Selector.getColumnValue(columns, Bytes.fromUTF8(colName), defaultValue);
    }

    public static Bytes getColumnValue(List<Column> columns, String colName, Bytes defaultValue) {
        return Selector.getColumnValue(columns, Bytes.fromUTF8(colName), defaultValue);
    }

    public static Bytes getColumnValue(List<Column> columns, Bytes colName, Bytes defaultValue) {
        for (Column column : columns) {
            if (!column.name.equals(Bytes.nullSafeGet(colName))) continue;
            return Bytes.fromByteBuffer(column.value);
        }
        return defaultValue;
    }

    public static long getCountColumnValue(List<CounterColumn> columns, Bytes colName, Long defaultValue) {
        for (CounterColumn column : columns) {
            if (!column.name.equals(Bytes.nullSafeGet(colName))) continue;
            return column.value;
        }
        return defaultValue;
    }

    public static long getCountColumnValue(List<CounterColumn> columns, String colName, Long defaultValue) {
        return Selector.getCountColumnValue(columns, Bytes.fromUTF8(colName), defaultValue);
    }

    public static String getColumnValue(List<Column> columns, Bytes colName, String defaultValue) {
        for (Column column : columns) {
            if (!column.name.equals(Bytes.nullSafeGet(colName))) continue;
            return Bytes.toUTF8(column.value);
        }
        return defaultValue;
    }

    public static boolean columnExists(List<Column> columns, Bytes colName) {
        for (Column column : columns) {
            if (!column.name.equals(Bytes.nullSafeGet(colName))) continue;
            return true;
        }
        return false;
    }

    public static boolean columnExists(List<Column> columns, String colName) {
        return Selector.columnExists(columns, Bytes.fromUTF8(colName));
    }

    public static Bytes getColumnValue(List<Column> columns, Bytes colName) throws ArrayIndexOutOfBoundsException {
        for (Column column : columns) {
            if (!column.name.equals(Bytes.nullSafeGet(colName))) continue;
            return Bytes.fromByteBuffer(column.value);
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public static Bytes getColumnValue(List<Column> columns, String colName) throws ArrayIndexOutOfBoundsException {
        return Selector.getColumnValue(columns, Bytes.fromUTF8(colName));
    }

    public static String getColumnStringValue(List<Column> columns, String colName) throws ArrayIndexOutOfBoundsException {
        return Selector.getColumnStringValue(columns, Bytes.fromUTF8(colName));
    }

    public static String getColumnStringValue(List<Column> columns, Bytes colName) throws ArrayIndexOutOfBoundsException {
        for (Column column : columns) {
            if (!column.name.equals(Bytes.nullSafeGet(colName))) continue;
            return Bytes.toUTF8(column.value);
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public static long getColumnTimestamp(List<Column> columns, Bytes colName) throws ArrayIndexOutOfBoundsException {
        for (Column column : columns) {
            if (!column.name.equals(Bytes.nullSafeGet(colName))) continue;
            return column.getTimestamp();
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public static long getColumnTimestamp(List<Column> columns, String colName) throws ArrayIndexOutOfBoundsException {
        return Selector.getColumnTimestamp(columns, Bytes.fromUTF8(colName));
    }

    public Selector(IThriftPool thrift) {
        super(thrift);
    }

    private static ColumnPath newColumnPath(String columnFamily, Bytes superColName, Bytes colName) {
        ColumnPath path = new ColumnPath(columnFamily);
        path.setSuper_column(Bytes.nullSafeGet(superColName));
        path.setColumn(Bytes.nullSafeGet(colName));
        return path;
    }

    private static ColumnParent newColumnParent(String columnFamily, String superColName) {
        return Selector.newColumnParent(columnFamily, Bytes.fromUTF8(superColName));
    }

    private static ColumnParent newColumnParent(String columnFamily, Bytes superColName) {
        ColumnParent parent = new ColumnParent(columnFamily);
        parent.setSuper_column(Bytes.nullSafeGet(superColName));
        return parent;
    }

    public static ColumnParent newColumnParent(String columnFamily) {
        return new ColumnParent(columnFamily);
    }
}

