/*
 * Decompiled with CFR 0.152.
 */
package org.scale7.cassandra.pelops;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;

public class Bytes {
    public static final Bytes EMPTY = Bytes.fromByteArray(new byte[0]);
    public static final Bytes NULL = Bytes.fromByteBuffer(null);
    private final ByteBuffer bytes;
    private int hashCode = -1;

    @Deprecated
    public Bytes(byte[] bytes) {
        this(ByteBuffer.wrap(bytes), false);
    }

    @Deprecated
    public Bytes(ByteBuffer bytes) {
        this(bytes, true);
    }

    private Bytes(ByteBuffer bytes, boolean duplicate) {
        if (bytes != null) {
            this.bytes = duplicate ? bytes.duplicate() : (ByteBuffer)bytes.rewind();
            this.bytes.mark();
        } else {
            this.bytes = null;
        }
    }

    public String toString() {
        if (this.isNull()) {
            return null;
        }
        this.bytes.reset();
        return Arrays.toString(Arrays.copyOfRange(this.bytes.array(), this.bytes.position(), this.bytes.limit()));
    }

    public ByteBuffer getBytes() {
        return this.bytes;
    }

    public Bytes duplicate() {
        return this.isNull() ? NULL : new Bytes(this.bytes, true);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Bytes)) {
            return false;
        }
        Bytes bytes = (Bytes)o;
        return this.bytes.equals(bytes.bytes);
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            this.hashCode = this.bytes.hashCode();
        }
        return this.hashCode;
    }

    public int length() {
        return this.bytes.remaining();
    }

    @Deprecated
    public static Bytes fromBytes(byte[] value) {
        return Bytes.fromByteArray(value);
    }

    public static Bytes fromByteArray(byte[] value) {
        return new Bytes(BufferHelper.fromByteArray(value), false);
    }

    public static Bytes fromByteBuffer(ByteBuffer value) {
        return new Bytes(value, true);
    }

    public static Bytes fromChar(char value) {
        return new Bytes(BufferHelper.fromChar(value), false);
    }

    public static Bytes fromChar(Character value) {
        return value == null ? NULL : Bytes.fromChar(value.charValue());
    }

    public static Bytes fromByte(byte value) {
        return new Bytes(BufferHelper.fromByte(value), false);
    }

    public static Bytes fromByte(Byte value) {
        return value == null ? NULL : Bytes.fromByte((byte)value);
    }

    public static Bytes fromLong(long value) {
        return new Bytes(BufferHelper.fromLong(value), false);
    }

    public static Bytes fromLong(Long value) {
        return value == null ? NULL : Bytes.fromLong((long)value);
    }

    public static Bytes fromInt(int value) {
        return new Bytes(BufferHelper.fromInt(value), false);
    }

    public static Bytes fromInt(Integer value) {
        return value == null ? NULL : Bytes.fromInt((int)value);
    }

    public static Bytes fromShort(short value) {
        return new Bytes(BufferHelper.fromShort(value), false);
    }

    public static Bytes fromShort(Short value) {
        return value == null ? NULL : Bytes.fromShort((short)value);
    }

    public static Bytes fromDouble(double value) {
        return new Bytes(BufferHelper.fromDouble(value), false);
    }

    public static Bytes fromDouble(Double value) {
        return value == null ? NULL : Bytes.fromDouble((double)value);
    }

    public static Bytes fromFloat(float value) {
        return new Bytes(BufferHelper.fromFloat(value), false);
    }

    public static Bytes fromFloat(Float value) {
        return value == null ? NULL : Bytes.fromFloat(value.floatValue());
    }

    public static Bytes fromBoolean(boolean value) {
        return new Bytes(BufferHelper.fromBoolean(value), false);
    }

    public static Bytes fromBoolean(Boolean value) {
        return value == null ? NULL : Bytes.fromBoolean((boolean)value);
    }

    public static Bytes fromUuid(UUID value) {
        return value == null ? NULL : new Bytes(BufferHelper.fromUuid(value), false);
    }

    public static Bytes fromUuid(String value) {
        return value == null ? NULL : new Bytes(BufferHelper.fromUuid(value), false);
    }

    public static Bytes fromUuid(long msb, long lsb) {
        return new Bytes(BufferHelper.fromUuid(msb, lsb), false);
    }

    public static Bytes fromTimeUuid(com.eaio.uuid.UUID value) {
        return value == null ? NULL : Bytes.fromUuid(value.getTime(), value.getClockSeqAndNode());
    }

    @Deprecated
    public static Bytes fromTimeUuid(UUID value) {
        return Bytes.fromUuid(value);
    }

    @Deprecated
    public static Bytes fromTimeUuid(String value) {
        return Bytes.fromUuid(value);
    }

    @Deprecated
    public static Bytes fromTimeUuid(long time, long clockSeqAndNode) {
        return Bytes.fromUuid(time, clockSeqAndNode);
    }

    public static Bytes fromUTF8(String value) {
        return value == null ? NULL : new Bytes(BufferHelper.fromUTF8(value), false);
    }

    public Character toChar(Character defaultIfNull) {
        if (this.isNull()) {
            return defaultIfNull;
        }
        return Character.valueOf(this.toChar());
    }

    public char toChar() throws IllegalStateException {
        try {
            this.bytes.reset();
            char c = this.bytes.getChar();
            return c;
        }
        catch (BufferUnderflowException e) {
            throw new IllegalStateException("Failed to read value due to invalid format.  See cause for details...", e);
        }
        finally {
            this.bytes.reset();
        }
    }

    public byte[] toByteArray(byte[] defaultIfNull) {
        if (this.isNull()) {
            return defaultIfNull;
        }
        return this.toByteArray();
    }

    public byte[] toByteArray() throws IllegalStateException {
        try {
            this.bytes.reset();
            byte[] byArray = Arrays.copyOfRange(this.bytes.array(), this.bytes.position(), this.bytes.limit());
            return byArray;
        }
        catch (BufferUnderflowException e) {
            throw new IllegalStateException("Failed to read value due to invalid format.  See cause for details...", e);
        }
        finally {
            this.bytes.reset();
        }
    }

    public Byte toByte(Byte defaultIfNull) {
        if (this.isNull()) {
            return defaultIfNull;
        }
        return this.toByte();
    }

    public byte toByte() throws IllegalStateException {
        try {
            this.bytes.reset();
            byte by = this.bytes.get();
            return by;
        }
        catch (BufferUnderflowException e) {
            throw new IllegalStateException("Failed to read value due to invalid format.  See cause for details...", e);
        }
        finally {
            this.bytes.reset();
        }
    }

    private static ByteBuffer padValue(int totalLength, ByteBuffer originalByteBuffer) {
        if (originalByteBuffer.capacity() >= totalLength) {
            return originalByteBuffer;
        }
        byte[] originalByteArray = originalByteBuffer.array();
        byte[] newByteArray = new byte[totalLength];
        for (int i = originalByteArray.length - 1; i >= 0; --i) {
            newByteArray[totalLength - 1 - i] = originalByteArray[i];
        }
        return ByteBuffer.wrap(newByteArray);
    }

    public Long toLong(Long defaultIfNull) {
        if (this.isNull()) {
            return defaultIfNull;
        }
        return this.toLong();
    }

    public long toLong() throws IllegalStateException {
        try {
            this.bytes.reset();
            long l = Bytes.padValue(8, this.bytes).getLong();
            return l;
        }
        catch (BufferUnderflowException e) {
            throw new IllegalStateException("Failed to read value due to invalid format.  See cause for details...", e);
        }
        finally {
            this.bytes.reset();
        }
    }

    public Integer toInt(Integer defaultIfNull) {
        if (this.isNull()) {
            return defaultIfNull;
        }
        return this.toInt();
    }

    public int toInt() throws IllegalStateException {
        try {
            this.bytes.reset();
            int n = Bytes.padValue(4, this.bytes).getInt();
            return n;
        }
        catch (BufferUnderflowException e) {
            throw new IllegalStateException("Failed to read value due to invalid format.  See cause for details...", e);
        }
        finally {
            this.bytes.reset();
        }
    }

    public Short toShort(Short defaultIfNull) {
        if (this.isNull()) {
            return defaultIfNull;
        }
        return this.toShort();
    }

    public short toShort() throws IllegalStateException {
        try {
            this.bytes.reset();
            short s = Bytes.padValue(2, this.bytes).getShort();
            return s;
        }
        catch (BufferUnderflowException e) {
            throw new IllegalStateException("Failed to read value due to invalid format.  See cause for details...", e);
        }
        finally {
            this.bytes.reset();
        }
    }

    public Double toDouble(Double defaultIfNull) {
        if (this.isNull()) {
            return defaultIfNull;
        }
        return this.toDouble();
    }

    public double toDouble() throws IllegalStateException {
        try {
            this.bytes.reset();
            double d = this.bytes.getDouble();
            return d;
        }
        catch (BufferUnderflowException e) {
            throw new IllegalStateException("Failed to read value due to invalid format.  See cause for details...", e);
        }
        finally {
            this.bytes.reset();
        }
    }

    public Float toFloat(Float defaultIfNull) {
        if (this.isNull()) {
            return defaultIfNull;
        }
        return Float.valueOf(this.toFloat());
    }

    public float toFloat() throws IllegalStateException {
        try {
            this.bytes.reset();
            float f = this.bytes.getFloat();
            return f;
        }
        catch (BufferUnderflowException e) {
            throw new IllegalStateException("Failed to read value due to invalid format.  See cause for details...", e);
        }
        finally {
            this.bytes.reset();
        }
    }

    public Boolean toBoolean(Boolean defaultIfNull) {
        if (this.isNull()) {
            return defaultIfNull;
        }
        return this.toBoolean();
    }

    public boolean toBoolean() throws IllegalStateException {
        try {
            this.bytes.reset();
            boolean bl = this.bytes.get() != 0;
            return bl;
        }
        catch (BufferUnderflowException e) {
            throw new IllegalStateException("Failed to read value due to invalid format.  See cause for details...", e);
        }
        finally {
            this.bytes.reset();
        }
    }

    public UUID toUuid() throws IllegalStateException {
        if (this.isNull()) {
            return null;
        }
        try {
            this.bytes.reset();
            long msb = this.bytes.getLong();
            long lsb = this.bytes.getLong();
            UUID uUID = new UUID(msb, lsb);
            return uUID;
        }
        catch (BufferUnderflowException e) {
            throw new IllegalStateException("Failed to read value due to invalid format.  See cause for details...", e);
        }
        finally {
            this.bytes.reset();
        }
    }

    public com.eaio.uuid.UUID toTimeUuid() throws IllegalStateException {
        UUID uuid = this.toUuid();
        if (uuid == null) {
            return null;
        }
        return new com.eaio.uuid.UUID(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits());
    }

    public static UUID uuidFromBytes(byte[] uuid) {
        int i;
        long msb = 0L;
        long lsb = 0L;
        assert (uuid.length == 16);
        for (i = 0; i < 8; ++i) {
            msb = msb << 8 | (long)(uuid[i] & 0xFF);
        }
        for (i = 8; i < 16; ++i) {
            lsb = lsb << 8 | (long)(uuid[i] & 0xFF);
        }
        return new UUID(msb, lsb);
    }

    @Deprecated
    public static UUID timeUuidFromBytes(byte[] uuid) {
        return Bytes.uuidFromBytes(uuid);
    }

    public static String utf8UuidFromBytes(byte[] uuid) {
        return Bytes.uuidFromBytes(uuid).toString();
    }

    @Deprecated
    public static String utf8TimeUuidFromBytes(byte[] uuid) {
        return Bytes.utf8UuidFromBytes(uuid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toUTF8() {
        if (this.isNull()) {
            return null;
        }
        try {
            this.bytes.reset();
            String string = new String(this.bytes.array(), this.bytes.position(), this.bytes.remaining(), BufferHelper.UTF8);
            return string;
        }
        finally {
            this.bytes.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toUTF8(ByteBuffer bytes) {
        if (bytes == null) {
            return null;
        }
        int position = bytes.position();
        try {
            String string = new String(bytes.array(), position, bytes.remaining(), BufferHelper.UTF8);
            return string;
        }
        finally {
            bytes.position(position);
        }
    }

    public static String toUTF8(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        return new String(bytes, BufferHelper.UTF8);
    }

    public static Set<ByteBuffer> transformBytesToSet(Collection<Bytes> arrays) {
        if (arrays == null) {
            return null;
        }
        HashSet<ByteBuffer> transformed = new HashSet<ByteBuffer>(arrays.size());
        for (Bytes array : arrays) {
            transformed.add(array.getBytes());
        }
        return transformed;
    }

    public static List<ByteBuffer> transformBytesToList(Collection<Bytes> arrays) {
        if (arrays == null) {
            return null;
        }
        ArrayList<ByteBuffer> transformed = new ArrayList<ByteBuffer>(arrays.size());
        for (Bytes array : arrays) {
            transformed.add(array.getBytes());
        }
        return transformed;
    }

    public static Set<ByteBuffer> transformUTF8ToSet(Collection<String> strings) {
        if (strings == null) {
            return null;
        }
        HashSet<ByteBuffer> transformed = new HashSet<ByteBuffer>(strings.size());
        for (String string : strings) {
            transformed.add(Bytes.fromUTF8(string).getBytes());
        }
        return transformed;
    }

    public static List<ByteBuffer> transformUTF8ToList(Collection<String> strings) {
        if (strings == null) {
            return null;
        }
        ArrayList<ByteBuffer> transformed = new ArrayList<ByteBuffer>(strings.size());
        for (String string : strings) {
            transformed.add(Bytes.fromUTF8(string).getBytes());
        }
        return transformed;
    }

    public static ByteBuffer nullSafeGet(Bytes bytes) {
        return bytes == null ? null : bytes.getBytes();
    }

    public boolean isNull() {
        return this.bytes == null;
    }

    public static CompositeBuilder composite() {
        return new CompositeBuilder(2);
    }

    public static CompositeBuilder composite(int parts) {
        return new CompositeBuilder(parts);
    }

    public static class BufferHelper {
        static final int SIZEOF_BYTE = 1;
        static final int SIZEOF_BOOLEAN = 1;
        static final byte BOOLEAN_TRUE = 1;
        static final byte BOOLEAN_FALSE = 0;
        static final int SIZEOF_CHAR = 2;
        static final int SIZEOF_SHORT = 2;
        static final int SIZEOF_INT = 4;
        static final int SIZEOF_LONG = 8;
        static final int SIZEOF_FLOAT = 4;
        static final int SIZEOF_DOUBLE = 8;
        static final int SIZEOF_UUID = 16;
        public static final Charset UTF8 = Charset.forName("UTF-8");

        private BufferHelper() {
        }

        public static ByteBuffer fromByteArray(byte[] value) {
            return ByteBuffer.wrap(value);
        }

        public static ByteBuffer fromChar(char value) {
            return ByteBuffer.allocate(2).putChar(value);
        }

        public static ByteBuffer fromByte(byte value) {
            return ByteBuffer.allocate(1).put(value);
        }

        public static ByteBuffer fromLong(long value) {
            return ByteBuffer.allocate(8).putLong(value);
        }

        public static ByteBuffer fromInt(int value) {
            return ByteBuffer.allocate(4).putInt(value);
        }

        public static ByteBuffer fromShort(short value) {
            return ByteBuffer.allocate(2).putShort(value);
        }

        public static ByteBuffer fromDouble(double value) {
            return ByteBuffer.allocate(8).putDouble(value);
        }

        public static ByteBuffer fromFloat(float value) {
            return ByteBuffer.allocate(4).putFloat(value);
        }

        public static ByteBuffer fromBoolean(boolean value) {
            return ByteBuffer.allocate(1).put(value ? (byte)1 : 0);
        }

        public static ByteBuffer fromUuid(UUID value) {
            return BufferHelper.fromUuid(value.getMostSignificantBits(), value.getLeastSignificantBits());
        }

        public static ByteBuffer fromUuid(String value) {
            return BufferHelper.fromUuid(UUID.fromString(value));
        }

        public static ByteBuffer fromUuid(long msb, long lsb) {
            return ByteBuffer.allocate(16).putLong(msb).putLong(lsb);
        }

        public static ByteBuffer fromUTF8(String value) {
            return BufferHelper.fromByteArray(value.getBytes(UTF8));
        }
    }

    public static class CompositeBuilder {
        private List<ByteBuffer> parts;
        private int length;

        public CompositeBuilder(int count) {
            this.parts = new ArrayList<ByteBuffer>(count);
        }

        public CompositeBuilder addByteBuffer(ByteBuffer value) {
            this.parts.add(value);
            this.length += value.rewind().remaining();
            return this;
        }

        public CompositeBuilder addBytes(Bytes value) {
            return this.addByteBuffer(value.getBytes());
        }

        public CompositeBuilder addBoolean(boolean value) {
            return this.addByteBuffer(BufferHelper.fromBoolean(value));
        }

        public CompositeBuilder addBoolean(Boolean value) {
            return this.addByteBuffer(BufferHelper.fromBoolean(value));
        }

        public CompositeBuilder addByte(byte value) {
            return this.addByteBuffer(BufferHelper.fromByte(value));
        }

        public CompositeBuilder addByte(Byte value) {
            return this.addByteBuffer(BufferHelper.fromByte(value));
        }

        public CompositeBuilder addByteArray(byte[] value) {
            return this.addByteBuffer(BufferHelper.fromByteArray(value));
        }

        public CompositeBuilder addChar(char value) {
            return this.addByteBuffer(BufferHelper.fromChar(value));
        }

        public CompositeBuilder addChar(Character value) {
            return this.addByteBuffer(BufferHelper.fromChar(value.charValue()));
        }

        public CompositeBuilder addDouble(double value) {
            return this.addByteBuffer(BufferHelper.fromDouble(value));
        }

        public CompositeBuilder addDouble(Double value) {
            return this.addByteBuffer(BufferHelper.fromDouble(value));
        }

        public CompositeBuilder addFloat(float value) {
            return this.addByteBuffer(BufferHelper.fromFloat(value));
        }

        public CompositeBuilder addFloat(Float value) {
            return this.addByteBuffer(BufferHelper.fromFloat(value.floatValue()));
        }

        public CompositeBuilder addInt(int value) {
            return this.addByteBuffer(BufferHelper.fromInt(value));
        }

        public CompositeBuilder addInt(Integer value) {
            return this.addByteBuffer(BufferHelper.fromInt(value));
        }

        public CompositeBuilder addLong(long value) {
            return this.addByteBuffer(BufferHelper.fromLong(value));
        }

        public CompositeBuilder addLong(Long value) {
            return this.addByteBuffer(BufferHelper.fromLong(value));
        }

        public CompositeBuilder addShort(short value) {
            return this.addByteBuffer(BufferHelper.fromShort(value));
        }

        public CompositeBuilder addShort(Short value) {
            return this.addByteBuffer(BufferHelper.fromShort(value));
        }

        public CompositeBuilder addUTF8(String str) {
            return this.addByteBuffer(BufferHelper.fromUTF8(str));
        }

        public CompositeBuilder addUuid(UUID value) {
            return this.addByteBuffer(BufferHelper.fromUuid(value));
        }

        public CompositeBuilder addUuid(String value) {
            return this.addByteBuffer(BufferHelper.fromUuid(value));
        }

        public CompositeBuilder addUuid(long msb, long lsb) {
            return this.addByteBuffer(BufferHelper.fromUuid(msb, lsb));
        }

        public CompositeBuilder addTimeUuid(com.eaio.uuid.UUID value) {
            return this.addByteBuffer(BufferHelper.fromUuid(value.getTime(), value.getClockSeqAndNode()));
        }

        @Deprecated
        public CompositeBuilder addTimeUuid(UUID value) {
            return this.addUuid(value);
        }

        @Deprecated
        public CompositeBuilder addTimeUuid(String value) {
            return this.addUuid(value);
        }

        @Deprecated
        public CompositeBuilder addTimeUuid(long time, long clockSeqAndNode) {
            return this.addUuid(time, clockSeqAndNode);
        }

        public Bytes build() {
            ByteBuffer buffer = ByteBuffer.allocate(this.length);
            for (ByteBuffer part : this.parts) {
                buffer.put(part);
            }
            return new Bytes(buffer, false);
        }
    }
}

