/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.formula.functions;

import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.poi.ss.formula.eval.ErrorEval;
import org.apache.poi.ss.formula.eval.EvaluationException;
import org.apache.poi.ss.formula.eval.NumberEval;
import org.apache.poi.ss.formula.eval.OperandResolver;
import org.apache.poi.ss.formula.eval.ValueEval;
import org.apache.poi.ss.formula.functions.Fixed1ArgFunction;
import org.apache.poi.ss.formula.functions.Function;
import org.apache.poi.ss.usermodel.DateUtil;

public final class CalendarFieldFunction
extends Fixed1ArgFunction {
    public static final Function YEAR = new CalendarFieldFunction(1, false);
    public static final Function MONTH = new CalendarFieldFunction(2, true);
    public static final Function DAY = new CalendarFieldFunction(5, false);
    private final int _dateFieldId;
    private final boolean _needsOneBaseAdjustment;

    private CalendarFieldFunction(int dateFieldId, boolean needsOneBaseAdjustment) {
        this._dateFieldId = dateFieldId;
        this._needsOneBaseAdjustment = needsOneBaseAdjustment;
    }

    public final ValueEval evaluate(int srcRowIndex, int srcColumnIndex, ValueEval arg0) {
        int val;
        try {
            ValueEval ve = OperandResolver.getSingleValue(arg0, srcRowIndex, srcColumnIndex);
            val = OperandResolver.coerceValueToInt(ve);
        }
        catch (EvaluationException e) {
            return e.getErrorEval();
        }
        if (val < 0) {
            return ErrorEval.NUM_ERROR;
        }
        return new NumberEval(this.getCalField(val));
    }

    private int getCalField(int serialDay) {
        if (serialDay == 0) {
            switch (this._dateFieldId) {
                case 1: {
                    return 1900;
                }
                case 2: {
                    return 1;
                }
                case 5: {
                    return 0;
                }
            }
            throw new IllegalStateException("bad date field " + this._dateFieldId);
        }
        Date d = DateUtil.getJavaDate(serialDay, false);
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(d);
        int result = c.get(this._dateFieldId);
        if (this._needsOneBaseAdjustment) {
            ++result;
        }
        return result;
    }
}

