/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.tool;

import au.org.ala.biocache.Config$;
import au.org.ala.biocache.ObserverCallback;
import au.org.ala.biocache.index.IndexRecords$;
import au.org.ala.biocache.load.Loader;
import au.org.ala.biocache.tool.DataResourceVirtualDelete;
import au.org.ala.biocache.tool.ProcessRecords$;
import au.org.ala.biocache.util.OptionParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

public final class ReloadDataResources$ {
    public static final ReloadDataResources$ MODULE$;
    private final Logger logger;

    static {
        new ReloadDataResources$();
    }

    public Logger logger() {
        return this.logger;
    }

    public void main(String[] args) {
        ObjectRef dataResource = new ObjectRef((Object)"");
        BooleanRef mark = new BooleanRef(false);
        BooleanRef load2 = new BooleanRef(false);
        BooleanRef remove = new BooleanRef(false);
        BooleanRef process2 = new BooleanRef(false);
        BooleanRef index = new BooleanRef(false);
        OptionParser parser = new OptionParser(dataResource, mark, load2, remove, process2, index){
            {
                this.arg("<data resource UID>", "The UID of the data resource to load", (Function1<String, BoxedUnit>)new Serializable(this, dataResource$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef dataResource$1;

                    public final void apply(String v) {
                        this.dataResource$1.elem = v;
                    }
                    {
                        this.dataResource$1 = dataResource$1;
                    }
                });
                this.opt("all", "perform all phases", (Function0<BoxedUnit>)new Serializable(this, mark$1, load$1, remove$1, process$1, index$1){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef mark$1;
                    private final BooleanRef load$1;
                    private final BooleanRef remove$1;
                    private final BooleanRef process$1;
                    private final BooleanRef index$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.mark$1.elem = true;
                        this.load$1.elem = true;
                        this.remove$1.elem = true;
                        this.process$1.elem = true;
                        this.index$1.elem = true;
                    }
                    {
                        this.mark$1 = mark$1;
                        this.load$1 = load$1;
                        this.remove$1 = remove$1;
                        this.process$1 = process$1;
                        this.index$1 = index$1;
                    }
                });
                this.opt("mark", "mark the occurrences in the data store as deleted", (Function0<BoxedUnit>)new Serializable(this, mark$1){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef mark$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.mark$1.elem = true;
                    }
                    {
                        this.mark$1 = mark$1;
                    }
                });
                this.opt("load", "reload the records from the data resource", (Function0<BoxedUnit>)new Serializable(this, load$1){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef load$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.load$1.elem = true;
                    }
                    {
                        this.load$1 = load$1;
                    }
                });
                this.opt("remove", "remove the occurrences from the data store", (Function0<BoxedUnit>)new Serializable(this, remove$1){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef remove$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.remove$1.elem = true;
                    }
                    {
                        this.remove$1 = remove$1;
                    }
                });
                this.opt("process", "reprocess the records for the data resource", (Function0<BoxedUnit>)new Serializable(this, process$1){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef process$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.process$1.elem = true;
                    }
                    {
                        this.process$1 = process$1;
                    }
                });
                this.opt("index", "reindex the records for the data resource", (Function0<BoxedUnit>)new Serializable(this, index$1){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef index$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.index$1.elem = true;
                    }
                    {
                        this.index$1 = index$1;
                    }
                });
            }
        };
        if (parser.parse((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])args))) {
            this.logger().info(new StringBuilder().append((Object)"Reloading data resource ").append((Object)((String)dataResource.elem)).append((Object)" reprocessing: ").append((Object)BoxesRunTime.boxToBoolean((boolean)process2.elem)).append((Object)" reindexing: ").append((Object)BoxesRunTime.boxToBoolean((boolean)index.elem)).append((Object)" removing from data store: ").append((Object)BoxesRunTime.boxToBoolean((boolean)remove.elem)).toString());
            this.completeReload((String)dataResource.elem, mark.elem, load2.elem, process2.elem, index.elem, remove.elem);
            if (index.elem) {
                Config$.MODULE$.indexDAO().shutdown();
            }
        }
    }

    public void completeReload(String dataResourceUid, boolean mark, boolean load2, boolean process2, boolean index, boolean remove) {
        DataResourceVirtualDelete deletor = new DataResourceVirtualDelete(dataResourceUid);
        if (mark) {
            deletor.deleteFromPersistent();
        }
        if (load2) {
            Loader l = new Loader();
            l.load(dataResourceUid, l.load$default$2(), l.load$default$3(), l.load$default$4());
        }
        if (process2) {
            ProcessRecords$.MODULE$.processRecords(4, (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)dataResourceUid), true, ProcessRecords$.MODULE$.processRecords$default$5(), ProcessRecords$.MODULE$.processRecords$default$6());
        }
        if (index) {
            deletor.deleteFromIndex();
            None$ x$1 = None$.MODULE$;
            None$ x$2 = None$.MODULE$;
            Some x$3 = new Some((Object)dataResourceUid);
            boolean x$4 = false;
            boolean x$5 = false;
            boolean x$6 = true;
            Option<String> x$7 = IndexRecords$.MODULE$.index$default$6();
            int x$8 = IndexRecords$.MODULE$.index$default$8();
            Seq<String> x$9 = IndexRecords$.MODULE$.index$default$9();
            Seq<String> x$10 = IndexRecords$.MODULE$.index$default$10();
            ObserverCallback x$11 = IndexRecords$.MODULE$.index$default$11();
            boolean x$12 = IndexRecords$.MODULE$.index$default$12();
            IndexRecords$.MODULE$.index((Option<String>)x$1, (Option<String>)x$2, (Option<String>)x$3, x$4, x$5, x$7, x$6, x$8, x$9, x$10, x$11, x$12);
        }
        if (remove) {
            deletor.physicallyDeleteMarkedRecords();
        }
    }

    public boolean completeReload$default$2() {
        return true;
    }

    public boolean completeReload$default$3() {
        return true;
    }

    public boolean completeReload$default$4() {
        return true;
    }

    public boolean completeReload$default$5() {
        return true;
    }

    public boolean completeReload$default$6() {
        return true;
    }

    private ReloadDataResources$() {
        MODULE$ = this;
        this.logger = LoggerFactory.getLogger((String)"ReloadDataResources");
    }
}

