/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.tool;

import au.org.ala.biocache.Config$;
import au.org.ala.biocache.cmd.Tool;
import au.org.ala.biocache.cmd.Tool$class;
import au.org.ala.biocache.model.FullRecord;
import au.org.ala.biocache.model.Processed$;
import au.org.ala.biocache.processor.RecordProcessor;
import au.org.ala.biocache.util.OptionParser;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;

public final class ProcessUuids$
implements Tool {
    public static final ProcessUuids$ MODULE$;
    private final Logger logger;

    static {
        new ProcessUuids$();
    }

    @Override
    public String help() {
        return Tool$class.help(this);
    }

    public Logger logger() {
        return this.logger;
    }

    @Override
    public String cmd() {
        return "process-uuids";
    }

    @Override
    public String desc() {
        return "Process a list of records specified by a comma separated uuid string";
    }

    @Override
    public void main(String[] args) {
        ObjectRef uuids = new ObjectRef((Object)"");
        OptionParser parser = new OptionParser(uuids){
            {
                this.arg("uuids", "UUIDs", (Function1<String, BoxedUnit>)new Serializable(this, uuids$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef uuids$1;

                    public final void apply(String v) {
                        this.uuids$1.elem = v;
                    }
                    {
                        this.uuids$1 = uuids$1;
                    }
                });
            }
        };
        if (parser.parse((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])args))) {
            this.processRecords((String)uuids.elem);
        }
    }

    public void processRecords(String uuids) {
        RecordProcessor processor = new RecordProcessor();
        Predef$.MODULE$.refArrayOps((Object[])uuids.split(",")).foreach((Function1)new Serializable(processor){
            public static final long serialVersionUID = 0L;
            private final RecordProcessor processor$1;

            public final void apply(String uuid) {
                Option<FullRecord[]> records = Config$.MODULE$.occurrenceDAO().getAllVersionsByRowKey(uuid, Config$.MODULE$.occurrenceDAO().getAllVersionsByRowKey$default$2());
                if (records.isEmpty()) {
                    records = Config$.MODULE$.occurrenceDAO().getAllVersionsByUuid(uuid, Config$.MODULE$.occurrenceDAO().getAllVersionsByUuid$default$2());
                }
                if (records.isEmpty()) {
                    ProcessUuids$.MODULE$.logger().info(new StringBuilder().append((Object)"UUID or row key not stored: ").append((Object)uuid).toString());
                } else {
                    ProcessUuids$.MODULE$.logger().info(new StringBuilder().append((Object)"Processing record: ").append((Object)uuid).toString());
                    this.processor$1.processRecord(((FullRecord[])records.get())[0], ((FullRecord[])records.get())[1], this.processor$1.processRecord$default$3(), this.processor$1.processRecord$default$4());
                    Option<FullRecord> processedRecord = Config$.MODULE$.occurrenceDAO().getByRowKey(((FullRecord[])records.get())[1].rowKey(), Processed$.MODULE$, Config$.MODULE$.occurrenceDAO().getByRowKey$default$3());
                    ObjectMapper objectMapper = new ObjectMapper();
                    if (processedRecord.isEmpty()) {
                        ProcessUuids$.MODULE$.logger().info(new StringBuilder().append((Object)"Record not found: ").append((Object)uuid).toString());
                    }
                }
            }
            {
                this.processor$1 = processor$1;
            }
        });
        Predef$.MODULE$.print((Object)"\n\nSupply a Row Key for a record: ");
    }

    public String readStdIn() {
        return new BufferedReader(new InputStreamReader(System.in)).readLine().trim();
    }

    private ProcessUuids$() {
        MODULE$ = this;
        Tool$class.$init$(this);
        this.logger = LoggerFactory.getLogger((String)"ProcessUuids");
    }
}

