/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.tool;

import au.org.ala.biocache.Config$;
import au.org.ala.biocache.ObserverCallback;
import au.org.ala.biocache.cmd.IncrementalTool;
import au.org.ala.biocache.cmd.IncrementalTool$class;
import au.org.ala.biocache.cmd.Tool;
import au.org.ala.biocache.cmd.Tool$class;
import au.org.ala.biocache.dao.OccurrenceDAO;
import au.org.ala.biocache.model.FullRecord;
import au.org.ala.biocache.persistence.PersistenceManager;
import au.org.ala.biocache.tool.Consumer;
import au.org.ala.biocache.tool.Consumer$;
import au.org.ala.biocache.tool.ProcessRecords$;
import au.org.ala.biocache.tool.ProcessedBatchWriter;
import au.org.ala.biocache.util.FileHelper$;
import au.org.ala.biocache.util.OptionParser;
import java.io.File;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.actors.Actor;
import scala.actors.Actor$;
import scala.actors.threadpool.LinkedBlockingQueue;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;

public final class ProcessRecords$
implements Tool,
IncrementalTool {
    public static final ProcessRecords$ MODULE$;
    private final OccurrenceDAO occurrenceDAO;
    private final PersistenceManager persistenceManager;
    private final Logger logger;

    static {
        new ProcessRecords$();
    }

    @Override
    public Option<String> getDeleteRowFile(String resourceUid) {
        return IncrementalTool$class.getDeleteRowFile(this, resourceUid);
    }

    @Override
    public Tuple2<Object, Option<String>> hasRowKey(String resourceUid) {
        return IncrementalTool$class.hasRowKey(this, resourceUid);
    }

    @Override
    public String help() {
        return Tool$class.help(this);
    }

    @Override
    public String cmd() {
        return "process";
    }

    @Override
    public String desc() {
        return "Process records (geospatial, taxonomy)";
    }

    public OccurrenceDAO occurrenceDAO() {
        return this.occurrenceDAO;
    }

    public PersistenceManager persistenceManager() {
        return this.persistenceManager;
    }

    public Logger logger() {
        return this.logger;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void main(String[] args) {
        this.logger().info("Starting processing...");
        IntRef threads = new IntRef(4);
        ObjectRef startUuid = new ObjectRef((Object)None$.MODULE$);
        ObjectRef endUuid = new ObjectRef((Object)None$.MODULE$);
        BooleanRef checkDeleted = new BooleanRef(false);
        ObjectRef dataResourceUid = new ObjectRef((Object)None$.MODULE$);
        BooleanRef checkRowKeyFile = new BooleanRef(false);
        String rowKeyFile = "";
        BooleanRef abortIfNotRowKeyFile = new BooleanRef(false);
        OptionParser parser = new OptionParser(threads, startUuid, endUuid, checkDeleted, dataResourceUid, checkRowKeyFile, abortIfNotRowKeyFile){
            {
                this.intOpt("t", "thread", "The number of threads to use", (Function1<Object, BoxedUnit>)new Serializable(this, threads$2){
                    public static final long serialVersionUID = 0L;
                    private final IntRef threads$2;

                    public final void apply(int v) {
                        this.apply$mcVI$sp(v);
                    }

                    public void apply$mcVI$sp(int v) {
                        this.threads$2.elem = v;
                    }
                    {
                        this.threads$2 = threads$2;
                    }
                });
                this.opt("s", "start", "The record to start with", (Function1<String, BoxedUnit>)new Serializable(this, startUuid$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef startUuid$1;

                    public final void apply(String v) {
                        this.startUuid$1.elem = new Some((Object)v);
                    }
                    {
                        this.startUuid$1 = startUuid$1;
                    }
                });
                this.opt("e", "end", "The record to end with", (Function1<String, BoxedUnit>)new Serializable(this, endUuid$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef endUuid$1;

                    public final void apply(String v) {
                        this.endUuid$1.elem = new Some((Object)v);
                    }
                    {
                        this.endUuid$1 = endUuid$1;
                    }
                });
                this.opt("dr", "resource", "The data resource to process", (Function1<String, BoxedUnit>)new Serializable(this, dataResourceUid$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef dataResourceUid$1;

                    public final void apply(String v) {
                        this.dataResourceUid$1.elem = new Some((Object)v);
                    }
                    {
                        this.dataResourceUid$1 = dataResourceUid$1;
                    }
                });
                this.booleanOpt("cd", "checkDeleted", "Check deleted records", (Function1<Object, BoxedUnit>)new Serializable(this, checkDeleted$1){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef checkDeleted$1;

                    public final void apply(boolean v) {
                        this.checkDeleted$1.elem = v;
                    }
                    {
                        this.checkDeleted$1 = checkDeleted$1;
                    }
                });
                this.opt("crk", "check for row key file", (Function0<BoxedUnit>)new Serializable(this, checkRowKeyFile$1){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef checkRowKeyFile$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.checkRowKeyFile$1.elem = true;
                    }
                    {
                        this.checkRowKeyFile$1 = checkRowKeyFile$1;
                    }
                });
                this.opt("acrk", "abort if no row key file found", (Function0<BoxedUnit>)new Serializable(this, abortIfNotRowKeyFile$1){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef abortIfNotRowKeyFile$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.abortIfNotRowKeyFile$1.elem = true;
                    }
                    {
                        this.abortIfNotRowKeyFile$1 = abortIfNotRowKeyFile$1;
                    }
                });
            }
        };
        if (!parser.parse((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])args))) return;
        if (!((Option)dataResourceUid.elem).isEmpty() && checkRowKeyFile.elem) {
            Tuple2 tuple2;
            Tuple2<Object, Option<String>> tuple22 = this.hasRowKey((String)((Option)dataResourceUid.elem).get());
            if (tuple22 == null) throw new MatchError(tuple22);
            boolean hasRowKey = tuple22._1$mcZ$sp();
            Option retrievedRowKeyFile = (Option)tuple22._2();
            Tuple2 tuple23 = tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)hasRowKey), (Object)retrievedRowKeyFile);
            boolean hasRowKey2 = tuple23._1$mcZ$sp();
            Option retrievedRowKeyFile2 = (Option)tuple23._2();
            rowKeyFile = (String)retrievedRowKeyFile2.getOrElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "";
                }
            });
        }
        if (abortIfNotRowKeyFile.elem) {
            String string = rowKeyFile;
            String string2 = "";
            if (!(string == null ? string2 != null : !string.equals(string2)) || !new File(rowKeyFile).exists()) {
                this.logger().warn("No rowkey file was found for this processing. Aborting.");
                return;
            }
        }
        String string = rowKeyFile;
        String string3 = "";
        if (!(string != null ? !string.equals(string3) : string3 != null)) {
            this.logger().info(new StringBuilder().append((Object)"Processing ").append(((Option)dataResourceUid.elem).getOrElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "";
                }
            })).append((Object)" from ").append(((Option)startUuid.elem).getOrElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "*";
                }
            })).append((Object)" to ").append(((Option)endUuid.elem).getOrElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "*";
                }
            })).append((Object)" with ").append((Object)BoxesRunTime.boxToInteger((int)threads.elem)).append((Object)" actors").toString());
            int x$3 = threads.elem;
            Option x$4 = (Option)startUuid.elem;
            Option x$5 = (Option)dataResourceUid.elem;
            boolean x$6 = checkDeleted.elem;
            Option x$7 = (Option)endUuid.elem;
            ObserverCallback x$8 = this.processRecords$default$5();
            this.processRecords(x$3, (Option<String>)x$4, (Option<String>)x$5, x$6, x$8, (Option<String>)x$7);
            return;
        }
        this.processRecords(new File(rowKeyFile), threads.elem, (Option<String>)None$.MODULE$);
    }

    public void processRecords(File file, int threads, Option<String> startUuid) {
        this.processRecords0(file, threads, startUuid, this.processRecords0$default$4(), this.processRecords0$default$5(), this.processRecords0$default$6(), this.processRecords0$default$7());
    }

    public void processRecords(int threads, Option<String> firstKey, Option<String> dr, boolean checkDeleted, ObserverCallback callback, Option<String> lastKey) {
        this.processRecords0(null, threads, firstKey, dr, checkDeleted, callback, lastKey);
    }

    public void processRecords(List<String> rowKeys) {
        File file = File.createTempFile("uuids", "");
        FileUtils.writeStringToFile((File)file, (String)rowKeys.mkString("\n"));
        this.processRecords(file, 4, (Option<String>)None$.MODULE$);
    }

    public boolean processRecords$default$4() {
        return false;
    }

    public ObserverCallback processRecords$default$5() {
        return null;
    }

    public Option<String> processRecords$default$6() {
        return None$.MODULE$;
    }

    public void processRecords0(File file, int threads, Option<String> startUuid, Option<String> dr, boolean checkDeleted, ObserverCallback callback, Option<String> lastKey) {
        ObjectRef buff = new ObjectRef((Object)new LinkedBlockingQueue(1000));
        ObjectRef writeBuffer = new ObjectRef((Object)new LinkedBlockingQueue(threads));
        IntRef ids = new IntRef(0);
        ProcessedBatchWriter p = new ProcessedBatchWriter((LinkedBlockingQueue<Object>)((LinkedBlockingQueue)writeBuffer.elem), callback);
        p.start();
        ProcessedBatchWriter writer = p;
        this.logger().info(new StringBuilder().append((Object)"writer status: ").append((Object)writer.getState()).toString());
        Consumer[] pool = (Consumer[])Array$.MODULE$.fill(threads, (Function0)new Serializable(buff, writeBuffer, ids){
            public static final long serialVersionUID = 0L;
            private final ObjectRef buff$1;
            private final ObjectRef writeBuffer$1;
            private final IntRef ids$1;

            /*
             * WARNING - void declaration
             */
            public final Consumer apply() {
                void var1_1;
                Consumer p = new Consumer(Actor$.MODULE$.self(), this.ids$1.elem, (LinkedBlockingQueue<Object>)((LinkedBlockingQueue)this.buff$1.elem), (LinkedBlockingQueue<Object>)((LinkedBlockingQueue)this.writeBuffer$1.elem), Consumer$.MODULE$.$lessinit$greater$default$5());
                ++this.ids$1.elem;
                p.start();
                return var1_1;
            }
            {
                this.buff$1 = buff$1;
                this.writeBuffer$1 = writeBuffer$1;
                this.ids$1 = ids$1;
            }
        }, ClassTag$.MODULE$.apply(Consumer.class));
        this.logger().info("Starting to process a list of records...");
        long start = System.currentTimeMillis();
        long startTime = System.currentTimeMillis();
        long finishTime = System.currentTimeMillis();
        int count = file == null ? this.readFromDB(startUuid, dr, checkDeleted, lastKey, (LinkedBlockingQueue<Object>)((LinkedBlockingQueue)buff.elem)) : this.readUuidList(file, startUuid, (LinkedBlockingQueue<Object>)((LinkedBlockingQueue)buff.elem));
        this.logger().info("Finished reading.");
        Predef$.MODULE$.refArrayOps((Object[])pool).foreach((Function1)new Serializable(buff){
            public static final long serialVersionUID = 0L;
            private final ObjectRef buff$1;

            public final void apply(Consumer p) {
                ((LinkedBlockingQueue)this.buff$1.elem).put((Object)"exit");
            }
            {
                this.buff$1 = buff$1;
            }
        });
        Predef$.MODULE$.refArrayOps((Object[])pool).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Consumer p) {
                while (true) {
                    Enumeration.Value value = p.getState();
                    Enumeration.Value value2 = Actor.State$.MODULE$.Terminated();
                    if (!(value != null ? !value.equals(value2) : value2 != null)) {
                        return;
                    }
                    Thread.sleep(50L);
                }
            }
        });
        this.printTimings(pool);
        this.logger().info("Finished processing.");
        ((LinkedBlockingQueue)writeBuffer.elem).put((Object)"exit");
        while (true) {
            Enumeration.Value value = writer.getState();
            Enumeration.Value value2 = Actor.State$.MODULE$.Terminated();
            if (!(value != null ? !value.equals(value2) : value2 != null)) {
                this.logger().info("Finished writing.");
                return;
            }
            Thread.sleep(50L);
        }
    }

    public Option<String> processRecords0$default$4() {
        return null;
    }

    public boolean processRecords0$default$5() {
        return false;
    }

    public ObserverCallback processRecords0$default$6() {
        return null;
    }

    public Option<String> processRecords0$default$7() {
        return None$.MODULE$;
    }

    public int readFromDB(Option<String> firstKey, Option<String> dr, boolean checkDeleted, Option<String> lastKey, LinkedBlockingQueue<Object> buffer) {
        String endUuid = lastKey.isDefined() ? (String)lastKey.get() : (dr.isEmpty() ? "" : new StringBuilder().append((Object)((String)dr.get())).append((Object)"|~").toString());
        String startUuid = dr.isEmpty() ? (String)firstKey.getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        }) : new StringBuilder().append((Object)((String)dr.get())).append((Object)"|").toString();
        this.logger().info(new StringBuilder().append((Object)"Starting with ").append((Object)startUuid).append((Object)" ending with ").append((Object)endUuid).toString());
        long start = System.currentTimeMillis();
        long startTime = System.currentTimeMillis();
        long finishTime = System.currentTimeMillis();
        this.logger().debug("Initialised actors...");
        IntRef count = new IntRef(0);
        ObjectRef guid = new ObjectRef((Object)"");
        boolean batches = false;
        this.performPaging((Function1<Option<Tuple2<FullRecord, FullRecord>>, Object>)new Serializable(buffer, count, guid){
            public static final long serialVersionUID = 0L;
            private final LinkedBlockingQueue buffer$2;
            private final IntRef count$1;
            private final ObjectRef guid$1;

            public final boolean apply(Option<Tuple2<FullRecord, FullRecord>> rawAndProcessed) {
                String string = (String)this.guid$1.elem;
                String string2 = "";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    ProcessRecords$.MODULE$.logger().info(new StringBuilder().append((Object)"First rowKey processed: ").append((Object)((FullRecord)((Tuple2)rawAndProcessed.get())._1()).rowKey()).toString());
                }
                this.guid$1.elem = ((FullRecord)((Tuple2)rawAndProcessed.get())._1()).rowKey();
                ++this.count$1.elem;
                if (!rawAndProcessed.isEmpty() && !((FullRecord)((Tuple2)rawAndProcessed.get())._1()).deleted()) {
                    this.buffer$2.put(rawAndProcessed.get());
                }
                if (this.count$1.elem % 1000 == 0) {
                    ProcessRecords$.MODULE$.logger().info(new StringBuilder().append((Object)"records read: ").append((Object)BoxesRunTime.boxToInteger((int)this.count$1.elem)).toString());
                }
                return true;
            }
            {
                this.buffer$2 = buffer$2;
                this.count$1 = count$1;
                this.guid$1 = guid$1;
            }
        }, startUuid, endUuid, this.performPaging$default$4());
        return count.elem;
    }

    public boolean readFromDB$default$3() {
        return false;
    }

    public Option<String> readFromDB$default$4() {
        return None$.MODULE$;
    }

    public int readUuidList(File file, Option<String> startUuid, LinkedBlockingQueue<Object> buffer) {
        long startTime = System.currentTimeMillis();
        LongRef finishTime = new LongRef(System.currentTimeMillis());
        IntRef count = new IntRef(0);
        this.logger().debug("Initialised actors...");
        FileHelper$.MODULE$.file2helper(file).foreachLine((Function1<String, BoxedUnit>)new Serializable(startUuid, buffer, finishTime, count){
            public static final long serialVersionUID = 0L;
            private final Option startUuid$2;
            private final LinkedBlockingQueue buffer$1;
            private final LongRef finishTime$1;
            private final IntRef count$2;

            public final void apply(String line) {
                block6: {
                    Option<FullRecord[]> record;
                    block5: {
                        ++this.count$2.elem;
                        if (this.startUuid$2.isEmpty()) break block5;
                        Object object = this.startUuid$2.get();
                        String string = line;
                        if (object != null ? !object.equals(string) : string != null) break block6;
                    }
                    if (!(record = ProcessRecords$.MODULE$.occurrenceDAO().getRawProcessedByRowKey(line)).isEmpty()) {
                        this.buffer$1.put((Object)new Tuple2((Object)((FullRecord[])record.get())[0], (Object)((FullRecord[])record.get())[1]));
                    }
                }
                if (this.count$2.elem % 1000 == 0) {
                    this.finishTime$1.elem = System.currentTimeMillis();
                    ProcessRecords$.MODULE$.logger().info(new StringBuilder().append((Object)"records read: ").append((Object)BoxesRunTime.boxToInteger((int)this.count$2.elem)).toString());
                }
            }
            {
                this.startUuid$2 = startUuid$2;
                this.buffer$1 = buffer$1;
                this.finishTime$1 = finishTime$1;
                this.count$2 = count$2;
            }
        });
        return count.elem;
    }

    public void performPaging(Function1<Option<Tuple2<FullRecord, FullRecord>>, Object> proc, String startKey, String endKey, int pageSize) {
        this.occurrenceDAO().pageOverRawProcessed((Function1<Option<Tuple2<FullRecord, FullRecord>>, Object>)new Serializable(proc){
            public static final long serialVersionUID = 0L;
            private final Function1 proc$1;

            public final boolean apply(Option<Tuple2<FullRecord, FullRecord>> rawAndProcessed) {
                return BoxesRunTime.unboxToBoolean((Object)this.proc$1.apply(rawAndProcessed));
            }
            {
                this.proc$1 = proc$1;
            }
        }, startKey, endKey, pageSize);
    }

    public String performPaging$default$2() {
        return "";
    }

    public String performPaging$default$3() {
        return "";
    }

    public int performPaging$default$4() {
        return 1000;
    }

    public void printTimings(Consumer[] pool) {
        Map processorTimings = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        Predef$.MODULE$.refArrayOps((Object[])pool).foreach((Function1)new Serializable(processorTimings){
            public static final long serialVersionUID = 0L;
            public final Map processorTimings$1;

            public final void apply(Consumer p) {
                p.processor().processTimings().foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.printTimings.1 $outer;

                    public final Map<String, Object> apply(Tuple2<String, Object> e) {
                        return (Map)this.$outer.processorTimings$1.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc(e._1()), (Object)BoxesRunTime.boxToLong((long)(e._2$mcJ$sp() + BoxesRunTime.unboxToLong((Object)this.$outer.processorTimings$1.getOrElse(e._1(), (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final long apply() {
                                return this.apply$mcJ$sp();
                            }

                            public long apply$mcJ$sp() {
                                return 0L;
                            }
                        }))))));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.processorTimings$1 = processorTimings$1;
            }
        });
        StringBuilder timings = new StringBuilder();
        timings.append("time for each processor (ms):");
        processorTimings.foreach((Function1)new Serializable(timings){
            public static final long serialVersionUID = 0L;
            private final StringBuilder timings$1;

            public final StringBuilder apply(Tuple2<String, Object> e) {
                return this.timings$1.append(new StringBuilder().append((Object)((String)e._1())).append((Object)"=").append((Object)BoxesRunTime.boxToLong((long)e._2$mcJ$sp())).append((Object)"; ").toString());
            }
            {
                this.timings$1 = timings$1;
            }
        });
        this.logger().info(timings.toString());
    }

    private ProcessRecords$() {
        MODULE$ = this;
        Tool$class.$init$(this);
        IncrementalTool$class.$init$(this);
        this.occurrenceDAO = Config$.MODULE$.occurrenceDAO();
        this.persistenceManager = Config$.MODULE$.persistenceManager();
        this.logger = LoggerFactory.getLogger((String)"ProcessRecords");
    }
}

